/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.util.ThreadLocals;
import kd.fi.bcm.business.serviceHelper.OlapSandBoxConnection;

public class OlapSandBoxContext
implements AutoCloseable {
    private final Map<String, OlapSandBoxConnection> currentConnectionPool = new ConcurrentHashMap<String, OlapSandBoxConnection>(1);
    private static final ThreadLocal<OlapSandBoxContext> current = ThreadLocals.create(OlapSandBoxContext::new);

    public static OlapSandBoxContext get() {
        return current.get();
    }

    public boolean isSandboxEnv(String cubeNumber) {
        return this.currentConnectionPool.containsKey(cubeNumber);
    }

    public void openSandBoxEnv(String cubeNumber) {
        this.currentConnectionPool.computeIfAbsent(cubeNumber, a -> new OlapSandBoxConnection());
    }

    @Override
    public void close() {
        new HashSet<String>(this.currentConnectionPool.keySet()).forEach(cube -> this.closeSandBoxEnv((String)cube));
    }

    public void closeSandBoxEnv(String cubeNum) {
        OlapSandBoxConnection sandBoxConnection = this.currentConnectionPool.remove(cubeNum);
        if (sandBoxConnection != null) {
            sandBoxConnection.close();
        }
    }

    public void initOlapConnection(String cubeNum, OlapConnection olapConnection) {
        this.getOlapSandBoxConnection(cubeNum).initOlapConnection(olapConnection);
    }

    public OlapConnection getOlapConnection(String cubeNum) {
        return this.getOlapSandBoxConnection(cubeNum).getOlapConnection();
    }

    private OlapSandBoxConnection getOlapSandBoxConnection(String cubeNum) {
        return this.currentConnectionPool.get(cubeNum);
    }
}

