/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.AggOperators;
import kd.bos.olap.dataSources.BlackWhiteScopeItem;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.DiscretePointScopeItem;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.MetadataItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.PiecewisePairMetadataItem;
import kd.bos.olap.metadata.MetadataTypes;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class OlapScopeHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, OlapScopeHelper.class);
    private static String orgPiecewisePrefix = "_org";
    private static String rateOrgPiecewisePrefix = "_rateorg";

    public static void createOrgPiecewise(String cubeNum, String number, String quoteNumber) {
        String piecewiseName = number + orgPiecewisePrefix + "_fun";
        String scopeName = number + orgPiecewisePrefix + "_scope";
        String blackName = number + orgPiecewisePrefix + "_black";
        if (!OlapScopeHelper.findOrgDataScope(cubeNum, number)) {
            String[] dimensions = new String[]{PresetConstant.FY_DIM, PresetConstant.PERIOD_DIM, PresetConstant.ENTITY_DIM};
            OlapScopeHelper.createDataScope(cubeNum, scopeName, blackName, dimensions);
        }
        PiecewisePairMetadataItem item = PiecewisePairMetadataItem.create((String)piecewiseName, (int)1, (String)scopeName).addFactor(quoteNumber, AggOperators.PLUS);
        String ownerName = cubeNum + "." + PresetConstant.SCENE_DIM + "." + number;
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.PiecewiseExpression, CommandTypes.create, new MetadataItem[]{item});
    }

    public static boolean findOrgPiecewise(String cubeNum, String dimNumber, String number) {
        String piecewiseName = number + orgPiecewisePrefix + "_fun";
        return OlapScopeHelper.findPiecewise(cubeNum, dimNumber, number, piecewiseName);
    }

    private static boolean findOrgDataScope(String cubeNum, String number) {
        String scopeName = number + orgPiecewisePrefix + "_scope";
        return OlapScopeHelper.findCubeDataScope(cubeNum, scopeName);
    }

    public static void createRateOrgPiecewise(String cubeNum, String number, String quoteNumber) {
        String piecewiseName = number + rateOrgPiecewisePrefix + "_fun";
        String scopeName = number + rateOrgPiecewisePrefix + "_scope";
        String blackName = number + rateOrgPiecewisePrefix + "_black";
        if (!OlapScopeHelper.findRateOrgDataScope(cubeNum, number)) {
            String[] dimensions = new String[]{PresetConstant.ENTITY_DIM};
            OlapScopeHelper.createDataScope(cubeNum, scopeName, blackName, dimensions);
        }
        PiecewisePairMetadataItem item = PiecewisePairMetadataItem.create((String)piecewiseName, (int)0, (String)scopeName).addFactor(quoteNumber, AggOperators.PLUS);
        String ownerName = cubeNum + "." + PresetConstant.SCENE_DIM + "." + number;
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.PiecewiseExpression, CommandTypes.create, new MetadataItem[]{item});
    }

    public static boolean findRateOrgPiecewise(String cubeNum, String dimNumber, String number) {
        String piecewiseName = number + rateOrgPiecewisePrefix + "_fun";
        return OlapScopeHelper.findPiecewise(cubeNum, dimNumber, number, piecewiseName);
    }

    private static boolean findRateOrgDataScope(String cubeNum, String number) {
        String scopeName = number + rateOrgPiecewisePrefix + "_scope";
        return OlapScopeHelper.findCubeDataScope(cubeNum, scopeName);
    }

    private static void createDataScope(String cubeNum, String scopeName, String blackName, String[] dimensions) {
        BlackWhiteScopeItem blackScopeItem = new BlackWhiteScopeItem(scopeName);
        DiscretePointScopeItem scopeItem = DiscretePointScopeItem.create((String)blackName, (String[])dimensions);
        blackScopeItem.getBlackList().add(scopeItem);
        OlapScopeHelper.execCubeMetadata(cubeNum, cubeNum, MetadataTypes.CubeDataScope, CommandTypes.create, new MetadataItem[]{blackScopeItem});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean findPiecewise(String cubeNum, String dimNumber, String number, String expressionName) {
        String path = dimNumber + "@" + number;
        try (OlapConnection olapConn = OlapServiceHelper.getOlapConnection(cubeNum);){
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNum);
            propertyBag.set("path", path);
            FunctionCommandInfo commandInfo = new FunctionCommandInfo("getFactorsV2", propertyBag);
            OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
            PropertyBag result = command.executeFunction();
            JSONArray resultArray = JSON.parseArray((String)result.get("result"));
            if (resultArray == null || resultArray.size() == 0) {
                boolean bl = false;
                return bl;
            }
            JSONObject jsonObject = resultArray.getJSONObject(0);
            if (jsonObject == null) {
                boolean bl = false;
                return bl;
            }
            String name = jsonObject.getString("name");
            if (!number.equals(name)) {
                boolean bl = false;
                return bl;
            }
            JSONObject calcExpression = jsonObject.getJSONObject("calcExpression");
            if (calcExpression == null) {
                boolean bl = false;
                return bl;
            }
            JSONArray expressions = calcExpression.getJSONArray("expressions");
            if (expressions == null || expressions.size() == 0) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < expressions.size(); ++i) {
                JSONObject expression = expressions.getJSONObject(i);
                if (expression == null || !Objects.equals(expression.getString("name"), expressionName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean findCubeDataScope(String cubeNum, String scopeName) {
        try (OlapConnection olapConn = OlapServiceHelper.getOlapConnection(cubeNum);){
            FunctionCommandInfo commandInfo;
            OlapCommand command;
            PropertyBag result;
            JSONArray resultArray;
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.set("cubeName", cubeNum);
            if (scopeName != null) {
                propertyBag.set("name", scopeName);
            }
            if ((resultArray = JSON.parseArray((String)(result = (command = new OlapCommand(olapConn, (CommandInfo)(commandInfo = new FunctionCommandInfo("getCubeDataScopes", propertyBag)))).executeFunction()).get("result"))) == null || resultArray.size() == 0) {
                boolean bl = false;
                return bl;
            }
            JSONObject jsonObject = resultArray.getJSONObject(0);
            boolean bl = jsonObject != null;
            return bl;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    protected static void execCubeMetadata(String cubeNum, String ownerName, MetadataTypes metadataType, CommandTypes type, MetadataItem ... scopeItems) {
        try (OlapConnection olapConn = OlapServiceHelper.getOlapConnection(cubeNum);){
            MetadataCommandInfo commandInfo = new MetadataCommandInfo();
            commandInfo.setMetadataType(metadataType);
            commandInfo.setOwnerUniqueName(ownerName);
            commandInfo.setAction(type);
            Arrays.stream(scopeItems).forEach(item -> commandInfo.getItems().add(item));
            OlapCommand command = new OlapCommand(olapConn, (CommandInfo)commandInfo);
            command.executeNonQuery();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public static void addOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        String scopeName = number + orgPiecewisePrefix + "_scope";
        String blackName = number + orgPiecewisePrefix + "_black";
        String ownerName = cubeNum + "." + scopeName + ".blacks." + blackName;
        DiscretePointScopeItem scopeItem = OlapScopeHelper.createPointScopeItem(pairList);
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.CubeDataScope, CommandTypes.create, new MetadataItem[]{scopeItem});
    }

    public static void addRateOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        String scopeName = number + rateOrgPiecewisePrefix + "_scope";
        String blackName = number + rateOrgPiecewisePrefix + "_black";
        String ownerName = cubeNum + "." + scopeName + ".blacks." + blackName;
        DiscretePointScopeItem scopeItem = OlapScopeHelper.createPointScopeItem(pairList);
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.CubeDataScope, CommandTypes.create, new MetadataItem[]{scopeItem});
    }

    public static void removePointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        String scopeName = number + orgPiecewisePrefix + "_scope";
        String blackName = number + orgPiecewisePrefix + "_black";
        String ownerName = cubeNum + "." + scopeName + ".blacks." + blackName;
        DiscretePointScopeItem scopeItem = OlapScopeHelper.createPointScopeItem(pairList);
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.CubeDataScope, CommandTypes.drop, new MetadataItem[]{scopeItem});
    }

    public static void removeRateOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        String scopeName = number + rateOrgPiecewisePrefix + "_scope";
        String blackName = number + rateOrgPiecewisePrefix + "_black";
        String ownerName = cubeNum + "." + scopeName + ".blacks." + blackName;
        DiscretePointScopeItem scopeItem = OlapScopeHelper.createPointScopeItem(pairList);
        OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.CubeDataScope, CommandTypes.drop, new MetadataItem[]{scopeItem});
    }

    public static void dropRateOrgPointScope(String cubeNum, String number) {
        String scopeName;
        boolean isExists = OlapScopeHelper.findRateOrgPiecewise(cubeNum, "Scenario", number);
        if (isExists) {
            String funName = number + rateOrgPiecewisePrefix + "_fun";
            String ownerName = cubeNum + "." + "Scenario" + "." + number;
            OlapScopeHelper.execCubeMetadata(cubeNum, ownerName, MetadataTypes.PiecewiseExpression, CommandTypes.drop, new MetadataItem[]{new PiecewisePairMetadataItem(funName)});
        }
        if (isExists = OlapScopeHelper.findCubeDataScope(cubeNum, scopeName = number + rateOrgPiecewisePrefix + "_scope")) {
            OlapScopeHelper.execCubeMetadata(cubeNum, cubeNum, MetadataTypes.CubeDataScope, CommandTypes.drop, new MetadataItem[]{new BlackWhiteScopeItem(scopeName)});
        }
    }

    private static DiscretePointScopeItem createPointScopeItem(PairList<String, Object> pairList) {
        DiscretePointScopeItem scopeItem = DiscretePointScopeItem.create((String[])((String[])pairList.toList().stream().map(p -> (String)p.p1).toArray(String[]::new)));
        ArrayList points = new ArrayList(16);
        for (Pair pair : pairList) {
            Collection coll = new ArrayList<String>();
            ArrayList newPoints = new ArrayList(16);
            if (pair.p2 instanceof String) {
                coll.add((String)pair.p2);
            } else if (pair.p2 instanceof Collection) {
                coll = (Collection)pair.p2;
            }
            if (points.isEmpty()) {
                newPoints.addAll(coll);
            } else {
                for (String point : points) {
                    for (String o : coll) {
                        newPoints.add(point + "," + o);
                    }
                }
            }
            points = newPoints;
        }
        for (String point : points) {
            scopeItem.add(point);
        }
        return scopeItem;
    }
}

