/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.olap.backup.BackupFile;
import kd.bos.olap.backup.DirectFile;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.common.PropertyBag;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.dataSources.AggShieldRuleBlackListMetadataItem;
import kd.bos.olap.dataSources.AggShieldRuleDataPartitionMetadataItem;
import kd.bos.olap.dataSources.BackupCommandInfo;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.FunctionCommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.MetadataItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.RecoveryCommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.dataSources.SliceScopeItemV2;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.olap.metadata.OlapDataTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.dimension.helper.ModelServiceHelper;
import kd.fi.bcm.business.formula.calculate.exception.InvalidParamException;
import kd.fi.bcm.business.log.ErrorLogServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.olap.scale.CurrencyScaleHandler;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.olap.verify.OlapDataVerifyServiceHelper;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.script.AggScriptBuilder;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.DataMonitorServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapSandBoxContext;
import kd.fi.bcm.business.serviceHelper.OlapScopeHelper;
import kd.fi.bcm.business.serviceHelper.SlowEvolvingServiceHelper;
import kd.fi.bcm.business.sql.CellSetResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetReader;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.OlapUtils;
import kd.fi.bcm.common.OlapConstant;
import kd.fi.bcm.common.OlapEnhancementHelper;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CacheTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.trace.OlapComTraceUtil;
import kd.fi.bcm.common.util.ClassUtil;
import kd.fi.bcm.common.util.DataConnectCacheUtil;
import kd.fi.bcm.common.util.DatasourceModel;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.NumberUtils;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.computing.ComputingContext;
import kd.fi.bcm.computing.ComputingEngine;
import kd.fi.bcm.computing.bizrule.BizRuleExecParam;
import kd.fi.bcm.computing.datasource.IOutline;
import kd.fi.bcm.computing.datasource.Outline;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import kd.fi.bcm.computing.util.RuleExecuteServiceHelper;
import kd.fi.bcm.spread.common.util.exception.MDQueryException;
import kotlin.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public final class OlapServiceHelper {
    public static final String IS_UPGRADE_DYNA_COMPUTING = "is_dynamic";
    public static final String OTHER = "other";
    public static final String EXCLUDEMONTHS = "ExcludeMonths";
    private static final List<String> DIM_ORDER = Lists.newArrayList((Object[])new String[]{"Scenario", "Year", "Period", "Currency", "Entity"});
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, OlapServiceHelper.class);

    public static void createCubeSchemes(DynamicObject model) {
        String cube = model.getString("number");
        OlapServiceHelper.checkCubeCatalogIsNotNull(cube);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName(cube);
        cmd.getProperties().set("caption", model.getString("name") + "(" + model.getString("shownumber") + "," + RequestContext.get().getTenantId() + ")");
        cmd.getProperties().set(IS_UPGRADE_DYNA_COMPUTING, "true");
        OlapServiceHelper.executeCommand(cmd, cube);
        OlapServiceHelper.createMeasureSchemes(cube, false, FacTabFieldDefEnum.FIELD_MONEY.getField());
        if ((model.getBoolean("issourcemeasure") || model.getBoolean("islockmeasure")) && !OlapServiceHelper.canAddMeasure(model.getLong("datasource.id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u591a\u7ef4\u5e93\u7248\u672c\u4e0d\u652f\u6301\u5f00\u542f\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u7248\u672c\u540e\u518d\u5f00\u542f\u3002", (String)"OlapServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        if (model.getBoolean("issourcemeasure")) {
            OlapServiceHelper.createMeasureSchemes(cube, true, FacTabFieldDefEnum.FIELD_SOURCE.getField());
        }
        if (model.getBoolean("islockmeasure")) {
            OlapServiceHelper.createMeasureSchemes(cube, true, FacTabFieldDefEnum.FIELD_LOCK.getField());
            OlapServiceHelper.lockMeasure(cube, FacTabFieldDefEnum.FIELD_MONEY.getField(), true);
            if (model.getBoolean("issourcemeasure")) {
                OlapServiceHelper.lockMeasure(cube, FacTabFieldDefEnum.FIELD_SOURCE.getField(), true);
            }
        }
        AppCacheServiceHelper.clearMeasureCache(cube);
    }

    public static void updateCubeCaption(String cubeName, String modelName, String modelShowNumber) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeName);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName(cubeName);
        cmd.getProperties().set("caption", modelName + "(" + modelShowNumber + "," + RequestContext.get().getTenantId() + ")");
        OlapServiceHelper.executeCommand(cmd, cubeName);
    }

    public static void createDimensionSchemes(String cubeCatalog, String dimNumber, String shortNumber) {
        boolean flag;
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeCatalog);
        cmd.setMetadataType(MetadataTypes.Dimension);
        cmd.setName(dimNumber);
        cmd.getProperties().set("alias", shortNumber);
        if (OlapServiceHelper.isContinuousDimension(dimNumber)) {
            cmd.setDimensionContinuousData(true);
        }
        if (flag = OlapServiceHelper.isPreSetDefaultMember(dimNumber)) {
            cmd.setAllowNull(false);
        } else {
            cmd.setDefaultMemberName(shortNumber + "None");
        }
        OlapServiceHelper.executeCommand(cmd, cubeCatalog);
    }

    public static void syncDimensionShortNumber2Cube(String cubeCatalog) {
        MemberReader.getDimensionShortNumber2NumberMap((String)cubeCatalog).forEach((key, value) -> {
            MetadataCommandInfo cmd = new MetadataCommandInfo();
            cmd.setAction(CommandTypes.alter);
            cmd.setOwnerUniqueName(cubeCatalog);
            cmd.setMetadataType(MetadataTypes.Dimension);
            cmd.setName(value);
            cmd.getProperties().set("alias", key);
            OlapServiceHelper.executeCommand(cmd, cubeCatalog);
        });
    }

    private static boolean isContinuousDimension(String dimNumber) {
        return DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber) || DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) || DimTypesEnum.CURRENCY.getNumber().equals(dimNumber) || DimTypesEnum.MULTIGAAP.getNumber().equals(dimNumber) || DimTypesEnum.VERSION.getNumber().equals(dimNumber) || DimTypesEnum.DATASORT.getNumber().equals(dimNumber) || DimTypesEnum.PROCESS.getNumber().equals(dimNumber) || DimTypesEnum.AUDITTRIAL.getNumber().equals(dimNumber);
    }

    private static boolean isPreSetDefaultMember(String dimNumber) {
        return DimTypesEnum.ENTITY.getNumber().equals(dimNumber) || DimTypesEnum.ACCOUNT.getNumber().equals(dimNumber) || DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber) || DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) || DimTypesEnum.PROCESS.getNumber().equals(dimNumber) || DimTypesEnum.CHANGETYPE.getNumber().equals(dimNumber) || DimTypesEnum.MULTIGAAP.getNumber().equals(dimNumber) || DimTypesEnum.DATASORT.getNumber().equals(dimNumber);
    }

    public static void dropDimensionSchemes(String dimNumber, String cubeCatalog) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Dimension);
        cmd.setName(dimNumber);
        cmd.setOwnerUniqueName(cubeCatalog);
        OlapServiceHelper.executeCommand(cmd, cubeCatalog);
    }

    public static void clearDimMemberCache(String cubeCatalog, String dimNumber) {
        if (OlapServiceHelper.isSandBoxCube(cubeCatalog)) {
            return;
        }
        GlobalCacheServiceHelper.invalidateAnyCache((CacheTypeEnum)CacheTypeEnum.CommonCache);
        if (StringUtils.isNull((String)cubeCatalog) || StringUtils.isNull((String)dimNumber)) {
            return;
        }
        MQMessagePublisherServiceHelper.publishClearDimMemberCache(cubeCatalog, dimNumber);
        if (PresetConstant.ENTITY_DIM.equals(dimNumber)) {
            MQMessagePublisherServiceHelper.publishInvalidateTemplateDispense(cubeCatalog);
            MQMessagePublisherServiceHelper.publishClearDimMemberCache(cubeCatalog, PresetConstant.INTERNALCOMPANY_DIM);
            MQMessagePublisherServiceHelper.publishClearDimMemberCache(cubeCatalog, PresetConstant.MYCOMPANY_DIM);
        }
    }

    public static void clearDimensionCache(String modelNum) {
        GlobalCacheServiceHelper.getCommonCache().invalidateByKey("dim-number-short-" + modelNum);
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey(modelNum);
        GlobalCacheServiceHelper.getDimMemberCache().invalidateStartsWithKey(modelNum);
    }

    public static void dropCubeSchemes(String cubeCatalog) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName(cubeCatalog);
        OlapServiceHelper.executeCommand(cmd, cubeCatalog);
    }

    private static void checkCubeCatalogIsNotNull(String cubeCatalog) {
        if (StringUtils.isEmpty((String)cubeCatalog)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u521b\u5efacube\u65b9\u6848\u65f6,\u63d0\u4f9b\u7684\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (String)"OlapServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
    }

    public static void createMeasureSchemes(String cubeCatalog, boolean isInt, String ... measureFields) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        for (String measure : measureFields) {
            cmd.setAction(CommandTypes.create);
            cmd.setMetadataType(MetadataTypes.Measure);
            cmd.setOwnerUniqueName(cubeCatalog);
            cmd.setName(measure);
            if (isInt) {
                cmd.setDataType(OlapDataTypes.int64);
            }
            OlapServiceHelper.executeCommand(cmd, cubeCatalog);
        }
    }

    public static void lockMeasure(String modelNum, String measure, boolean lock) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Measure);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setName(measure);
        OlapCommandUtil.setReadonlyExpression((MetadataCommandInfo)cmd, (boolean)lock);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void createLockDataScope(String modelNum, Map<String, Map<String, String[]>> lockDimScopes) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        if (lockDimScopes == null || lockDimScopes.isEmpty()) {
            return;
        }
        List scopeItemList = lockDimScopes.entrySet().stream().map(kv -> {
            SliceScopeItemV2 socpeItem = new SliceScopeItemV2((String)kv.getKey());
            OlapServiceHelper.sortDimMap((Map)kv.getValue()).forEach((arg_0, arg_1) -> ((SliceScopeItemV2)socpeItem).addFilter(arg_0, arg_1));
            return socpeItem;
        }).collect(Collectors.toList());
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.CubeLockRule);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setAction(CommandTypes.create);
        cmd.getItems().addAll(scopeItemList);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void dropLockDataScope(String modelNum, Set<String> scopeNames) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        if (scopeNames == null || scopeNames.isEmpty()) {
            return;
        }
        List scopeItemList = scopeNames.stream().map(SliceScopeItemV2::new).collect(Collectors.toList());
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.CubeLockRule);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setAction(CommandTypes.drop);
        cmd.getItems().addAll(scopeItemList);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void updateLockDataScope(String modelNum, Map<String, Map<String, String[]>> lockDimScopes) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        if (lockDimScopes == null || lockDimScopes.isEmpty()) {
            return;
        }
        List scopeItemList = lockDimScopes.entrySet().stream().map(kv -> {
            SliceScopeItemV2 socpeItem = new SliceScopeItemV2((String)kv.getKey());
            OlapServiceHelper.sortDimMap((Map)kv.getValue()).forEach((arg_0, arg_1) -> ((SliceScopeItemV2)socpeItem).addFilter(arg_0, arg_1));
            return socpeItem;
        }).collect(Collectors.toList());
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.CubeLockRule);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setAction(CommandTypes.alter);
        cmd.getItems().addAll(scopeItemList);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void addLockDataScopeMember(String modelNum, Map<String, Map<String, String[]>> lockDimScopes) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        if (lockDimScopes == null || lockDimScopes.isEmpty()) {
            return;
        }
        List scopeItemList = lockDimScopes.entrySet().stream().map(kv -> {
            SliceScopeItemV2 scopeItem = new SliceScopeItemV2((String)kv.getKey());
            OlapServiceHelper.sortDimMap((Map)kv.getValue()).forEach((key, value) -> {
                if (value != null) {
                    scopeItem.addFilter(key, value);
                } else {
                    scopeItem.addFilter(key, new String[0]);
                }
            });
            return scopeItem;
        }).collect(Collectors.toList());
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.CubeLockRule);
        cmd.setOwnerUniqueName(modelNum);
        cmd.getProperties().set("dataLockAppendMember", "true");
        cmd.setAction(CommandTypes.create);
        cmd.getItems().addAll(scopeItemList);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void dropLockDataScopeMember(String modelNum, Map<String, Map<String, String[]>> lockDimScopes) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        if (lockDimScopes == null || lockDimScopes.isEmpty()) {
            return;
        }
        List scopeItemList = lockDimScopes.entrySet().stream().map(kv -> {
            SliceScopeItemV2 scopeItem = new SliceScopeItemV2((String)kv.getKey());
            OlapServiceHelper.sortDimMap((Map)kv.getValue()).forEach((key, value) -> {
                if (value != null) {
                    scopeItem.addFilter(key, value);
                } else {
                    scopeItem.addFilter(key, new String[0]);
                }
            });
            return scopeItem;
        }).collect(Collectors.toList());
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setMetadataType(MetadataTypes.CubeLockRule);
        cmd.setOwnerUniqueName(modelNum);
        cmd.getProperties().set("dataLockRemoveMember", "true");
        cmd.setAction(CommandTypes.drop);
        cmd.getItems().addAll(scopeItemList);
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String queryLockScope(String modelNum) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("cubeName", modelNum);
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getCubeDataLockRuleNames", propertyBag);
        try (OlapConnection conn = OlapServiceHelper.getOlapConnection(modelNum);){
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            PropertyBag retPropertyBag = cmd.executeFunction();
            String string = retPropertyBag.get("scopeNames");
            return string;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String queryLockScopeDetail(String modelNum, String scopeName) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(modelNum);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("cubeName", modelNum);
        propertyBag.set("name", scopeName);
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getCubeDataLockRule", propertyBag);
        try (OlapConnection conn = OlapServiceHelper.getOlapConnection(modelNum);){
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            PropertyBag retPropertyBag = cmd.executeFunction();
            String string = retPropertyBag.get("scope");
            return string;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static LinkedHashMap<String, String[]> sortDimMap(Map<String, String[]> dimScopeMap) {
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>(6);
        if (dimScopeMap == null || dimScopeMap.isEmpty()) {
            return result;
        }
        HashSet<String> dimSets = new HashSet<String>(dimScopeMap.keySet());
        for (String dimNum : DIM_ORDER) {
            if (!dimSets.remove(dimNum)) continue;
            result.put(dimNum, dimScopeMap.get(dimNum));
        }
        if (!dimSets.isEmpty()) {
            dimSets.stream().sorted().forEach(e -> result.put((String)e, (String[])dimScopeMap.get(e)));
        }
        return result;
    }

    public static VerifyResult saveData(SaveCommandInfo info, CellSet cellSets, String cubeCatalog) {
        return OlapServiceHelper.saveData(info, cellSets, cubeCatalog, true);
    }

    public static VerifyResult saveData(SaveCommandInfo info, CellSet cellSets, String cubeCatalog, boolean isNeedMonitorDataStatus) {
        return OlapServiceHelper.saveData(info, cellSets, cubeCatalog, isNeedMonitorDataStatus, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyResult saveData(SaveCommandInfo info, CellSet cellSets, String cubeCatalog, boolean isNeedMonitorDataStatus, boolean isNeedHandleCurrency) {
        VerifyResult vr = null;
        if (isNeedHandleCurrency) {
            CurrencyScaleHandler.handle(info, cellSets, cubeCatalog);
        } else {
            CurrencyScaleHandler.handleToOlapScale(info, cellSets);
        }
        try {
            vr = OlapServiceHelper.saveCore(info, cellSets, cubeCatalog);
            if (isNeedMonitorDataStatus && !OlapServiceHelper.isSandBoxCube(cubeCatalog)) {
                DataMonitorServiceHelper.dataMonitor(info, cubeCatalog, cellSets);
            }
        }
        catch (Exception e) {
            HashMap<String, String> cellDim = new HashMap<String, String>(16);
            try {
                for (FixedDimension fixedDimension : info.getFixedDimensions()) {
                    cellDim.put(fixedDimension.getName(), fixedDimension.getValue());
                }
                List dims = info.getDimensions();
                String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
                for (String measure : info.getMeasures()) {
                    Iterator it = cellSets.getMetricEntries(fMoney);
                    while (it.hasNext()) {
                        Pair entry = (Pair)it.next();
                        MembersKey key = (MembersKey)entry.getFirst();
                        for (int i = 0; i < dims.size(); ++i) {
                            cellDim.put((String)dims.get(i), key.get(i).toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            finally {
                logger.info("saveData Error: \n" + cellDim);
            }
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        return vr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VerifyResult saveCore(SaveCommandInfo info, CellSet cellSets, String cubeCatalog) {
        VerifyResult vr = null;
        if (cellSets.getCount() <= 0) {
            return vr;
        }
        OlapDataWriter writer = null;
        OlapDataVerifyServiceHelper.handleCellSetAndCheck(info, cellSets);
        if (!OlapServiceHelper.isSandBoxCube(cubeCatalog)) {
            vr = OlapDataVerifyServiceHelper.verifyDataFlowControl(info, cellSets, cubeCatalog);
        }
        if (cellSets.getCount() <= 0) {
            return vr;
        }
        OlapEnhancementHelper.enhanceOlapCommandWithAudit((String)cubeCatalog, null, (CommandInfo)info);
        OlapConnection conn = OlapServiceHelper.getOlapConnection(cubeCatalog);
        try {
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)info);
            OlapComTraceUtil.setTraceId((CommandInfo)info, (boolean)false);
            writer = cmd.CreateWriter();
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"save");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"save");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"save", info});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", info.toString());
                }
                ts.addTag("route", cubeCatalog);
                ts.addTag("count", String.valueOf(cellSets.getCount()));
                if (!OlapServiceHelper.isSandBoxCube(cubeCatalog)) {
                    OlapCommandUtil.checkIsSetSource((String)cubeCatalog, (CommandInfo)info);
                }
                cellSets.Save(writer);
            }
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return vr;
    }

    public static boolean isSandBoxCube(String cubeNum) {
        return OlapSandBoxContext.get().isSandboxEnv(cubeNum);
    }

    /*
     * Exception decompiling
     */
    @SDKMark(description="")
    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubeCatalog) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> queryDataCore(SelectCommandInfo queryInfo, String cubeCatalog) {
        SQLBuilder sql = new SQLBuilder(cubeCatalog);
        sql.addSelectField(queryInfo.getDimensions().toArray(new String[0]));
        if (queryInfo.getFilter() != null) {
            queryInfo.getFilter().forEach(f -> sql.addFilter(f.getName(), f.getValues().toArray(new String[0])));
        }
        sql.addMeasures(queryInfo.getMeasures().toArray(new String[0]));
        sql.setTop(queryInfo.getTop());
        sql.setExcludeDynaData(queryInfo.getExcludeDynamicCalcResult());
        sql.setIncludeDynamicMemberWhenNullFilter(queryInfo.getIncludeDynamicMemberWhenNullFilter());
        MDResultSet rs = OlapServiceHelper.queryData(sql);
        HashMap<String, Object> result = rs == null ? new HashMap(16) : rs.asMap("|", queryInfo.getDimensions());
        return result;
    }

    @SDKMark
    public static MDResultSet queryData(SQLBuilder sql) {
        return OlapServiceHelper.queryData(sql, false);
    }

    public static MDResultSet madeUpData(SQLBuilder sql, List<String> carsdim) {
        MDResultSet rs = new MDResultSet();
        rs.makeup(sql, carsdim);
        return rs;
    }

    public static Object[] queryDataToReader(SQLBuilder sql) {
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        queryInfo.addMeasures(sql.getMeasures());
        queryInfo.setExcludeDynamicCalcResult(sql.isExcludeDynaData());
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        Object[] result = new Object[2];
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(sql.getCubecatalog());
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            result[0] = cmd.ExecuteReader();
            result[1] = conn;
            try (TraceSpan ts = Tracer.create((String)"olap", (String)"query");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"query", queryInfo});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
            }
            return result;
        }
        catch (Throwable e) {
            logger.error(e);
            throw new MDQueryException(String.format(ResManager.loadKDString((String)"olap \u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"OlapServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    public static void dropDimensionMember(String cubeCatalog, String dimNum, String memNum) {
        OlapServiceHelper.batchDropDimensionMembersForce(cubeCatalog, dimNum, Lists.newArrayList((Object[])new String[]{memNum}));
    }

    public static void batchDropDimensionMembers(String cubeCatalog, String dimNum, Collection<String> members) {
        OlapServiceHelper.batchDropDimensionMembersForce(cubeCatalog, dimNum, members);
    }

    public static void dropDimensionMemberForce(String cubeCatalog, String dimNum, String memNum) {
        OlapServiceHelper.batchDropDimensionMembersForce(cubeCatalog, dimNum, Lists.newArrayList((Object[])new String[]{memNum}));
    }

    public static void batchDropDimensionMembersForce(String cubeCatalog, String dimNum, Collection<String> members) {
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeCatalog);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeCatalog + "." + dimNum);
        cmd.getProperties().set("allowDropMemberWhenRowReferenced", "true");
        Set<String> notExistMemberSet = OlapServiceHelper.batCheckMemberIsExistOlap(dimNum, members.toArray(new String[0]), cubeCatalog);
        for (String name : members) {
            if (notExistMemberSet.contains(name)) continue;
            MemberMetadataItem memeber = new MemberMetadataItem();
            memeber.setName(name);
            cmd.getItems().add(memeber);
        }
        if (!cmd.getItems().isEmpty()) {
            OlapServiceHelper.executeCommand(cmd, cubeCatalog);
        }
    }

    protected static void executeCommand(MetadataCommandInfo cmd, String modelNum) {
        OlapConnection conn = null;
        OlapEnhancementHelper.enhanceOlapCommandWithAudit((String)modelNum, null, (CommandInfo)cmd);
        try {
            conn = OlapServiceHelper.getOlapConnection(modelNum);
            conn.Open();
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"executeNonQuery");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"executeNonQuery");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"executeNonQuery", cmd});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", cmd.toString());
                }
                ts.addTag("route", modelNum);
                olapCommand.executeNonQuery();
                String ownerUniqueName = cmd.getOwnerUniqueName();
                if (StringUtils.isNotEmpty((String)ownerUniqueName) && ownerUniqueName.startsWith(modelNum) && cmd.getMetadataType() == MetadataTypes.Member) {
                    String dimNum = ownerUniqueName.substring(modelNum.length() + 1);
                    OlapServiceHelper.clearDimMemberCache(modelNum, dimNum);
                    if (CommandTypes.create == cmd.getAction() && PresetConstant.ENTITY_DIM.equals(dimNum)) {
                        if (StringUtils.isNotEmpty((String)cmd.getName())) {
                            String name = cmd.getName();
                            if (name.contains("_")) {
                                OlapServiceHelper.alterMemberStorageType(modelNum, dimNum, name, MemberStorageTypes.DynamicCalc);
                                OlapServiceHelper.createAggFactor(modelNum, dimNum, name.split("_")[1], 1, name);
                            }
                        } else if (CollectionUtils.isNotEmpty((Collection)cmd.getItems())) {
                            HashMap<String, MemberStorageTypes> storageTypeMap = new HashMap<String, MemberStorageTypes>(cmd.getItems().size());
                            HashMap<String, List<AggFactorMetadataItem>> aggMap = new HashMap<String, List<AggFactorMetadataItem>>(cmd.getItems().size());
                            cmd.getItems().forEach(item -> {
                                String name = item.getName();
                                if (name != null && name.contains("_")) {
                                    storageTypeMap.put(name, MemberStorageTypes.DynamicCalc);
                                    aggMap.put(name, Collections.singletonList(OlapUtils.createAggFactorMetadataItem(name.split("_")[1], 1)));
                                }
                            });
                            if (!storageTypeMap.isEmpty()) {
                                OlapServiceHelper.batchAlterMemberStorageType(modelNum, dimNum, storageTypeMap);
                                OlapServiceHelper.batchRepairAggFactor(modelNum, dimNum, aggMap);
                            }
                        }
                    }
                }
                if (cmd.getMetadataType() == MetadataTypes.Dimension && CommandTypes.alter != cmd.getAction()) {
                    OlapServiceHelper.clearDimensionCache(modelNum);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
        OlapServiceHelper.deleteScale(cmd, modelNum);
    }

    private static void deleteScale(MetadataCommandInfo cmd, String cubeCatalog) {
        if (CommandTypes.drop == cmd.getAction() && MetadataTypes.Member == cmd.getMetadataType() && cmd.getOwnerUniqueName().endsWith(".Account")) {
            Long modelid = MemberReader.findModelIdByNum((String)cubeCatalog);
            ArrayList<String> accountList = new ArrayList<String>(cmd.getItems().size());
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model", "=", (Object)modelid));
            for (MetadataItem item : cmd.getItems()) {
                accountList.add(item.getName());
            }
            qfBuilder.add(new QFilter("accountnumber", "in", accountList));
            DeleteServiceHelper.delete((String)"bcm_accountscale", (QFilter[])qfBuilder.toArray());
        }
    }

    public static void repairEntityWithParentFactor(String cubeName, Set<String> involvedNumbers) {
        HashMap<String, List<AggFactorMetadataItem>> numberAggFactsMap = new HashMap<String, List<AggFactorMetadataItem>>(16);
        MemberReader.getAllNodeByDimNum((String)PresetConstant.ENTITY_DIM, (String)cubeName).forEach(e -> {
            if (!e.isLeaf() && !e.isShare()) {
                e.getChildren().forEach(c -> {
                    if (involvedNumbers.contains(c.getNumber())) {
                        AggFactorMetadataItem aggFactorMetadataItem = OlapUtils.createAggFactorMetadataItem(c.getNumber(), 1);
                        List<AggFactorMetadataItem> factorList = Collections.singletonList(aggFactorMetadataItem);
                        String withParentEntity = e.getNumber() + "_" + c.getNumber();
                        numberAggFactsMap.put(withParentEntity, factorList);
                    }
                });
            }
        });
        if (!numberAggFactsMap.isEmpty()) {
            try {
                OlapServiceHelper.batchAlterMemberStorageType(cubeName, PresetConstant.ENTITY_DIM, numberAggFactsMap.keySet().stream().collect(Collectors.toMap(x -> x, x -> MemberStorageTypes.DynamicCalc)));
                OlapServiceHelper.batchRepairAggFactor(cubeName, PresetConstant.ENTITY_DIM, numberAggFactsMap);
            }
            catch (Throwable e2) {
                OlapServiceHelper.batchCreateDimensionMembers(cubeName, PresetConstant.ENTITY_DIM, numberAggFactsMap.keySet().toArray(new String[0]));
                OlapServiceHelper.batchRepairAggFactor(cubeName, PresetConstant.ENTITY_DIM, numberAggFactsMap);
            }
        }
    }

    public static void setProcessShieldRule(String cubeName) {
        IDNumberTreeNode cadj;
        IDNumberTreeNode eje;
        IDNumberTreeNode TADJ;
        ArrayList<IDNumberTreeNode> processes = new ArrayList<IDNumberTreeNode>(8);
        long modelId = MemberReader.findModelIdByNum((String)cubeName);
        IDNumberTreeNode adj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"ADJ");
        if (IDNumberTreeNode.NotFoundTreeNode != adj) {
            processes.add(adj);
        }
        if (IDNumberTreeNode.NotFoundTreeNode != (TADJ = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"TADJ"))) {
            processes.add(TADJ);
        }
        if ((eje = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"EJE")).isLeaf()) {
            processes.add(eje);
        } else {
            eje.getChildren().forEach(e -> processes.add((IDNumberTreeNode)e));
        }
        IDNumberTreeNode ccadj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"CCADJ");
        if (IDNumberTreeNode.NotFoundTreeNode != ccadj) {
            processes.add(ccadj);
        }
        if (IDNumberTreeNode.NotFoundTreeNode != (cadj = MemberReader.findMemberByNumber((String)cubeName, (String)PresetConstant.PROCESS_DIM, (String)"CADJ"))) {
            processes.add(cadj);
        }
        processes.forEach(p -> {
            ShieldRuleBulider srb = new ShieldRuleBulider(modelId);
            long srid = srb.getShieldRule(p.getDimId(), DimTypesEnum.ENTITY.getShortNumber());
            srb.save(p.getDimId(), p.getId(), srid);
        });
    }

    public static boolean createMember(String cubeName, String dimNumber, String member) {
        OlapServiceHelper.checkCubeCatalogIsNotNull(cubeName);
        if (OlapServiceHelper.batCheckMemberIsExistOlap(dimNumber, new String[]{member}, cubeName).isEmpty()) {
            return false;
        }
        if (PresetConstant.ENTITY_DIM.equals(dimNumber)) {
            AppCacheServiceHelper.removeTemplateDispenseCache(cubeName);
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeName + "." + dimNumber);
        cmd.setName(member);
        OlapServiceHelper.executeCommand(cmd, cubeName);
        return true;
    }

    public static void createMember(String cubeName, String dimNumber, String member, int aggOprt, String parentNumber) {
        if (OlapServiceHelper.createMember(cubeName, dimNumber, member)) {
            try {
                OlapServiceHelper.createAggFactor(cubeName, dimNumber, member, aggOprt, parentNumber);
            }
            catch (KDBizException e) {
                OlapServiceHelper.handleAggFactor(cubeName, dimNumber, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(member, aggOprt)}), CommandTypes.alter);
            }
        } else {
            try {
                OlapServiceHelper.handleAggFactor(cubeName, dimNumber, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(member, aggOprt)}), CommandTypes.alter);
            }
            catch (KDBizException e) {
                OlapServiceHelper.createAggFactor(cubeName, dimNumber, member, aggOprt, parentNumber);
            }
        }
    }

    public static void batchCreateDimensionSchemes(String cubeName, String dimension, String dimShortNumber, String[] members) {
        OlapServiceHelper.createDimensionSchemes(cubeName, dimension, dimShortNumber);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setDefaultMemberName(dimShortNumber + "None");
        Set<String> notExistsMem = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName);
        if (CollectionUtils.isNotEmpty(notExistsMem)) {
            notExistsMem.forEach(mem -> {
                MemberMetadataItem metadataItem = new MemberMetadataItem();
                metadataItem.setName(mem);
                cmd.getItems().add(metadataItem);
            });
            OlapServiceHelper.executeCommand(cmd, cubeName);
        }
    }

    public static void batchCreateDimensionSchemes(String cubeName, String dimension, String dimShortNumber, List<Tuple<String, Integer, String>> tupleList) {
        OlapServiceHelper.createDimensionSchemes(cubeName, dimension, dimShortNumber);
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setDefaultMemberName(dimShortNumber + "None");
        String[] members = new String[tupleList.size()];
        for (int i = 0; i < tupleList.size(); ++i) {
            members[i] = (String)tupleList.get((int)i).p1;
        }
        Set<String> notExistsMember = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName);
        if (notExistsMember.isEmpty()) {
            return;
        }
        ArrayList metadataItems = new ArrayList(notExistsMember.size());
        notExistsMember.forEach(mem -> {
            MemberMetadataItem metadataItem = new MemberMetadataItem();
            metadataItem.setName(mem);
            metadataItems.add(metadataItem);
        });
        BatchProcessHelper.batchConsume(new ArrayList(metadataItems), (int)5000, batchBetadataItems -> {
            cmd.getItems().addAll(batchBetadataItems);
            OlapServiceHelper.executeCommand(cmd, cubeName);
            cmd.getItems().clear();
        });
        HashMap map = new HashMap(16);
        List<String> ignores = Arrays.asList("Entity", "RatePreset");
        tupleList.forEach(t -> {
            if (StringUtils.isNotEmpty((String)((String)t.p3))) {
                List l = map.getOrDefault(t.p3, new ArrayList(10));
                if (!ignores.contains(t.p1)) {
                    l.add(OlapUtils.createAggFactorMetadataItem((String)t.p1, (Integer)t.p2));
                }
                map.put(t.p3, l);
            }
        });
        if (ICVersionServiceHelper.isICVersion(cubeName, dimension)) {
            SlowEvolvingServiceHelper.createTags(cubeName, PresetConstant.INTERNALCOMPANY_DIM, new String[]{"internal", "external", "ICNone"});
        }
        for (Map.Entry entry : map.entrySet()) {
            OlapServiceHelper.createAggFactor(cubeName, dimension, (String)entry.getKey(), (List)entry.getValue());
        }
    }

    public static void batchCreateDimensionMembers(String cubeName, String dimension, String[] members) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        Set<String> notExistsMember = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName);
        if (notExistsMember.isEmpty()) {
            return;
        }
        notExistsMember.forEach(mem -> {
            MemberMetadataItem metadataItem = new MemberMetadataItem();
            metadataItem.setName(mem);
            cmd.getItems().add(metadataItem);
        });
        OlapServiceHelper.executeCommand(cmd, cubeName);
    }

    public static void batchCreateDimensionMembers(String cubeName, String dimension, List<Tuple<String, Integer, String>> tupleList) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        String[] members = new String[tupleList.size()];
        for (int i = 0; i < tupleList.size(); ++i) {
            members[i] = (String)tupleList.get((int)i).p1;
        }
        Set<String> notExistsMember = OlapServiceHelper.batCheckMemberIsExistOlap(dimension, members, cubeName);
        if (notExistsMember.isEmpty()) {
            return;
        }
        notExistsMember.forEach(mem -> {
            MemberMetadataItem metadataItem = new MemberMetadataItem();
            metadataItem.setName(mem);
            cmd.getItems().add(metadataItem);
        });
        OlapServiceHelper.executeCommand(cmd, cubeName);
        OlapServiceHelper.batchCreateAggFactors(cubeName, dimension, tupleList);
    }

    public static void alterMemberName(String cubeName, String dimension, String number, String newNumber) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setOwnerUniqueName(cubeName + "." + dimension);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setName(number);
        cmd.setNewName(newNumber);
        OlapServiceHelper.executeCommand(cmd, cubeName);
    }

    public static void batchCreateAggFactors(String cubeName, String dimension, List<Tuple<String, Integer, String>> tupleList) {
        if (tupleList == null) {
            return;
        }
        HashMap map = new HashMap(16);
        HashMap parentSourceMap = new HashMap(16);
        tupleList.forEach(t -> {
            if (t.p3 != null) {
                List l = map.getOrDefault(t.p3, new ArrayList(10));
                l.add(OlapUtils.createAggFactorMetadataItem((String)t.p1, (Integer)t.p2));
                map.put(t.p3, l);
                if (!parentSourceMap.containsKey(t.p3)) {
                    parentSourceMap.put(t.p3, new ArrayList(8));
                }
                ((List)parentSourceMap.get(t.p3)).add(t);
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            try {
                OlapServiceHelper.createAggFactor(cubeName, dimension, (String)entry.getKey(), (List)entry.getValue());
            }
            catch (Exception e) {
                logger.error(ResManager.loadKDString((String)"olap \u66f4\u65b0\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"OlapServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), (Throwable)e);
                List sameParentBatch = (List)parentSourceMap.get(entry.getKey());
                for (Tuple tuple : sameParentBatch) {
                    try {
                        OlapServiceHelper.createAggFactor(cubeName, dimension, (String)tuple.p1, (Integer)tuple.p2, (String)tuple.p3);
                    }
                    catch (KDBizException ex) {
                        logger.error(ResManager.loadKDString((String)"olap \u66f4\u65b0\u5143\u6570\u636e\u5931\u8d25\u3002", (String)"OlapServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), (Throwable)ex);
                        OlapServiceHelper.handleAggFactor(cubeName, dimension, (String)tuple.p3, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem((String)tuple.p1, (Integer)tuple.p2)}), CommandTypes.alter);
                    }
                }
            }
        }
    }

    private static void handleAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList, CommandTypes commandType) {
        if (OlapServiceHelper.isEntityRoot(dimNum, memNum)) {
            return;
        }
        if (ICVersionServiceHelper.isICVersion(cubeNum, dimNum) && CollectionUtils.isNotEmpty(factorList)) {
            String memberTag = ICVersionServiceHelper.getMemberTags(memNum);
            List<String> members = factorList.stream().map(m -> m.getName()).collect(Collectors.toList());
            if (memberTag != null && !members.contains("ICTotal")) {
                SlowEvolvingServiceHelper.tagMembers(cubeNum, dimNum, memberTag, members);
            }
            OlapServiceHelper.clearDimMemberCache(cubeNum, dimNum);
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(commandType);
        cmd.setMetadataType(MetadataTypes.AggFactor);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum + "@" + memNum);
        cmd.getItems().addAll(factorList);
        if (CommandTypes.drop == commandType) {
            try {
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else {
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
        }
        OlapServiceHelper.clearDimMemberCache(cubeNum, dimNum);
    }

    private static boolean isEntityRoot(String dimNum, String memNum) {
        return "Entity".equals(memNum) && PresetConstant.ENTITY_DIM.equals(dimNum);
    }

    public static void createAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.create);
    }

    public static void createAggFactor(String cubeNum, String dimNum, String memNum, int aggOprt, String parentNumber) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(memNum, aggOprt)}), CommandTypes.create);
    }

    public static void alterAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.alter);
    }

    public static void dropAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.drop);
    }

    public static void dropAggFactor(String cubeNum, String dimNum, String memNum, int aggOprt, String parentNumber) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, parentNumber, Lists.newArrayList((Object[])new AggFactorMetadataItem[]{OlapUtils.createAggFactorMetadataItem(memNum, aggOprt)}), CommandTypes.drop);
    }

    public static void batchDropAggFactor(String cubeNum, String dimNum, Multimap<String, kd.fi.bcm.common.Pair<String, Integer>> multimap) {
        for (String key : multimap.keySet()) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)multimap.get((Object)key).size());
            for (kd.fi.bcm.common.Pair pair : multimap.get((Object)key)) {
                list.add(OlapUtils.createAggFactorMetadataItem((String)pair.p1, (Integer)pair.p2));
            }
            OlapServiceHelper.handleAggFactor(cubeNum, dimNum, key, list, CommandTypes.drop);
        }
    }

    public static void repairAggFactor(String cubeNum, String dimNum, String memNum, List<AggFactorMetadataItem> factorList) {
        OlapServiceHelper.handleAggFactor(cubeNum, dimNum, memNum, factorList, CommandTypes.repair);
    }

    public static void batchAlterAggFactorNoRetry(String cubeNum, String dimNum, Map<String, List<AggFactorMetadataItem>> map) {
        if (map != null && map.size() > 0) {
            MetadataCommandInfo cmd = new MetadataCommandInfo();
            cmd.setAction(CommandTypes.alter);
            cmd.setMetadataType(MetadataTypes.Member);
            cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
            List items = cmd.getItems();
            for (Map.Entry<String, List<AggFactorMetadataItem>> entry : map.entrySet()) {
                String memNum = entry.getKey();
                List<AggFactorMetadataItem> agg = entry.getValue();
                MemberMetadataItem memItem = new MemberMetadataItem();
                memItem.setName(memNum);
                memItem.setFactors(agg);
                items.add(memItem);
                if (items.size() % 5000 != 0) continue;
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
                items.clear();
            }
            if (items.size() > 0) {
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
            }
            OlapServiceHelper.clearDimMemberCache(cubeNum, dimNum);
        }
    }

    public static void batchRepairAggFactor(String cubeNum, String dimNum, Map<String, List<AggFactorMetadataItem>> map) {
        if (map != null && map.size() > 0) {
            MetadataCommandInfo cmd = new MetadataCommandInfo();
            cmd.setAction(CommandTypes.alter);
            cmd.setMetadataType(MetadataTypes.Member);
            cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
            List items = cmd.getItems();
            for (Map.Entry<String, List<AggFactorMetadataItem>> entry : map.entrySet()) {
                String memNum = entry.getKey();
                List<AggFactorMetadataItem> agg = entry.getValue();
                MemberMetadataItem memItem = new MemberMetadataItem();
                memItem.setName(memNum);
                memItem.setFactors(agg);
                items.add(memItem);
                if (items.size() % 5000 != 0) continue;
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
                items.clear();
            }
            if (items.size() > 0) {
                OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
            }
            OlapServiceHelper.clearDimMemberCache(cubeNum, dimNum);
        }
    }

    private static void executeUpdateMetadata(MetadataCommandInfo cmd, String cubeNum) {
        if (!ConfigServiceHelper.getBoolParam(cubeNum, "CM006")) {
            return;
        }
        String bizType = ResManager.loadKDString((String)"OLAP\u66f4\u65b0\u6307\u4ee4", (String)"OlapServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]);
        OlapEnhancementHelper.enhanceOlapCommandWithAudit((String)cubeNum, null, (CommandInfo)cmd);
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cubeNum);
            conn.Open();
            OlapCommand olapCommand = new OlapCommand(conn, (CommandInfo)cmd);
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"executeUpdateMetadata");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"executeUpdateMetadata");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"executeUpdateMetadata", cmd});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", cmd.toString());
                }
                ts.addTag("route", cubeNum);
                olapCommand.updateMetadata();
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            ErrorLogServiceHelper.saveErrorLog(MemberReader.findModelIdByNum((String)cubeNum), bizType, cmd.toString(), ThrowableHelper.toString((Exception)e));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u66f4\u65b0\u5143\u6570\u636e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static void alterMemberStorageType(String cubeNum, String dimNum, String memNum, String storetype) {
        if (StorageTypeEnum.DYNAMIC.getOIndex().equals(storetype)) {
            OlapServiceHelper.alterMemberStorageType(cubeNum, dimNum, memNum, MemberStorageTypes.DynamicCalc);
        } else {
            OlapServiceHelper.alterMemberStorageType(cubeNum, dimNum, memNum, MemberStorageTypes.Stored);
        }
    }

    public static void alterMemberStorageType(String cubeNum, String dimNum, String memNum, MemberStorageTypes type) {
        HashMap<String, MemberStorageTypes> map = new HashMap<String, MemberStorageTypes>(16);
        map.put(memNum, type);
        OlapServiceHelper.batchAlterMemberStorageType(cubeNum, dimNum, map);
    }

    public static void batchAlterMemberStorageType(String cubeNum, String dimNum, Map<String, MemberStorageTypes> map) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
        List items = cmd.getItems();
        for (Map.Entry<String, MemberStorageTypes> entry : map.entrySet()) {
            String memNum = entry.getKey();
            MemberStorageTypes type = entry.getValue();
            MemberMetadataItem memItem = new MemberMetadataItem();
            if (type == MemberStorageTypes.Stored) {
                memItem.getProperties().set("storageType", "");
            } else {
                memItem.getProperties().set("storageType", type.getCode());
            }
            memItem.setName(memNum);
            items.add(memItem);
            if (items.size() % 100000 != 0) continue;
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
            items.clear();
        }
        if (items.size() > 0) {
            OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
        }
    }

    public static void alterMemberAggRule(String cubeNum, String dimNum, String memNum, String rule) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setMetadataType(MetadataTypes.Member);
        cmd.setOwnerUniqueName(cubeNum + "." + dimNum);
        cmd.setName(memNum);
        cmd.getProperties().set("aggShieldRule", rule);
        OlapServiceHelper.executeUpdateMetadata(cmd, cubeNum);
    }

    public static void excuteAggScript(String cube, AggScriptBuilder builder) {
        OlapServiceHelper.excuteAggScript(cube, builder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excuteAggScript(String cube, AggScriptBuilder builder, boolean throwException) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cube);
            conn.Open();
            Outline ot = new Outline(conn);
            ComputingEngine computingEngine = new ComputingEngine(conn, (IOutline)ot);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("outline", ot);
            String script = builder.getBuildScript(params, conn, (IOutline)ot);
            builder.buildScope2ScriptParam(params, conn, (IOutline)ot);
            computingEngine.execute(script, params);
            if (builder.isNeedUpdateDataStatus()) {
                DataMonitorServiceHelper.dataMonitor(builder, cube, null);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (throwException) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"olap \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()), e);
            }
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static void excuteScript(String cube, String script, Map<String, Object> params) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cube);
            conn.Open();
            Outline ot = new Outline(conn);
            ComputingEngine computingEngine = new ComputingEngine(conn, (IOutline)ot);
            params.put("outline", ot);
            computingEngine.execute(script, params);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static <T> T excuteScriptNew(String cube, String script, Map<String, Object> params) {
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cube);
            conn.Open();
            Outline ot = new Outline(conn);
            BizRuleExecParam bizRuleExecParam = new BizRuleExecParam(cube);
            params.forEach((k, v) -> bizRuleExecParam.addCommonParamPair(k, (kd.fi.bcm.common.Pair)v));
            params.clear();
            ComputingEngine computingEngine = new ComputingEngine(conn, (IOutline)ot);
            params.put("outline", ot);
            params.put("ctx", ComputingContext.create((OlapConnection)conn, (IOutline)ot, (BizRuleExecParam.BizRuleExecCommonParam)bizRuleExecParam.getCommonParam()));
            Object object = computingEngine.execute(script, params);
            return (T)object;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new InvalidParamException(String.format(ResManager.loadKDString((String)"olap \u64cd\u4f5c\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static Map<Long, String> excuteScript4ReportParams(String cube, List<BizRuleExecParam> paramList, ApplicationTypeEnum app) {
        return RuleExecuteServiceHelper.excuteScript4ReportParams((String)cube, paramList, (ApplicationTypeEnum)app, (boolean)true);
    }

    public static Map<Long, String> excuteScript4ReportParams(String cube, List<BizRuleExecParam> paramList, ApplicationTypeEnum app, boolean isDebug) {
        return RuleExecuteServiceHelper.excuteScript4ReportParams((String)cube, paramList, (ApplicationTypeEnum)app, (boolean)isDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIsOnline(String olapconnect, String username, String password) {
        boolean flag = true;
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setMetadataType(MetadataTypes.Cube);
        cmd.setName("olapTestCube");
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(olapconnect, username, password, "olapTestCube");
            conn.Open();
            new OlapCommand(conn, (CommandInfo)cmd).executeNonQuery();
        }
        catch (Exception e) {
            flag = false;
            logger.error("Olap Check Connection Error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
        return flag;
    }

    public static OlapConnection getOlapConnection(String cubeNum) {
        OlapConnection olapConnection;
        if (OlapSandBoxContext.get().isSandboxEnv(cubeNum)) {
            olapConnection = RuleExecuteServiceHelper.getOlapConnection((String)cubeNum, (boolean)true);
            OlapSandBoxContext.get().initOlapConnection(cubeNum, olapConnection);
            olapConnection = OlapSandBoxContext.get().getOlapConnection(cubeNum);
        } else {
            olapConnection = RuleExecuteServiceHelper.getOlapConnection((String)cubeNum);
        }
        return olapConnection;
    }

    public static OlapConnection getOlapConnection(String olapconnect, String username, String password, String catalog) {
        OlapConnection conn = new OlapConnection(OlapConstant.getConnectSerial((String)olapconnect, (String)catalog));
        conn.setUserName(EncryptUtils.aesDecrypt((String)username));
        conn.setPassword(EncryptUtils.aesDecrypt((String)password));
        return conn;
    }

    public static BigDecimal getLegalDecimalForOlap(BigDecimal value) {
        return value.setScale(15, RoundingMode.HALF_UP);
    }

    public static long selectDatasource(boolean isCheckAvailable) {
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"epbs_datasource", (String)"id", (QFilter[])new QFilter[0]);
        if (!dataSources.isEmpty()) {
            if (isCheckAvailable) {
                for (DynamicObject dsDy : dataSources) {
                    long dataSourceID = dsDy.getLong("id");
                    if (!OlapServiceHelper.checkConnection(dataSourceID)) continue;
                    return dataSourceID;
                }
            } else {
                return ((DynamicObject)dataSources.get(0)).getLong("id");
            }
        }
        return 0L;
    }

    public static List<String> getMembersOfDimFromOlap(String dimensionNum, String cube) {
        OlapConnection connect = OlapServiceHelper.getOlapConnection(cube);
        PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, dimensionNum, true);
        String[] childs = null;
        ArrayList<String> olapMembers = new ArrayList<String>(10);
        if (propertyBag.get("exist").equals("true")) {
            childs = propertyBag.get("children").split("\n");
            olapMembers = new ArrayList<String>(Arrays.asList(childs));
        }
        return olapMembers;
    }

    public static Set<String> batCheckMemberIsExistOlap(String dimensionNum, String[] memberNum, String cube) {
        if (memberNum == null || memberNum.length == 0) {
            return Sets.newHashSet();
        }
        List<String> olapMembers = OlapServiceHelper.getMembersOfDimFromOlap(dimensionNum, cube);
        if (CollectionUtils.isEmpty(olapMembers)) {
            return Sets.newHashSet((Object[])memberNum);
        }
        HashSet olapMembersLowCase = new HashSet(olapMembers.size());
        HashSet<String> notExistMember = new HashSet<String>(memberNum.length);
        olapMembers.forEach(member -> olapMembersLowCase.add(member.toLowerCase(Locale.ENGLISH)));
        for (int i = 0; i < memberNum.length; ++i) {
            if (olapMembersLowCase.contains(String.valueOf(memberNum[i]).toLowerCase(Locale.ENGLISH))) continue;
            notExistMember.add(String.valueOf(memberNum[i]));
        }
        return notExistMember;
    }

    public static PropertyBag isExistMetadataNames(OlapConnection con, String path, boolean children) {
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.set("path", path);
        propertyBag.set("children", String.valueOf(children));
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getMetadataNames", propertyBag);
        OlapCommand cmd = new OlapCommand(con, (CommandInfo)functionCommandInfo);
        return cmd.executeFunction();
    }

    public static boolean isExistCube(String cube) {
        try {
            OlapConnection connect = OlapServiceHelper.getOlapConnection(cube);
            PropertyBag propertyBag = OlapServiceHelper.isExistMetadataNames(connect, "", false);
            return "true".equals(propertyBag.get("exist"));
        }
        catch (Exception e) {
            logger.error("OlapServiceHelper_isExistCube check faield:" + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static void setMemberAggShieldRule(String cubeNum, String dimNum, String memNum, String ruleNumber) {
        MetadataCommandInfo memberCreateCmd = new MetadataCommandInfo();
        memberCreateCmd.setMetadataType(MetadataTypes.Member);
        memberCreateCmd.setAction(CommandTypes.alter);
        memberCreateCmd.setOwnerUniqueName(cubeNum + '.' + dimNum);
        memberCreateCmd.setName(memNum);
        memberCreateCmd.setMemberAggShieldRule(ruleNumber);
        OlapServiceHelper.executeUpdateMetadata(memberCreateCmd, cubeNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existAggShieldRule(String cube, String name) {
        OlapConnection conn = OlapServiceHelper.getOlapConnection(cube);
        FunctionCommandInfo info = new FunctionCommandInfo("getAggShieldRules");
        try {
            Map[] cast;
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)info);
            PropertyBag propertyBag = cmd.executeFunction();
            String result = propertyBag.get("result");
            for (Map map : cast = (Map[])JSONUtils.cast((String)result, Map[].class)) {
                Object n = map.get("name");
                if (!name.equals(n)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            conn.Close();
        }
        return false;
    }

    public static void createAggShieldRule(String cubeNum, String number, List<String> dims) {
        MetadataCommandInfo createAggShieldRuleCmd = new MetadataCommandInfo();
        createAggShieldRuleCmd.setMetadataType(MetadataTypes.AggShieldRule);
        createAggShieldRuleCmd.setAction(CommandTypes.create);
        createAggShieldRuleCmd.setOwnerUniqueName(cubeNum);
        List items = createAggShieldRuleCmd.getItems();
        AggShieldRuleBlackListMetadataItem item1 = new AggShieldRuleBlackListMetadataItem(number);
        item1.setDimensionList(dims);
        items.add(item1);
        OlapServiceHelper.executeUpdateMetadata(createAggShieldRuleCmd, cubeNum);
    }

    public static boolean checkDSIsEnableDynamic(String ip, String port, String user, String pwd) {
        String olapconnect = "http://" + ip + ":" + port + "/bos-olap-webserver/services/httpolap";
        String CUBE_CATALOG = "provider=kingdee.olap.Shrek;isForTest=false;datasource=" + olapconnect;
        OlapConnection conn = new OlapConnection(CUBE_CATALOG);
        conn.setUserName(EncryptUtils.aesDecrypt((String)user));
        conn.setPassword(EncryptUtils.aesDecrypt((String)pwd));
        return OlapServiceHelper.checkIsEnableDynamic(conn);
    }

    public static boolean checkCubeIsEnableDynamic(String cube) {
        OlapConnection conn = OlapServiceHelper.getOlapConnection(cube);
        return OlapServiceHelper.checkIsEnableDynamic(conn);
    }

    private static boolean checkIsEnableDynamic(OlapConnection conn) {
        try {
            FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("isEnableDynamic");
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            String result = cmd.executeFunction().get("isEnable");
            return "true".equals(result);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static String excuteCustomFunction(String cube, String function, String param) {
        try {
            OlapConnection conn = OlapServiceHelper.getOlapConnection(cube);
            FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo(function);
            OlapEnhancementHelper.enhanceOlapCommandWithAudit((String)cube, null, (CommandInfo)functionCommandInfo);
            functionCommandInfo.getParameters().set("path", param);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)functionCommandInfo);
            String result = cmd.executeFunction().get("result");
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static boolean checkConnection(long datasourceId) {
        QFilter idFilter = new QFilter("id", "=", (Object)datasourceId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"serveraddress,port,username,password", (QFilter[])new QFilter[]{idFilter});
        if (dyn == null) {
            return false;
        }
        String serveraddress = dyn.getString("serveraddress");
        String port = dyn.getString("port");
        String username = dyn.getString("username");
        String password = dyn.getString("password");
        String conn = "http://" + serveraddress + ":" + port + "/bos-olap-webserver/services/httpolap";
        return OlapServiceHelper.checkIsOnline(conn, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alterSingleMemberName(String cube, String dimensionName, String memberOldName, String memberNewName) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Member);
        commandInfo.setAction(CommandTypes.alter);
        commandInfo.setName(memberOldName);
        commandInfo.setOwnerUniqueName(cube + "." + dimensionName);
        commandInfo.getProperties().set("newName", memberNewName);
        OlapConnection olapConnection = OlapServiceHelper.getOlapConnection(cube);
        try {
            olapConnection.Open();
            OlapCommand cmd = new OlapCommand(olapConnection, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
        finally {
            olapConnection.Close();
        }
    }

    public static File backupCube(String cubeName) throws IOException {
        File _tempDir = FileUtils.getTempDirectory();
        File genDataDir = new File(_tempDir, String.format("modeback_%s_%s", cubeName, GlobalIdUtil.genStringId()));
        FileUtils.forceMkdir((File)genDataDir);
        BackupCommandInfo commandInfo = new BackupCommandInfo((BackupFile)new DirectFile(genDataDir.getAbsolutePath()));
        OlapConnection conn = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(cubeName);
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)commandInfo);
            cmd.executeBackup();
            File file = (File)FileUtils.listFiles((File)genDataDir, (String[])new String[]{"backup"}, (boolean)false).iterator().next();
            return file;
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5907\u4efdCUBE: %1$s \u5230\u6587\u4ef6 %2$s \u5931\u8d25: %3$s", (String)"OlapServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), cubeName, genDataDir.getAbsolutePath(), e.getMessage());
            logger.error(errMsg, (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)errMsg), new Object[0]);
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static void backupCube(String cubeName, File targetFile) throws IOException {
        File backFile = OlapServiceHelper.backupCube(cubeName);
        FileUtils.moveFile((File)backFile, (File)targetFile);
    }

    public static void restoreCubeFromFile(String targetCubeName, long datasourceId, File dataFile) {
        if (!dataFile.exists()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u6587\u4ef6\uff1a%s \u4e0d\u5b58\u5728\u3002", (String)"OlapServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), dataFile.getPath()));
        }
        RecoveryCommandInfo commandInfo = new RecoveryCommandInfo(targetCubeName, (BackupFile)new DirectFile(dataFile.getAbsolutePath()));
        OlapConnection conn = null;
        try {
            QFilter idFilter = new QFilter("id", "=", (Object)datasourceId);
            DynamicObject dsDy = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"id,dataconnect,serveraddress,port,username,password,number", (QFilter[])idFilter.toArray());
            DataConnectCacheUtil.checkDataSource((String)dsDy.getString("number"));
            DatasourceModel datasource = new DatasourceModel(dsDy.getString("dataconnect"), dsDy.getString("username"), dsDy.getString("password"));
            DataConnectCacheUtil.cacheDataSource((String)targetCubeName, (DatasourceModel)datasource);
            QFilter filter = new QFilter("number", "=", (Object)targetCubeName);
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"issourcemeasure,islockmeasure", (QFilter[])filter.toArray());
            if (model != null && (model.getBoolean("issourcemeasure") || model.getBoolean("islockmeasure")) && !OlapServiceHelper.canAddMeasure(dsDy.getLong("id"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u4f53\u7cfb\u5f00\u542f\u4e86\u6570\u636e\u6765\u6e90\u6216\u62a5\u8868\u6570\u636e\u9501\u5b9a\u6807\u8bb0\uff0c\u5f53\u524d\u591a\u7ef4\u5e93\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u5347\u7ea7\u591a\u7ef4\u5e93\u7248\u672c\u540e\u518d\u6267\u884c\u5bfc\u5165\u3002", (String)"OlapServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            conn = OlapServiceHelper.getOlapConnection(targetCubeName);
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)commandInfo);
            cmd.executeRecovery();
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8fd8\u539fCUBE: %1$s \u4ece\u6587\u4ef6 %2$s \u5931\u8d25: %3$s", (String)"OlapServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), targetCubeName, dataFile, e.getMessage());
            logger.error(errMsg, (Throwable)e);
            throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)errMsg), new Object[0]);
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
    }

    public static Map<String, Boolean> judgeExistMDDataByMember(String cubeCatalog, String dimNum, Set<String> members) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(members.size());
        SQLBuilder sql = new SQLBuilder(cubeCatalog);
        sql.addSelectField(dimNum);
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        sql.addMeasures(measure);
        sql.setIncludeNull(false);
        sql.setExcludeDynaData(true);
        for (String member : members) {
            sql.replaceOrAddFilter(dimNum, member);
            result.put(member, OlapServiceHelper.judeExistNotNullMDData(sql));
        }
        return result;
    }

    public static boolean hasOlapData(String cubeNum, List<String> memberNum, String dimensionNum) {
        Map<String, Boolean> queryData = OlapServiceHelper.queryData(cubeNum, memberNum, dimensionNum);
        return memberNum.stream().anyMatch(m -> (Boolean)queryData.get(m));
    }

    public static List<String> getHasOlapDataMembers(String cubeNum, List<String> memberNum, String dimensionNum) {
        Map<String, Boolean> queryData = OlapServiceHelper.queryData(cubeNum, memberNum, dimensionNum);
        return queryData.keySet().stream().filter(k -> (Boolean)queryData.get(k)).collect(Collectors.toList());
    }

    public static Map<String, Boolean> queryData(String cubeNum, List<String> memberNum, String dimensionNum) {
        boolean result = (Boolean)GlobalCacheServiceHelper.getCommonCache().getOrLoad("checkOlapDataSourceIsEffect" + cubeNum, () -> OlapServiceHelper.checkConnection(cubeNum));
        if (!result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u591a\u7ef4\u6570\u636e\u6e90\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u914d\u7f6e\u3002", (String)"OlapServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        Set<String> notExistMembers = OlapServiceHelper.batCheckMemberIsExistOlap(dimensionNum, memberNum.toArray(new String[0]), cubeNum);
        if (!CollectionUtils.isEmpty(notExistMembers)) {
            memberNum.removeAll(notExistMembers);
        }
        if (memberNum.isEmpty()) {
            return Maps.newHashMap();
        }
        HashSet members = Sets.newHashSet(memberNum);
        return OlapServiceHelper.judgeExistMDDataByMember(cubeNum, dimensionNum, members);
    }

    public static boolean judeExistNotNullMDData(SQLBuilder sql) {
        int limitCount = 1000000;
        String measure = sql.getMeasures()[0];
        boolean isExist = false;
        try (MDResultSetReader rs = OlapServiceHelper.queryDataReader(sql);){
            int exeCount = 0;
            while (rs.next()) {
                if (exeCount >= limitCount) {
                    break;
                }
                Object v = rs.getOriginalValue(measure);
                if (v != null && (v instanceof Number && BigDecimal.ZERO.compareTo(new BigDecimal(v.toString())) != 0 || v instanceof String && StringUtils.isNotEmpty((String)v.toString()))) {
                    isExist = true;
                    break;
                }
                ++exeCount;
            }
        }
        return isExist;
    }

    public static MDResultSetReader queryDataReader(SQLBuilder sql) {
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        queryInfo.addMeasures(sql.getMeasures());
        queryInfo.setExcludeDynamicCalcResult(sql.isExcludeDynaData());
        OlapServiceHelper.setExcludeNull(sql, queryInfo);
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        if (sql.getTop() > 0) {
            queryInfo.setTop(sql.getTop());
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            conn = OlapServiceHelper.getOlapConnection(sql.getCubecatalog());
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
            cs = cmd.ExecuteReader();
            MDResultSetReader rs = new MDResultSetReader();
            CellSetResultSet set = new CellSetResultSet(sql.getCubecatalog(), cs, queryInfo, conn);
            set.setIncludeNull(sql.getTop() > 0 || sql.isIncludeNull());
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"query");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"query");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"query", queryInfo});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
                rs.populate(set);
            }
            return rs;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new MDQueryException(String.format(ResManager.loadKDString((String)"olap \u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"OlapServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static void changeExcludeMonth(String cubeNum, String mounthArray, String includeYear) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.AggShieldRule);
        commandInfo.setAction(CommandTypes.repair);
        commandInfo.setOwnerUniqueName(cubeNum);
        String ruleName = EXCLUDEMONTHS;
        List<Object> aggShieldRuleList = new ArrayList();
        if (StringUtils.isNotEmpty((String)mounthArray)) {
            mounthArray = mounthArray.substring(1, mounthArray.length());
            String[] mounths = mounthArray.split(",");
            aggShieldRuleList = Arrays.asList(mounths);
        }
        AggShieldRuleDataPartitionMetadataItem item = new AggShieldRuleDataPartitionMetadataItem(ruleName, aggShieldRuleList);
        commandInfo.getItems().add(item);
        OlapConnection olapConnection = OlapServiceHelper.getOlapConnection(cubeNum);
        try {
            olapConnection.Open();
            OlapCommand cmd = new OlapCommand(olapConnection, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), exception.getMessage()));
        }
        finally {
            olapConnection.Close();
        }
        MetadataCommandInfo commandIncludeYear = new MetadataCommandInfo();
        commandIncludeYear.setMetadataType(MetadataTypes.Member);
        commandIncludeYear.setAction(CommandTypes.alter);
        commandIncludeYear.setName(includeYear);
        commandIncludeYear.setOwnerUniqueName(cubeNum + '.' + "Year");
        commandIncludeYear.setMemberAggShieldRule(ruleName);
        OlapConnection olapYearConnection = OlapServiceHelper.getOlapConnection(cubeNum);
        try {
            olapYearConnection.Open();
            OlapCommand yearCmd = new OlapCommand(olapYearConnection, (CommandInfo)commandIncludeYear);
            yearCmd.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), exception.getMessage()));
        }
        finally {
            olapYearConnection.Close();
        }
    }

    public static void excludeMonth(String cubeNum, String mounthArray, String includeYear, String dimNum, Boolean hasShieldRule) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.AggShieldRule);
        if (hasShieldRule.booleanValue()) {
            commandInfo.setAction(CommandTypes.repair);
        } else {
            commandInfo.setAction(CommandTypes.create);
        }
        commandInfo.setOwnerUniqueName(cubeNum);
        String ruleName = EXCLUDEMONTHS;
        mounthArray = mounthArray.substring(1, mounthArray.length());
        String[] mounths = mounthArray.split(",");
        AggShieldRuleDataPartitionMetadataItem item = new AggShieldRuleDataPartitionMetadataItem(ruleName, Arrays.asList(mounths));
        commandInfo.getItems().add(item);
        OlapConnection olapConnection = OlapServiceHelper.getOlapConnection(cubeNum);
        try {
            olapConnection.Open();
            OlapCommand cmd = new OlapCommand(olapConnection, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), exception.getMessage()));
        }
        finally {
            olapConnection.Close();
        }
        MetadataCommandInfo commandIncludeYear = new MetadataCommandInfo();
        commandIncludeYear.setMetadataType(MetadataTypes.Member);
        commandIncludeYear.setAction(CommandTypes.alter);
        commandIncludeYear.setName(includeYear);
        commandIncludeYear.setOwnerUniqueName(cubeNum + '.' + dimNum);
        commandIncludeYear.setMemberAggShieldRule(ruleName);
        OlapConnection olapConnection1 = OlapServiceHelper.getOlapConnection(cubeNum);
        try {
            olapConnection1.Open();
            OlapCommand cmd1 = new OlapCommand(olapConnection1, (CommandInfo)commandIncludeYear);
            cmd1.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), exception.getMessage()));
        }
        finally {
            olapConnection1.Close();
        }
    }

    public static void includeYear(String excludeYear, String cubNum, String dimNum) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Member);
        commandInfo.setAction(CommandTypes.alter);
        commandInfo.setName(excludeYear);
        commandInfo.setOwnerUniqueName(cubNum + '.' + dimNum);
        commandInfo.setMemberAggShieldRule(OTHER);
        OlapConnection olapConnection = OlapServiceHelper.getOlapConnection(cubNum);
        try {
            olapConnection.Open();
            OlapCommand cmd = new OlapCommand(olapConnection, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a8\u6001\u8ba1\u7b97\u671f\u95f4\u8bbe\u7f6e\u5931\u8d25\uff0c%s", (String)"OlapServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), exception.getMessage()));
        }
        finally {
            olapConnection.Close();
        }
    }

    public static boolean checkConnection(String cubeNum) {
        QFilter qf = new QFilter("number", "=", (Object)cubeNum);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)"datasource", (QFilter[])qf.toArray());
        if (dynamicObject == null || dynamicObject.getLong("datasource") == 0L) {
            return false;
        }
        long id = dynamicObject.getLong("datasource");
        return OlapServiceHelper.checkConnection(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPartitions(String cubNum) {
        MetadataCommandInfo commandInfo = new MetadataCommandInfo();
        commandInfo.setMetadataType(MetadataTypes.Partition);
        commandInfo.setAction(CommandTypes.repair);
        commandInfo.setOwnerUniqueName(cubNum);
        commandInfo.addPartitions(new String[]{"Year"});
        OlapConnection connection = null;
        try {
            connection = OlapServiceHelper.getOlapConnection(cubNum);
            connection.Open();
            OlapCommand cmd = new OlapCommand(connection, (CommandInfo)commandInfo);
            cmd.executeNonQuery();
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        finally {
            if (connection != null) {
                connection.Close();
            }
        }
    }

    public static void createOrgPiecewise(String cubeNum, String number, String quoteNumber) {
        OlapScopeHelper.createOrgPiecewise(cubeNum, number, quoteNumber);
    }

    public static boolean findOrgPiecewise(String cubeNum, String dimNumber, String number) {
        return OlapScopeHelper.findOrgPiecewise(cubeNum, dimNumber, number);
    }

    public static void createRateOrgPiecewise(String cubeNum, String number, String quoteNumber) {
        OlapScopeHelper.createRateOrgPiecewise(cubeNum, number, quoteNumber);
    }

    public static boolean findRateOrgPiecewise(String cubeNum, String dimNumber, String number) {
        return OlapScopeHelper.findRateOrgPiecewise(cubeNum, dimNumber, number);
    }

    public static void addOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        OlapScopeHelper.addOrgPointScope(cubeNum, number, pairList);
    }

    public static void addRateOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        OlapScopeHelper.addRateOrgPointScope(cubeNum, number, pairList);
    }

    public static void removePointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        OlapScopeHelper.removePointScope(cubeNum, number, pairList);
    }

    public static void dropRateOrgPointScope(String cubeNum, String number) {
        OlapScopeHelper.dropRateOrgPointScope(cubeNum, number);
    }

    public static void removeRateOrgPointScope(String cubeNum, String number, PairList<String, Object> pairList) {
        OlapScopeHelper.removeRateOrgPointScope(cubeNum, number, pairList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getCubeMeasures(String cube) {
        OlapConnection con = OlapServiceHelper.getOlapConnection(cube);
        FunctionCommandInfo functionCommandInfo = new FunctionCommandInfo("getCubeMeasures");
        OlapCommand cmd = new OlapCommand(con, (CommandInfo)functionCommandInfo);
        HashSet<String> measures = new HashSet<String>(16);
        try {
            String result = cmd.executeFunction().get("measures");
            List list = (List)JSONUtils.cast((String)result, ArrayList.class);
            list.forEach(l -> measures.add((String)l.get("name")));
            HashSet<String> hashSet = measures;
            return hashSet;
        }
        catch (Throwable e) {
            logger.error("getCubeMeasures fail." + ThrowableHelper.toString((Throwable)e));
            HashSet hashSet = Sets.newHashSet((Object[])new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            return hashSet;
        }
        finally {
            if (con != null) {
                con.Close();
            }
        }
    }

    public static boolean checkMeasure(String modelNum, String measure) {
        return AppCacheServiceHelper.getCacheMeasures(modelNum).contains(measure);
    }

    private static Tuple<Integer, Integer, Integer> getOlapServerVersion(Long datasource) {
        return (Tuple)GlobalCacheServiceHelper.getCommonCache().getOrLoad("getOlapServerVersion" + datasource, () -> {
            QFilter filter = new QFilter("id", "=", (Object)datasource);
            DynamicObject datasourceDy = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"dataconnect,username,password", (QFilter[])filter.toArray());
            if (datasourceDy == null) {
                return Tuple.create((Object)0, (Object)0, (Object)0);
            }
            try (OlapConnection conn = OlapServiceHelper.getOlapConnection(datasourceDy.getString("dataconnect"), datasourceDy.getString("username"), datasourceDy.getString("password"), "");){
                FunctionCommandInfo command = new FunctionCommandInfo("getServerInfo");
                OlapCommand cmd = new OlapCommand(conn, (CommandInfo)command);
                PropertyBag bag = cmd.executeFunction();
                Map map = (Map)JSONUtils.cast((String)bag.get("version"), Map.class);
                String major = String.valueOf(map.get("majorVersion"));
                String minor = String.valueOf(map.get("minorVersion"));
                String[] thirds = ((String)map.get("stringValue")).split("\\.");
                int majorVersion = StringUtils.isNotEmpty((String)major) ? Integer.parseInt(major) : 0;
                int minorVersion = StringUtils.isNotEmpty((String)minor) ? Integer.parseInt(minor) : 0;
                int thirdVersion = 0;
                if (thirds.length >= 3 && NumberUtils.isNumber((String)thirds[2])) {
                    thirdVersion = Integer.parseInt(thirds[2]);
                }
                Tuple tuple = Tuple.create((Object)majorVersion, (Object)minorVersion, (Object)thirdVersion);
                return tuple;
            }
            catch (Throwable e) {
                logger.error("getOlapServerVersion fail." + ThrowableHelper.toString((Throwable)e));
                return Tuple.create((Object)0, (Object)0, (Object)0);
            }
        });
    }

    public static boolean canOpenDataLock(Long modelId) {
        DynamicObject model = ModelServiceHelper.getModelDynamic(modelId);
        if (model == null) {
            return false;
        }
        Tuple<Integer, Integer, Integer> tuple = OlapServiceHelper.getOlapServerVersion(model.getLong("datasource.id"));
        return ClassUtil.isDataLockJarVersion() && (Integer)tuple.p1 >= 9 && (Integer)tuple.p2 >= 13;
    }

    public static boolean canAddMeasure(Long datasource) {
        Tuple<Integer, Integer, Integer> tuple = OlapServiceHelper.getOlapServerVersion(datasource);
        return (Integer)tuple.p1 >= 9 && (Integer)tuple.p2 >= 6;
    }

    public static boolean canOpenIcVersion(Long modelId) {
        DynamicObject model = ModelServiceHelper.getModelDynamic(modelId);
        if (model == null) {
            return false;
        }
        Tuple<Integer, Integer, Integer> tuple = OlapServiceHelper.getOlapServerVersion(model.getLong("datasource.id"));
        return ClassUtil.isICVersionJarVersion() && (Integer)tuple.p1 >= 9 && (Integer)tuple.p2 >= 16;
    }

    private static void setExcludeNull(SQLBuilder sql, SelectCommandInfo queryInfo) {
        try {
            Method setExcludeNull = queryInfo.getClass().getMethod("setExcludeNull", Boolean.TYPE);
            setExcludeNull.invoke((Object)queryInfo, sql.getTop() <= 0 && !sql.isIncludeNull());
        }
        catch (Throwable e) {
            logger.error("olap low version");
        }
    }

    public static MDResultSet queryData(SQLBuilder sql, boolean multiMeasure) {
        if (sql.isCancel()) {
            return null;
        }
        sql.checkSelf();
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        queryInfo.addDims(sql.getSelectField());
        if (sql.isExcludeNullOrDefault()) {
            try {
                queryInfo.setExcludeNullOrDefault(sql.isExcludeNullOrDefault());
            }
            catch (Throwable e) {
                logger.error("setExcludeNullOrDefault fail." + ThrowableHelper.toString((Throwable)e));
            }
        }
        if (multiMeasure) {
            queryInfo.addMeasures(sql.getMeasures());
        } else {
            queryInfo.addMeasures(new String[]{sql.getMeasures()[0]});
        }
        List<String> measures = Arrays.asList(sql.getMeasures());
        if (measures.contains(FacTabFieldDefEnum.FIELD_SOURCE.getField()) || measures.contains(FacTabFieldDefEnum.FIELD_LOCK.getField())) {
            queryInfo.setExcludeDynamicCalcResult(true);
        } else {
            queryInfo.setExcludeDynamicCalcResult(sql.isExcludeDynaData());
        }
        queryInfo.setIncludeDynamicMemberWhenNullFilter(sql.getIncludeDynamicMemberWhenNullFilter());
        if (!sql.getLazyFilter().isEmpty()) {
            queryInfo.setIncludeDynamicMemberWhenNullFilter(true);
        }
        sql.getFilters().forEach(p -> queryInfo.addFilter((String)p.p1, (String[])p.p2));
        if (sql.getTop() > 0) {
            queryInfo.setTop(sql.getTop());
        }
        OlapConnection conn = null;
        OlapDataReader cs = null;
        try {
            MDResultSet rs = new MDResultSet();
            try (TraceSpan ts = Tracer.create((String)"olap", (String)"query");){
                conn = OlapServiceHelper.getOlapConnection(sql.getCubecatalog());
                conn.Open();
                OlapCommand cmd = new OlapCommand(conn, (CommandInfo)queryInfo);
                cs = cmd.ExecuteReader();
                CellSetResultSet set = new CellSetResultSet(sql.getCubecatalog(), cs, queryInfo, conn);
                set.setIncludeNull(sql.getTop() > 0 || sql.isIncludeNull());
                set.setLazyFilters(sql.getLazyFilter());
                set.getDataChecker().setCheckPar_Son(sql.isCheckPar_Son());
                if (sql.isExcludeNullData()) {
                    set.setIncludeNull(false);
                }
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", queryInfo.toString());
                }
                ts.addTag("route", sql.getCubecatalog());
                if (multiMeasure) {
                    rs.populates(set);
                } else {
                    rs.populate(set);
                }
                ts.addTag("count", String.valueOf(rs.getCount()));
            }
            MDResultSet mDResultSet = rs;
            return mDResultSet;
        }
        catch (Throwable e) {
            logger.error(e);
            throw new MDQueryException(String.format(ResManager.loadKDString((String)"olap \u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"OlapServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), e.getMessage()), e);
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (conn != null) {
                conn.Close();
            }
        }
    }
}

