/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.model.BCMOperationResult;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;

public class ReportRecordHelper {
    public static OperationResult delReportRecord(Object[] delKeys, IFormView view) {
        int all = 0;
        int success = 0;
        int fail = 0;
        String opName = ResManager.loadKDString((String)"\u72b6\u6001\u91cd\u7f6e", (String)"TemplateListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        BCMOperationResult operationResult = new BCMOperationResult();
        try (TXHandle tx = TX.required();){
            try {
                int i;
                QFilter filter = new QFilter("id", "in", (Object)delKeys);
                String selectFields = "id,report,template,template.name,template.versionnumber,template.issavebydim,reportstatus,model,fyear,period,scene,entity,entity.number,entity.name";
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportlistentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
                ArrayList canDelIds = new ArrayList();
                ArrayList<Long> resetdataIDs = new ArrayList<Long>(10);
                ArrayList delIdsLog = new ArrayList(10);
                ArrayList failIdsLog = new ArrayList(10);
                ArrayList noDimTempLogs = new ArrayList(10);
                ArrayList closePeriodLogs = new ArrayList(10);
                doc.forEach(p -> {
                    if (ReportStatusEnum.WEAVING.status().equals(p.getString("reportstatus")) || ReportStatusEnum.BACK.status().equals(p.getString("reportstatus"))) {
                        if (ReportServiceHelper.checkIsExcute(p.getLong("template"), p.getLong("model"), p.getLong("entity"), p.getLong("scene"), p.getLong("fyear"), p.getLong("period"))) {
                            failIdsLog.add(p.getLong("id"));
                        } else if (ConfigServiceHelper.getBoolParam(p.getLong("model"), "CM012") && !ReportRecordHelper.getBillListOrgPeriodStatus(doc, p.getLong("model"), p.getLong("scene"), p.getLong("fyear"), p.getLong("period")).contains(p.getString("entity.number"))) {
                            closePeriodLogs.add(p.getLong("id"));
                        } else {
                            canDelIds.add(p.getLong("report"));
                            delIdsLog.add(p.getLong("id"));
                            operationResult.putSuccessMsgMap(String.valueOf(p.getLong("report")), ReportRecordHelper.getSuccessMsgFromTemplate(p));
                        }
                    } else if (!p.getBoolean("template.issavebydim") && !ReportStatusEnum.UNWEAVE.status().equals(p.getString("reportstatus"))) {
                        noDimTempLogs.add(p.getLong("id"));
                    } else {
                        resetdataIDs.add(p.getLong("report"));
                        delIdsLog.add(p.getLong("id"));
                        operationResult.putSuccessMsgMap(String.valueOf(p.getLong("report")), ReportRecordHelper.getSuccessMsgFromTemplate(p));
                    }
                });
                MyTaskStatusHelper.synchronizeTaskStatusForPK(canDelIds.toArray(), true);
                QFilter idFilter = new QFilter("id", "in", (Object)delKeys);
                ArrayList sucessData = new ArrayList(delKeys.length);
                ArrayList failData = new ArrayList(delKeys.length);
                QueryServiceHelper.query((String)"bcm_reportlistentity", (String)"id,entity.name,template.number,template.name,model.id, period.number, fyear.number", (QFilter[])new QFilter[]{idFilter}).forEach(e -> {
                    if (!delIdsLog.contains(e.getLong("id"))) {
                        failData.add(e);
                    } else {
                        sucessData.add(e);
                    }
                });
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_reportentity"), (Object[])canDelIds.toArray());
                ReportRecordHelper.resetData(resetdataIDs);
                all = delKeys.length;
                success = canDelIds.size() + resetdataIDs.size();
                fail = all - success;
                for (i = 0; i < canDelIds.size(); ++i) {
                    operationResult.addSuccessPkId(canDelIds.get(i));
                }
                for (i = 0; i < resetdataIDs.size(); ++i) {
                    operationResult.addSuccessPkId(resetdataIDs.get(i));
                }
                long modelId = 0L;
                ArrayList<String> sucessLogList = new ArrayList<String>(sucessData.size());
                for (DynamicObject sucessDatum : sucessData) {
                    Object org = sucessDatum.get("entity.name");
                    Object number = sucessDatum.get("template.number");
                    Object name = sucessDatum.get("template.name");
                    modelId = sucessDatum.getLong("model.id");
                    String yearNum = sucessDatum.getString("fyear.number");
                    String periodNum = sucessDatum.getString("period.number");
                    sucessLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s %4$s %5$s,\u91cd\u7f6e\u72b6\u6001\u6210\u529f", (String)"ReportRecordHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), yearNum, periodNum, org.toString(), number.toString(), name.toString()));
                }
                if (sucessLogList.size() != 0) {
                    OperationLogUtil.batchWriteOperationLog(view, ResManager.loadKDString((String)"\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), sucessLogList, modelId);
                }
                ArrayList<String> failLogList = new ArrayList<String>(failData.size());
                for (DynamicObject failDataum : failData) {
                    OperateErrorInfo operateErrorInfo;
                    Object org = failDataum.get("entity.name");
                    Object number = failDataum.get("template.number");
                    Object name = failDataum.get("template.name");
                    if (failIdsLog.contains(failDataum.getLong("id"))) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(opName);
                        operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\u5728\u516c\u5f0f\u53d6\u6570\u83dc\u5355\u4e2d\u5904\u4e8e\u6267\u884c\u4e2d\u72b6\u6001,\u91cd\u7f6e\u72b6\u6001\u5931\u8d25", (String)"ReportRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                        operationResult.addErrorInfo(operateErrorInfo);
                        failLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\u5728\u516c\u5f0f\u53d6\u6570\u83dc\u5355\u4e2d\u5904\u4e8e\u6267\u884c\u4e2d\u72b6\u6001,\u91cd\u7f6e\u72b6\u6001\u5931\u8d25", (String)"ReportRecordHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        continue;
                    }
                    if (noDimTempLogs.contains(failDataum.getLong("id"))) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(opName);
                        operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u5df2\u4e0a\u62a5/\u7f16\u5236\u5b8c\u6210\u7684\u65e0\u7ef4\u5ea6\u62a5\u8868\u4e0d\u5141\u8bb8\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                        operationResult.addErrorInfo(operateErrorInfo);
                        failLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u5df2\u4e0a\u62a5/\u7f16\u5236\u5b8c\u6210\u7684\u65e0\u7ef4\u5ea6\u62a5\u8868\u4e0d\u5141\u8bb8\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        continue;
                    }
                    if (closePeriodLogs.contains(failDataum.getLong("id"))) {
                        operateErrorInfo = new OperateErrorInfo();
                        operateErrorInfo.setTitle(opName);
                        operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                        operationResult.addErrorInfo(operateErrorInfo);
                        failLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s\uff1a\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                        continue;
                    }
                    failLogList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s %3$s,\u91cd\u7f6e\u72b6\u6001\u5931\u8d25", (String)"ReportRecordHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), org.toString(), number.toString(), name.toString()));
                }
                if (failLogList.size() != 0) {
                    OperationLogUtil.batchWriteOperationLog(view, ResManager.loadKDString((String)"\u91cd\u7f6e\u72b6\u6001", (String)"ReportRecordHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]), failLogList, modelId);
                }
            }
            catch (Throwable e2) {
                tx.markRollback();
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setTitle(opName);
                operateErrorInfo.setMessage(e2.getMessage());
                operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
                operationResult.addErrorInfo(operateErrorInfo);
                BCMOperationResult bCMOperationResult = operationResult;
                if (tx != null) {
                    if (var8_8 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return bCMOperationResult;
            }
        }
        operationResult.setBillCount(all);
        return operationResult;
    }

    public static String getSuccessMsgFromTemplate(DynamicObject obj) {
        BigDecimal versionnumber = obj.getBigDecimal("template.versionnumber");
        String version = versionnumber == null ? "V1.0" : String.format("V%.1f", versionnumber);
        return obj.getString("entity.name") + " " + obj.getString("template.name") + " " + version;
    }

    private static Set<String> getBillListOrgPeriodStatus(DynamicObjectCollection doc, long modelid, long scenarioid, long yearid, long periodid) {
        return (Set)ThreadCache.get((Object)("ReportRecordHelper.getBillListOrgPeriodStatus" + modelid + scenarioid + yearid + periodid), () -> {
            Set<String> orgNums = doc.stream().map(r -> r.getString("entity.number")).collect(Collectors.toSet());
            Set<String> openOrgs = PeriodSettingHelper.batchSelectPeriodStatusOpen(modelid, orgNums, scenarioid, yearid, periodid, "datastatus");
            return openOrgs;
        });
    }

    public static void resetData(List<Long> resetdataIDs) {
        if (resetdataIDs.isEmpty()) {
            return;
        }
        Object[] docs = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)"data,spreadjson", (QFilter[])new QFilter[]{new QFilter("id", "in", resetdataIDs)});
        if (docs != null && docs.length > 0) {
            for (DynamicObject dynamicObject : docs) {
                dynamicObject.set("data", null);
                dynamicObject.set("spreadjson", null);
            }
            BusinessDataWriter.save((IDataEntityType)docs[0].getDynamicObjectType(), (Object[])docs);
        }
    }

    public static OPDescMultiLangEnumBridge delReportRecord(Long reportId) {
        int all = 0;
        int success = 0;
        int fail = 0;
        try (TXHandle tx = TX.required();){
            try {
                QFilter filter = new QFilter("report", "=", (Object)reportId);
                String selectFields = "report, reportstatus";
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportlistentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
                ArrayList<Long> canDelIds = new ArrayList<Long>();
                canDelIds.add(reportId);
                doc.forEach(p -> {
                    if (ReportStatusEnum.COMPLETE.status().equals(p.getString("reportstatus")) || ReportStatusEnum.COMMIT.status().equals(p.getString("reportstatus"))) {
                        canDelIds.remove(p.getLong("report"));
                    }
                });
                MyTaskStatusHelper.synchronizeTaskStatusForPK(canDelIds.toArray(), true);
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_reportentity"), (Object[])canDelIds.toArray());
                all = 1;
                success = canDelIds.size();
                fail = all - success;
            }
            catch (Throwable e) {
                tx.markRollback();
                OPDescMultiLangEnumBridge oPDescMultiLangEnumBridge = new OPDescMultiLangEnumBridge("\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", "ReportRecordHelper_0", "fi-bcm-business", OPDescMultiLangEnumBridge.genObjectBridgeArgs((Object[])new Object[]{all, 0, all}));
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return oPDescMultiLangEnumBridge;
            }
        }
        return new OPDescMultiLangEnumBridge("\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", "ReportRecordHelper_0", "fi-bcm-business", OPDescMultiLangEnumBridge.genObjectBridgeArgs((Object[])new Object[]{all, success, fail}));
    }

    public static int clearRepeatRoport(Object[] tmpids) {
        QFilter tmpFilter = new QFilter("template", "in", (Object)tmpids);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,fyear,period,currency,entity,scene,template", (QFilter[])new QFilter[]{tmpFilter}, (String)"modifytime desc");
        HashSet<String> repeat = new HashSet<String>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (doc != null) {
            for (DynamicObject rep : doc) {
                long fyear = rep.getLong("fyear");
                long period = rep.getLong("period");
                long currency = rep.getLong("currency");
                long entity = rep.getLong("entity");
                long scene = rep.getLong("scene");
                long template = rep.getLong("template");
                String key = "" + fyear + period + currency + entity + scene + template;
                if (repeat.add(key)) continue;
                ids.add(rep.getLong("id"));
            }
        }
        return DeleteServiceHelper.delete((String)"bcm_reportentity", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }
}

