/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.extdata.ExtDataLockServiceHelper;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.lockdata.ReportLockDataUtil;
import kd.fi.bcm.business.mergecontrol.MergeCondition;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataCollectRecordEnum;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.MergeDataSourceEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.enums.chkcheck.CHKReportType;
import kd.fi.bcm.common.enums.chkcheck.CheckResultenum;
import kd.fi.bcm.common.enums.config.ProcessSelectionEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;

public class ReportServiceHelper {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ReportServiceHelper.class);
    private static final String NUMBER = "number";
    public static final String model = "model";
    public static final String year = "year";
    public static final String period = "period";
    public static final String scenario = "scenario";
    public static final String entity = "entity";
    public static final String currency = "currency";
    public static final String version = "version";
    public static final String cslScheme = "cslscheme";
    public static final String userTaskInfo = "ReportServiceHelper_userTaskInfo";

    public static List<String> updateReportStatus(ReportStatusEnum status, Object[] pks) {
        String selectFields = "id,template,model,reportstatus, completer,completetime, commitor,committime,firstcommittime,committimes, sendbacker,sendbacktime,sendbacktimes,reporttype,fyear,period,scene,currency,currency.number,entity";
        QFilter filter = new QFilter("id", "in", (Object)pks);
        Object[] reports = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HashSet<Long> templateIds = new HashSet<Long>(reports.length);
        HashMap<String, Long> filterMap = new HashMap<String, Long>(6);
        for (DynamicObject dynamicObject : reports) {
            if (ReportStatusEnum.COMPLETE == status) {
                dynamicObject.set("completer", (Object)userId);
                dynamicObject.set("completetime", (Object)new Date());
            } else if (ReportStatusEnum.WEAVING == status) {
                dynamicObject.set("completer", null);
                dynamicObject.set("completetime", null);
            } else if (ReportStatusEnum.COMMIT == status) {
                dynamicObject.set("commitor", (Object)userId);
                dynamicObject.set("committime", (Object)new Date());
                if (dynamicObject.get("firstcommittime") == null) {
                    dynamicObject.set("firstcommittime", (Object)new Date());
                }
                dynamicObject.set("committimes", (Object)(dynamicObject.getInt("committimes") + 1));
            } else if (ReportStatusEnum.BACK == status) {
                dynamicObject.set("sendbacker", (Object)userId);
                dynamicObject.set("sendbacktime", (Object)new Date());
                dynamicObject.set("sendbacktimes", (Object)(dynamicObject.getInt("sendbacktimes") + 1));
                dynamicObject.set("completer", null);
                dynamicObject.set("completetime", null);
            }
            dynamicObject.set("reportstatus", (Object)status.status());
            templateIds.add(dynamicObject.getLong("template.id"));
            filterMap.put(DimTypesEnum.ENTITY.getNumber(), dynamicObject.getLong("entity.id"));
            filterMap.put(DimTypesEnum.SCENARIO.getNumber(), dynamicObject.getLong("scene.id"));
            filterMap.put(DimTypesEnum.YEAR.getNumber(), dynamicObject.getLong("fyear.id"));
            filterMap.put(DimTypesEnum.PERIOD.getNumber(), dynamicObject.getLong("period.id"));
            filterMap.put(DimTypesEnum.CURRENCY.getNumber(), dynamicObject.getLong("currency.id"));
            filterMap.put(model, dynamicObject.getLong("model.id"));
        }
        if (reports.length == 0) {
            return Lists.newArrayList();
        }
        if (ReportStatusEnum.COMMIT == status) {
            ReportLockDataUtil.lockByReport(pks);
        }
        if (ReportStatusEnum.BACK == status) {
            ReportLockDataUtil.unLockByReport(pks);
        }
        BusinessDataServiceHelper.save((IDataEntityType)reports[0].getDynamicObjectType(), (Object[])reports);
        ReportServiceHelper.updateExtDataStatus(templateIds, filterMap, status);
        if (ReportStatusEnum.COMMIT == status && ConfigServiceHelper.getBoolChildParam(reports[0].getLong("model_id"), "CM024", "params") && !ThreadCache.exists((Object)userTaskInfo)) {
            return ReportServiceHelper.synEcCommitStatus((DynamicObject[])reports);
        }
        return Lists.newArrayList();
    }

    private static void updateExtDataStatus(Set<Long> templateIds, Map<String, Long> filterMap, ReportStatusEnum status) {
        DynamicObjectCollection objects;
        Set<Long> extModels;
        if (!templateIds.isEmpty() && CollectionUtils.isNotEmpty(extModels = (objects = QueryServiceHelper.query((String)"bcm_extmodelref", (String)"id,extmodel", (QFilter[])new QFilter("template", "in", templateIds).toArray())).stream().map(obj -> obj.getLong("extmodel")).collect(Collectors.toSet()))) {
            Long modelId = filterMap.get(model);
            Long entity = filterMap.get(DimTypesEnum.ENTITY.getNumber());
            Long scenario = filterMap.get(DimTypesEnum.SCENARIO.getNumber());
            Long year = filterMap.get(DimTypesEnum.YEAR.getNumber());
            Long period = filterMap.get(DimTypesEnum.PERIOD.getNumber());
            Long currency = filterMap.get(DimTypesEnum.CURRENCY.getNumber());
            if (status == ReportStatusEnum.COMMIT) {
                ExtDataLockServiceHelper.lockMultiExtData(modelId, extModels, entity, scenario, year, period, currency);
            } else if (status == ReportStatusEnum.BACK) {
                ExtDataLockServiceHelper.unlockMulExtData(modelId, extModels, entity, scenario, year, period, currency);
            }
        }
    }

    public static DynamicObjectCollection queryReport(List<Object> successIds) {
        String selectFields = "id,template,model,reportstatus,fyear,period,scene,currency,currency.number,entity,template.group,template.number";
        QFilter filter = new QFilter("id", "in", successIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return reports;
    }

    public static Set<Long> getCommitTemplateByReport(DynamicObject reportDyn) {
        long modelId = reportDyn.getLong(model);
        long year = reportDyn.getLong("fyear");
        long period = reportDyn.getLong(period);
        long scene = reportDyn.getLong("scene");
        long entity = reportDyn.getLong(entity);
        String currencyNumber = reportDyn.getString("currency.number");
        return ReportServiceHelper.getCommitTemplateByReport(modelId, scene, year, period, entity, currencyNumber);
    }

    public static Set<Long> getCommitTemplateByReport(long modelId, long scene, long year, long period, long entity, String currencyNumber) {
        QFilter qFilter = new QFilter(model, "=", (Object)modelId);
        qFilter.and("fyear", "=", (Object)year);
        qFilter.and(period, "=", (Object)period);
        qFilter.and("scene", "=", (Object)scene);
        qFilter.and("currency.number", "=", (Object)currencyNumber);
        qFilter.and(entity, "=", (Object)entity);
        qFilter.and("reportstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
        DynamicObjectCollection allReport = QueryServiceHelper.query((String)"bcm_reportentity", (String)"template,template.group", (QFilter[])qFilter.toArray());
        return allReport.stream().map(dy -> dy.getLong("template.group")).collect(Collectors.toSet());
    }

    private static List<String> synEcCommitStatus(DynamicObject[] reports) {
        ArrayList<String> errorList = new ArrayList<String>(10);
        Map<Long, List<DynamicObject>> orgToReportMap = Arrays.stream(reports).collect(Collectors.groupingBy(dy -> dy.getLong("entity_id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : orgToReportMap.entrySet()) {
            Long orgId = entry.getKey();
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bcm_entitymembertree", (String)"id,number,currency,model");
            List<DynamicObject> orgReportList = entry.getValue();
            if (orgReportList.size() <= 0) continue;
            long modelId = orgReportList.get(0).getLong("model_id");
            long year = orgReportList.get(0).getLong("fyear_id");
            long period = orgReportList.get(0).getLong("period_id");
            long scene = orgReportList.get(0).getLong("scene_id");
            long entity = orgReportList.get(0).getLong("entity_id");
            List<String> notCommitTemplates = ReportServiceHelper.checkOrgReportCommitStatus(modelId, entity, scene, year, period);
            if (notCommitTemplates.isEmpty()) {
                String modelNumber = MemberReader.findModelNumberById((Object)modelId);
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)modelNumber, (Long)orgId);
                String orgNumber = orgNode.getNumber();
                String sceneNumber = MemberReader.findScenaMemberById((String)modelNumber, (Long)scene).getNumber();
                String yearNumber = MemberReader.findFyMemberById((String)modelNumber, (Long)year).getNumber();
                String periodNumber = MemberReader.findPeriodMemberById((String)modelNumber, (Long)period).getNumber();
                FixedItem fixedItem = FixedItem.newOne(SimpleItem.newOne(modelId, modelNumber), SimpleItem.newOne(scene, sceneNumber), SimpleItem.newOne(year, yearNumber), SimpleItem.newOne(period, periodNumber));
                List<SimpleItem> orgList = Collections.singletonList(SimpleItem.newOne(orgId, orgNumber));
                fixedItem.setOrgList(orgList);
                MergeControlService mergeControlService = MergeControlService.getInstance();
                McStatus mcStatus = McStatus.getMcStatus(modelId, entity, scene, year, period);
                if (!mcStatus.getCalculate().isSuccess()) {
                    if (orgNode.isLeaf()) {
                        MergeCondition mergeCondition = mergeControlService.getDefaultCalculateCondition();
                        mergeControlService.syncExecuteCalculate(fixedItem, mergeCondition);
                    } else {
                        errorList.add(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9 %s \u667a\u80fd\u5408\u5e76\u540e\u624d\u53ef\u4ee5\u6d41\u7a0b\u63d0\u4ea4\u3002", (String)"ReportServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), orgNode.getNumber()));
                        continue;
                    }
                }
                HashMap<String, Object> stageConditionMap = new HashMap<String, Object>(16);
                stageConditionMap.put("stepid", null);
                stageConditionMap.put("opinion", ResManager.loadKDString((String)"\u62a5\u8868\u4e0a\u62a5\u8054\u52a8\u63d0\u4ea4", (String)"ReportServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]));
                stageConditionMap.put("includeson", "1");
                stageConditionMap.put("stageoptype", StageOpTypeEnum.COMMIT.getCode());
                stageConditionMap.put("isEc", "EC");
                stageConditionMap.put("isIgnoreOrgEffect", Boolean.TRUE);
                ResultBox resultBox = mergeControlService.stageOp(fixedItem, stageConditionMap);
                if (resultBox.isSuccess()) continue;
                List messageList = resultBox.getMessageList();
                List msgs = messageList.stream().map(MessageInfo::getMessage).collect(Collectors.toList());
                errorList.addAll(msgs);
                continue;
            }
            errorList.add(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 %1$s \u8fd8\u6709 %2$s \u4e2a\u5df2\u5206\u914d\u7f16\u5236\u7c7b\u6a21\u677f\u672a\u4e0a\u62a5\uff0c\u65e0\u6cd5\u81ea\u52a8\u63d0\u4ea4\u6d41\u7a0b, \u672a\u63d0\u4ea4\u7684\u6a21\u677f\u7f16\u7801\uff1a%3$s", (String)"ReportServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), org.getString(NUMBER), notCommitTemplates.size(), String.join((CharSequence)",", notCommitTemplates)));
        }
        return errorList;
    }

    public static List<String> checkOrgReportCommitStatus(Long modelId, Long orgId, Long scenarioId, Long yearId, Long periodId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode DCNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)"Currency", (String)"DC");
        return ReportServiceHelper.checkOrgReportCommitStatusWithCurrency(modelId, orgId, scenarioId, yearId, periodId, DCNode.getId());
    }

    public static List<String> checkOrgReportCommitStatusWithCurrency(Long modelId, Long orgId, Long scenarioId, Long yearId, Long periodId, Long currencyId) {
        return ReportServiceHelper.checkOrgReportCommitStatusWithCurrencyAndStage(modelId, orgId, scenarioId, yearId, periodId, currencyId, 0L);
    }

    public static List<String> checkOrgReportCommitStatusWithCurrencyAndStage(Long modelId, Long orgId, Long scenarioId, Long yearId, Long periodId, Long currencyId, Long stageId) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        RightVersionTemplateParams params = new RightVersionTemplateParams(modelId, scenarioId, yearId, periodId, currencyId, true);
        HashSet<Long> orgSetId = new HashSet<Long>();
        orgSetId.add(orgId);
        params.setOrgIds(orgSetId);
        params.setStageId(stageId);
        Map<Long, ReportEditStatus> reportCommitStatus = TemplateUtil.getCommitReportCount(params);
        IDNumberTreeNode orgNode = BcmThreadCache.findNodeById((String)modelNumber, (String)"Entity", (long)orgId);
        IDNumberTreeNode baseTreeNode = orgNode.getBaseTreeNode();
        ReportEditStatus reportStatus = reportCommitStatus.get(baseTreeNode.getId());
        HashSet<Long> notCommitReportTplIdSet = new HashSet<Long>(16);
        notCommitReportTplIdSet.addAll(reportStatus.getUnweaveTemplates());
        notCommitReportTplIdSet.addAll(reportStatus.getWeavingTemplates());
        notCommitReportTplIdSet.addAll(reportStatus.getCompleteTemplates());
        notCommitReportTplIdSet.addAll(reportStatus.getBackTemplates());
        notCommitReportTplIdSet.addAll(reportStatus.getBackapplyTemplates());
        List<String> notCommitTplNumbers = new ArrayList<String>();
        if (notCommitReportTplIdSet.size() > 0) {
            QFilter filter = new QFilter("id", "in", notCommitReportTplIdSet);
            if (ConfigServiceHelper.getBoolChildParam(modelId, "CM024", "ignoredimensionlesreport")) {
                filter.and("issavebydim", "=", (Object)"1");
            }
            DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])filter.toArray());
            notCommitTplNumbers = templates.stream().map(r -> r.getString(NUMBER)).collect(Collectors.toList());
        }
        return notCommitTplNumbers;
    }

    public static void filterVersionTemplateTree(Collection<DynamicObject> templateColls) {
        HashSet passes = new HashSet();
        Map<String, List<DynamicObject>> templateGroups = templateColls.stream().collect(Collectors.groupingBy(e -> e.getString(NUMBER)));
        templateGroups.forEach((number, tmpList) -> {
            if (tmpList.size() == 1) {
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            } else {
                tmpList.sort((o1, o2) -> -1 * o1.getBigDecimal("versionnumber").compareTo(o2.getBigDecimal("versionnumber")));
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            }
        });
        templateColls.removeIf(t -> !passes.contains(t.getLong("id")));
    }

    public static DynamicObject loadCurrencyMemberByDBCurrency(Object baseCurrPk, Object modelPK) {
        DynamicObject currency = ReportServiceHelper.queryDynamic("bd_currency", baseCurrPk);
        QFilter currentFilter = currency == null ? new QFilter("id", "=", (Object)LongUtil.toLong((Object)baseCurrPk)) : new QFilter(NUMBER, "=", (Object)currency.getString(NUMBER));
        return QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)"id,name,number", (QFilter[])new QFilter[]{currentFilter, new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelPK))});
    }

    public static DynamicObject loadCurrencyMemberByDBCurrency(Object baseCurrPk, Object modelPK, String selectFields) {
        DynamicObject currency = ReportServiceHelper.queryDynamic("bd_currency", baseCurrPk);
        QFilter currentFilter = currency == null ? new QFilter("id", "=", (Object)LongUtil.toLong((Object)baseCurrPk)) : new QFilter(NUMBER, "=", (Object)currency.getString(NUMBER));
        return QueryServiceHelper.queryOne((String)"bcm_currencymembertree", (String)selectFields, (QFilter[])new QFilter[]{currentFilter, new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelPK))});
    }

    private static DynamicObject queryDynamic(String entityNum, Object pk) {
        return QueryServiceHelper.queryOne((String)entityNum, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)pk))});
    }

    public static List<Object> TestReportIsSave(List<Object> templateIds, Object modelId, Object currencyId, Object entityId, Object yearId, Object periodId, List<Long> makingReports) {
        QFilter filter = new QFilter(model, "=", modelId);
        filter.and(currency, "=", currencyId);
        filter.and(entity, "=", entityId);
        filter.and("fyear", "=", yearId);
        filter.and(period, "=", periodId);
        filter.and("template", "in", templateIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,reportstatus,template.id", (QFilter[])new QFilter[]{filter});
        ArrayList existIds = new ArrayList();
        templateIds.forEach(e -> reports.forEach(r -> {
            if (e.equals(r.get("template.id"))) {
                existIds.add(r.get("template.id"));
            }
            if (e.equals(r.get("template.id")) && r.getString("reportstatus").equals(ReportStatusEnum.WEAVING.status())) {
                makingReports.add(r.getLong("template.id"));
            }
        }));
        ArrayList<Object> templateIdsCopy = new ArrayList<Object>(templateIds);
        templateIdsCopy.removeAll(existIds);
        return templateIdsCopy;
    }

    public static void saveNewNofinancialRecords(Object nofi, Object modelId, Object currencyId, Object entityId, Object yearId, Object periodId, Object tempId) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>();
        DynamicObject record = ORM.create().newDynamicObject("bcm_nofinancialentity");
        record.set("id", nofi);
        record.set(model, modelId);
        record.set(year, yearId);
        record.set(period, periodId);
        record.set(currency, currencyId);
        record.set(entity, entityId);
        record.set("template", tempId);
        records.add(record);
        BusinessDataWriter.save((IDataEntityType)((DynamicObject)records.get(0)).getDataEntityType(), (Object[])records.toArray());
    }

    public static void updateDescription(Object[] pks, Map<String, String> data) {
        Object[] reports;
        if (data == null) {
            return;
        }
        String selectFields = "id,template,description";
        QFilter filter = new QFilter("id", "in", (Object)pks);
        for (DynamicObject dynamicObject : reports = BusinessDataServiceHelper.load((String)"bcm_reportentity", (String)selectFields, (QFilter[])new QFilter[]{filter})) {
            dynamicObject.set("description", (Object)data.get("description"));
        }
        if (reports.length > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)reports[0].getDynamicObjectType(), (Object[])reports);
        }
    }

    public static Map<String, String> getDataMap(Long reportRecordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)reportRecordId);
        String selectFields = "id, model, template, entity, scene, fyear, period, currency, reportstatus, template.number, entity.number";
        DynamicObject rptRecord = QueryServiceHelper.queryOne((String)"bcm_reportlistentity", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put(model, rptRecord.getString(model));
        data.put("template", rptRecord.getString("template"));
        data.put(entity, rptRecord.getString(entity));
        data.put("scene", rptRecord.getString("scene"));
        data.put("fyear", rptRecord.getString("fyear"));
        data.put(period, rptRecord.getString(period));
        data.put("reportstatus", rptRecord.getString("reportstatus"));
        return data;
    }

    public static DynamicObjectCollection getListDataMap(Collection<Object> rptListIds) {
        QFilter qFilter = new QFilter("id", "in", rptListIds);
        String selectFields = "id, model, template, entity, scene, fyear, period, reportstatus, template.number, entity.number";
        DynamicObjectCollection rptRecords = QueryServiceHelper.query((String)"bcm_reportlistentity", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return rptRecords;
    }

    public static void saveDescriptionData(Object modelId, Object[] pks, Map<String, String> data, String itemkey) {
        ArrayList<DynamicObject> newDyns = new ArrayList<DynamicObject>(8);
        String excuteaction = null;
        switch (itemkey) {
            case "baritemap_submit": 
            case "btn_commit": {
                excuteaction = "1";
                break;
            }
            case "baritemap_return": 
            case "btn_back": {
                excuteaction = "2";
            }
        }
        for (Object pk : pks) {
            DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rptdescriptionentity");
            newDyn.set("report", pk);
            newDyn.set(model, modelId);
            newDyn.set("excuteaction", (Object)excuteaction);
            newDyn.set("creator", (Object)RequestContext.get().getUserId());
            newDyn.set("createtime", (Object)TimeServiceHelper.now());
            newDyn.set("description", (Object)data.get("description"));
            newDyn.set("template", (Object)data.get("template"));
            newDyn.set(entity, (Object)data.get(entity));
            newDyn.set("scene", (Object)data.get("scene"));
            newDyn.set("fyear", (Object)data.get("fyear"));
            newDyn.set(period, (Object)data.get(period));
            newDyn.set(currency, (Object)data.get(currency));
            newDyns.add(newDyn);
        }
        SaveServiceHelper.save((DynamicObject[])newDyns.toArray(new DynamicObject[0]));
    }

    public static String verifyCompeteStatus(Map template, String status, long modelId, String modelNumber, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, boolean isContinue, String cycleTableName) {
        if (!isContinue) {
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6a21\u677f\u6240\u5c5e\u5957\u8868 %2$s \u72b6\u6001\u662f\u7f16\u5236\u5b8c\u6210\u6216\u5df2\u4e0a\u62a5\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u5957\u8868\u6267\u884c\u7f16\u5236\u5b8c\u6210\u5355\u5f20\u8868\u3002", (String)"ReportListPlugin_103", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("template.name"), cycleTableName);
        }
        if (ReportStatusEnum.COMPLETE.status().equals(status) || ReportStatusEnum.COMMIT.status().equals(status)) {
            return String.format(ResManager.loadKDString((String)"%s:\u53ea\u53ef\u5bf9\u72b6\u6001\u4e3a\u672a\u7f16\u5236\u3001\u7f16\u5236\u4e2d\u548c\u6253\u56de\u7684\u62a5\u8868\u6267\u884c\u7f16\u5236\u5b8c\u6210\u7684\u64cd\u4f5c\u3002", (String)"AbstractMultiReportPlugin_110", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("template.name"));
        }
        if (ReportServiceHelper.checkIsExcute(LongUtil.toLong(template.get("template.id")), modelId, LongUtil.toLong(template.get("entity.id")), scenarioDy.getLong("id"), yearDy.getLong("id"), periodDy.getLong("id"))) {
            return String.format(ResManager.loadKDString((String)"%s\u62a5\u8868\u5728\u516c\u5f0f\u53d6\u6570\u83dc\u5355\u4e2d\u5904\u4e8e\u6267\u884c\u4e2d\u72b6\u6001\uff0c\u4e0d\u53ef\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002\u53ef\u5c1d\u8bd5\u91cd\u7f6e\u6267\u884c\u72b6\u6001\u540e\u91cd\u8bd5\u3002", (String)"AbstractMultiReportPlugin_835", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("template.name"));
        }
        if (!ReportServiceHelper.verifyStatusAboutLedger(template, status, modelId, scenarioDy, yearDy, periodDy)) {
            return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u8d26\u7c3f\u672a\u7ed3\u8d26\uff0c\u4e0d\u53ef\u7f16\u5236\u5b8c\u6210\u3002", (String)"ReportListPlugin_158", (String)"fi-bcm-formplugin", (Object[])new Object[0]), template.get("template.name"));
        }
        return null;
    }

    public static String verifyCancelStatus(Map template, String status, long modelId, String modelNumber, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy, boolean isContinue, String cycleTableName) {
        if (!isContinue) {
            return String.format(ResManager.loadKDString((String)"%1$s \uff1a\u6a21\u677f\u6240\u5c5e\u5957\u8868 %2$s \u72b6\u6001\u4e3a\u5df2\u4e0a\u62a5\u6216\u7f16\u5236\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u5355\u5f20\u62a5\u8868\u53d6\u6d88\u7f16\u5236\u5b8c\u6210\u3002", (String)"ReportServiceHelper_9", (String)"fi-bcm-business", (Object[])new Object[0]), String.valueOf(template.get("template.name")), cycleTableName);
        }
        if (!ReportStatusEnum.COMPLETE.status().equals(status)) {
            return String.format(ResManager.loadKDString((String)"%s:\u53ea\u53ef\u5bf9\u72b6\u6001\u4e3a\u7f16\u5236\u5b8c\u6210\u7684\u62a5\u8868\u6267\u884c\u53d6\u6d88\u7f16\u5236\u5b8c\u6210\u7684\u64cd\u4f5c\u3002", (String)"ReportServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]), String.valueOf(template.get("template.name")));
        }
        return null;
    }

    public static String verifyBackStatus(Map template, String status, long modelId, String modelNumber, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy, boolean isContinue, String cycleTableName) {
        if (!isContinue) {
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6a21\u677f\u6240\u5c5e\u5957\u8868 %2$s \u72b6\u6001\u4e3a\u5df2\u4e0a\u62a5\u6216\u7f16\u5236\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u6253\u56de\u5355\u5f20\u62a5\u8868\u3002", (String)"ReportServiceHelper_10", (String)"fi-bcm-business", (Object[])new Object[0]), String.valueOf(template.get("template.name")), cycleTableName);
        }
        if (!ReportStatusEnum.COMMIT.status().equals(status)) {
            return String.format(ResManager.loadKDString((String)"%s:\u53ea\u53ef\u5bf9\u72b6\u6001\u4e3a\u4e0a\u62a5\u62a5\u8868\u6267\u884c\u6253\u56de\u64cd\u4f5c\u3002", (String)"ReportServiceHelper_11", (String)"fi-bcm-business", (Object[])new Object[0]), String.valueOf(template.get("template.name")));
        }
        String tips = ReportServiceHelper.verifyBackStatusAboutParentChildStatus(template, status, modelId, scenarioDy, yearDy, periodDy, currencyDy);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tips)) {
            return tips;
        }
        if (!ReportServiceHelper.verifyStatusOperatorsMutuallyExclusive(template, modelId, modelNumber, scenarioDy, yearDy, periodDy, currencyDy, ReportStatusEnum.BACK.number())) {
            return String.format(ResManager.loadKDString((String)"%s:\u6253\u56de\u4eba\u4e0e\u62a5\u8868\u7f16\u5236\u5b8c\u6210\u4eba\u4e0d\u80fd\u4e3a\u540c\u4e00\u4eba\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u6267\u884c\u6253\u56de\u64cd\u4f5c\uff01", (String)"ReportServiceHelper_13", (String)"fi-bcm-business", (Object[])new Object[0]), String.valueOf(template.get("template.name")));
        }
        return null;
    }

    public static String verifySubmitStatus(Map template, String status, long modelId, String modelNumber, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy, Object cslscheme, boolean isContinue, String cycleTableName) {
        if (!isContinue) {
            return String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6a21\u677f\u6240\u5c5e\u5957\u8868 %2$s \u72b6\u6001\u4e0d\u662f\u7f16\u5236\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u901a\u8fc7\u5957\u8868\u6267\u884c\u4e0a\u62a5\u5355\u5f20\u8868\u3002", (String)"ReportServiceHelper_14", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"), cycleTableName);
        }
        if (!ReportStatusEnum.COMPLETE.status().equals(status)) {
            return String.format(ResManager.loadKDString((String)"%s:\u53ea\u53ef\u4e0a\u62a5\u7f16\u5236\u5b8c\u6210\u72b6\u6001\u7684\u62a5\u8868\u3002", (String)"ReportServiceHelper_15", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
        }
        if (!ReportServiceHelper.verifyStatusAboutLedger(template, status, modelId, scenarioDy, yearDy, periodDy)) {
            return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u8d26\u7c3f\u672a\u7ed3\u8d26\uff0c\u4e0d\u53ef\u4e0a\u62a5\u3002", (String)"ReportServiceHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
        }
        String tips = ReportServiceHelper.verifySubmitStatusAboutParentChildStatus(template, status, modelId, scenarioDy, yearDy, periodDy, currencyDy);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tips)) {
            return tips;
        }
        if (!ReportServiceHelper.verifyStatusOperatorsMutuallyExclusive(template, modelId, modelNumber, scenarioDy, yearDy, periodDy, currencyDy, ReportStatusEnum.COMMIT.number())) {
            return String.format(ResManager.loadKDString((String)"%s:\u4e0a\u62a5\u4eba\u4e0e\u7f16\u5236\u5b8c\u6210\u4eba\u4e0d\u53ef\u4e3a\u540c\u4e00\u4eba\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u6267\u884c\u4e0a\u62a5\u64cd\u4f5c\uff01", (String)"ReportServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
        }
        return null;
    }

    public static Pair<Boolean, String> getCM018(Long modelId) {
        JSONObject json = ParamSettingServiceHelper.getJSON((long)modelId, (String)"CM018");
        return Pair.onePair((Object)json.getBoolean("checkreport"), (Object)json.getString("processselection"));
    }

    public static boolean verifyStatusAboutLedger(Map template, String status, Long modelId, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy) {
        boolean isCommit;
        DynamicObject templateDobj;
        Object id2Tmps = ThreadCache.get((Object)"ReportServiceHelper.verifySubmitStatusAboutLedger");
        if (id2Tmps == null) {
            QFilter templateFilter = new QFilter("Id", "=", (Object)LongUtil.toLong(template.get("template.id")));
            templateDobj = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"ischeckstatus,uncheckentity", (QFilter[])new QFilter[]{templateFilter});
        } else {
            templateDobj = (DynamicObject)((Map)id2Tmps).get(LongUtil.toLong(template.get("template.id")));
        }
        Pair<Boolean, String> cm018 = ReportServiceHelper.getCM018(modelId);
        boolean isComplete = (status.equals(ReportStatusEnum.UNWEAVE.status()) || status.equals(ReportStatusEnum.WEAVING.status()) || status.equals(ReportStatusEnum.BACK.status())) && ((String)cm018.p2).equalsIgnoreCase(ProcessSelectionEnum.REPORTCOMPETE.getValue());
        boolean bl = isCommit = status.equals(ReportStatusEnum.COMPLETE.status()) && ((String)cm018.p2).equalsIgnoreCase(ProcessSelectionEnum.REPORTCOMMIT.getValue());
        if (((Boolean)cm018.p1).booleanValue() && templateDobj.getBoolean("ischeckstatus") && (isComplete || isCommit)) {
            String entityNum = String.valueOf(template.get("entity.number"));
            String unCheckEntityStr = templateDobj.getString("uncheckentity");
            IDNumberTreeNode node = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)LongUtil.toLong(template.get("entity.id")));
            if (node != IDNumberTreeNode.NotFoundTreeNode && node.isLeaf()) {
                HashSet<String> allEntityIdSet = new HashSet<String>();
                QFBuilder entityBuilder = new QFBuilder(NUMBER, "=", (Object)"CM018");
                entityBuilder.add(model, "=", (Object)LongUtil.toLong((Object)modelId));
                entityBuilder.add("dentity.isshow", "=", (Object)"1");
                DynamicObjectCollection dyc = (DynamicObjectCollection)ThreadCache.get((Object)("bcm_checkledgersetting" + modelId + "CM018"), () -> QueryServiceHelper.query((String)"bcm_checkledgersetting", (String)"number, dentity.num, dentity.rangevalue, dentity.oid,dentity.year, dentity.period, dentity.id", (QFilter[])entityBuilder.toArray()));
                HashMap<Long, Pair<List<Long>, List<Long>>> entity2YearPeriods = new HashMap<Long, Pair<List<Long>, List<Long>>>(16);
                if (!dyc.isEmpty()) {
                    HashMap<Long, List<DynamicObject>> model2dy = new HashMap<Long, List<DynamicObject>>(8);
                    model2dy.put(modelId, (List<DynamicObject>)dyc);
                    entity2YearPeriods.putAll(ReportServiceHelper.collectEntity2YearPeriods(model2dy));
                }
                long yearId = yearDy.getLong("id");
                long periodId = periodDy.getLong("id");
                dyc.stream().forEach(p -> {
                    boolean needCheck = false;
                    if (entity2YearPeriods.get(p.getLong("dentity.id")) != null) {
                        Pair yearPeriods = (Pair)entity2YearPeriods.get(p.getLong("dentity.id"));
                        if (CollectionUtils.isNotEmpty((Collection)((Collection)yearPeriods.p1)) && !needCheck) {
                            needCheck = ((List)yearPeriods.p1).contains(yearId);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)((Collection)yearPeriods.p2)) && (CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p1)) || needCheck)) {
                            needCheck = ((List)yearPeriods.p2).contains(periodId);
                        }
                        if (CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p1)) && CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p2))) {
                            needCheck = true;
                        }
                    } else {
                        needCheck = true;
                    }
                    if (needCheck) {
                        Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", Long.parseLong(p.getString("dentity.oid")), p.getString("dentity.num"), Integer.parseInt(p.getString("dentity.rangevalue")), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                        allEntityIdSet.addAll(entitySet);
                    }
                });
                if (!StringUtil.isEmptyString((String)unCheckEntityStr)) {
                    List list = (List)JSON.parseObject((String)unCheckEntityStr, List.class);
                    for (Map stringStringMap : list) {
                        Set<String> entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange("bcm_entitymembertree", Long.parseLong((String)stringStringMap.get("oid")), (String)stringStringMap.get(NUMBER), Integer.parseInt((String)stringStringMap.get("rangevalue")), String.valueOf(modelId), DetailTypeEnum.MEMBERPERM);
                        allEntityIdSet.addAll(entitySet);
                    }
                }
                if (!allEntityIdSet.contains(entityNum)) {
                    Map<String, String> dimMemMapByNum = DataCollectUtils.getDimMemMapByNum(modelId, Collections.singletonList(entityNum), "Entity");
                    entityNum = dimMemMapByNum.get(entityNum);
                    String yearNum = yearDy.getString("name");
                    String year = yearNum.substring(0, 4);
                    String periodNum = periodDy.getString(NUMBER);
                    String periodName = periodNum.substring(3);
                    String sceneNum = scenarioDy.getString(NUMBER);
                    if (sceneNum.equals("MRpt")) {
                        Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"GLAccountBookService", (String)"isAccountBookClose", (Object[])new Object[]{entityNum, null, year, periodName});
                        return result;
                    }
                }
            }
        }
        return true;
    }

    public static Map<Long, Pair<List<Long>, List<Long>>> collectEntity2YearPeriods(Map<Long, List<DynamicObject>> cm018Entitys) {
        HashMap<Long, Pair<List<Long>, List<Long>>> entity2YearPeriods = new HashMap<Long, Pair<List<Long>, List<Long>>>(16);
        if (MapUtils.isNotEmpty(cm018Entitys)) {
            for (List<DynamicObject> value : cm018Entitys.values()) {
                for (DynamicObject dy : value) {
                    Pair ids = entity2YearPeriods.computeIfAbsent(dy.getLong("dentity.id"), k -> new Pair(new ArrayList(16), new ArrayList(16)));
                    if (StringUtils.isNotEmpty((CharSequence)dy.getString("dentity.year"))) {
                        try {
                            List years = (List)JSON.parseObject((String)dy.getString("dentity.year"), List.class);
                            if (years.size() > 0) {
                                ((List)ids.p1).addAll(years);
                            }
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)dy.getString("dentity.period"))) continue;
                    try {
                        List periods = (List)JSON.parseObject((String)dy.getString("dentity.period"), List.class);
                        if (periods.size() <= 0) continue;
                        ((List)ids.p2).addAll(periods);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                }
            }
        }
        return entity2YearPeriods;
    }

    private static boolean isNeedcheckDataLock(Long modelId) {
        return (Boolean)ThreadCache.get((Object)String.join((CharSequence)"_", "isNeedcheckDataLock", modelId + ""), () -> OlapServiceHelper.checkMeasure(MemberReader.findModelNumberById((Object)modelId), FacTabFieldDefEnum.FIELD_LOCK.getField()));
    }

    private static boolean isNeedCheckForCM034(Long modelId, DynamicObject scenarioDy) {
        if (ReportServiceHelper.isNeedcheckDataLock(modelId)) {
            return true;
        }
        if (!ConfigServiceHelper.getBoolChildParam(modelId, "CM034", "config")) {
            return false;
        }
        JSONArray exceptionScenario = (JSONArray)ParamSettingServiceHelper.getJsonChildKey((long)modelId, (String)"CM034", (String)scenario);
        if (exceptionScenario != null) {
            return !exceptionScenario.stream().anyMatch(s -> s.equals(scenarioDy.getLong("id")));
        }
        return true;
    }

    public static String verifySubmitStatusAboutParentChildStatus(Map template, String status, Long modelId, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy) {
        if (ReportStatusEnum.COMPLETE.status().equals(status) && ReportServiceHelper.isNeedCheckForCM034(modelId, scenarioDy)) {
            boolean flag;
            MergeDataSourceEnum mergeDataSourceEnum;
            boolean isSirpt;
            long scenarioId = scenarioDy.getLong("id");
            long periodId = periodDy.getLong("id");
            long yearId = yearDy.getLong("id");
            Long entityId = LongUtil.toLong(template.get("entity.id"));
            String curNum = currencyDy.getString(NUMBER);
            IDNumberTreeNode parentNode = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)entityId);
            if (parentNode == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            boolean isDefaultCur = curNum.equals(parentNode.getCurrency());
            String templateNum = String.valueOf(template.get("template.number"));
            HashSet<String> orgNums = new HashSet<String>(16);
            Set<Object> entityIdSet = new HashSet(16);
            HashSet<Long> ids = new HashSet<Long>(16);
            HashMap<Long, IDNumberTreeNode> childMap = new HashMap<Long, IDNumberTreeNode>(16);
            if (!((Boolean)template.get("entity.isleaf")).booleanValue() && (isSirpt = (mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)scenarioId, (Object)yearId, (Object)periodId, entityId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex()))) {
                ReportServiceHelper.getEffectChildDataForOrg(modelId, scenarioId, yearDy.getString(NUMBER), periodId, entityId, childMap);
                if (!childMap.isEmpty()) {
                    Map<String, Boolean> orgsIsMerge = MergeControlHelper.getAllStructInfoForMap(modelId, scenarioId, yearId, periodId);
                    childMap.forEach((k, v) -> {
                        if (ReportServiceHelper.isMerge(parentNode.getNumber() + "!" + v.getNumber(), orgsIsMerge)) {
                            ids.add((Long)k);
                            orgNums.add(v.getNumber());
                        }
                    });
                    if (CollectionUtils.isNotEmpty(ids) && CollectionUtils.isNotEmpty(orgNums)) {
                        Long templateId = LongUtil.toLong(template.get("template.id"));
                        Map<Long, Set<Long>> distributeMap = ReportServiceHelper.getDistributeMapFromCacheNew(modelId, Sets.newHashSet((Object[])new Long[]{templateId}), ids);
                        entityIdSet = distributeMap.get(templateId);
                    }
                }
            }
            if ((flag = ReportServiceHelper.isNeedcheckDataLock(modelId)) && !isDefaultCur) {
                orgNums.add(parentNode.getNumber());
            }
            Map<String, ReportStatusEnum> reportRecordMap = ReportServiceHelper.getReportRecordMap(modelId, orgNums, scenarioId, yearId, periodId, templateNum, null, null);
            if (!isDefaultCur) {
                if (flag && ReportStatusEnum.COMMIT != ReportServiceHelper.getReportStatusEnum(reportRecordMap, String.join((CharSequence)"_", parentNode.getNumber(), parentNode.getCurrency()))) {
                    return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u975e\u672c\u4f4d\u5e01\u62a5\u8868\u4e0d\u53ef\u4e0a\u62a5\uff0c\u9700\u8981\u672c\u4f4d\u5e01\u62a5\u8868\u5df2\u4e0a\u62a5\u3002", (String)"ReportServiceHelper_21", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
                }
                return null;
            }
            for (Long id : ids) {
                boolean isExitDis;
                boolean bl = isExitDis = entityIdSet != null && entityIdSet.contains(id);
                IDNumberTreeNode childNode = (IDNumberTreeNode)childMap.get(id);
                if (childNode == null) continue;
                ReportStatusEnum statusEnum = null;
                statusEnum = flag ? ReportServiceHelper.getReportStatusEnum(reportRecordMap, String.join((CharSequence)"_", childNode.getNumber(), parentNode.getCurrency())) : ReportServiceHelper.getReportStatusEnum(reportRecordMap, String.join((CharSequence)"_", childNode.getNumber(), childNode.getCurrency()));
                if (ReportStatusEnum.COMMIT == statusEnum || !isExitDis && ReportStatusEnum.UNWEAVE == statusEnum) continue;
                return String.format(flag ? ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u672c\u4f4d\u5e01\u62a5\u8868\u4e0d\u53ef\u4e0a\u62a5\uff0c\u9700\u8981\u5176\u76f4\u63a5\u4e0b\u7ea7\u5bf9\u5e94\u5e01\u79cd\u7684\u62a5\u8868\u5747\u5df2\u4e0a\u62a5\u3002", (String)"ReportServiceHelper_23", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u76f4\u63a5\u4e0b\u7ea7\u5355\u4f4d\u62a5\u8868\u5b58\u5728\u672a\u4e0a\u62a5\u62a5\u8868\uff0c\u5f53\u524d\u7ec4\u7ec7\u6b64\u62a5\u8868\u4e0d\u53ef\u4e0a\u62a5\uff01", (String)"ReportServiceHelper_17", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
            }
        }
        return null;
    }

    private static IDNumberTreeNode getEffectChildDataForOrg(long modelId, long sceneId, String yearNum, long periodId, long orgId, Map<Long, IDNumberTreeNode> childMap) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode treeNode = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        if (treeNode != IDNumberTreeNode.NotFoundTreeNode) {
            HashMap<Long, IDNumberTreeNode> result = new HashMap<Long, IDNumberTreeNode>(16);
            treeNode.getChildren().forEach(e -> {
                result.put(e.getId(), (IDNumberTreeNode)e);
                orgIds.add(e.getId());
            });
            EntityVersioningUtil.getOrgsByVersion(modelId, sceneId, yearNum, periodId, orgIds).forEach(id -> result.remove(id));
            result.forEach((k, v) -> {
                long id = k;
                if (v.isShare() && v.getCopyfromId() != 0L) {
                    id = v.getCopyfromId();
                }
                childMap.put(id, (IDNumberTreeNode)v);
            });
        }
        return treeNode;
    }

    public static Map<Long, Set<Long>> getDistributeMapFromCacheNew(Object modelId, Set<Long> selectTemplateIdSet, Set<Long> orgRangeBsaeMembers) {
        Object usertaskParam = ThreadCache.get((Object)userTaskInfo);
        if (null != usertaskParam) {
            return TaskRecordServiceHelper.getTemplate2OrgMapOfUserTask(Long.valueOf(modelId.toString()), selectTemplateIdSet, orgRangeBsaeMembers, (Map)usertaskParam);
        }
        return TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense(Long.valueOf(modelId.toString()), selectTemplateIdSet, orgRangeBsaeMembers);
    }

    private static boolean isMerge(String key, Map<String, Boolean> isMergeMap) {
        return isMergeMap.get(key) == null || isMergeMap.get(key) != false;
    }

    private static IDNumberTreeNode getEffectParentDataForOrg(long modelId, long sceneId, String yearNum, long periodId, String orgNum, Map<Long, IDNumberTreeNode> parentMap) {
        QFilter qFilter = new QFilter(model, "=", (Object)modelId);
        qFilter.and(NUMBER, "=", (Object)orgNum);
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        HashMap<Long, Long> childToParentMap = new HashMap<Long, Long>(16);
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,parent.id,parent.number", (QFilter[])qFilter.toArray()).forEach(e -> {
            long curId = e.getLong("id");
            String number = e.getString("parent.number");
            if (!"Entity".equals(number)) {
                long parentId = e.getLong("parent.id");
                orgIds.add(parentId);
                childToParentMap.put(curId, parentId);
            }
            orgIds.add(curId);
        });
        IDNumberTreeNode childTreeNode = IDNumberTreeNode.NotFoundTreeNode;
        if (!childToParentMap.isEmpty()) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            childTreeNode = BcmThreadCache.findMemberByNum((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNum);
            orgIds.removeAll(EntityVersioningUtil.getOrgsByVersion(modelId, sceneId, yearNum, periodId, orgIds));
            childToParentMap.forEach((k, v) -> {
                IDNumberTreeNode node;
                if (orgIds.contains(k) && orgIds.contains(v) && (node = BcmThreadCache.findNodeById((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (long)v)) != IDNumberTreeNode.NotFoundTreeNode) {
                    parentMap.put((Long)v, node);
                }
            });
        }
        return childTreeNode;
    }

    public static String verifyBackStatusAboutParentChildStatus(Map template, String status, Long modelId, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy) {
        if (ReportStatusEnum.COMMIT.status().equals(status) && ReportServiceHelper.isNeedCheckForCM034(modelId, scenarioDy)) {
            long scenarioId = scenarioDy.getLong("id");
            long periodId = periodDy.getLong("id");
            long yearId = yearDy.getLong("id");
            String curOrgNum = String.valueOf(template.get("entity.number"));
            HashMap<Long, IDNumberTreeNode> parentMap = new HashMap<Long, IDNumberTreeNode>(16);
            IDNumberTreeNode childNode = ReportServiceHelper.getEffectParentDataForOrg(modelId, scenarioId, yearDy.getString(NUMBER), periodId, curOrgNum, parentMap);
            if (childNode == IDNumberTreeNode.NotFoundTreeNode) {
                return null;
            }
            String curNum = currencyDy.getString(NUMBER);
            boolean isDefaultCur = curNum.equals(childNode.getCurrency());
            HashSet<String> orgs = new HashSet<String>(16);
            parentMap.forEach((k, v) -> orgs.add(v.getNumber()));
            Map<String, ReportStatusEnum> reportRecordMap = ReportServiceHelper.getReportRecordMap(modelId, orgs, scenarioId, yearId, periodId, String.valueOf(template.get("template.number")), curNum, isDefaultCur ? childNode.getNumber() : null);
            boolean flag = ReportServiceHelper.isNeedcheckDataLock(modelId);
            if (flag && isDefaultCur && ReportStatusEnum.COMMIT == ReportServiceHelper.getReportStatusEnum(reportRecordMap, childNode.getNumber())) {
                return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u6253\u56de\u672c\u4f4d\u5e01\u62a5\u8868\u65f6\uff0c\u8981\u6c42\u5f53\u524d\u7ec4\u7ec7\u6240\u6709\u975e\u672c\u4f4d\u5e01\u62a5\u8868\u5747\u5df2\u6253\u56de\uff01", (String)"ReportServiceHelper_20", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
            }
            if (parentMap.isEmpty() || !flag && !isDefaultCur) {
                return null;
            }
            Map<String, Boolean> orgsIsMerge = MergeControlHelper.getAllStructInfoForMap(modelId, scenarioId, yearId, periodId);
            for (Map.Entry entry : parentMap.entrySet()) {
                MergeDataSourceEnum mergeDataSourceEnum;
                long parentId = (Long)entry.getKey();
                IDNumberTreeNode parentNode = (IDNumberTreeNode)entry.getValue();
                if (!ReportServiceHelper.isMerge(parentNode.getNumber() + "!" + curOrgNum, orgsIsMerge) || !(mergeDataSourceEnum = MergeControlHelper.getMergeSource((Object)modelId, (Object)scenarioId, (Object)yearId, (Object)periodId, parentId)).getIndex().equals(MergeDataSourceEnum.SIRpt.getIndex())) continue;
                if (flag) {
                    if (!curNum.equals(parentNode.getCurrency()) || ReportStatusEnum.COMMIT != ReportServiceHelper.getReportStatusEnum(reportRecordMap, String.join((CharSequence)"_", parentNode.getNumber(), parentNode.getCurrency()))) continue;
                    return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u6253\u56de\u7236\u7ea7\u5e01\u79cd\u62a5\u8868\u65f6\uff0c\u8981\u6c42\u7236\u7ea7\u7ec4\u7ec7\u672c\u4f4d\u5e01\u62a5\u8868\u5df2\u6253\u56de\u3002", (String)"ReportServiceHelper_22", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
                }
                if (ReportStatusEnum.COMMIT != ReportServiceHelper.getReportStatusEnum(reportRecordMap, String.join((CharSequence)"_", parentNode.getNumber(), parentNode.getCurrency()))) continue;
                return String.format(ResManager.loadKDString((String)"%s:\u5f53\u524d\u7ec4\u7ec7\u76f4\u63a5\u7236\u7ea7\u5355\u4f4d\u6b64\u62a5\u8868\u5df2\u4e0a\u62a5\uff0c\u5f53\u524d\u7ec4\u7ec7\u6b64\u62a5\u8868\u4e0d\u53ef\u6253\u56de\uff01", (String)"ReportServiceHelper_12", (String)"fi-bcm-business", (Object[])new Object[0]), template.get("template.name"));
            }
        }
        return null;
    }

    private static ReportStatusEnum getReportStatusEnum(Map<String, ReportStatusEnum> reportRecordMap, String key) {
        ReportStatusEnum statusEnum = reportRecordMap.get(key);
        if (statusEnum == null) {
            statusEnum = ReportStatusEnum.UNWEAVE;
        }
        return statusEnum;
    }

    private static DynamicObjectCollection queryRecord(Long modelId, Set<String> orgs, long scenarioId, long yearId, long periodId, String templateNum) {
        QFilter filter = new QFilter("template.number", "=", (Object)templateNum);
        filter.and(model, "=", (Object)modelId);
        filter.and("entity.number", "in", orgs);
        filter.and("scene", "=", (Object)scenarioId);
        filter.and("fyear", "=", (Object)yearId);
        filter.and(period, "=", (Object)periodId);
        filter.and(TemplateUtil.getReportTypeFilter());
        return QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity.number,currency.number,reportstatus", (QFilter[])filter.toArray());
    }

    private static Map<String, ReportStatusEnum> getReportRecordMap(Long modelId, Set<String> orgs, long scenarioId, long yearId, long periodId, String templateNum, String curNum, String curOrgNum) {
        HashMap<String, ReportStatusEnum> result = new HashMap<String, ReportStatusEnum>(16);
        HashSet<String> numbers = new HashSet<String>(orgs);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)curOrgNum)) {
            numbers.add(curOrgNum);
        }
        if (CollectionUtils.isNotEmpty(numbers)) {
            ReportServiceHelper.queryRecord(modelId, numbers, scenarioId, yearId, periodId, templateNum).forEach(e -> {
                ReportStatusEnum statusEnum = ReportStatusEnum.getStatusEnumBy((String)e.getString("reportstatus"));
                String orgNum = e.getString("entity.number");
                String currency = e.getString("currency.number");
                boolean isCur = orgNum.equals(curOrgNum);
                if (ReportStatusEnum.COMMIT != result.get(orgNum) && (!isCur || isCur && !currency.equals(curNum))) {
                    result.put(orgNum, statusEnum);
                }
                if (!isCur) {
                    String key = String.join((CharSequence)"_", orgNum, currency);
                    if (result.get(key) != null && ReportStatusEnum.COMMIT == result.get(key)) {
                        return;
                    }
                    result.put(key, statusEnum);
                }
            });
        }
        return result;
    }

    private static boolean verifyStatusOperatorsMutuallyExclusive(Map template, long modelId, String modelNumber, DynamicObject scenarioDy, DynamicObject yearDy, DynamicObject periodDy, DynamicObject currencyDy, String actionItem) {
        if (ConfigServiceHelper.getBoolParam(modelNumber, "CM038")) {
            String userId = RequestContext.get().getUserId();
            boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel(Long.parseLong(userId), String.valueOf(modelId));
            if (isAdmin) {
                return true;
            }
            QFilter qFilter = new QFilter(model, "=", (Object)modelId).and("scene", "=", (Object)scenarioDy.getLong("id")).and("fyear", "=", (Object)yearDy.getLong("id")).and(period, "=", (Object)periodDy.getLong("id")).and(currency, "=", (Object)currencyDy.getLong("id")).and("entity.number", "in", (Object)String.valueOf(template.get("entity.number"))).and("template", "in", (Object)LongUtil.toLong(template.get("template.id")));
            DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,commitor,completer", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
            if (reports != null && !reports.isEmpty()) {
                String commitor = String.valueOf(((DynamicObject)reports.get(0)).getLong("commitor"));
                String completer = String.valueOf(((DynamicObject)reports.get(0)).getLong("completer"));
                switch (actionItem) {
                    case "back": {
                        if (!userId.equals(completer)) break;
                        return false;
                    }
                    case "commit": {
                        if (!userId.equals(completer)) break;
                        return false;
                    }
                    case "cancel": {
                        if (userId.equals(completer)) break;
                        return false;
                    }
                    case "complete": {
                        if (LongUtil.toLong((Object)commitor) == 0L || !commitor.equals(userId)) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static Map<Pair<Long, Long>, CheckResultenum> checkUpChkForCt(Map<String, String> map, DynamicObject[] dyos, boolean clickCheck, boolean fromCompiling, Long modelId, String modelNumber, boolean isCsl, boolean isCWPReport, boolean isFromReportQuery, boolean isCycleTablesView, boolean isShowCTStatus, Object[] getSelectedPks, Long cslschemeId) {
        QFilter filter;
        if (dyos != null) {
            ArrayList ids = new ArrayList(16);
            Arrays.stream(dyos).forEach(dyo -> ids.add(dyo.getLong("id")));
            filter = new QFilter("id", "in", ids);
        } else {
            filter = new QFilter("id", "in", (Object)getSelectedPks);
        }
        QFilter statusfilter = new QFilter("reportstatus", "not in", (Object)new String[]{ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.UNWEAVE.status()});
        if (isCycleTablesView && isShowCTStatus) {
            filter.and("reportstatus", "not in", (Object)new String[]{ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()});
        }
        DynamicObjectCollection reportlist = clickCheck && fromCompiling ? QueryServiceHelper.query((String)"bcm_reportlistentity", (String)"entity,template,cycletable,template.id,template.number", (QFilter[])new QFilter[]{filter, statusfilter}) : QueryServiceHelper.query((String)"bcm_reportlistentity", (String)"entity,template,cycletable,template.id,template.number", (QFilter[])new QFilter[]{filter});
        CalContext ctx = new CalContext(map.get(model), null, map.get(year), map.get(period), map.get(scenario), map.get(currency));
        ctx.setProperty("selecttemplatelist", reportlist);
        ctx.setProperty("cslSchemeId", cslschemeId);
        ctx.setProperty("reporttype", ReportServiceHelper.getReportType(isCsl, isCWPReport, isFromReportQuery));
        ctx.setProperty("clickCheck", clickCheck);
        Map<Pair<Long, Long>, CheckResultenum> results = new HashMap<Pair<Long, Long>, CheckResultenum>(reportlist.size());
        if (CollectionUtils.isNotEmpty((Collection)reportlist)) {
            if (reportlist.size() > 1) {
                ctx.setProperty("batchChkTmp", reportlist.stream().map(t -> t.getString("template.number")).collect(Collectors.joining(",")));
                results = ChkCheckServiceHelper.check(ctx, true);
            } else {
                DynamicObject dot = (DynamicObject)reportlist.get(0);
                QFilter filter2 = new QFilter(model, "=", (Object)modelId).and(new QFilter("id", "=", (Object)dot.getLong("template")));
                DynamicObject template = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"id,number", (QFilter[])new QFilter[]{filter2});
                Long templateId = dot.getLong("template");
                CalContext calContext = new CalContext(map.get(model), MemberReader.findEntityMemberById((Long)modelId, (Long)dot.getLong(entity)).getNumber(), map.get(year), map.get(period), map.get(scenario), map.get(currency));
                String templateNumber = template.getString(NUMBER);
                calContext.setProperty("temp", templateNumber);
                calContext.setProperty("originalOrgId", dot.get(entity));
                calContext.setProperty("reporttype", ReportServiceHelper.getReportType(isCsl, isCWPReport, isFromReportQuery));
                CheckResultenum resultenum = ChkCheckServiceHelper.check(calContext);
                results.put((Pair<Long, Long>)Pair.onePair((Object)dot.getLong(entity), (Object)templateId), resultenum);
            }
        }
        return results;
    }

    public static String getReportType(boolean isCsl, boolean isCWPReport, boolean isFromReportQuery) {
        String reportType = isCsl ? CHKReportType.CSLREPORT.getSign() : (isCWPReport ? CHKReportType.CWPREPORT.getSign() : (isFromReportQuery ? CHKReportType.QUERYREPORT.getSign() : CHKReportType.NORMALREPORT.getSign()));
        return reportType;
    }

    public static Map<String, Object> getMap(DynamicObject template) {
        HashMap<String, Object> temp = new HashMap<String, Object>(4);
        temp.put("entity.id", template.getLong("entity.id"));
        temp.put("entity.number", template.getString("entity.number"));
        temp.put("template.id", template.getLong("template.id"));
        temp.put("template.number", template.getString("template.number"));
        temp.put("template.name", template.getString("template.name"));
        temp.put("entity.isleaf", template.getBoolean("entity.isleaf"));
        return temp;
    }

    public static boolean checkIsExcute(Long templateId, Long modelId, Long orgId, Long scenarioId, Long fyId, Long periodId) {
        Object excuting2Dys = ThreadCache.get((Object)"ReportListPlugin.checkIsExcute");
        boolean isExist = false;
        if (excuting2Dys != null) {
            Map checkIsExcute_org2_sorgs = (Map)ThreadCache.get((Object)"ReportListPlugin.checkIsExcute_org2_sorgs");
            long trueEntityId = (Long)checkIsExcute_org2_sorgs.get(orgId);
            isExist = ((Map)excuting2Dys).get("" + templateId + trueEntityId) != null;
        } else {
            IDNumberTreeNode node = BcmThreadCache.findNodeById((String)MemberReader.findModelNumberById((Object)modelId), (String)DimTypesEnum.ENTITY.getNumber(), (long)orgId);
            if (node != IDNumberTreeNode.NotFoundTreeNode) {
                long entityId = node.getCopyfromId();
                long trueEntityId = entityId == 0L ? orgId : entityId;
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add(model, "=", (Object)modelId);
                qfBuilder.add("org", "=", (Object)trueEntityId);
                qfBuilder.add(scenario, "=", (Object)scenarioId);
                qfBuilder.add("fy", "=", (Object)fyId);
                qfBuilder.add(period, "=", (Object)periodId);
                qfBuilder.add("template.id", "=", (Object)templateId);
                qfBuilder.add("collectstatus", "in", Arrays.asList(Character.valueOf(DataCollectRecordEnum.EXCUTING.index), Character.valueOf(DataCollectRecordEnum.READY.index)));
                isExist = QueryServiceHelper.exists((String)"bcm_datacollect", (QFilter[])qfBuilder.toArray());
            }
        }
        return isExist;
    }

    public static DynamicObjectCollection getExcutingRecords(Set<Long> templateIds, Long modelId, Long scenarioId, Long fyId, Long periodId, Set<Long> orgIds) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(model, "=", (Object)modelId);
        qfBuilder.add("org", "in", orgIds);
        qfBuilder.add(scenario, "=", (Object)scenarioId);
        qfBuilder.add("fy", "=", (Object)fyId);
        qfBuilder.add(period, "=", (Object)periodId);
        qfBuilder.add("template.id", "in", templateIds);
        qfBuilder.add("collectstatus", "in", Arrays.asList(Character.valueOf(DataCollectRecordEnum.EXCUTING.index), Character.valueOf(DataCollectRecordEnum.READY.index)));
        DynamicObjectCollection excuteRecords = QueryServiceHelper.query((String)"bcm_datacollect", (String)"id,org,template.id", (QFilter[])qfBuilder.toArray());
        return excuteRecords;
    }

    public static DynamicObjectCollection queryCycleTableReport(List<Object> successIds) {
        String selectFields = "id,model,cycletabstatus,fyear,period,scene,currency,currency.number,entity,cycletable.id";
        QFilter filter = new QFilter("id", "in", successIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"bcm_cycletablereport", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return reports;
    }

    public static Set<Long> getCommitCycleTableByReport(DynamicObject reportDyn, Set<Long> cycleIds) {
        long modelId = reportDyn.getLong(model);
        long year = reportDyn.getLong("fyear");
        long period = reportDyn.getLong(period);
        long scene = reportDyn.getLong("scene");
        long entity = reportDyn.getLong(entity);
        String currencyNumber = reportDyn.getString("currency.number");
        return ReportServiceHelper.getCommitCycleTableByReport(modelId, scene, year, period, entity, currencyNumber, cycleIds);
    }

    public static Set<Long> getCommitCycleTableByReport(long modelId, long scene, long year, long period, long entity, String currencyNumber, Set<Long> cycleIds) {
        QFilter qFilter = new QFilter(model, "=", (Object)modelId);
        qFilter.and("fyear", "=", (Object)year);
        qFilter.and(period, "=", (Object)period);
        qFilter.and("scene", "=", (Object)scene);
        qFilter.and("currency.number", "=", (Object)currencyNumber);
        qFilter.and(entity, "=", (Object)entity);
        qFilter.and("cycletabstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
        qFilter.and("cycletable", "in", cycleIds);
        DynamicObjectCollection allReport = QueryServiceHelper.query((String)"bcm_cycletablereport", (String)"id,entity.id,cycletable.id", (QFilter[])qFilter.toArray());
        return allReport.stream().map(dy -> dy.getLong("cycletable.id")).collect(Collectors.toSet());
    }
}

