/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.bcm.business.dto.ScenePeriodDTO;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ScenePeriodServiceHelper {
    public static Map<String, List<Long>> getScenePeriodByModel(Long modelId, Collection<String> sceneNumbers) {
        DynamicObject[] scenePeriods;
        Map<Object, Object> scenePeriodMap = Maps.newHashMap();
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)modelId);
        if (CollectionUtils.isNotEmpty(sceneNumbers)) {
            qfBuilder.add("number", "in", sceneNumbers);
        }
        if ((scenePeriods = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"number, sceneperiod.number", (QFilter[])qfBuilder.toArray())).length != 0) {
            scenePeriodMap = Arrays.stream(scenePeriods).collect(Collectors.toMap(scenePeriod -> scenePeriod.getString("number"), scenePeriod -> scenePeriod.getDynamicObjectCollection("sceneperiod").stream().map(period -> period.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList())));
        }
        return scenePeriodMap;
    }

    public static Map<String, List<DynamicObject>> getScenePeriod(Long modelId, Collection<String> sceneNumbers) {
        Map<String, List<Long>> scenePeriodByModel = ScenePeriodServiceHelper.getScenePeriodByModel(modelId, sceneNumbers);
        ArrayList periodPKs = Lists.newArrayList();
        scenePeriodByModel.values().stream().forEach(periodIds -> periodPKs.addAll(periodIds));
        DynamicObject[] queryPeriods = BusinessDataServiceHelper.load((Object[])periodPKs.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bcm_periodmembertree"));
        Map periodMap = Arrays.stream(queryPeriods).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), Function.identity()));
        HashMap scenePeriodMap = Maps.newHashMap();
        scenePeriodByModel.forEach((sceneNumber, periodIds) -> {
            ArrayList periodObjects = Lists.newArrayList();
            periodIds.stream().forEach(periodId -> periodObjects.add(periodMap.get(periodId)));
            scenePeriodMap.put(sceneNumber, periodObjects);
        });
        return scenePeriodMap;
    }

    public static Map<String, ScenePeriodDTO> convertPeriod2Month(Long modelId, Collection<String> sceneNumbers) {
        HashMap scenePeriodMonth = Maps.newHashMap();
        Map<String, List<DynamicObject>> scenePeriods = ScenePeriodServiceHelper.getScenePeriod(modelId, sceneNumbers);
        scenePeriods.forEach((sceneNumber, periods) -> {
            ScenePeriodDTO scenePeriodDTO = new ScenePeriodDTO();
            HashMap periodMonths = Maps.newHashMap();
            periods.stream().forEach(period -> {
                HashSet months = Sets.newHashSet();
                String effmonth = period.getString("effmonth");
                months.add(effmonth);
                String expmonth = period.getString("expmonth");
                months.add(expmonth);
                ScenePeriodServiceHelper.getDiffMonths(effmonth, expmonth, months);
                periodMonths.put(period.getString("number"), months);
            });
            scenePeriodDTO.setPeriodMonths(periodMonths);
            scenePeriodMonth.put(sceneNumber, scenePeriodDTO);
        });
        return scenePeriodMonth;
    }

    public static List<String> convertAllPeriod2Month(Long modelId, Collection<String> sceneNumbers) {
        Map<String, ScenePeriodDTO> scenePeriodDTOMap = ScenePeriodServiceHelper.convertPeriod2Month(modelId, sceneNumbers);
        ArrayList months = Lists.newArrayList();
        if (MapUtils.isEmpty(scenePeriodDTOMap)) {
            return months;
        }
        months.addAll(scenePeriodDTOMap.values().stream().map(scenePeriodDTO -> scenePeriodDTO.getAllMonths()).flatMap(Collection::stream).collect(Collectors.toSet()));
        return months.stream().sorted(Comparator.comparing(month -> Integer.parseInt(month))).collect(Collectors.toList());
    }

    private static void getDiffMonths(String effmonth, String expmonth, Set<String> months) {
        int effmonthInt = Integer.parseInt(effmonth);
        int expmonthInt = Integer.parseInt(expmonth);
        for (int i = effmonthInt + 1; i < expmonthInt; ++i) {
            months.add(String.valueOf(i));
        }
    }
}

