/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.QueryTreenodeHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class SearchHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(SearchHelper.class);
    public static final String treeentryentity = "treeentryentity";
    private static int focusRow = 0;

    public static TreeMap<Integer, Long> getSearchItemId(String searchText, DynamicObjectCollection members, long parentId) {
        TreeMap<Integer, Long> resultMap = new TreeMap<Integer, Long>();
        DynamicObject root = null;
        HashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new HashMap<Long, TreeMap<Integer, DynamicObject>>(16);
        if (members != null && members.size() > 0) {
            for (DynamicObject memberObject : members) {
                long parent = memberObject.getLong("parent");
                int dseq = memberObject.getInt("dseq");
                if (root == null && parent == parentId) {
                    root = memberObject;
                    continue;
                }
                TreeMap treeMap = (TreeMap)searchChild.get(parent);
                if (null != treeMap) {
                    if (treeMap.containsKey(dseq)) {
                        treeMap.put((Integer)treeMap.lastKey() + 1, memberObject);
                        continue;
                    }
                    treeMap.put(dseq, memberObject);
                    continue;
                }
                TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
                children.put(dseq, memberObject);
                searchChild.put(parent, children);
            }
        }
        if (root == null) {
            log.error("getSearchItemId root is null,parentId:" + parentId);
            return resultMap;
        }
        if (root.getString("number").toLowerCase(Locale.ENGLISH).contains(searchText) || root.getString("name").toLowerCase(Locale.ENGLISH).contains(searchText)) {
            resultMap.put(0, root.getLong("id"));
        }
        SearchHelper.expandNextLevel(0, root, searchChild, searchText, resultMap);
        return resultMap;
    }

    private static int expandNextLevel(int row, DynamicObject parent, Map<Long, TreeMap<Integer, DynamicObject>> treeMap, String searchText, Map<Integer, Long> resultMap) {
        long parentId = parent.getLong("id");
        if (treeMap.containsKey(parentId)) {
            TreeMap<Integer, DynamicObject> childrenMap = treeMap.get(parentId);
            for (DynamicObject child : childrenMap.values()) {
                if (child.getString("number").toLowerCase(Locale.ENGLISH).contains(searchText) || child.getString("name").toLowerCase(Locale.ENGLISH).contains(searchText)) {
                    resultMap.put(++row, child.getLong("id"));
                }
                row = SearchHelper.expandNextLevel(row, child, treeMap, searchText, resultMap);
            }
        }
        return row;
    }

    public static List<String> getOrgParentNodeList(String modelid, String dimensionid, String nodeid, String entityname) {
        List<Map<String, String>> treeList = QueryTreenodeHelper.getallnode(entityname, dimensionid, modelid);
        ArrayList<String> orgparent = new ArrayList<String>();
        orgparent.addAll(QueryTreenodeHelper.queryAllParentNodeList(nodeid, new ArrayList<String>(), treeList));
        return orgparent;
    }

    public static int fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection members, List<String> propertyList, String focusID, Long parentId, Set<Long> ids) {
        DynamicObject root = null;
        focusRow = 0;
        HashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new HashMap<Long, TreeMap<Integer, DynamicObject>>(16);
        if (members != null && members.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, members.size());
            for (int i = 0; i < members.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)members.get(i);
                Long parent = memberObject.getLong("parent");
                int seq = memberObject.getInt("dseq");
                if (parent.equals(parentId)) {
                    root = memberObject;
                    continue;
                }
                TreeMap treeMap = (TreeMap)searchChild.get(parent);
                if (null != treeMap) {
                    if (treeMap.containsKey(seq)) {
                        treeMap.put(seq + memberObject.getInt("id"), memberObject);
                        continue;
                    }
                    treeMap.put(seq, memberObject);
                    continue;
                }
                TreeMap<Integer, DynamicObject> children = new TreeMap<Integer, DynamicObject>();
                children.put(seq, memberObject);
                searchChild.put(parent, children);
            }
        }
        if (root == null) {
            return 0;
        }
        DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
        for (int k = 0; k < propertyList.size() - 1; ++k) {
            String property = propertyList.get(k);
            if ("showdproperty".equals(property)) {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= 10; ++i) {
                    String dpname = root.getString("dpname" + i);
                    String dppaname = root.getString("dppaname" + i);
                    if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                    sb.append(dppaname).append(':').append(dpname).append(';');
                }
                rowObj.set(property, (Object)sb.toString());
                continue;
            }
            if ("cycle".equals(property)) {
                rowObj.set("daterangefield_startdate", root.get("daterangefield_startdate1"));
                rowObj.set("daterangefield_enddate", root.get("daterangefield_enddate1"));
                continue;
            }
            if ("drcrdirect1".equals(property)) {
                rowObj.set(property, root.get("drcrdirect"));
                continue;
            }
            rowObj.set(property, root.get(property));
        }
        if (!root.getBoolean("isleaf")) {
            rowObj.set("isgroupnode", (Object)(ids != null && ids.contains(root.getLong("id")) ? 1 : 0));
        }
        rowObj.set("id", (Object)root.getLong("id"));
        rowObj.set("pid", (Object)0);
        if (focusID.equals(root.getString("id"))) {
            focusRow = 0;
        }
        SearchHelper.expandNextLevel(model, propertyList, 0, root, searchChild, focusID, ids);
        return focusRow;
    }

    public static Map<Long, TreeSet<DynamicObject>> fillParentMapChild(DynamicObjectCollection members) {
        HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>(16);
        if (members != null && members.size() > 0) {
            String parentKey = "parent";
            if (!(((DynamicObject)members.get(members.size() - 1)).get("parent") instanceof Long)) {
                parentKey = "parent.id";
            }
            for (int i = 0; i < members.size(); ++i) {
                DynamicObject memberObject = (DynamicObject)members.get(i);
                long parent = memberObject.getLong(parentKey);
                TreeSet treeSet = (TreeSet)searchChild.get(parent);
                if (null != treeSet) {
                    treeSet.add(memberObject);
                    continue;
                }
                TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(Comparator.comparing(a -> a.getInt("dseq")));
                children.add(memberObject);
                searchChild.put(parent, children);
            }
        }
        return searchChild;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, DynamicObject parent, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, String focusID, Set<Long> ids) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size() - 1; ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = child.getString("dpname" + i);
                            String dppaname = child.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", child.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", child.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set(property, child.get("drcrdirect"));
                        continue;
                    }
                    rowObj.set(property, child.get(property));
                }
                if (!child.getBoolean("isleaf")) {
                    rowObj.set("isgroupnode", (Object)(ids != null && ids.contains(child.getLong("id")) ? 1 : 0));
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                if (focusID.equals(child.getString("id"))) {
                    focusRow = row;
                }
                row = SearchHelper.expandNextLevel(model, propertyList, row, child, searchChild, focusID, ids);
            }
        }
        return row;
    }

    public static List<Integer> removeExistNodeForSearchShow(List<String> parentlist, DynamicObjectCollection currentRowObjs) {
        int lastIndex;
        int rowIndex = 0;
        int currentIndex = lastIndex = parentlist.size();
        ArrayList<Integer> pRowIndexs = new ArrayList<Integer>();
        if (!currentRowObjs.isEmpty()) {
            for (DynamicObject row : currentRowObjs) {
                String rowId = row.getString("memberid");
                if (parentlist.contains(rowId)) {
                    if (parentlist.indexOf(rowId) > currentIndex) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u3002", (String)"SearchHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
                    }
                    pRowIndexs.add(rowIndex);
                    currentIndex = parentlist.indexOf(rowId);
                }
                if (currentIndex == 0) break;
                ++rowIndex;
            }
        }
        if (currentIndex == lastIndex - 1 && lastIndex != 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7ed3\u6784\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u3002", (String)"SearchHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        for (int i = lastIndex - 1; i >= 0; --i) {
            if (currentIndex >= i) continue;
            parentlist.set(i, null);
        }
        parentlist.removeIf(pid -> pid == null);
        return pRowIndexs;
    }
}

