/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.AggTagExpressionMetadataItem;
import kd.bos.olap.dataSources.AggTagSlowEvolvingExpressionMetadataItem;
import kd.bos.olap.dataSources.DateValueSlowEvolvingPairMetadataItem;
import kd.bos.olap.dataSources.DateValueSlowEvolvingSetMetadataItem;
import kd.bos.olap.dataSources.ExpressionMetadataItem;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.SlowEvolvingProfileMetadataItem;
import kd.bos.olap.dataSources.SlowEvolvingSetMetadataItem;
import kd.bos.olap.dataSources.TagMetadataItem;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SlowEvolvingServiceHelper {
    public static final String OBSERVE_NAME = "parent";

    public static void createTags(String modelNum, String dimNum, String[] tags) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setMetadataType(MetadataTypes.Dimension);
        cmd.setName(dimNum);
        cmd.setTagDefinitions(String.join((CharSequence)",", tags));
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void tagMembers(String modelNum, String dimNum, String tag, List<String> members) {
        if (CollectionUtils.isEmpty(members) || StringUtils.isEmpty((String)tag)) {
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.create);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setName(dimNum);
        cmd.setMetadataType(MetadataTypes.Tag);
        TagMetadataItem item = new TagMetadataItem(tag);
        item.setMembers(members);
        cmd.getItems().add(item);
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void untagMembers(String modelNum, String dimNum, String[] tags, List<String> members) {
        if (CollectionUtils.isEmpty(members) || tags == null || tags.length == 0) {
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.drop);
        cmd.setOwnerUniqueName(modelNum);
        cmd.setName(dimNum);
        cmd.setMetadataType(MetadataTypes.Tag);
        for (int i = 0; i < tags.length; ++i) {
            TagMetadataItem item = new TagMetadataItem(tags[i]);
            item.setMembers(members);
            cmd.getItems().add(item);
        }
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void setAggTagExpression(String modelNum, String dimNum, String member, String tag) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setOwnerUniqueName(modelNum + '.' + dimNum);
        cmd.setMetadataType(MetadataTypes.Member);
        MemberMetadataItem item = new MemberMetadataItem(member);
        AggTagExpressionMetadataItem aggTag = new AggTagExpressionMetadataItem();
        aggTag.setTags(tag);
        item.setExpression((ExpressionMetadataItem)aggTag);
        cmd.getItems().add(item);
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void setAggTagSlowEvolvingExpression(String modelNum, String dimNum, String member, String tag) {
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setOwnerUniqueName(modelNum + '.' + dimNum);
        cmd.setMetadataType(MetadataTypes.Member);
        MemberMetadataItem item = new MemberMetadataItem(member);
        AggTagSlowEvolvingExpressionMetadataItem expression = new AggTagSlowEvolvingExpressionMetadataItem();
        expression.setObservedPropertyNames(OBSERVE_NAME);
        AggTagExpressionMetadataItem aggTag = new AggTagExpressionMetadataItem();
        aggTag.setTags(tag);
        expression.setBaseExpression(aggTag);
        item.setExpression((ExpressionMetadataItem)expression);
        cmd.getItems().add(item);
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    public static void setMemberSlowEvolving(String modelNum, String dimNum, String member, TreeMap<Integer, String> pairList, String defaultTag) {
        if (pairList == null || pairList.isEmpty()) {
            return;
        }
        MetadataCommandInfo cmd = new MetadataCommandInfo();
        cmd.setAction(CommandTypes.alter);
        cmd.setOwnerUniqueName(modelNum + '.' + dimNum);
        cmd.setMetadataType(MetadataTypes.Member);
        MemberMetadataItem item = new MemberMetadataItem(member);
        SlowEvolvingProfileMetadataItem slowEvolvingItem = new SlowEvolvingProfileMetadataItem();
        slowEvolvingItem.setPropertyName(OBSERVE_NAME);
        DateValueSlowEvolvingSetMetadataItem dateValueSlowEvolvingItem = new DateValueSlowEvolvingSetMetadataItem();
        dateValueSlowEvolvingItem.setDateModel("bcmGetDate");
        pairList.forEach((k, v) -> dateValueSlowEvolvingItem.getItems().add(new DateValueSlowEvolvingPairMetadataItem(k.intValue(), v)));
        dateValueSlowEvolvingItem.setInitValue((Object)defaultTag);
        slowEvolvingItem.setSlowEvolvingSet((SlowEvolvingSetMetadataItem)dateValueSlowEvolvingItem);
        item.setSlowEvolvingProfiles(Collections.singletonList(slowEvolvingItem));
        cmd.getItems().add(item);
        SlowEvolvingServiceHelper.executeCommand(cmd, modelNum);
    }

    private static void executeCommand(MetadataCommandInfo cmd, String modelNum) {
        OlapServiceHelper.executeCommand(cmd, modelNum);
    }
}

