/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;

public class TemplateCatalogServiceHelper {
    public static void setDefaultRootNode(DynamicObject model, long orgId) {
        DynamicObject catalogTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templatecatalog");
        catalogTree.set("number", (Object)"root");
        catalogTree.set("model", model.get("id"));
        catalogTree.set("name", (Object)ResManager.getLocaleString((String)"\u6a21\u677f\u5206\u7c7b", (String)"TemplateCatalogServiceHelper_0", (String)"fi-bcm-business"));
        catalogTree.set("parent", (Object)0);
        catalogTree.set("longnumber", (Object)"root");
        catalogTree.set("status", (Object)"C");
        catalogTree.set("enable", (Object)1);
        catalogTree.set("catalogtype", (Object)0);
        catalogTree.set("modifier", (Object)RequestContext.get().getUserId());
        catalogTree.set("creator", (Object)RequestContext.get().getUserId());
        catalogTree.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
        catalogTree.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
        if (orgId != -1L) {
            catalogTree.set("modelorg", (Object)orgId);
        }
        BusinessDataWriter.save((IDataEntityType)catalogTree.getDynamicObjectType(), (Object[])new Object[]{catalogTree});
        TemplateCatalogServiceHelper.upgradeWorkPaperNode(model.getLong("id"), orgId);
    }

    public static void upgradeWorkPaperNode(long modelid, long orgId) {
        boolean isFalse = false;
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        QFilter wpFilter = new QFilter("catalogtype", "=", (Object)Character.valueOf(TemplateCatalogTypeEnum.WPCATALOG.getType()));
        if (QueryServiceHelper.exists((String)"bcm_templatecatalog", (QFilter[])new QFilter[]{filter, wpFilter})) {
            return;
        }
        HashMap<String, Long> map = new HashMap<String, Long>(TemplateCatalogEnum.values().length);
        filter.and("number", "=", (Object)"root");
        DynamicObject root = QueryServiceHelper.queryOne((String)"bcm_templatecatalog", (String)"id,isleaf", (QFilter[])new QFilter[]{filter});
        map.put("root", root.getLong("id"));
        root.set("isleaf", (Object)isFalse);
        ArrayList<DynamicObject> catalogs = new ArrayList<DynamicObject>();
        for (TemplateCatalogEnum catalog : TemplateCatalogEnum.values()) {
            if (catalog.getType() != TemplateCatalogTypeEnum.WPCATALOG.getType()) continue;
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_templatecatalog");
            obj.set("number", (Object)catalog.getNumber());
            obj.set("model", (Object)modelid);
            obj.set("name", LanguageUtil.getValue(catalog.getName(), "TemplateCatalogServiceHelper_" + catalog.getNumber(), "fi-bcm-business"));
            obj.set("level", (Object)catalog.getLevel());
            obj.set("sequence", (Object)catalog.getSeq());
            obj.set("longnumber", (Object)catalog.getLongnumber());
            obj.set("status", (Object)"C");
            obj.set("enable", (Object)1);
            obj.set("catalogtype", (Object)Character.valueOf(catalog.getType()));
            obj.set("modifier", (Object)RequestContext.get().getUserId());
            obj.set("creator", (Object)RequestContext.get().getUserId());
            obj.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
            obj.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
            obj.set("isleaf", (Object)catalog.isIsleaf());
            if (orgId != -1L) {
                obj.set("modelorg", (Object)orgId);
            }
            long id = DBServiceHelper.genGlobalLongId();
            obj.set("id", (Object)id);
            map.put(catalog.getNumber(), id);
            obj.set("parent", map.get(catalog.getParent()));
            catalogs.add(obj);
        }
        BusinessDataWriter.save((IDataEntityType)((DynamicObject)catalogs.get(0)).getDynamicObjectType(), (Object[])catalogs.toArray());
        TemplateCatalogServiceHelper.upgradeWorkPaperTemplate(modelid, (Long)map.get(TemplateCatalogEnum.MERGE_WP.getNumber()));
    }

    private static void upgradeWorkPaperTemplate(long modelId, long catalogId) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter typeFilter = new QFilter("templatetype", "=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType()));
        Object[] col = BusinessDataServiceHelper.load((String)"bcm_templateentity", (String)"id,templatecatalog", (QFilter[])new QFilter[]{filter, typeFilter});
        if (col.length > 0) {
            for (DynamicObject dynamicObject : col) {
                dynamicObject.set("templatecatalog", (Object)catalogId);
            }
            BusinessDataWriter.save((IDataEntityType)col[0].getDynamicObjectType(), (Object[])col);
        }
    }
}

