/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.model.MemberTreeNode;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.model.FilterOrgStructParam;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class TreeStructureServiceHelper {
    public static boolean isRootEntityNodeId(long modelId, Object entityId, DetailTypeEnum type) {
        IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)Long.parseLong(entityId.toString()));
        return DetailTypeEnum.TEMPLATEDIS == type && "Entity".equals(node.getNumber());
    }

    public static boolean isDirectChild(String entityNum, Object pId, Object id, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        return TreeStructureServiceHelper.getIds(nodes.get(pId).getChildren()).contains(id);
    }

    public static boolean isDirectChildByCustom(String mEntityNum, Object mId, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("bcm_definedpropertyvalue", modelId);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        List props = node.getChildren();
        if (props.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)TreeStructureServiceHelper.getIds(props).toArray()), new QFilter("id", "in", mId)});
    }

    public static boolean isChildByAssign(String entityNum, Object mId, Object pId, Object modelId, boolean isOnlyLeaf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode mNode = nodes.get(mId);
        IDNumberTreeNode parentNode = nodes.get(pId instanceof Long ? (Long)pId : Long.parseLong(pId.toString()));
        if (mNode != null && parentNode != null) {
            mNode = mNode.getBaseTreeNode();
            ArrayList<IDNumberTreeNode> searchNodeList = new ArrayList<IDNumberTreeNode>(4);
            searchNodeList.add(mNode);
            if (mNode.getShareNodes() != null) {
                searchNodeList.addAll(mNode.getShareNodes());
            }
            for (IDNumberTreeNode childNode : searchNodeList) {
                for (IDNumberTreeNode parentOfChild = childNode.getParent(); parentOfChild != null; parentOfChild = parentOfChild.getParent()) {
                    if (!parentNode.getNumber().equals(parentOfChild.getNumber())) continue;
                    return mNode.isLeaf() == isOnlyLeaf;
                }
            }
        }
        return false;
    }

    public static boolean isAssignChildByCustom(String mEntityNum, Object mId, Object cusPropId, boolean isOnlyLeaf, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("bcm_definedpropertyvalue", modelId);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getAllChildren());
        propIds.add(node.getId());
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "=", mId), new QFilter("isleaf", "=", (Object)isOnlyLeaf)});
    }

    public static boolean isBrotherByCustom(String mEntityNum, Object mId, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("bcm_definedpropertyvalue", modelId);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getBrother());
        if (propIds.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "in", mId)});
    }

    public static List<SimpleItem> getDirectChild(String entityNum, Object pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        if (nodes.get(pId) == null) {
            return s;
        }
        nodes.get(pId).getChildren().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        return s;
    }

    public static DynamicObjectCollection getDirectChild(String entityNum, Object pId, String select) {
        QFBuilder qf = new QFBuilder();
        qf.add("parent", "=", pId);
        if ("bcm_entitymembertree".equals(entityNum)) {
            qf.add("isexchangerate", "=", (Object)"0");
        }
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityNum, (String)select, (QFilter[])qf.toArray(), (String)"dseq");
        return result;
    }

    public static DynamicObject getSelfById(String entityNum, Long id, String select) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNum, (String)select);
    }

    public static DynamicObject getSelfByFilter(String entityNum, QFilter[] filters) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityNum, (QFilter[])filters);
    }

    public static List<SimpleItem> getDirectChildByCustom(String mEntityNum, Object cusPropId, boolean isIncludeSelf, long schemeId) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", cusPropId)});
        ArrayList<Object> propIds = new ArrayList<Object>();
        children.forEach(e -> propIds.add(e.get("id")));
        if (isIncludeSelf) {
            propIds.add(cusPropId);
        }
        if (!propIds.isEmpty() && cusPropDyna != null) {
            QFilter filter = new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray());
            if ("bcm_entitymembertree".equals(mEntityNum) && schemeId != 0L) {
                filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
            }
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])filter.toArray());
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static List<SimpleItem> getChild(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(pId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>(nodes.size());
        if (node != null) {
            node.getAllChildren().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        }
        return s;
    }

    public static List<SimpleItem> getLeafChildren(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(pId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        node.getAllChildren(2).forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        return s;
    }

    public static boolean isChildByCustom(String mEntityNum, Object mId, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("bcm_definedpropertyvalue", modelId);
        IDNumberTreeNode node = nodes.get(cusPropId);
        if (node == null) {
            return false;
        }
        Set<Long> propIds = TreeStructureServiceHelper.getIds(node.getAllChildren());
        if (propIds.isEmpty()) {
            return false;
        }
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray()), new QFilter("id", "in", mId)});
    }

    public static List<SimpleItem> getChildByCustom(String mEntityNum, Object cusPropId, String cusPropLongNum, boolean isIncludeSelf, long schemeId) {
        DynamicObject cusPropDyna;
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        ArrayList<Object> propIds = new ArrayList<Object>();
        if (isIncludeSelf) {
            propIds.add(cusPropId);
        }
        if ((cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)})) == null) {
            return s;
        }
        String dimId = cusPropDyna.getString("dimension");
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(cusPropLongNum + '!' + "%")), new QFilter("dimension", "=", (Object)ConvertUtil.convertStrToLong(dimId))});
        children.forEach(e -> propIds.add(e.get("id")));
        if (!propIds.isEmpty()) {
            QFilter filter = new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray());
            if ("bcm_entitymembertree".equals(mEntityNum) && schemeId != 0L) {
                filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
            }
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])filter.toArray());
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static boolean isBrother(String entityNum, Object id, Object pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        IDNumberTreeNode node = nodes.get(id);
        if (node != null) {
            return TreeStructureServiceHelper.getIds(node.getBrother()).contains(pId);
        }
        return false;
    }

    public static List<SimpleItem> getBrother(String entityNum, Long pId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        IDNumberTreeNode node = nodes.get(pId);
        if (node != null) {
            node.getBrother().forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
        }
        return s;
    }

    public static List<SimpleItem> getChildByAssign(String entityNum, Long pId, Object modelId, boolean isOnlyLeaf) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode(entityNum, modelId);
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        IDNumberTreeNode node = nodes.get(pId);
        if (node != null) {
            node.getAllChildren(isOnlyLeaf ? 2 : 1).forEach(e -> s.add(SimpleItem.newOne(e.getId(), e.getNumber())));
            if (node.getAllChildren().size() > 0) {
                if (!isOnlyLeaf) {
                    s.add(SimpleItem.newOne(node.getId(), node.getNumber()));
                }
            } else if (isOnlyLeaf) {
                s.add(SimpleItem.newOne(node.getId(), node.getNumber()));
            }
        }
        return s;
    }

    public static List<SimpleItem> getAssignChildByCustom(String mEntityNum, Object cusPropId, String cusPropLongNum, boolean isOnlyLeaf, long schemeId) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        ArrayList propIds = new ArrayList();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn,dimension", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        if (cusPropDyna == null) {
            return s;
        }
        long dimId = cusPropDyna.getLong("dimension");
        DynamicObjectCollection children = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(cusPropLongNum + '!' + "%")).or("longnumber", "=", (Object)cusPropLongNum), new QFilter("dimension", "=", (Object)dimId)});
        children.forEach(e -> propIds.add(e.get("id")));
        if (!propIds.isEmpty()) {
            QFilter filter = new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray());
            filter.and(new QFilter("isleaf", "=", (Object)isOnlyLeaf));
            if ("bcm_entitymembertree".equals(mEntityNum) && schemeId != 0L) {
                filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
            }
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])filter.toArray());
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static List<SimpleItem> getBrotherByCustom(String mEntityNum, Object cusPropId, boolean isIncludeSelf, long schemeId) {
        ArrayList<SimpleItem> s = new ArrayList<SimpleItem>();
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        if (cusPropDyna == null) {
            return s;
        }
        DynamicObjectCollection brothers = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id", (QFilter[])new QFilter[]{new QFilter("parentid", "=", cusPropDyna.get("parentid"))});
        ArrayList propIds = new ArrayList();
        brothers.forEach(e -> propIds.add(e.get("id")));
        if (!isIncludeSelf) {
            propIds.remove(cusPropId);
        }
        if (!propIds.isEmpty()) {
            QFilter filter = new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)propIds.toArray());
            if ("bcm_entitymembertree".equals(mEntityNum) && schemeId != 0L) {
                filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
            }
            DynamicObjectCollection result = QueryServiceHelper.query((String)mEntityNum, (String)"id,number", (QFilter[])filter.toArray());
            result.forEach(e -> s.add(SimpleItem.newOne(e.get("id"), e.getString("number"))));
        }
        return s;
    }

    public static boolean isSelfByCustom(String mEntityNum, Object mId, Object cusPropId) {
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        return cusPropDyna != null && QueryServiceHelper.exists((String)mEntityNum, (QFilter[])new QFilter[]{new QFilter(cusPropDyna.getString("propertyid.propertyn"), "=", cusPropId), new QFilter("id", "=", mId)});
    }

    public static List<SimpleItem> getSelfByCustom(Object modelId, String entityName, Object cusPropId, long schemeId) {
        if (SystemVarsEnum.PR_NONE.getId().equals(cusPropId != null ? cusPropId.toString() : "0") && LongUtil.toLong((Object)modelId) != 0L) {
            return TreeStructureServiceHelper.getNonePropertyMembers(LongUtil.toLong((Object)modelId), entityName, schemeId);
        }
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        String key = modelNum + "|" + entityName + "|" + cusPropId + "|" + schemeId;
        return (List)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)key, () -> {
            ArrayList<SimpleItem> items = new ArrayList<SimpleItem>(16);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getSelfByCustom", (String)"bcm_definedpropertyvalue", (String)"propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)}, null, (int)1);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    QFilter filter = new QFilter(row.getString("propertyid.propertyn"), "=", cusPropId);
                    if ("bcm_entitymembertree".equals(entityName) && schemeId != 0L) {
                        filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
                    }
                    if (LongUtil.toLong((Object)modelId) != 0L) {
                        filter.and(new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId)));
                    }
                    DynamicObjectCollection result = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])filter.toArray());
                    for (DynamicObject e : result) {
                        items.add(SimpleItem.newOne(e.get("id"), e.getString("number")));
                    }
                }
            }
            return items;
        });
    }

    public static List<SimpleItem> getNonePropertyMembers(long modelId, String entityName, long schemeId) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        return (List)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)(modelNum + "|" + entityName + "|" + schemeId), () -> {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            if ("bcm_entitymembertree".equals(entityName) && schemeId != 0L) {
                filter.and(new QFilter("cslscheme", "=", (Object)schemeId));
            }
            filter.and("dpropertyid1", "=", (Object)0).and("dpropertyid2", "=", (Object)0).and("dpropertyid3", "=", (Object)0).and("dpropertyid4", "=", (Object)0).and("dpropertyid5", "=", (Object)0).and("dpropertyid6", "=", (Object)0).and("dpropertyid7", "=", (Object)0).and("dpropertyid8", "=", (Object)0).and("dpropertyid9", "=", (Object)0).and("dpropertyid10", "=", (Object)0);
            ArrayList items = new ArrayList(16);
            QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])filter.toArray()).forEach(d -> items.add(SimpleItem.newOne(d.getLong("id"), d.getString("number"))));
            return items;
        });
    }

    public static String getLongNumber(String entityNum, String number, Object modelId) {
        DynamicObject baseMember = MemberServiceHelper.getBaseMember(entityNum, "longnumber", new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", modelId)));
        if (baseMember == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458", (String)"TreeStructureServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), number));
        }
        return baseMember.getString("longnumber");
    }

    public static String getLongNumber(String entityNum, Long id) {
        DynamicObject baseMember = MemberServiceHelper.queryMemberFromCache(entityNum, "longnumber", id);
        if (baseMember == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458", (String)"TreeStructureServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), id));
        }
        return baseMember.getString("longnumber");
    }

    public static boolean isLeafMembNode(String entityNum, String number, Object modelId) {
        DynamicObject baseMember = MemberServiceHelper.getBaseMember(entityNum, "isleaf", new QFilter("number", "=", (Object)number).and(new QFilter("model", "=", modelId)));
        if (baseMember == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%2$s\u7684\u6210\u5458", (String)"TreeStructureServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), DimEntityNumEnum.getNumberByEntieyNum((String)entityNum), number));
        }
        return baseMember.getBoolean("isleaf");
    }

    public static Map<Long, IDNumberTreeNode> getAllNode(String entityname, Object modelid) {
        return MemberReader.getAllNodeFromCache((String)entityname, (Object)modelid);
    }

    public static Map<Long, MemberTreeNode> getAllMember(String entityname, Object modelid, Pair<Supplier<String>, Function<DynamicObject, Map<String, Object>>> function) {
        MemberTreeNode node;
        QFilter rfilter;
        String key = "membertree|" + entityname + "|" + modelid + "|" + (String)((Supplier)function.p1).get();
        HashMap<Long, MemberTreeNode> nodes = (HashMap<Long, MemberTreeNode>)ThreadCache.get((Object)key);
        if (nodes != null) {
            return nodes;
        }
        QFilter qf = null;
        boolean isCust = "bcm_definedpropertyvalue".equals(entityname);
        if (!isCust) {
            qf = new QFilter("model.id", "=", modelid);
        }
        if ("bcm_entitymembertree".equals(entityname)) {
            rfilter = new QFilter("isexchangerate", "=", (Object)"0");
            qf = qf == null ? rfilter : qf.and(rfilter);
        } else if ("bcm_eb_versionmembertree".equals(entityname)) {
            rfilter = new QFilter("isactual", "!=", (Object)"1");
            qf = qf == null ? rfilter : qf.and(rfilter);
        }
        String parent = isCust ? "parentid" : "parent";
        Map dcs = BusinessDataServiceHelper.loadFromCache((String)entityname, (String)((String)((Supplier)function.p1).get() + "id, number, name, copyfrom.id, " + parent), (QFilter[])(qf == null ? null : qf.toArray()), null);
        nodes = new HashMap<Long, MemberTreeNode>(16);
        for (Map.Entry entry : dcs.entrySet()) {
            node = new MemberTreeNode(((DynamicObject)entry.getValue()).getLong("id"), ((DynamicObject)entry.getValue()).getString("number"), ((DynamicObject)entry.getValue()).getString("name"), ((DynamicObject)entry.getValue()).getLong("copyfrom.id"));
            node.setData((Map)((Function)function.p2).apply(entry.getValue()));
            nodes.put((Long)entry.getKey(), node);
        }
        for (DynamicObject obj : dcs.values()) {
            node = (MemberTreeNode)nodes.get(obj.getLong("id"));
            MemberTreeNode pNode = (MemberTreeNode)nodes.get(obj.getLong(parent + "_id"));
            if (pNode == null) continue;
            node.setParent(pNode);
            pNode.addChild(node);
        }
        ThreadCache.put((Object)key, nodes);
        return nodes;
    }

    public static Map<Long, MemberTreeNode> getOrgInYearAndPeriod(Long modelid, Long schemeId, Long sceneId, Long yearId, Long periodId, Pair<Supplier<String>, Function<DynamicObject, Map<String, Object>>> function) {
        MemberTreeNode node;
        HashMap<Long, MemberTreeNode> nodes = new HashMap<Long, MemberTreeNode>();
        QFilter qf = new QFilter("model.id", "=", (Object)modelid);
        qf.and("isexchangerate", "=", (Object)"0");
        if (schemeId != null && schemeId != 0L) {
            qf.and("cslscheme", "=", (Object)schemeId);
        }
        qf.and("status", "!=", (Object)"A");
        DynamicObjectCollection allOrg = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)((String)((Supplier)function.p1).get() + "id, number, name, copyfrom.id, parent"), (QFilter[])qf.toArray(), (String)"level,dseq");
        String fynu = MemberReader.findMemberById((long)modelid, (String)DimEntityNumEnum.YEAR.getEntityNum(), (Long)yearId).getNumber();
        FilterOrgStructParam param = new FilterOrgStructParam((long)modelid, (long)sceneId, fynu, (long)periodId);
        EntityVersioningUtil.filterOrgsByMergeStruct(param, (List<DynamicObject>)allOrg);
        for (DynamicObject org : allOrg) {
            node = new MemberTreeNode(org.getLong("id"), org.getString("number"), org.getString("name"), org.getLong("copyfrom.id"));
            node.setData((Map)((Function)function.p2).apply(org));
            nodes.put(org.getLong("id"), node);
        }
        for (DynamicObject org : allOrg) {
            node = (MemberTreeNode)nodes.get(org.getLong("id"));
            MemberTreeNode pNode = (MemberTreeNode)nodes.get(org.getLong("parent"));
            if (pNode == null) continue;
            node.setParent(pNode);
            pNode.addChild(node);
        }
        return nodes;
    }

    public static Set<Long> getIds(List<IDNumberTreeNode> nodes) {
        HashSet<Long> ids = new HashSet<Long>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public static Set<String> getNumbers(List<IDNumberTreeNode> nodes) {
        HashSet<String> numbers = new HashSet<String>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                numbers.add(node.getNumber());
            }
        }
        return numbers;
    }

    public static Set<Long> getStorageIds(List<IDNumberTreeNode> nodes) {
        HashSet<Long> ids = new HashSet<Long>();
        if (nodes != null) {
            for (IDNumberTreeNode node : nodes) {
                if (node.getCopyfromId() != 0L) {
                    ids.add(node.getCopyfromId());
                    continue;
                }
                ids.add(node.getId());
            }
        }
        return ids;
    }

    public static QFilter getFilterByCustomScope(RangeEnum range, Object cusPropId, Object modelId) {
        Map<Long, IDNumberTreeNode> nodes = TreeStructureServiceHelper.getAllNode("bcm_definedpropertyvalue", modelId);
        DynamicObject cusPropDyna = QueryServiceHelper.queryOne((String)"bcm_definedpropertyvalue", (String)"parentid,propertyid.propertyn", (QFilter[])new QFilter[]{new QFilter("id", "=", cusPropId)});
        HashSet<Object> ids = new HashSet<Object>();
        IDNumberTreeNode node = nodes.get(cusPropId);
        switch (range) {
            case VALUE_10: {
                ids.add(cusPropId);
                break;
            }
            case VALUE_20: {
                if (node == null) break;
                ids.addAll(node.getChildrenIds());
                break;
            }
            case VALUE_30: {
                if (node != null) {
                    ids.addAll(node.getChildrenIds());
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_40: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(0), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_50: {
                if (node != null) {
                    ids.addAll(Lists.transform((List)node.getAllChildren(0), IDNumberTreeNode::getId));
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_60: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getBrother(), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_70: {
                if (node != null) {
                    ids.addAll(Lists.transform((List)node.getBrother(), IDNumberTreeNode::getId));
                }
                ids.add(cusPropId);
                break;
            }
            case VALUE_90: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(2), IDNumberTreeNode::getId));
                break;
            }
            case VALUE_110: {
                if (node == null) break;
                ids.addAll(Lists.transform((List)node.getAllChildren(1), IDNumberTreeNode::getId));
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u8303\u56f4\u679a\u4e3e{%s}", (String)"TreeStructureServiceHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), range));
            }
        }
        QFilter qf = ids.isEmpty() || cusPropDyna == null ? new QFilter("1", "=", (Object)2) : new QFilter(cusPropDyna.getString("propertyid.propertyn"), "in", (Object)ids.toArray());
        return qf;
    }

    public static long getEntityBaseMemberId(long id) {
        return (Long)ThreadCache.get((Object)("base_" + id), () -> {
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bcm_entitymembertree", (String)"id,storagetype,copyfrom");
            if (dyna == null) {
                return 0L;
            }
            return dyna.getInt("storagetype") == 3 ? dyna.getLong("copyfrom_id") : dyna.getLong("id");
        });
    }

    public static Map<Long, Long> getEntityBaseMemberIds(Collection<Long> ids) {
        return (Map)ThreadCache.get((Object)("base_" + ids), () -> {
            HashMap map = new HashMap();
            BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,storagetype,copyfrom", (QFilter[])new QFilter("id", "in", (Object)ids).toArray()).values().stream().filter(dyna -> dyna != null).forEach(dyna -> map.put(dyna.getLong("id"), dyna.getInt("storagetype") == 3 ? dyna.getLong("copyfrom_id") : dyna.getLong("id")));
            return map;
        });
    }

    public static Map<String, Long> getEntityBaseMemberNumbers(Collection<Long> ids) {
        return (Map)ThreadCache.get((Object)("base_num2baseid" + ids), () -> {
            HashMap map = new HashMap();
            BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number,storagetype,copyfrom", (QFilter[])new QFilter("id", "in", (Object)ids).toArray()).values().forEach(dyna -> map.put(dyna.getString("number"), dyna.getInt("storagetype") == 3 ? dyna.getLong("copyfrom_id") : dyna.getLong("id")));
            return map;
        });
    }

    public static Map<Long, String> getEntityBaseMemberid2Numbers(Collection<Long> ids) {
        return (Map)ThreadCache.get((Object)("base_id2num" + ids), () -> {
            HashMap map = new HashMap();
            BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter("id", "in", (Object)ids).toArray()).values().forEach(dyna -> map.put(dyna.getLong("id"), dyna.getString("number")));
            return map;
        });
    }

    public static long getParentId(String entity, String entityid) {
        String selectFields = "parent";
        QFilter filter = new QFilter("id", "=", (Object)ConvertUtil.convertObjToLong(entityid));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getLong("parent");
        }
        return 0L;
    }

    public static String getParentOrgBaseNumber(String modelNum, String currentOrgNum) {
        IDNumberTreeNode orgMember = MemberReader.findEntityMemberByNum((String)modelNum, (String)currentOrgNum);
        IDNumberTreeNode parent = orgMember.getParent();
        String parentOrgBaseNum = parent.getNumber();
        if (StorageTypeEnum.STORAGE != parent.getStorageType()) {
            Map<Long, String> baseId2Number = TreeStructureServiceHelper.getEntityBaseMemberid2Numbers(Collections.singletonList(parent.getId()));
            parentOrgBaseNum = baseId2Number.get(parent.getId());
        }
        return parentOrgBaseNum;
    }

    public static Map<String, IDNumberTreeNode> initParentOrgs(IDNumberTreeNode orgNode, String mergeNum, Map<String, IDNumberTreeNode> num2NodeMap) {
        if (orgNode == null || IDNumberTreeNode.NotFoundTreeNode == orgNode || orgNode.getNumber().equals("Entity") || orgNode.getNumber().equals(mergeNum)) {
            return num2NodeMap;
        }
        num2NodeMap.put(orgNode.getNumber(), orgNode);
        TreeStructureServiceHelper.initParentOrgs(orgNode.getParent(), mergeNum, num2NodeMap);
        return num2NodeMap;
    }
}

