/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UpgradeServiceHelper {
    public static final String USER = "user";
    public static final String ENTRYENTITY = "entryentity";
    private static final String FID = "fid";
    private static final String FSEQ = "fseq";
    private static final String FCONTROLMODE = "fcontrolmode";
    private static final String FPERMITEMID = "fpermitemid";
    private static final String FENTITYTYPEID = "fentitytypeid";
    private static final String FBIZAPPID = "fbizappid";
    private static final String FSOURCE = "fsource";
    private static final String FBIZROLEID = "fbizroleid";
    private static final String FUSERID = "fuserid";
    private static final String FDIMTYPE = "fdimtype";
    private static final String FDIMID = "fdimid";
    private static final String FISINCLUDESUB = "fisincludesub";
    private static final String FROLEID = "froleid";
    private static final String FINHERITMODE = "finheritmode";
    private static final String FORGID = "forgid";
    private static final String FENTRYID = "fentryid";
    private static final String FUSERGROUPID = "fusergroupid";
    private static final String T_BCM_UPGRADE_RECORD = "t_bcm_upgraderecord";
    private static final String F_UPGRADE_TYPE = "fupgradetype";
    private static final String F_UPGRADE_TIME = "fupgradetime";
    private static final String F_UPGRADE_NAME = "fupgradename";
    private static final String F_UPGRADE_CLASS = "fupgradeclass";
    private static final String BCM_UPGRADE_SERVICE_IS_EXIST_TABLE_AND_FIELD = "BcmUpgradeService#isExistTableAndField";
    private static final String CMAPPID = "11H66HLOX4IC";
    private static final String RPTAPPID = "L/B5N23NCFS";
    private static final String QUOTER = "'";
    private static final int DFTCOLNUM = 16;
    private static final long DFTID = 0L;
    private static final int BATCH2COUNT = 2000;

    public static void upgradeBizTypeBD008A009(long modelId) {
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format("update t_bcm_invchangetype set fchange = '1' where fmodelid = %s and fnumber = 'BD008' ", modelId));
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)String.format("update t_bcm_invchangetype set fchange = '3' where fmodelid = %s and fnumber = 'BD009' ", modelId));
    }

    public static void upgradeOrgScheme(long modelid, IFormView view, String callbackClassName) {
        DynamicObject[] orgs = UpgradeServiceHelper.getOrgLevel2List(modelid);
        if (orgs.length == 1) {
            UpgradeServiceHelper.upgradeCslScheme(modelid, "1");
            UpgradeServiceHelper.showUpgradeInfo(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f", (String)"UpgradeServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), view);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("modelId", (Object)modelid);
            showParameter.setFormId("bcm_upgradeorgview");
            if (callbackClassName != null) {
                showParameter.setCloseCallBack(new CloseCallBack(callbackClassName, "upgradeorgschemecallback"));
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
    }

    public static void showUpgradeInfo(String info, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("operationInfo", (Object)info);
        showParameter.setFormId("bcm_upgradeorgviewinfo");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void upgradeCslScheme(long modelid, String selectInfo) {
        boolean isFalse = false;
        try (TXHandle tx = TX.required();){
            try {
                long parentId = UpgradeServiceHelper.createRoot(modelid);
                Map<String, Long> schemeMap = UpgradeServiceHelper.createSchemes(modelid, parentId, selectInfo);
                QFilter filter = new QFilter("model", "=", (Object)modelid);
                QFilter filter1 = new QFilter("isexchangerate", "=", (Object)isFalse);
                DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"number,longnumber,level,cslscheme", (QFilter[])new QFilter[]{filter, filter1}, (String)"level");
                for (Map.Entry<String, Long> entry : schemeMap.entrySet()) {
                    for (DynamicObject dot : collection) {
                        if (!entry.getKey().equalsIgnoreCase(dot.getString("longnumber")) && !dot.getString("longnumber").startsWith(entry.getKey() + "!")) continue;
                        dot.set("cslscheme", (Object)entry.getValue());
                    }
                }
                SaveServiceHelper.save((DynamicObject[])collection);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    public static long createRoot(long modelid) {
        CslSchemeEnum root = CslSchemeEnum.Root;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
        obj.set("number", (Object)root.getNumber());
        obj.set("name", (Object)root.getName());
        obj.set("model", (Object)modelid);
        obj.set("isleaf", (Object)root.isLeaf());
        obj.set("isenable", (Object)root.isIsenable());
        obj.set("nodetype", (Object)root.getNodetype());
        obj.set("level", (Object)root.getLevel());
        obj.set("longnumber", (Object)root.getLongnumber());
        obj.set("parent", (Object)0);
        DynamicObject[] parent = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        return parent[0].getLong("id");
    }

    private static Map<String, Long> createSchemes(long modelid, long parentId, String selectInfo) {
        DynamicObject[] orgs = UpgradeServiceHelper.getOrgLevel2List(modelid);
        HashMap<String, Long> results = new HashMap<String, Long>();
        ArrayList<DynamicObject> schemes = new ArrayList<DynamicObject>();
        if (orgs.length == 0) {
            Long id = DBServiceHelper.genGlobalLongId();
            DynamicObject temp = UpgradeServiceHelper.buildSingleScheme(modelid, parentId, id, "DefaultScheme");
            schemes.add(temp);
        } else if ("1".equals(selectInfo)) {
            for (DynamicObject dot : orgs) {
                Long id = DBServiceHelper.genGlobalLongId();
                DynamicObject temp = UpgradeServiceHelper.buildSingleScheme(modelid, parentId, id, dot.getString("number"));
                schemes.add(temp);
                results.put(dot.getString("longnumber"), id);
            }
        } else {
            UpgradeServiceHelper.buildEntityTotalScheme(modelid, parentId, orgs[0], results, schemes);
        }
        SaveServiceHelper.save((DynamicObject[])schemes.toArray(new DynamicObject[0]));
        return results;
    }

    public static DynamicObject[] getOrgLevel2List(long modelid) {
        boolean isFalse = false;
        QFilter filter = new QFilter("model", "=", (Object)modelid);
        filter.and("isexchangerate", "=", (Object)isFalse);
        filter.and("level", "=", (Object)2);
        return BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"number,longnumber,level,cslscheme,parent.id,currency.id", (QFilter[])new QFilter[]{filter});
    }

    private static void buildEntityTotalScheme(long modelid, long parentId, DynamicObject org, Map<String, Long> results, List<DynamicObject> schemes) {
        DynamicObject[] allOrgList;
        boolean isFalse = false;
        String number = "EntityTotal";
        Long id = DBServiceHelper.genGlobalLongId();
        DynamicObject temp = UpgradeServiceHelper.buildSingleScheme(modelid, parentId, id, number);
        schemes.add(temp);
        DynamicObject memberOrg = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymember");
        Long memberId = DBServiceHelper.genGlobalLongId();
        String name = ResManager.loadKDString((String)"\u7ec4\u7ec7\u6c47\u603b", (String)"UpgradeServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        memberOrg.set("id", (Object)memberId);
        memberOrg.set("number", (Object)number);
        memberOrg.set("name", (Object)name);
        memberOrg.set("model", (Object)modelid);
        DimensionServiceHelper.initDimensionDyObject(memberOrg);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberOrg});
        String longNumber = "Entity!" + number;
        DynamicObject entityTotalOrg = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
        Long orgId = DBServiceHelper.genGlobalLongId();
        DimensionServiceHelper.initDimensionDyObject(entityTotalOrg);
        entityTotalOrg.set("id", (Object)orgId);
        entityTotalOrg.set("number", (Object)number);
        entityTotalOrg.set("name", (Object)name);
        entityTotalOrg.set("model", (Object)modelid);
        entityTotalOrg.set("isleaf", (Object)isFalse);
        entityTotalOrg.set("storagetype", (Object)2);
        entityTotalOrg.set("level", (Object)2);
        entityTotalOrg.set("longnumber", (Object)longNumber);
        entityTotalOrg.set("aggoprt", (Object)5);
        entityTotalOrg.set("isindependentorg", (Object)1);
        entityTotalOrg.set("isinnerorg", (Object)1);
        entityTotalOrg.set("member", (Object)memberId);
        entityTotalOrg.set("parent", (Object)org.getString("parent.id"));
        entityTotalOrg.set("currency", (Object)org.getLong("currency.id"));
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        qFilter.and("number", "=", (Object)"Entity");
        DynamicObject col = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
        entityTotalOrg.set("dimension", (Object)col.getLong("id"));
        Date now = new Date();
        String userId = RequestContext.get().getUserId();
        Date beginDate = EntityVersioningUtil.getModelBeginDate(modelid);
        DynamicObjectCollection bizRecords = entityTotalOrg.getDynamicObjectCollection("bizchangerds");
        DynamicObject bizRecord = new DynamicObject(bizRecords.getDynamicObjectType());
        bizRecord.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
        bizRecord.set("bizeffdate", (Object)beginDate);
        bizRecord.set("bizmodifier", (Object)userId);
        bizRecord.set("bizmodifytime", (Object)now);
        bizRecord.set("seq", (Object)1);
        bizRecords.add((Object)bizRecord);
        DynamicObjectCollection nameRecords = entityTotalOrg.getDynamicObjectCollection("namechangerds");
        DynamicObject nameRecord = new DynamicObject(nameRecords.getDynamicObjectType());
        nameRecord.set("namerds", (Object)name);
        nameRecord.set("simplenamerds", (Object)name);
        nameRecord.set("nameeffdate", (Object)beginDate);
        nameRecord.set("namemodifier", (Object)userId);
        nameRecord.set("namemodifytime", (Object)now);
        nameRecord.set("seq", (Object)1);
        nameRecords.add((Object)nameRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entityTotalOrg});
        QFilter modelFilter = new QFilter("id", "=", (Object)modelid);
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number,name", (QFilter[])new QFilter[]{modelFilter});
        OlapServiceHelper.createMember(model.getString("number"), DimTypesEnum.ENTITY.getNumber(), number, 5, DimTypesEnum.ENTITY.getNumber());
        ArrayList<String> deriveNumbers = new ArrayList<String>();
        deriveNumbers.add("Entity_EntityTotal");
        QFilter filter2 = new QFilter("model", "=", (Object)modelid);
        filter2.and("isexchangerate", "=", (Object)isFalse);
        filter2.and("level", ">", (Object)1);
        filter2.and("id", "!=", (Object)orgId);
        for (DynamicObject subOrg : allOrgList = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,number,longnumber,level,parent", (QFilter[])new QFilter[]{filter2})) {
            if (subOrg.getInt("level") == 2) {
                subOrg.set("parent", (Object)orgId);
                deriveNumbers.add("EntityTotal_" + subOrg.getString("number"));
            }
            subOrg.set("level", (Object)(subOrg.getInt("level") + 1));
            subOrg.set("longnumber", (Object)(longNumber + subOrg.getString("longnumber").substring(6)));
        }
        SaveServiceHelper.save((DynamicObject[])allOrgList);
        OlapServiceHelper.batchCreateDimensionMembers(model.getString("number"), DimTypesEnum.ENTITY.getNumber(), deriveNumbers.toArray(new String[0]));
        results.put(longNumber, id);
    }

    public static DynamicObject buildSingleScheme(long modelid, long parentId, Long id, String number) {
        boolean isTrue = true;
        DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
        temp.set("id", (Object)id);
        temp.set("number", (Object)number);
        temp.set("name", (Object)String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c6\u56fe%s", (String)"UpgradeServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), number));
        temp.set("model", (Object)modelid);
        temp.set("isleaf", (Object)isTrue);
        temp.set("isenable", (Object)isTrue);
        temp.set("nodetype", (Object)1);
        temp.set("level", (Object)1);
        temp.set("longnumber", (Object)(CslSchemeEnum.Root.getLongnumber() + "." + number));
        temp.set("parent", (Object)parentId);
        temp.set("islegalorgview", (Object)isTrue);
        String userId = RequestContext.get().getUserId();
        Date now = new Date();
        temp.set("creater", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("createdate", (Object)now);
        temp.set("modifytime", (Object)now);
        return temp;
    }

    public static void doUpgrade(WatchLogger log, String newPermItem, String newPageNum, String oldPermItem, String oldPageNum) {
        try (TXHandle tx = TX.required();){
            try {
                UpgradeServiceHelper.upgradeUser(newPermItem, newPageNum, oldPermItem, oldPageNum, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
                UpgradeServiceHelper.upgradeRole(newPermItem, newPageNum, oldPermItem, oldPageNum, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                tx.markRollback();
                log.error(String.format("UpgradeServiceHelper - upgrade: %s", e.getMessage()));
            }
        }
    }

    public static void upgradeUser(final String newPermItem, final String newPageNum, String oldPermItem, String oldPageNum, Boolean CMandRPT, Boolean isCM, Boolean isRPT) {
        List userItemList;
        StringBuilder selectSql = new StringBuilder();
        StringBuilder existSql = new StringBuilder();
        existSql.append("SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_userpermdetail' AND KSQL_COL_NAME IN ('fuserid')");
        final Boolean isNewPlatform = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql.toString(), (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        if (isNewPlatform.booleanValue()) {
            selectSql.append("select DISTINCT fid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid,fuserid,fdimtype,fdimid,fisincludesub from t_perm_userpermdetail where fentitytypeid = ? and fpermitemid = ?");
        } else {
            selectSql.append("select DISTINCT fid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail where fentitytypeid = ? and fpermitemid = ?");
        }
        if (!CMandRPT.booleanValue()) {
            if (isCM.booleanValue()) {
                selectSql.append("and fbizappid = '11H66HLOX4IC'");
            }
            if (isRPT.booleanValue()) {
                selectSql.append("and fbizappid = 'L/B5N23NCFS'");
            }
        }
        if ((userItemList = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (Object[])new Object[]{oldPageNum, oldPermItem}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(100);
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(10);
                    String fId = rs.getString(UpgradeServiceHelper.FID) == null ? "" : rs.getString(UpgradeServiceHelper.FID);
                    map.put(UpgradeServiceHelper.FID, fId);
                    Integer fSeq = rs.getInt(UpgradeServiceHelper.FSEQ);
                    map.put(UpgradeServiceHelper.FSEQ, fSeq);
                    String fControlMode = rs.getString(UpgradeServiceHelper.FCONTROLMODE) == null ? "" : rs.getString(UpgradeServiceHelper.FCONTROLMODE);
                    map.put(UpgradeServiceHelper.FCONTROLMODE, fControlMode);
                    String fPermitemId = rs.getString(UpgradeServiceHelper.FPERMITEMID) == null ? "" : rs.getString(UpgradeServiceHelper.FPERMITEMID);
                    map.put(UpgradeServiceHelper.FPERMITEMID, fPermitemId);
                    String fEntityTypeId = rs.getString(UpgradeServiceHelper.FENTITYTYPEID) == null ? "" : rs.getString(UpgradeServiceHelper.FENTITYTYPEID);
                    map.put(UpgradeServiceHelper.FENTITYTYPEID, fEntityTypeId);
                    String fBizAppId = rs.getString(UpgradeServiceHelper.FBIZAPPID) == null ? "" : rs.getString(UpgradeServiceHelper.FBIZAPPID);
                    map.put(UpgradeServiceHelper.FBIZAPPID, fBizAppId);
                    String fSource = rs.getString(UpgradeServiceHelper.FSOURCE) == null ? "" : rs.getString(UpgradeServiceHelper.FSOURCE);
                    map.put(UpgradeServiceHelper.FSOURCE, fSource);
                    Integer fBizRoleId = rs.getInt(UpgradeServiceHelper.FBIZROLEID);
                    map.put(UpgradeServiceHelper.FBIZROLEID, fBizRoleId);
                    if (isNewPlatform.booleanValue()) {
                        Long fuserid = rs.getLong(UpgradeServiceHelper.FUSERID);
                        map.put(UpgradeServiceHelper.FUSERID, fuserid);
                        String fdimtype = rs.getString(UpgradeServiceHelper.FDIMTYPE);
                        map.put(UpgradeServiceHelper.FDIMTYPE, fdimtype);
                        Long fdimid = rs.getLong(UpgradeServiceHelper.FDIMID);
                        map.put(UpgradeServiceHelper.FDIMID, fdimid);
                        Integer fisincludesub = rs.getInt(UpgradeServiceHelper.FISINCLUDESUB);
                        map.put(UpgradeServiceHelper.FISINCLUDESUB, fisincludesub);
                    }
                    list.add(map);
                    if (list.size() != 2000) continue;
                    ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
                    newList.addAll(list);
                    list.clear();
                    ThreadPoolService.upgradeServiceThread(() -> UpgradeServiceHelper.saveFunPerm(newPermItem, newPageNum, isNewPlatform, newList));
                }
                return list;
            }
        })).size() > 0) {
            UpgradeServiceHelper.saveFunPerm(newPermItem, newPageNum, isNewPlatform, userItemList);
        }
    }

    private static void saveFunPerm(String newPermItem, String newPageNum, Boolean isNewPlatform, List<Map<String, Object>> userItemList) {
        String[] genGlobalLongIds = GlobalIdUtil.genStringIds((int)userItemList.size());
        ArrayList<Object[]> paramsUserList = new ArrayList<Object[]>(userItemList.size());
        for (int i = 0; i < userItemList.size(); ++i) {
            Object[] params;
            Map<String, Object> map = userItemList.get(i);
            String fId = (String)map.get(FID);
            String controlMode = (String)map.get(FCONTROLMODE);
            String appId = (String)map.get(FBIZAPPID);
            String source = (String)map.get(FSOURCE);
            Integer seq = (Integer)map.get(FSEQ);
            Integer fBizRoleId = (Integer)map.get(FBIZROLEID);
            Long fdimId = 0L;
            String fdimType = "";
            Integer fisincludesub = 0;
            if (isNewPlatform.booleanValue()) {
                Long fuserId = (Long)map.get(FUSERID);
                fdimType = (String)map.get(FDIMTYPE);
                fdimId = (Long)map.get(FDIMID);
                fisincludesub = (Integer)map.get(FISINCLUDESUB);
                params = new Object[13];
                params[0] = fId;
                if (genGlobalLongIds != null) {
                    params[1] = genGlobalLongIds[i];
                }
                params[2] = seq;
                params[3] = controlMode;
                params[4] = newPermItem;
                params[5] = newPageNum;
                params[6] = appId;
                params[7] = source;
                params[8] = fBizRoleId;
                params[9] = fuserId;
                params[10] = fdimType;
                params[11] = fdimId;
                params[12] = fisincludesub;
                paramsUserList.add(params);
                continue;
            }
            params = new Object[9];
            params[0] = fId;
            if (genGlobalLongIds != null) {
                params[1] = genGlobalLongIds[i];
            }
            params[2] = seq;
            params[3] = controlMode;
            params[4] = newPermItem;
            params[5] = newPageNum;
            params[6] = appId;
            params[7] = source;
            params[8] = fBizRoleId;
            paramsUserList.add(params);
        }
        if (!CollectionUtils.isEmpty(paramsUserList)) {
            String insertUserpermdetail = "";
            insertUserpermdetail = isNewPlatform != false ? "insert into t_perm_userpermdetail(fid,fentryid,fseq, fcontrolmode,fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid,fuserid,fdimtype,fdimid,fisincludesub) values (?,?,?,?,?,?,?,?,?,?,?,?,?)" : "insert into t_perm_userpermdetail(fid,fentryid,fseq, fcontrolmode,fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid) values (?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertUserpermdetail, paramsUserList);
        }
    }

    public static void upgradeRole(final String newPermItem, final String newPageNum, String oldPermItem, String oldPageNum, Boolean CMandRPT, Boolean isCM, Boolean isRPT) {
        List roleItemList;
        StringBuilder existSql = new StringBuilder();
        existSql.append("SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_rolepermdetial' AND KSQL_COL_NAME IN ('froleid')");
        final Boolean isNewPlatform = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql.toString(), (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                return rs.next();
            }
        });
        StringBuilder selectSql = new StringBuilder();
        if (isNewPlatform.booleanValue()) {
            selectSql.append("select DISTINCT fid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial where fentitytypeid = ? and fpermitemid = ?");
        } else {
            selectSql.append("select DISTINCT fid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid from t_perm_rolepermdetial where fentitytypeid = ? and fpermitemid = ?");
        }
        if (!CMandRPT.booleanValue()) {
            if (isCM.booleanValue()) {
                selectSql.append("and fbizappid = '11H66HLOX4IC'");
            }
            if (isRPT.booleanValue()) {
                selectSql.append("and fbizappid = 'L/B5N23NCFS'");
            }
        }
        if ((roleItemList = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (Object[])new Object[]{oldPageNum, oldPermItem}, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashSet<String> checkRoleSet = new HashSet<String>(16);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(100);
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String fId = rs.getString(UpgradeServiceHelper.FID) == null ? "" : rs.getString(UpgradeServiceHelper.FID);
                    map.put(UpgradeServiceHelper.FID, fId);
                    Integer fSeq = rs.getInt(UpgradeServiceHelper.FSEQ);
                    map.put(UpgradeServiceHelper.FSEQ, fSeq);
                    String fControlMode = rs.getString(UpgradeServiceHelper.FCONTROLMODE) == null ? "" : rs.getString(UpgradeServiceHelper.FCONTROLMODE);
                    map.put(UpgradeServiceHelper.FCONTROLMODE, fControlMode);
                    String fPermItemId = rs.getString(UpgradeServiceHelper.FPERMITEMID) == null ? "" : rs.getString(UpgradeServiceHelper.FPERMITEMID);
                    map.put(UpgradeServiceHelper.FPERMITEMID, fPermItemId);
                    String fEntityTypeId = rs.getString(UpgradeServiceHelper.FENTITYTYPEID) == null ? "" : rs.getString(UpgradeServiceHelper.FENTITYTYPEID);
                    map.put(UpgradeServiceHelper.FENTITYTYPEID, fEntityTypeId);
                    String fBizAppId = rs.getString(UpgradeServiceHelper.FBIZAPPID) == null ? "" : rs.getString(UpgradeServiceHelper.FBIZAPPID);
                    map.put(UpgradeServiceHelper.FBIZAPPID, fBizAppId);
                    String fInheritMode = rs.getString(UpgradeServiceHelper.FINHERITMODE) == null ? "" : rs.getString(UpgradeServiceHelper.FINHERITMODE);
                    map.put(UpgradeServiceHelper.FINHERITMODE, fInheritMode);
                    if (isNewPlatform.booleanValue()) {
                        String froleid = rs.getString(UpgradeServiceHelper.FROLEID);
                        map.put(UpgradeServiceHelper.FROLEID, froleid);
                        if (checkRoleSet.add(fId + fControlMode + fInheritMode + fBizAppId + fSeq + froleid)) {
                            list.add(map);
                        }
                    } else if (checkRoleSet.add(fId + fControlMode + fInheritMode + fBizAppId + fSeq)) {
                        list.add(map);
                    }
                    if (list.size() != 2000) continue;
                    ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>();
                    newList.addAll(list);
                    list.clear();
                    ThreadPoolService.upgradeServiceThread(() -> UpgradeServiceHelper.saveFunRolePerm(newPermItem, newPageNum, isNewPlatform, newList));
                }
                return list;
            }
        })).size() > 0) {
            UpgradeServiceHelper.saveFunRolePerm(newPermItem, newPageNum, isNewPlatform, roleItemList);
        }
    }

    private static void saveFunRolePerm(String newPermItem, String newPageNum, Boolean isNewPlatform, List<Map<String, Object>> roleItemList) {
        String[] genGlobalLongIds = GlobalIdUtil.genStringIds((int)roleItemList.size());
        ArrayList<Object[]> paramsRoleList = new ArrayList<Object[]>(roleItemList.size());
        for (int i = 0; i < roleItemList.size(); ++i) {
            Map<String, Object> map = roleItemList.get(i);
            String fId = (String)map.get(FID);
            String controlMode = (String)map.get(FCONTROLMODE);
            String inheritMode = (String)map.get(FINHERITMODE);
            String appId = (String)map.get(FBIZAPPID);
            Integer seq = (Integer)map.get(FSEQ);
            if (isNewPlatform.booleanValue()) {
                String froleid = (String)map.get(FROLEID);
                Object[] params = new Object[9];
                params[0] = fId;
                if (genGlobalLongIds != null) {
                    params[1] = genGlobalLongIds[i];
                }
                params[2] = controlMode;
                params[3] = newPermItem;
                params[4] = inheritMode;
                params[5] = newPageNum;
                params[6] = appId;
                params[7] = seq;
                params[8] = froleid;
                paramsRoleList.add(params);
                continue;
            }
            Object[] params = new Object[8];
            params[0] = fId;
            if (genGlobalLongIds != null) {
                params[1] = genGlobalLongIds[i];
            }
            params[2] = controlMode;
            params[3] = newPermItem;
            params[4] = inheritMode;
            params[5] = newPageNum;
            params[6] = appId;
            params[7] = seq;
            paramsRoleList.add(params);
        }
        if (!CollectionUtils.isEmpty(paramsRoleList)) {
            String insertRolepermdetial = "";
            insertRolepermdetial = isNewPlatform != false ? "insert into t_perm_rolepermdetial(fid,fentryid,fcontrolmode,fpermitemid, finheritmode, fentitytypeid, fbizappid,fseq,froleid) values (?,?,?,?,?,?,?,?,?)" : "insert into t_perm_rolepermdetial(fid,fentryid,fcontrolmode,fpermitemid, finheritmode, fentitytypeid, fbizappid,fseq) values (?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertRolepermdetial, paramsRoleList);
        }
    }

    public static void doUpgradeRole(WatchLogger log, String newRole, String oldPermItem, String oldPageNum) {
        String allModelSql = "select fid,fmodelid from t_bcm_modelperm where fmodelid >0";
        Map allModel = (Map)DB.query((DBRoute)BCMConstant.DBROUTE, (String)allModelSql, rs -> {
            HashMap res = Maps.newHashMapWithExpectedSize((int)16);
            while (rs.next()) {
                Long fid = rs.getLong(FID);
                Long fmodelid = rs.getLong("fmodelid");
                if (Objects.equals(fid, 0L) || Objects.equals(fmodelid, 0L)) continue;
                res.put(fid, fmodelid);
            }
            return res;
        });
        HashSet userModelAdmin = Sets.newHashSetWithExpectedSize((int)16);
        HashMap allAdmWsGp = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty((Map)allModel)) {
            SqlBuilder allAdmCountSql = new SqlBuilder();
            allAdmCountSql.append("select count(1) count from t_bcm_modelpermentry where ", new Object[0]);
            allAdmCountSql.appendIn(FID, (List)Lists.newArrayList(allModel.keySet()));
            int allAdmCount = (Integer)DB.query((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)allAdmCountSql, rs -> {
                if (rs.next()) {
                    return rs.getInt("count");
                }
                return 0;
            });
            int page = allAdmCount / 2000;
            for (int i = 0; i < page; ++i) {
                UpgradeServiceHelper.batchGetModelAdmin(i, allModel, allAdmWsGp, userModelAdmin);
            }
            if (!Objects.equals(allAdmCount % 2000, 0)) {
                UpgradeServiceHelper.batchGetModelAdmin(0, allModel, allAdmWsGp, userModelAdmin);
            }
        }
        try (TXHandle tx = TX.required();){
            try {
                if (!CollectionUtils.isEmpty((Map)allAdmWsGp)) {
                    SqlBuilder sb = new SqlBuilder();
                    sb.append("select distinct fuserid,fusergroupid from t_sec_usergroupstaff where", new Object[0]);
                    sb.appendIn(FUSERGROUPID, allAdmWsGp.keySet().toArray());
                    DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sb, rs -> {
                        while (rs.next()) {
                            Long uId = rs.getLong(FUSERID);
                            Long uGId = rs.getLong(FUSERGROUPID);
                            Long mId = (Long)allAdmWsGp.get(uGId);
                            if (Objects.equals(uId, 0L) || Objects.equals(uGId, 0L) || Objects.equals(mId, 0L)) continue;
                            userModelAdmin.add(UpgradeServiceHelper.userModelJoin(uId, mId));
                        }
                        return null;
                    });
                }
                UpgradeServiceHelper.upgradeUserRole(newRole, userModelAdmin, oldPermItem, oldPageNum, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
                UpgradeServiceHelper.upgradeRoleRole(oldPermItem, oldPageNum, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
                CacheMrg.clearAllCache();
            }
            catch (Exception e) {
                tx.markRollback();
                log.error("UpgradeServiceHelper - upgradeRole error:", (Throwable)e);
                throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            }
        }
    }

    public static void upgradeUserRole(String newRole, Set<String> allAdmWsGp, String oldPermItem, String oldPageNum, Boolean CMandRPT, Boolean isCM, Boolean isRPT) {
        List userItemList;
        StringBuilder selectSql = new StringBuilder("select distinct pup.fuserid,pup.forgid,pupd.fentryid,pup.fdimtype from t_perm_userpermdetail as pupd left join t_perm_userperm as pup on pupd.fid = pup.fid where pupd.fentitytypeid = ? and pupd.fpermitemid = ?");
        StringBuilder appFilter = UpgradeServiceHelper.convertAppSql("pupd.fbizappid", CMandRPT, isCM, isRPT);
        if (StringUtils.isNotBlank((CharSequence)appFilter)) {
            selectSql.append((CharSequence)appFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(userItemList = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (Object[])new Object[]{oldPageNum, oldPermItem}, rs -> {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
            while (rs.next()) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)4);
                Long fuserid = rs.getLong(FUSERID);
                String fentryid = rs.getString(FENTRYID);
                String fdimtype = rs.getString(FDIMTYPE);
                Long forgid = rs.getLong(FORGID);
                if (Objects.equals(fuserid, 0L) || Objects.equals(forgid, 0L) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fentryid, fdimtype})) continue;
                if (!allAdmWsGp.contains(UpgradeServiceHelper.userModelJoin(fuserid, forgid))) {
                    map.put(FUSERID, fuserid);
                    map.put(FENTRYID, fentryid);
                    map.put(FDIMTYPE, fdimtype);
                    map.put(FORGID, forgid);
                    list.add(map);
                }
                if (!Objects.equals(list.size(), 2000)) continue;
                ArrayList newList = Lists.newArrayList((Iterable)list);
                ThreadPoolService.upgradeServiceThread(() -> UpgradeServiceHelper.saveFunPermRole(newRole, newList));
                list.clear();
            }
            return list;
        })))) {
            UpgradeServiceHelper.saveFunPermRole(newRole, userItemList);
        }
    }

    private static void saveFunPermRole(String newRole, List<Map<String, Object>> userItemList) {
        String[] genGlobalLongIds = GlobalIdUtil.genStringIds((int)userItemList.size());
        ArrayList paramsUserList = Lists.newArrayListWithExpectedSize((int)userItemList.size());
        ArrayList oldIds = Lists.newArrayListWithExpectedSize((int)userItemList.size());
        for (int i = 0; i < userItemList.size(); ++i) {
            Map<String, Object> map = userItemList.get(i);
            Object fentryid = map.get(FENTRYID);
            Object fuserId = map.get(FUSERID);
            Object fdimType = map.get(FDIMTYPE);
            Object forgid = map.get(FORGID);
            if (ObjectUtils.anyNull((Object[])new Object[]{fentryid, fuserId, fdimType, forgid})) continue;
            oldIds.add(fentryid);
            Object[] params = new Object[5];
            params[0] = genGlobalLongIds[i];
            params[1] = ConvertUtil.convertObjToLong(forgid);
            params[2] = ConvertUtil.convertObjToLong(fuserId);
            params[3] = newRole;
            if (Objects.equals(fdimType, "DIM_BCM_MODEL")) {
                fdimType = "bcm_model";
            }
            params[4] = fdimType;
            paramsUserList.add(params);
        }
        if (!CollectionUtils.isEmpty((Collection)paramsUserList)) {
            String insertUserpermdetail = "insert into t_perm_userrole(fid,forgid,fuserid,froleid,fdimtype) values (?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertUserpermdetail, (List)paramsUserList);
            if (!CollectionUtils.isEmpty((Collection)oldIds)) {
                SqlBuilder deleteUserPermDetail = new SqlBuilder();
                deleteUserPermDetail.append("delete from t_perm_userpermdetail where", new Object[0]);
                deleteUserPermDetail.appendIn(FENTRYID, (List)oldIds);
                DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)deleteUserPermDetail);
            }
        }
    }

    public static void upgradeRoleRole(String oldPermItem, String oldPageNum, Boolean CMandRPT, Boolean isCM, Boolean isRPT) {
        List roleItemList;
        StringBuilder selectSql = new StringBuilder("select fentryid from t_perm_rolepermdetial where fentitytypeid = ? and fpermitemid = ?");
        StringBuilder appFilter = UpgradeServiceHelper.convertAppSql(FBIZAPPID, CMandRPT, isCM, isRPT);
        if (StringUtils.isNotBlank((CharSequence)appFilter)) {
            selectSql.append((CharSequence)appFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(roleItemList = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (Object[])new Object[]{oldPageNum, oldPermItem}, rs -> {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
            while (rs.next()) {
                String fentryId = rs.getString(FENTRYID);
                if (StringUtils.isBlank((CharSequence)fentryId)) continue;
                list.add(fentryId);
                if (!Objects.equals(list.size(), 2000)) continue;
                ArrayList newList = Lists.newArrayList((Iterable)list);
                list.clear();
                ThreadPoolService.upgradeServiceThread(() -> UpgradeServiceHelper.deleteFunRolePerm(newList));
            }
            return list;
        })))) {
            UpgradeServiceHelper.deleteFunRolePerm(roleItemList);
        }
    }

    private static void deleteFunRolePerm(List<Object> roleItemList) {
        if (!CollectionUtils.isEmpty(roleItemList)) {
            SqlBuilder deleteRolePermDetail = new SqlBuilder();
            deleteRolePermDetail.append("delete from t_perm_rolepermdetial where", new Object[0]);
            deleteRolePermDetail.appendIn(FENTRYID, roleItemList);
            DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)deleteRolePermDetail);
        }
    }

    private static StringBuilder convertAppSql(String field, boolean CMandRPT, boolean isCM, boolean isRPT) {
        StringBuilder selectSql = new StringBuilder();
        if (!CMandRPT) {
            boolean checkRPT;
            boolean checkCM = isCM && !isRPT;
            boolean bl = checkRPT = !isCM && isRPT;
            if (checkCM || checkRPT) {
                selectSql.append(" and ");
                selectSql.append(field);
                selectSql.append(" = '");
                if (checkCM) {
                    selectSql.append(CMAPPID);
                }
                if (checkRPT) {
                    selectSql.append(RPTAPPID);
                }
                selectSql.append(QUOTER);
            }
        }
        return selectSql;
    }

    private static void batchGetModelAdmin(int page, Map<Long, Long> allModel, Map<Long, Long> allAdmWsGp, Set<String> userModelAdmin) {
        SqlBuilder allAdminSql = new SqlBuilder();
        allAdminSql.append("select distinct top 2000,", new Object[0]);
        allAdminSql.append(String.valueOf(page), new Object[0]);
        allAdminSql.append(" fusers,fetype,fid from t_bcm_modelpermentry where", new Object[0]);
        allAdminSql.appendIn(FID, allModel.keySet().toArray());
        DB.query((DBRoute)BCMConstant.DBROUTE, (SqlBuilder)allAdminSql, rs -> {
            while (rs.next()) {
                String uTp = rs.getString("fetype");
                Long uId = rs.getLong("fusers");
                Long fid = rs.getLong(FID);
                if (StringUtils.isBlank((CharSequence)uTp) || Objects.equals(uId, 0L) || Objects.equals(fid, 0L)) continue;
                if (Objects.equals(uTp, UserTypeEnum.USERGROUP.getName())) {
                    allAdmWsGp.put(uId, (Long)allModel.get(fid));
                    continue;
                }
                if (!Objects.equals(uTp, UserTypeEnum.USER.getName())) continue;
                userModelAdmin.add(UpgradeServiceHelper.userModelJoin(uId, (Long)allModel.get(fid)));
            }
            return null;
        });
    }

    private static String userModelJoin(long userId, long modelId) {
        return StringUtils.join((Object[])new Long[]{userId, modelId}, (char)'#');
    }

    public static Pair<Long, String> getNameByTypeClz(String type, String clzName) {
        String record = "select fid,fupgradename from t_bcm_upgraderecord where fupgradetype=? and fupgradeclass=?";
        Object[] params = new SqlParameter[]{new SqlParameter(": fupgradetype", 12, (Object)type), new SqlParameter(": fupgradeclass", 12, (Object)clzName)};
        Pair recorded = (Pair)DB.query((DBRoute)BCMConstant.DBROUTE, (String)record, (Object[])params, rs -> {
            if (rs.next()) {
                return Pair.onePair((Object)rs.getLong(FID), (Object)rs.getString(F_UPGRADE_NAME));
            }
            return Pair.onePair((Object)0L, (Object)"");
        });
        return recorded;
    }

    public static void recordInsertOrUpdate(Long fid, String type, String name, String clzName) {
        if (Objects.equals(0L, fid)) {
            String sqlInsert = "insert into t_bcm_upgraderecord(fid,fupgradetype,fupgradetime,fupgradename,fupgradeclass) values(?,?,?,?,?)";
            DB.update((DBRoute)BCMConstant.DBROUTE, (String)sqlInsert, (Object[])new Object[]{GlobalIdUtil.genGlobalLongId(), type, TimeServiceHelper.now(), name, clzName});
            return;
        }
        String sqlUpdate = "update t_bcm_upgraderecord set fupgradename=?,fupgradetime=? where fid=?";
        DB.update((DBRoute)BCMConstant.DBROUTE, (String)sqlUpdate, (Object[])new Object[]{name, TimeServiceHelper.now(), fid});
    }

    public static Boolean isRolePermTableNew() {
        String existSql = "SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 't_perm_rolepermdetial' AND KSQL_COL_NAME IN ('froleid')";
        return (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)existSql, ResultSet::next);
    }

    public static boolean isExistTableAndField() {
        return (Boolean)ThreadCache.get((Object)BCM_UPGRADE_SERVICE_IS_EXIST_TABLE_AND_FIELD, () -> Lists.newArrayList((Iterable)DB.getColumnNames((DBRoute)DBRoute.of((String)"bcm"), (String)T_BCM_UPGRADE_RECORD)).containsAll(Lists.newArrayList((Object[])new String[]{FID, F_UPGRADE_TYPE, F_UPGRADE_TIME, F_UPGRADE_NAME, F_UPGRADE_CLASS})));
    }
}

