/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelUtil;
import kd.fi.bcm.business.model.UserSelectEntryModel;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ModelStatusEnum;
import kd.fi.bcm.common.enums.UserSelectEntryTypeEnum;
import kd.fi.bcm.common.log.DebugHelper;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;

public class UserSelectServiceHelper {
    public static final String defaultFileds = "issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel";

    public static UserSelectModel getUserSelect(String userId, String selectFileds, ApplicationTypeEnum application) {
        DynamicObject dynamicObjec = (DynamicObject)ThreadCache.get((Object)(userId + application.getAppnum() + selectFileds.hashCode()), () -> UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("modifier", "=", (Object)Long.valueOf(userId)), new QFilter("application", "=", (Object)application.index), new QFilter("modifydate", "is not null", null), new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()), new QFilter("formid", "=", (Object)" ")}));
        return UserSelectServiceHelper.transformDynamicObjectToUserSelect(dynamicObjec, false);
    }

    public static String getDefaultFileds(String formID) {
        if (formID.equals("bcm_report_list")) {
            return "issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,period.dimension,period.dimension.membermodel,period.isleaf,currency.dimension,currency.dimension.membermodel,currency.isleaf,scenario.dimension,scenario.dimension.membermodel,scenario.isleaf,year.dimension,year.dimension.membermodel,year.isleaf,entity.dimension,entity.dimension.membermodel,entity.isleaf,dmmodel";
        }
        return defaultFileds;
    }

    public static UserSelectModel getUserSelectByForm(String userId, String selectFileds, ApplicationTypeEnum application, String form) {
        if (StringUtils.isEmpty((CharSequence)form)) {
            return UserSelectServiceHelper.getUserSelect(userId, selectFileds, application);
        }
        DynamicObject dynamicObjec = UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("modifier", "=", (Object)Long.valueOf(userId)), new QFilter("application", "=", (Object)application.index), new QFilter("modifydate", "is not null", null), new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()), new QFilter("formid", "=", (Object)form)});
        return UserSelectServiceHelper.transformDynamicObjectToUserSelect(dynamicObjec, false);
    }

    public static UserSelectModel getDmUserSelectByForm(String userId, String selectFileds, ApplicationTypeEnum application) {
        DynamicObject dynamicObject = null;
        dynamicObject = UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("modifier", "=", (Object)Long.valueOf(userId)), new QFilter("application", "=", (Object)application.index), new QFilter("modifydate", "is not null", null), new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()), new QFilter("formid", "=", (Object)" ")});
        return UserSelectServiceHelper.transformDynamicObjectToUserSelect(dynamicObject, true);
    }

    public static List<UserSelectEntryModel> getUserSelectEntryByForm(IFormView formView, Long userId) {
        DynamicObject userSelect = BusinessDataServiceHelper.loadSingle((String)"bcm_userselect", (String)"userselectentry.data,userselectentry.type,userselectentry.id", (QFilter[])new QFilter[]{new QFilter("modifier", "=", (Object)userId), new QFilter("application", "=", (Object)ModelUtil.queryApp((IFormView)formView).index), new QFilter("formid", "=", (Object)" ")});
        if (null == userSelect) {
            return null;
        }
        DynamicObjectCollection userSelectEntry = userSelect.getDynamicObjectCollection("userselectentry");
        return UserSelectServiceHelper.dynamicObjectCol2UserSelectEntry(userSelectEntry);
    }

    private static List<UserSelectEntryModel> dynamicObjectCol2UserSelectEntry(DynamicObjectCollection userSelectEntry) {
        return userSelectEntry.stream().map(entry -> {
            UserSelectEntryModel userSelectEntryModel = new UserSelectEntryModel();
            userSelectEntryModel.setEntityId(entry.getString("id"));
            userSelectEntryModel.setData(entry.getString("data"));
            userSelectEntryModel.setType(UserSelectEntryTypeEnum.getUserSelectEntryTypeEnumByType((Integer)entry.getInt("type")));
            return userSelectEntryModel;
        }).collect(Collectors.toList());
    }

    public static UserSelectModel transformDynamicObjectToUserSelect(DynamicObject dynamicObject, Boolean isDm) {
        UserSelectModel userSelect = new UserSelectModel();
        if (dynamicObject == null) {
            return userSelect;
        }
        String formName = "bcm_model";
        String model = dynamicObject.getString("model");
        if (isDm.booleanValue()) {
            formName = "fidm_model";
            model = dynamicObject.getString("dmmodel");
        }
        if (!QueryServiceHelper.exists((String)formName, (Object)model)) {
            return userSelect;
        }
        userSelect.setId(dynamicObject.getString("id"));
        userSelect.setModel(dynamicObject.getString("model"));
        userSelect.setDmmodel(dynamicObject.getString("dmmodel"));
        userSelect.setOrg(dynamicObject.getString("entity"));
        userSelect.setCurrency(dynamicObject.getString("currency"));
        userSelect.setModifier(dynamicObject.getString("modifier"));
        userSelect.setPeriod(dynamicObject.getString("period"));
        userSelect.setScene(dynamicObject.getString("scenario"));
        userSelect.setYear(dynamicObject.getString("year"));
        userSelect.setVersion(dynamicObject.getString("version"));
        userSelect.setApplication(ApplicationTypeEnum.getApplication((String)dynamicObject.getString("application")));
        userSelect.setOnlyModel(dynamicObject.getBoolean("onlymodel"));
        userSelect.setFormid(dynamicObject.getString("formid"));
        userSelect.setCslScheme(dynamicObject.getString("cslscheme"));
        userSelect.setIsSummury("1".equals(dynamicObject.getString("issummury")));
        userSelect.setAdjustListType("1".equals(dynamicObject.getString("isadjustlisttype")));
        if (dynamicObject.containsProperty("config") && StringUtils.isNotBlank((CharSequence)dynamicObject.getString("config"))) {
            JSONObject configObj = JSON.parseObject((String)dynamicObject.getString("config"));
            userSelect.setConfig(configObj.getInnerMap());
        }
        return userSelect;
    }

    public static DynamicObject getUserSelectDynamicObject(String userId, String selectFields, ApplicationTypeEnum application) {
        DynamicObject dyn = (DynamicObject)ThreadCache.get((Object)(userId + application.getAppnum() + selectFields.hashCode()), () -> UserSelectServiceHelper.queryUserSelect(selectFields, new QFilter[]{new QFilter("modifier", "=", (Object)Long.valueOf(userId)), new QFilter("application", "=", (Object)application.index), new QFilter("modifydate", "is not null", null), new QFilter("model.status", "=", (Object)ModelStatusEnum.AUDIT.getValue()), new QFilter("formid", "=", (Object)" ")}));
        return dyn;
    }

    public static DynamicObject queryUserSelect(String selectFields, QFilter[] qFilters) {
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userselect", (String)selectFields, (QFilter[])qFilters, (String)"modifydate desc", (int)1);
        if (doc == null || doc.isEmpty()) {
            return null;
        }
        DynamicObject dyn = (DynamicObject)doc.get(0);
        if (selectFields.contains("model") && selectFields.contains("scenario") && selectFields.contains("period")) {
            long modelId = dyn.getLong("model");
            long scenarioId = dyn.getLong("scenario");
            long periodId = dyn.getLong("period");
            if (scenarioId != 0L && periodId != 0L) {
                QFBuilder qf = new QFBuilder();
                qf.add("model", "=", (Object)modelId);
                qf.add("sceneperiod.id", "=", (Object)scenarioId);
                qf.add("sceneperiod.fbasedataid", "=", (Object)periodId);
                if (!QueryServiceHelper.exists((String)"bcm_scenemembertree", (QFilter[])qf.toArray())) {
                    dyn.set("period", (Object)0L);
                }
            }
        }
        return dyn;
    }

    public static DynamicObjectCollection queryUserSelectCollection(String selectFileds, QFilter[] qFilters) {
        return QueryServiceHelper.query((String)"bcm_userselect", (String)selectFileds, (QFilter[])qFilters);
    }

    public static DynamicObjectCollection queryUserSelectCollection(String selectFileds, QFilter[] qFilters, String orderby) {
        return QueryServiceHelper.query((String)"bcm_userselect", (String)selectFileds, (QFilter[])qFilters, (String)orderby);
    }

    public static void saveUserSelect(UserSelectModel userSelectModel) {
        DynamicObject userSelect;
        if (userSelectModel == null || StringUtils.isEmpty((CharSequence)userSelectModel.getModifier())) {
            return;
        }
        try {
            QFilter qf = new QFilter("formid", "=", (Object)" ");
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getFormid())) {
                qf = new QFilter("formid", "=", (Object)userSelectModel.getFormid());
            }
            userSelect = BusinessDataServiceHelper.loadSingle((String)"bcm_userselect", (String)"issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel,userselectentry.data,userselectentry.type,config", (QFilter[])new QFilter[]{qf, new QFilter("model", "=", (Object)LongUtil.toLong((Object)userSelectModel.getModel())), new QFilter("modifier", "=", (Object)LongUtil.toLong((Object)userSelectModel.getModifier())), new QFilter("application", "=", (Object)userSelectModel.getApplication().index)});
        }
        catch (Exception e) {
            DebugHelper.debugDataObjectType((String[])new String[]{"bcm_userselect", "bcm_model"});
            throw new RuntimeException(e);
        }
        DynamicObject userSelectObject = userSelect == null ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_userselect") : userSelect;
        if (Objects.nonNull(userSelectModel.getModel())) {
            userSelectObject.set("model", (Object)userSelectModel.getModel());
        }
        long modelId = userSelectObject.getLong("model");
        if (!userSelectModel.isOnlyModel()) {
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getOrg()) && MemberReader.findMemberById((long)modelId, (String)"bcm_entitymembertree", (Long)LongUtil.toLong((Object)userSelectModel.getOrg())) != IDNumberTreeNode.NotFoundTreeNode) {
                userSelectObject.set("entity", (Object)userSelectModel.getOrg());
            }
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getYear()) && MemberReader.findMemberById((long)modelId, (String)"bcm_fymembertree", (Long)LongUtil.toLong((Object)userSelectModel.getYear())) != IDNumberTreeNode.NotFoundTreeNode) {
                userSelectObject.set("year", (Object)userSelectModel.getYear());
            }
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getScene()) && MemberReader.findMemberById((long)modelId, (String)"bcm_scenemembertree", (Long)LongUtil.toLong((Object)userSelectModel.getScene())) != IDNumberTreeNode.NotFoundTreeNode) {
                userSelectObject.set("scenario", (Object)userSelectModel.getScene());
            }
            if ((StringUtils.isNotEmpty((CharSequence)userSelectModel.getPeriod()) || userSelectModel.isSPConfig()) && MemberReader.findMemberById((long)modelId, (String)"bcm_periodmembertree", (Long)LongUtil.toLong((Object)userSelectModel.getPeriod())) != IDNumberTreeNode.NotFoundTreeNode) {
                userSelectObject.set("period", (Object)userSelectModel.getPeriod());
            }
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getCurrency()) && MemberReader.findMemberById((long)modelId, (String)"bcm_currencymembertree", (Long)LongUtil.toLong((Object)userSelectModel.getCurrency())) != IDNumberTreeNode.NotFoundTreeNode) {
                userSelectObject.set("currency", (Object)userSelectModel.getCurrency());
            }
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getVersion())) {
                userSelectObject.set("version", (Object)userSelectModel.getVersion());
            }
            if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getCslScheme()) && CslSchemeServiceHelper.existsScheme(modelId, LongUtil.toLong((Object)userSelectModel.getCslScheme()))) {
                userSelectObject.set("cslscheme", (Object)userSelectModel.getCslScheme());
            }
            if (null != userSelectModel.getUserSelectEntryModel()) {
                if (userSelect != null) {
                    DynamicObjectCollection userSelectEntry = userSelect.getDynamicObjectCollection("userselectentry");
                    UserSelectServiceHelper.clearAndSetUserSelectEntry(userSelectEntry, userSelectModel);
                    userSelectObject.set("userselectentry", (Object)userSelectEntry);
                }
            } else {
                userSelectObject.set("userselectentry", (Object)new DynamicObjectCollection());
            }
            userSelectObject.set("isSummury", (Object)(userSelectModel.isSummury() ? "1" : "0"));
            userSelectObject.set("isadjustlisttype", (Object)(userSelectModel.isAdjustListType() ? "1" : "0"));
        }
        if (StringUtils.isNotEmpty((CharSequence)userSelectModel.getDmmodel())) {
            userSelectObject.set("dmmodel", (Object)userSelectModel.getDmmodel());
        }
        userSelectObject.set("modifier", (Object)userSelectModel.getModifier());
        userSelectObject.set("modifydate", (Object)TimeServiceHelper.now());
        userSelectObject.set("application", (Object)userSelectModel.getApplication().index);
        userSelectObject.set("onlymodel", (Object)(userSelectModel.isOnlyModel() ? "1" : "0"));
        userSelectObject.set("formid", (Object)userSelectModel.getFormid());
        if (userSelectModel.getConfig() != null && !userSelectModel.getConfig().isEmpty()) {
            JSONObject configObj = new JSONObject();
            String configStr = userSelectObject.getString("config");
            if (StringUtils.isNotBlank((CharSequence)configStr)) {
                configObj = JSON.parseObject((String)configStr);
            }
            configObj.putAll(userSelectModel.getConfig());
            userSelectObject.set("config", (Object)configObj.toJSONString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userSelectObject});
    }

    private static void clearAndSetUserSelectEntry(DynamicObjectCollection userSelectEntry, UserSelectModel userSelectModel) {
        Map<UserSelectEntryTypeEnum, List<UserSelectEntryModel>> entryMapGroupByType = userSelectModel.getUserSelectEntryModel().stream().collect(Collectors.groupingBy(UserSelectEntryModel::getType));
        entryMapGroupByType.keySet().forEach(type -> {
            userSelectEntry.removeIf(entry -> type.getType().equals(entry.getInt("type")));
            List userSelectEntryModels = (List)entryMapGroupByType.get(type);
            userSelectEntryModels.forEach(userSelectEntryModel -> {
                DynamicObject dynamicObject = userSelectEntry.addNew();
                dynamicObject.set("data", (Object)userSelectEntryModel.getData());
                dynamicObject.set("type", (Object)userSelectEntryModel.getType().getType());
            });
        });
    }

    public static Object getEntity(Long userId, Long modelId) {
        return AppCacheServiceHelper.get(UserSelectServiceHelper.getEntityKey(userId, modelId), Object.class);
    }

    public static Object getEntity(Long userId, Long modelId, Function<IFormView, Object> function, IFormView formView) {
        Object result = function.apply(formView);
        if (result == null) {
            return AppCacheServiceHelper.get(UserSelectServiceHelper.getEntityKey(userId, modelId), Object.class);
        }
        return String.valueOf(result);
    }

    public static void setEntity(Long userId, Long modelId, Object id) {
        AppCacheServiceHelper.put(UserSelectServiceHelper.getEntityKey(userId, modelId), id);
    }

    private static String getEntityKey(Long modelId, Long userId) {
        return String.format("SelectedEntity_%s_%s", modelId, userId);
    }

    @SDKMark
    public static DynamicObject getUserSelectDynamicObject(String modelid, String userId, String selectFileds, ApplicationTypeEnum application) {
        DynamicObject dynamicObjec = UserSelectServiceHelper.queryUserSelect(selectFileds, new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid)), new QFilter("modifier", "=", (Object)LongUtil.toLong((Object)userId)), new QFilter("modifydate", "is not null", null), new QFilter("application", "=", (Object)application.index), new QFilter("formid", "=", (Object)" ")});
        return dynamicObjec == null ? null : dynamicObjec;
    }
}

