/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper.dc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.dc.DCResultsMap;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.config.SamePeriodLastYearVo;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DCQueryHelper {
    public static final String ENTITY = DimTypesEnum.ENTITY.getNumber();
    public static final String PROCESS = DimTypesEnum.PROCESS.getNumber();
    public static final String CURRENCY = DimTypesEnum.CURRENCY.getNumber();
    public static final List<String> dcdims = new ArrayList<String>();
    public static final List<String> VARDIMS = new ArrayList<String>();

    public static String toNEProcess(String number) {
        if ("EIRpt".equals(number)) {
            return "IRpt";
        }
        if ("ERAdj".equals(number)) {
            return "RAdj";
        }
        return number;
    }

    public static boolean hasLastYear(SelectCommandInfo queryInfo) {
        return queryInfo.getFilter().stream().anyMatch(f -> PresetConstant.FY_DIM.equals(f.getName()) && f.getValues().stream().anyMatch(e -> "LastYear".equals(e)));
    }

    public static Map<String, String> getExchangePeriodForLastYear(SelectCommandInfo queryInfo, String modelNum) {
        List<SamePeriodLastYearVo> vos;
        HashMap<String, String> result = new HashMap<String, String>(16);
        if (queryInfo.getDimensions().contains(PresetConstant.PERIOD_DIM) || !queryInfo.getDimensions().contains(PresetConstant.FY_DIM)) {
            return result;
        }
        HashSet periodNums = new HashSet(16);
        AtomicBoolean flag = new AtomicBoolean(false);
        queryInfo.getFilter().forEach(e -> {
            if (PresetConstant.PERIOD_DIM.equals(e.getName())) {
                periodNums.addAll(e.getValues());
            } else if (PresetConstant.FY_DIM.equals(e.getName()) && e.getValues().contains("LastYear")) {
                flag.set(true);
            }
        });
        if (flag.get() && periodNums.size() == 1 && !periodNums.contains("CurrentPeriod") && !periodNums.contains("LastPeriod") && CollectionUtils.isNotEmpty(vos = ConfigServiceHelper.getCM056Config(MemberReader.findModelIdByNum((String)modelNum)))) {
            vos.forEach(s -> result.put(String.join((CharSequence)"|", s.getSceario(), s.getCurrentPeriod()), s.getExchangePeriod()));
        }
        return result;
    }

    public static boolean hasLastPeriod(SelectCommandInfo queryInfo) {
        return queryInfo.getFilter().stream().anyMatch(f -> PresetConstant.PERIOD_DIM.equals(f.getName()) && f.getValues().stream().anyMatch(e -> "LastPeriod".equals(e)));
    }

    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubeCatalog, long mainOrgId, IRelaMembSupplier<String, String> periodSupplier) {
        return DCQueryHelper.queryData(queryInfo, cubeCatalog, mainOrgId, periodSupplier, false);
    }

    public static Map<String, Object> queryData(SelectCommandInfo queryInfo, String cubeCatalog, long mainOrgId, IRelaMembSupplier<String, String> periodSupplier, boolean unCheckYPVar) {
        if (!DCQueryHelper.checkCanTrans(queryInfo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u884c\u5217\u7ef4\u8bbe\u7f6e\uff0c\u5f53\u524d\u573a\u666f\u67e5\u8be2\u517c\u5bb9\u9519\u8bef\u3002", (String)"DCQueryHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        SelectCommandInfo newInfo = DCQueryHelper.packComInfo(queryInfo, cubeCatalog, mainOrgId, periodSupplier);
        if (newInfo == null) {
            return new HashMap<String, Object>();
        }
        for (DimensionFilterItem fil : newInfo.getFilter()) {
            if (!fil.getName().equals(DimTypesEnum.PROCESS.getNumber())) continue;
            fil.getValues().replaceAll(DCQueryHelper::toNEProcess);
        }
        Map<String, Object> pakresults = OlapServiceHelper.queryData(newInfo, cubeCatalog);
        if (!(DCQueryHelper.isECPInRC(queryInfo) || unCheckYPVar || DCQueryHelper.hasLastPeriod(queryInfo) || DCQueryHelper.hasLastYear(queryInfo))) {
            return pakresults;
        }
        DCResultsMap map = new DCResultsMap(queryInfo, cubeCatalog, periodSupplier, unCheckYPVar);
        map.putAll(pakresults);
        return map;
    }

    private static Map<String, Integer> getRCIndex(SelectCommandInfo queryInfo) {
        HashMap<String, Integer> changeIndex = new HashMap<String, Integer>();
        int offset = 0;
        for (String ebc : dcdims) {
            int index = queryInfo.getDimensions().indexOf(ebc);
            if (index >= 0) {
                changeIndex.put(ebc, index);
                continue;
            }
            changeIndex.put(ebc, queryInfo.getDimensions().size() + offset++);
        }
        return changeIndex;
    }

    public static boolean isECPInRC(SelectCommandInfo queryInfo) {
        HashSet set = new HashSet(queryInfo.getDimensions());
        set.retainAll(dcdims);
        return set.size() > 0;
    }

    private static SelectCommandInfo packComInfo(SelectCommandInfo queryInfo, String cubeCatalog, long mainOrgId, IRelaMembSupplier<String, String> periodSupplier) {
        SelectCommandInfo qicopy = DCQueryHelper.copyInfo(queryInfo);
        HashMap<String, List<String>> fs = new HashMap<String, List<String>>();
        qicopy.getFilter().forEach(f -> fs.put(f.getName(), f.getValues()));
        if (periodSupplier != null) {
            if (DCQueryHelper.hasLastPeriod(qicopy)) {
                DCQueryHelper.packLastPeriondInfo(qicopy, fs, periodSupplier);
            } else if (DCQueryHelper.hasLastYear(queryInfo)) {
                DCQueryHelper.packSamePeriodLastYearInfo(qicopy, fs, cubeCatalog);
            }
        }
        if (DCQueryHelper.isECPInRC(qicopy)) {
            qicopy = DCQueryHelper.packInRCInfo(qicopy, cubeCatalog, fs);
        } else {
            DCQueryHelper.packNotInRCInfo(qicopy, cubeCatalog, mainOrgId, fs);
        }
        return qicopy;
    }

    private static void packSamePeriodLastYearInfo(SelectCommandInfo queryInfo, Map<String, List<String>> fs, String cubeCatalog) {
        List<String> fys = fs.get(PresetConstant.FY_DIM);
        List<String> periods = fs.get(PresetConstant.PERIOD_DIM);
        if (fys == null || periods == null) {
            return;
        }
        Map<String, String> map = DCQueryHelper.getExchangePeriodForLastYear(queryInfo, cubeCatalog);
        VARDIMS.forEach(dim -> {
            if (!queryInfo.getDimensions().contains(dim)) {
                queryInfo.addDims(new String[]{dim});
            }
        });
        if (MapUtils.isNotEmpty(map)) {
            HashSet samePeriods = new HashSet(16);
            map.values().forEach(e -> {
                if (StringUtils.isNotEmpty((String)e)) {
                    samePeriods.add(e);
                }
            });
            if (CollectionUtils.isNotEmpty(samePeriods)) {
                queryInfo.getFilter().forEach(f -> {
                    if (PresetConstant.PERIOD_DIM.equals(f.getName())) {
                        samePeriods.addAll(f.getValues());
                        f.getValues().clear();
                        f.getValues().addAll(samePeriods);
                    }
                });
            }
        }
    }

    private static void packLastPeriondInfo(SelectCommandInfo queryInfo, Map<String, List<String>> fs, IRelaMembSupplier<String, String> periodSupplier) {
        List<String> fys = fs.get(PresetConstant.FY_DIM);
        List<String> periods = fs.get(PresetConstant.PERIOD_DIM);
        if (fys == null || periods == null) {
            return;
        }
        VARDIMS.forEach(dim -> {
            if (!queryInfo.getDimensions().contains(dim)) {
                queryInfo.addDims(new String[]{dim});
            }
        });
        HashSet<String> newFys = new HashSet<String>(fys);
        HashSet<String> newPeriods = new HashSet<String>(periods);
        periods.forEach(e -> {
            if ("LastPeriod".equals(e)) {
                fys.forEach(year -> {
                    if (!Arrays.asList("LastYear", "CurrentYear", "AllYear", "Year").contains(year)) {
                        Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)periodSupplier.getModelNumber(), (String)periodSupplier.getCurrentScenario(), (String)periodSupplier.getCurrentPeriod(), (String)year, (String)e);
                        if (StringUtils.isNotEmpty((String)((String)yearAndPeriod.p2)) && !"LastPeriod".equals(yearAndPeriod.p2)) {
                            newPeriods.add((String)yearAndPeriod.p2);
                            if (StringUtils.isNotEmpty((String)((String)yearAndPeriod.p1))) {
                                newFys.add((String)yearAndPeriod.p1);
                            }
                        }
                    }
                });
            }
        });
        queryInfo.getFilter().forEach(f -> {
            if (PresetConstant.FY_DIM.equals(f.getName())) {
                f.getValues().clear();
                f.getValues().addAll(newFys);
            } else if (PresetConstant.PERIOD_DIM.equals(f.getName())) {
                f.getValues().clear();
                f.getValues().addAll(newPeriods);
            }
        });
    }

    private static SelectCommandInfo copyInfo(SelectCommandInfo queryInfo) {
        SelectCommandInfo qicopy = new SelectCommandInfo();
        qicopy.setMeasures(new ArrayList(queryInfo.getMeasures()));
        qicopy.setTop(queryInfo.getTop());
        qicopy.setDimensions(new ArrayList(queryInfo.getDimensions()));
        queryInfo.getFilter().forEach(f -> qicopy.addFilter(f.getName(), f.getValues().toArray(new String[0])));
        qicopy.setExcludeDynamicCalcResult(queryInfo.getExcludeDynamicCalcResult());
        qicopy.setIncludeDynamicMemberWhenNullFilter(queryInfo.getIncludeDynamicMemberWhenNullFilter());
        return qicopy;
    }

    private static SelectCommandInfo packInRCInfo(SelectCommandInfo queryInfo, String cubeCatalog, Map<String, List<String>> fs) {
        List<String> orgs = fs.get(ENTITY);
        List<String> bps = fs.get(PROCESS);
        List<String> curs = fs.get(CURRENCY);
        if (orgs == null || bps == null || curs == null) {
            return null;
        }
        HashSet<String> neworgs = new HashSet<String>(orgs);
        HashSet<String> newcurs = new HashSet<String>(curs);
        for (String cur : curs) {
            for (String org : orgs) {
                for (String bp : bps) {
                    IDNumberTreeNode numberTreeNode = MemberReader.findMemberByNumber((String)cubeCatalog, (String)ENTITY, (String)org);
                    if (numberTreeNode.getId() == -1L) continue;
                    Pair<String, String> p = TransMemberUtil.transOrgAndCurbyOrgId(cubeCatalog, (long)numberTreeNode.getId(), bp, cur, 0L, 0L);
                    neworgs.add((String)p.p1);
                    if (p.p2 == null) continue;
                    newcurs.add((String)p.p2);
                }
            }
        }
        queryInfo.getFilter().forEach(f -> {
            if (f.getName().equals(CURRENCY)) {
                f.getValues().clear();
                f.getValues().addAll(newcurs);
            } else if (f.getName().equals(ENTITY)) {
                f.getValues().clear();
                f.getValues().addAll(neworgs);
            } else if (f.getName().equals(PROCESS) && f.getValues().contains("EIRpt")) {
                f.getValues().remove("EIRpt");
                f.getValues().add("IRpt");
            }
        });
        for (String dim : dcdims) {
            if (queryInfo.getDimensions().contains(dim)) continue;
            queryInfo.addDims(new String[]{dim});
        }
        return queryInfo;
    }

    private static void packNotInRCInfo(SelectCommandInfo queryInfo, String cubeCatalog, long mainOrgId, Map<String, List<String>> fs) {
        String bp = fs.get(PROCESS).get(0);
        String cur = fs.get(CURRENCY).get(0);
        Pair<String, String> p = TransMemberUtil.transOrgAndCurbyOrgId(cubeCatalog, mainOrgId, bp, cur, 0L, 0L);
        queryInfo.getFilter().forEach(f -> {
            if (f.getName().equals(CURRENCY) && StringUtils.isNotEmpty((String)((String)p.p2))) {
                f.getValues().clear();
                f.getValues().add(p.p2);
            } else if (f.getName().equals(ENTITY)) {
                f.getValues().clear();
                f.getValues().add(p.p1);
            } else if (f.getName().equals(PROCESS) && f.getValues().contains("EIRpt")) {
                f.getValues().remove("EIRpt");
                f.getValues().add("IRpt");
            }
        });
    }

    private static boolean checkCanTrans(SelectCommandInfo queryInfo) {
        return queryInfo.getFilter().stream().noneMatch(f -> !queryInfo.getDimensions().contains(f.getName()) && f.getValues().size() != 1);
    }

    public static boolean isECPInRC(SpreadManager sm) {
        ArrayList pageAndViewDim = new ArrayList();
        sm.getFilter().getPageDomain().getDimensions().forEach(p -> pageAndViewDim.add(p.getNumber()));
        sm.getFilter().getViewPointDomain().getDimensions().forEach(v -> pageAndViewDim.add(v.getNumber()));
        pageAndViewDim.retainAll(dcdims);
        return pageAndViewDim.size() != 3;
    }

    static {
        dcdims.add(ENTITY);
        dcdims.add(PROCESS);
        dcdims.add(CURRENCY);
        VARDIMS.add(PresetConstant.PERIOD_DIM);
        VARDIMS.add(PresetConstant.FY_DIM);
    }
}

