/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.serviceHelper.dc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.serviceHelper.dc.DCQueryHelper;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.util.PeriodUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DCResultsMap
extends HashMap<String, Object> {
    private SelectCommandInfo queryInfo;
    private String cubeCatalog;
    private Map<String, Integer> rcIndexs;
    private Map<String, List<String>> fs;
    private IRelaMembSupplier<String, String> periodSupplier;
    private Map<String, String> samePeriodLastYearMap;
    private boolean unCheckYPVar;

    public DCResultsMap(SelectCommandInfo queryInfo, String cubeCatalog, IRelaMembSupplier<String, String> periodSupplier, boolean unCheckYPVar) {
        this.queryInfo = queryInfo;
        this.cubeCatalog = cubeCatalog;
        this.periodSupplier = periodSupplier;
        this.rcIndexs = new HashMap<String, Integer>(16);
        DCResultsMap.addDimIndex(queryInfo, true, this.rcIndexs);
        DCResultsMap.addDimIndex(queryInfo, false, this.rcIndexs);
        this.fs = new HashMap<String, List<String>>();
        queryInfo.getFilter().forEach((? super T f) -> this.fs.put(f.getName(), f.getValues()));
        this.samePeriodLastYearMap = DCQueryHelper.getExchangePeriodForLastYear(queryInfo, cubeCatalog);
        this.unCheckYPVar = unCheckYPVar;
    }

    private static void addDimIndex(SelectCommandInfo queryInfo, boolean isVar, Map<String, Integer> changeIndex) {
        if (isVar && !DCQueryHelper.hasLastPeriod(queryInfo) && !DCQueryHelper.hasLastYear(queryInfo)) {
            return;
        }
        if (!isVar && !DCQueryHelper.isECPInRC(queryInfo)) {
            return;
        }
        int offset = 0;
        if (!changeIndex.isEmpty()) {
            for (Map.Entry entry : changeIndex.entrySet()) {
                if (queryInfo.getDimensions().indexOf(entry.getKey()) != -1) continue;
                ++offset;
            }
        }
        for (String string : isVar ? DCQueryHelper.VARDIMS : DCQueryHelper.dcdims) {
            int index = queryInfo.getDimensions().indexOf(string);
            if (index >= 0) {
                changeIndex.put(string, index);
                continue;
            }
            changeIndex.put(string, queryInfo.getDimensions().size() + offset++);
        }
    }

    @Override
    public Object get(Object key) {
        if (this.isEmpty()) {
            return null;
        }
        String strKey = (String)key;
        ArrayList<String> mems = new ArrayList<String>();
        Collections.addAll(mems, strKey.split("\\|"));
        if (!this.unCheckYPVar && !this.exchangeVarYearAndPeriod(mems)) {
            return null;
        }
        if (DCQueryHelper.isECPInRC(this.queryInfo)) {
            for (String ebc : DCQueryHelper.dcdims) {
                if (this.rcIndexs.get(ebc) < this.queryInfo.getDimensions().size()) continue;
                mems.add(this.fs.get(ebc).get(0));
            }
            IDNumberTreeNode numberTreeNode = BcmThreadCache.findMemberByNum((String)this.cubeCatalog, (String)DCQueryHelper.ENTITY, (String)((String)mems.get(this.rcIndexs.get(DCQueryHelper.ENTITY))));
            if (numberTreeNode.getId() == -1L) {
                return null;
            }
            int pidex = this.rcIndexs.get(DCQueryHelper.PROCESS);
            String bpNum = (String)mems.get(pidex);
            Pair<String, String> p = TransMemberUtil.getTransOrgAndCurbyOrgId(numberTreeNode, numberTreeNode.getModelId(), bpNum, (String)mems.get(this.rcIndexs.get(DCQueryHelper.CURRENCY)));
            mems.set(this.rcIndexs.get(DCQueryHelper.ENTITY), (String)p.p1);
            mems.set(this.rcIndexs.get(DCQueryHelper.CURRENCY), (String)p.p2);
            mems.set(pidex, DCQueryHelper.toNEProcess(bpNum));
        }
        String pakkey = String.join((CharSequence)"|", mems);
        return super.get(pakkey);
    }

    private boolean exchangeVarYearAndPeriod(List<String> mems) {
        Optional lastYear;
        boolean hasLastPeriod = DCQueryHelper.hasLastPeriod(this.queryInfo);
        boolean hasLastYear = DCQueryHelper.hasLastYear(this.queryInfo);
        if (this.periodSupplier == null || !hasLastPeriod && !hasLastYear) {
            return true;
        }
        for (String ebc : DCQueryHelper.VARDIMS) {
            if (this.rcIndexs.get(ebc) < this.queryInfo.getDimensions().size()) continue;
            mems.add(this.fs.get(ebc).get(0));
        }
        String period = mems.get(this.rcIndexs.get(PresetConstant.PERIOD_DIM));
        String year = mems.get(this.rcIndexs.get(PresetConstant.FY_DIM));
        if (hasLastPeriod) {
            if (Arrays.asList("LastYear", "AllYear", "Year").contains(year)) {
                return false;
            }
            Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)this.cubeCatalog, (String)this.periodSupplier.getCurrentScenario(), (String)this.periodSupplier.getCurrentPeriod(), (String)year, (String)period);
            if (yearAndPeriod.p2 != null && !period.equals(yearAndPeriod.p2)) {
                mems.set(this.rcIndexs.get(PresetConstant.PERIOD_DIM), (String)yearAndPeriod.p2);
            }
            if (yearAndPeriod.p1 != null && !year.equals(yearAndPeriod.p1)) {
                mems.set(this.rcIndexs.get(PresetConstant.FY_DIM), (String)yearAndPeriod.p1);
            }
        } else if (hasLastYear && "LastYear".equals(year) && (lastYear = PeriodUtils.getLastYear((String)this.cubeCatalog, (String)this.periodSupplier.getCurrentYear())).isPresent() && StringUtils.isNotEmpty((CharSequence)((CharSequence)lastYear.get()))) {
            mems.set(this.rcIndexs.get(PresetConstant.FY_DIM), (String)lastYear.get());
            if (!this.queryInfo.getDimensions().contains(PresetConstant.PERIOD_DIM)) {
                if (Arrays.asList("LastPeriod", "CurrentPeriod", "M_YearTotal").contains(period)) {
                    return false;
                }
                if (MapUtils.isNotEmpty(this.samePeriodLastYearMap)) {
                    String exchangePeriod;
                    String scenario = null;
                    Integer idx = this.rcIndexs.get(PresetConstant.SCENE_DIM);
                    scenario = idx != null ? mems.get(idx) : this.fs.get(PresetConstant.SCENE_DIM).get(0);
                    if (StringUtils.isNotEmpty((CharSequence)scenario) && StringUtils.isNotEmpty((CharSequence)(exchangePeriod = this.samePeriodLastYearMap.get(String.join((CharSequence)"|", scenario, period)))) && !StringUtils.equals((CharSequence)period, (CharSequence)exchangePeriod)) {
                        mems.set(this.rcIndexs.get(PresetConstant.PERIOD_DIM), exchangePeriod);
                    }
                }
            }
        }
        return true;
    }
}

