/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.spread.common.util.exception.MDQueryException;
import org.apache.commons.collections4.map.MultiKeyMap;

public class ExtSQLBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _cubecatalog;
    private String modelnumber;
    private static String SPLIT_STR = "#@#";
    private String extmodelnumber;
    private String entityname;
    private int asc;
    private List<String> measures = new LinkedList<String>();
    private List<String> selector = new LinkedList<String>();
    private List<String> orderby = new LinkedList<String>();
    private List<String> groupby = new LinkedList<String>();
    private List<Pair<String, String[]>> filter = new ArrayList<Pair<String, String[]>>();
    private int top;
    private Map<String, String> fieldMappedForCols;
    private Map<String, String> fieldMappedForDims;
    Map<String, String> shortnumbermaps;
    MultiKeyMap orgCurrencyMap;
    private Boolean useEcDcPcStr;
    private Set<String> pcorgs = new HashSet<String>(16);
    private Set<String> currencys = new HashSet<String>(16);
    private List<String> allCols = new LinkedList<String>();
    Map<String, String> shortmapsToCol;
    private Pair<String[], String[]> multiRow;

    public List<String> getSelector() {
        return this.selector;
    }

    public String[] getGroupby() {
        return this.groupby.toArray(new String[0]);
    }

    public void setSelector(List<String> selector) {
        this.selector = selector;
    }

    public Pair<String[], String[]> getMultiRow() {
        return this.multiRow;
    }

    public Map<String, String> getShortmapsToCol() {
        return this.shortmapsToCol;
    }

    public Map<String, String> getShortnumbermaps() {
        return this.shortnumbermaps;
    }

    public void setShortnumbermaps(Map<String, String> shortnumbermaps) {
        this.shortnumbermaps = shortnumbermaps;
    }

    public void setShortmapsToCol(Map<String, String> shortmapsToCol) {
        this.shortmapsToCol = shortmapsToCol;
    }

    public void setMultiRow(Pair<String[], String[]> multiRow) {
        this.multiRow = multiRow;
    }

    public int getAsc() {
        return this.asc;
    }

    public void setAsc(int asc) {
        this.asc = asc;
    }

    public String getEntityname() {
        return this.entityname;
    }

    public void setEntityname(String entityname) {
        this.entityname = entityname;
    }

    public Map<String, String> getFieldMappedForCols() {
        return this.fieldMappedForCols;
    }

    public void setFieldMappedForCols(Map<String, String> fieldMappedForCols) {
        this.fieldMappedForCols = fieldMappedForCols;
    }

    public Map<String, String> getFieldMappedForDims() {
        return this.fieldMappedForDims;
    }

    public void setFieldMappedForDims(Map<String, String> fieldMappedForDims) {
        this.fieldMappedForDims = fieldMappedForDims;
    }

    public String getModelnumber() {
        return this.modelnumber;
    }

    public void setModelnumber(String modelnumber) {
        this.modelnumber = modelnumber;
    }

    public ExtSQLBuilder(String cubecatalog, String extmodelnumber) {
        this._cubecatalog = cubecatalog;
        this.extmodelnumber = extmodelnumber;
    }

    public ExtSQLBuilder(String cubecatalog) {
        this._cubecatalog = cubecatalog;
    }

    public String getExtmodelnumber() {
        return this.extmodelnumber;
    }

    public void setExtmodelnumber(String extmodelnumber) {
        this.extmodelnumber = extmodelnumber;
    }

    public String getCubecatalog() {
        return this._cubecatalog;
    }

    public void addSelectField(String ... dimKeys) {
        for (String f : dimKeys) {
            if (this.selector.contains(f)) continue;
            this.selector.add(f);
        }
    }

    public void addOrderby(String ... fields) {
        for (String f : fields) {
            if (this.orderby.contains(f)) continue;
            this.orderby.add(f);
        }
    }

    public void addCurrency(String ... fields) {
        for (String f : fields) {
            if (this.currencys.contains(f)) continue;
            this.currencys.add(f);
        }
    }

    public Set<String> getCurrencys() {
        return this.currencys;
    }

    public void clearOrderby() {
        this.orderby.clear();
    }

    public void clearGroupby() {
        this.groupby.clear();
    }

    public void addGroupby(String ... fields) {
        for (String f : fields) {
            if (this.groupby.contains(f)) continue;
            this.groupby.add(f);
        }
    }

    public String[] getOrderby() {
        return this.orderby.toArray(new String[0]);
    }

    public String[] getSelectField() {
        return this.selector.toArray(new String[0]);
    }

    public void addFilter(String dimKey, String ... values) {
        this.filter.add((Pair<String, String[]>)Pair.onePair((Object)dimKey, (Object)values));
    }

    public void replaceOrAddFilter(String dimKey, String ... values) {
        boolean isReplace = false;
        for (int i = 0; i < this.filter.size(); ++i) {
            if (!dimKey.equals(this.filter.get((int)i).p1)) continue;
            this.filter.set(i, (Pair<String, String[]>)Pair.onePair((Object)this.filter.get((int)i).p1, (Object)values));
            isReplace = true;
            break;
        }
        if (!isReplace) {
            this.addFilter(dimKey, values);
        }
    }

    public List<Pair<String, String[]>> getFilters() {
        return this.filter;
    }

    public void addMeasures(String ... measures) {
        for (String m : measures) {
            if (this.measures.contains(m)) continue;
            this.measures.add(m);
        }
    }

    public String[] getMeasures() {
        return this.measures.toArray(new String[0]);
    }

    public void reset() {
        this.selector.clear();
        this.filter.clear();
        this.measures.clear();
    }

    public void checkSelf() {
        if (StringUtils.isEmpty((String)this._cubecatalog) || this.selector.isEmpty()) {
            throw new MDQueryException(String.format("SQLBuilder is not complete SQL:%s", ToStringHelper.deepToString((Object)this)));
        }
    }

    public int getTop() {
        return this.top;
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }

    public void setTop(int top) {
        this.top = top;
    }

    public MultiKeyMap getOrgCurrencyMap() {
        return this.orgCurrencyMap;
    }

    public void setOrgCurrencyMap(MultiKeyMap orgCurrencyMap) {
        this.orgCurrencyMap = orgCurrencyMap;
    }

    public void addAllCols(String ... fields) {
        for (String f : fields) {
            if (this.allCols.contains(f)) continue;
            this.allCols.add(f);
        }
    }

    public String[] getAllCols() {
        return this.allCols.toArray(new String[0]);
    }

    public boolean getMemberinAllCols(String number) {
        return this.allCols.contains(number);
    }

    public List<String> getNumbersAllCols() {
        return this.allCols.stream().map(s -> this.shortnumbermaps.get(s)).collect(Collectors.toList());
    }

    public void addPCOrgs(String ... fields) {
        for (String f : fields) {
            if (this.pcorgs.contains(f)) continue;
            this.pcorgs.add(f);
        }
    }

    public Set<String> getPCOrgs() {
        return this.pcorgs;
    }

    public Boolean getUseEcDcPcStr() {
        return this.useEcDcPcStr;
    }

    public void setUseEcDcPcStr(Boolean useEcDcPcStr) {
        this.useEcDcPcStr = useEcDcPcStr;
    }
}

