/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.business.sql.CellSetResultSet;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDColumn;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.util.CartesianUtil;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.common.util.exception.MDQueryException;

public class MDResultSet
implements IMDResultSet,
Serializable {
    private int cursorPos = 0;
    private int numRows = 0;
    private Row[] rows;
    private MDResultSetMetaData metaData;
    private String measure;
    private List<String> measures;
    private Map<MemberMeta, MemberMeta> memberMetaDic = new HashMap<MemberMeta, MemberMeta>();

    @Override
    public boolean next() {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new MDQueryException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    protected boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    @Override
    public void beforeFirst() {
        this.cursorPos = 0;
    }

    @Override
    public void populate(CellSetResultSet rs) {
        boolean isNotEmptyLazyFilter;
        List<String> list = rs.getMetaData();
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
        this.measure = rs.getMeasure();
        ArrayList<Row> rows2 = new ArrayList<Row>(10);
        Object[] values = new Object[rs.getMetaData().size()];
        boolean bl = isNotEmptyLazyFilter = !rs.getLazyFilters().isEmpty();
        while (rs.getOlapDataReader().next()) {
            Object v;
            rs.getOlapDataReader().getValues(values);
            if (values[0] == null && !rs.isIncludeNull() || (v = values[0]) != null && rs.isOnlyNumber() && !this.isNumber(v)) continue;
            Row row = new Row(this.metaData, this.memberMetaDic);
            int size = values.length;
            for (int i = 1; i < size; ++i) {
                row.addColumnValue(values[i]);
            }
            Object value = values[0];
            if (value instanceof String && String.valueOf(value).startsWith("/OADate")) {
                value = DateTimeUtils.formatDateToUTC((String)String.valueOf(value));
            }
            row.addMeasureValue(value);
            if (!this.isValidated(rs.getModelNum(), row, rs.getDataChecker())) continue;
            if (isNotEmptyLazyFilter) {
                Row row2 = row;
                if (!rs.getLazyFilters().entrySet().stream().allMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(f -> f.filter(row2.getString((String)entry.getKey()))))) continue;
            }
            rows2.add(row);
        }
        this.rows = rows2.toArray(new Row[0]);
        this.numRows = rows2.size();
    }

    public void makeup(SQLBuilder sql, List<String> carsdim) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> dims = Arrays.asList(sql.getSelectField());
        list.addAll(dims);
        list.addAll(Arrays.asList(sql.getMeasures()));
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
        this.measure = sql.getMeasures()[0];
        this.measures = Arrays.asList(sql.getMeasures());
        ArrayList makerows = new ArrayList(10);
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        sql.getFilters().forEach(f -> {
            if (carsdim.contains(f.p1)) {
                map.put(f.p1, (String[])f.p2);
            } else {
                map.put(f.p1, new String[]{((String[])f.p2)[0]});
            }
        });
        for (String string : dims) {
            if (map.containsKey(string)) continue;
            Map number2Node = (Map)MemberReader.getAllNodeByNumberFromCache((String)DimEntityNumEnum.getEntieyNumByNumber((String)string), (String)sql.getCubecatalog()).get(string);
            map.put(string, number2Node.keySet().toArray(new String[0]));
        }
        ArrayList mems = new ArrayList(dims.size());
        for (String dim : dims) {
            mems.add(map.get(dim));
        }
        List list2 = CartesianUtil.cartesianProduct((Object[][])((Object[][])mems.toArray((T[])new String[mems.size()][])));
        list2.forEach(r -> {
            Row row = new Row(this.metaData, this.memberMetaDic);
            r.forEach(row::addColumnValue);
            row.addMeasureValue("");
            makerows.add(row);
        });
        this.rows = makerows.toArray(new Row[0]);
        this.numRows = makerows.size();
    }

    private boolean isValidated(Row row, int entityIndex, int processIndex) {
        if (entityIndex == -1 || processIndex == -1) {
            return true;
        }
        String entity = row.getString(PresetConstant.ENTITY_DIM);
        String process = row.getString(PresetConstant.PROCESS_DIM);
        return OrgRelaProcessMembPool.isRelaProcess((String)process) && entity.contains("_") || !OrgRelaProcessMembPool.isRelaProcess((String)process) && !entity.contains("_");
    }

    private boolean isNumber(Object v) {
        return v == null ? false : v instanceof Number;
    }

    @Override
    public void merger(IMDResultSet rs) {
        if (rs == null || rs.isEmpty()) {
            return;
        }
        int rsSize = rs.getFetchSize();
        if (this.rows == null) {
            this.rows = new Row[0];
        }
        int size = this.rows.length + rsSize;
        Row[] mergerRows = new Row[size];
        System.arraycopy(this.rows, 0, mergerRows, 0, this.rows.length);
        int from = this.rows.length;
        rs.beforeFirst();
        while (rs.next()) {
            mergerRows[from++] = rs.getRow();
        }
        this.rows = mergerRows;
        this.numRows = this.rows.length;
    }

    @Override
    public void mergerReduce(IMDResultSet rs) {
        Map<String, Object> selfMap = this.asMap();
        Map<String, Object> otherMap = rs.asMap();
        otherMap.keySet().removeAll(selfMap.keySet());
        if (otherMap.isEmpty()) {
            return;
        }
        int size = this.rows.length + otherMap.size();
        Row[] mergerRows = new Row[size];
        System.arraycopy(this.rows, 0, mergerRows, 0, this.rows.length);
        int from = this.rows.length;
        for (Map.Entry<String, Object> entry : otherMap.entrySet()) {
            Row row = new Row(this.metaData, this.memberMetaDic);
            for (String memb : entry.getKey().split("\\|")) {
                row.addColumnValue(memb);
            }
            row.addMeasureValue(entry.getValue());
            mergerRows[from++] = row;
        }
        this.rows = mergerRows;
        this.numRows = this.rows.length;
        rs.beforeFirst();
    }

    public Map<String, Set<String>> getValidDim() {
        HashMap<String, Set<String>> kvMap = new HashMap<String, Set<String>>(16);
        this.beforeFirst();
        while (this.next()) {
            this.metaData.getMetaDatas().forEach(m -> {
                if (!m.getMdName().equals(this.measure)) {
                    if (!kvMap.containsKey(m.getMdName())) {
                        kvMap.put(m.getMdName(), new HashSet());
                    }
                    ((Set)kvMap.get(m.getMdName())).add(String.valueOf(this.getCurrRow().getOriginalValue(m.getMdName())));
                }
            });
        }
        this.beforeFirst();
        return kvMap;
    }

    public Set<List<String>> getValidDimensionComposition(Set<String> dimensionNubmers, Map<String, String> shortNumber2Number) {
        HashSet<List<String>> dimensionCompositions = new HashSet<List<String>>(16);
        this.beforeFirst();
        while (this.next()) {
            ArrayList singleDimensionComposition = new ArrayList();
            this.metaData.getMetaDatas().forEach(m -> {
                for (String dim : dimensionNubmers) {
                    if (!m.getMdName().equals(shortNumber2Number.get(dim))) continue;
                    singleDimensionComposition.add(String.format("%s.%s", dim, this.getCurrRow().getString(m.getMdName())));
                    break;
                }
            });
            dimensionCompositions.add(singleDimensionComposition);
        }
        this.beforeFirst();
        return dimensionCompositions;
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> kvMap = new HashMap<String, Object>(16);
        this.beforeFirst();
        ArrayList keys = new ArrayList(this.metaData.getMetaDatas().size());
        while (this.next()) {
            keys.clear();
            this.metaData.getMetaDatas().forEach(m -> {
                if (!m.getMdName().equals(this.measure)) {
                    keys.add(this.getCurrRow().getString(m.getMdName()));
                }
            });
            kvMap.put(String.join((CharSequence)"|", keys), this.getCurrRow().getOriginalValue(this.measure));
        }
        this.beforeFirst();
        return kvMap;
    }

    @Override
    public Map<String, Object> asMap(String joinSign, List<String> selectDims) {
        HashMap<String, Object> kvMap = new HashMap<String, Object>(16);
        this.beforeFirst();
        ArrayList keys = new ArrayList(selectDims.size());
        while (this.next()) {
            keys.clear();
            selectDims.forEach(s -> keys.add(this.getCurrRow().getString((String)s)));
            kvMap.put(String.join((CharSequence)joinSign, keys), this.getCurrRow().getOriginalValue(this.measure));
        }
        this.beforeFirst();
        return kvMap;
    }

    public void transVirtrual2RealEntity() {
        int index = this.metaData.getColIndex(PresetConstant.ENTITY_DIM);
        if (index == -1) {
            return;
        }
        MDColumn colum = this.metaData.getColumnMeta(PresetConstant.ENTITY_DIM);
        String entity = null;
        for (Row row : this.rows) {
            entity = row.getString(colum.getMdName());
            if (!entity.contains("_")) continue;
            row.replaceColumnValue(colum.getColIndex(), entity.split("_")[1]);
        }
    }

    public Map<String, List<String>> getRCDimMemberMap(List<String> selectDims) {
        HashMap<String, List<String>> exitDataMap = new HashMap<String, List<String>>(16);
        this.beforeFirst();
        while (this.next()) {
            selectDims.forEach(s -> {
                if (exitDataMap.get(s) == null) {
                    exitDataMap.put((String)s, new ArrayList(16));
                }
                String memNum = this.getCurrRow().getString((String)s);
                if (!((List)exitDataMap.get(s)).contains(memNum)) {
                    ((List)exitDataMap.get(s)).add(memNum);
                }
            });
        }
        this.beforeFirst();
        return exitDataMap;
    }

    @Override
    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    @Override
    public String getString(String colName) {
        this.checkCursor();
        return this.getCurrRow().getString(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkCursor();
        return this.getCurrRow().getOriginalValue(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkCursor();
        return this.getCurrRow().getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkCursor();
        return this.getCurrRow().getBigDecimal(colName);
    }

    @Override
    public int getInt(String colName) {
        this.checkCursor();
        return this.getCurrRow().getInt(colName);
    }

    protected void checkCursor() {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new MDQueryException("Invalid cursor position");
        }
    }

    private Row getCurrRow() {
        return this.rows[this.cursorPos - 1];
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public Row getRow() {
        return this.getCurrRow();
    }

    public int getCount() {
        return this.numRows;
    }

    @Override
    public MDResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() {
        this.rows = null;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == null || this.rows.length == 0;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public Map<String, Object> asMultiMeasureMap() {
        HashMap<String, Object> kvMap = new HashMap<String, Object>(16);
        this.beforeFirst();
        ArrayList keys = new ArrayList(this.metaData.getMetaDatas().size());
        while (this.next()) {
            keys.clear();
            this.metaData.getMetaDatas().forEach(m -> {
                if (!this.measures.contains(m.getMdName())) {
                    keys.add(this.getCurrRow().getString(m.getMdName()));
                }
            });
            ArrayList values = new ArrayList(16);
            this.measures.forEach(m -> values.add(this.getCurrRow().getOriginalValue((String)m)));
            kvMap.put(String.join((CharSequence)"|", keys), values);
        }
        this.beforeFirst();
        return kvMap;
    }

    public void populates(CellSetResultSet rs) {
        boolean isNotEmptyLazyFilter;
        List<String> list = rs.getMetaData();
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
        this.measures = rs.getMeasures();
        ArrayList<Row> rows2 = new ArrayList<Row>(10);
        Object[] values = new Object[rs.getMetaData().size()];
        boolean bl = isNotEmptyLazyFilter = !rs.getLazyFilters().isEmpty();
        while (rs.getOlapDataReader().next()) {
            int i;
            Object v;
            rs.getOlapDataReader().getValues(values);
            if (values[0] == null && !rs.isIncludeNull() || (v = values[0]) != null && rs.isOnlyNumber() && !this.isNumber(v)) continue;
            Row row = new Row(this.metaData, this.memberMetaDic);
            int size = values.length;
            for (i = this.measures.size(); i < size; ++i) {
                row.addColumnValue(values[i]);
            }
            for (i = 0; i < this.measures.size(); ++i) {
                Object value = values[i];
                if (this.measures.get(i) == FacTabFieldDefEnum.FIELD_MONEY.getField() && value instanceof String && String.valueOf(value).startsWith("/OADate")) {
                    value = DateTimeUtils.formatDateToUTC((String)String.valueOf(value));
                }
                row.addMeasureValue(value);
            }
            if (!this.isValidated(rs.getModelNum(), row, rs.getDataChecker())) continue;
            if (isNotEmptyLazyFilter) {
                Row row2 = row;
                if (!rs.getLazyFilters().entrySet().stream().allMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(f -> f.filter(row2.getString((String)entry.getKey()))))) continue;
            }
            rows2.add(row);
        }
        this.rows = rows2.toArray(new Row[0]);
        this.numRows = rows2.size();
    }

    public static class MemberMeta
    implements Serializable {
        private Object val;

        MemberMeta(Object v) {
            this.val = v;
        }

        Object get() {
            return this.val;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemberMeta) {
                MemberMeta oth = (MemberMeta)obj;
                return oth.toString().equals(this.toString());
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.val == null ? "" : this.val.toString();
        }
    }
}

