/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.sql.CellSetResultSet;
import kd.fi.bcm.business.sql.IMDResultSet;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class MDResultSetReader
implements Serializable,
IMDResultSet {
    private CellSetResultSet cs;
    private boolean hasNextRow = false;
    private Row row;
    private MDResultSetMetaData metaData;
    private Map<MDResultSet.MemberMeta, MDResultSet.MemberMeta> memberMetaDic = new HashMap<MDResultSet.MemberMeta, MDResultSet.MemberMeta>();

    @Override
    public boolean next() {
        this.hasNextRow = false;
        while (this.cs.getOlapDataReader().next()) {
            Object v;
            this.row = null;
            Object[] values = new Object[this.cs.getMetaData().size()];
            this.cs.getOlapDataReader().getValues(values);
            if (values[0] == null && !this.cs.isIncludeNull() || (v = values[0]) != null && this.cs.isOnlyNumber() && !this.isNumber(v)) continue;
            this.row = new Row(this.metaData, this.memberMetaDic);
            int size = values.length;
            for (int i = 1; i < size; ++i) {
                this.row.addColumnValue(values[i]);
            }
            Object value = values[0];
            if (value instanceof String && String.valueOf(value).startsWith("/OADate")) {
                value = DateTimeUtils.formatDateToUTC((String)String.valueOf(value));
            }
            this.row.addMeasureValue(value);
            if (!this.isValidated(this.cs.getModelNum(), this.row, this.cs.getDataChecker())) continue;
            this.hasNextRow = true;
            break;
        }
        return this.hasNextRow;
    }

    private boolean isNumber(Object v) {
        return v instanceof Number;
    }

    @Override
    public void beforeFirst() {
        this.notSupportException();
    }

    @Override
    public void populate(CellSetResultSet rs) {
        this.cs = rs;
        List<String> list = rs.getMetaData();
        this.metaData = new MDResultSetMetaData();
        list.forEach(c -> this.metaData.addColumnMeta((String)c));
    }

    @Override
    public int getFetchSize() {
        return (Integer)this.notSupportException();
    }

    private <T> T notSupportException() {
        throw new RuntimeException("not support operator");
    }

    private void checkRecordRead() {
        if (this.row == null) {
            throw new RuntimeException("not record to read");
        }
    }

    @Override
    public String getString(String colName) {
        this.checkRecordRead();
        return this.row.getString(colName);
    }

    @Override
    public Date getDate(String colName) {
        this.checkRecordRead();
        return this.row.getDate(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        this.checkRecordRead();
        return this.row.getBigDecimal(colName);
    }

    @Override
    public int getInt(String colName) {
        this.checkRecordRead();
        return this.row.getInt(colName);
    }

    @Override
    public Object getOriginalValue(String colName) {
        this.checkRecordRead();
        return this.row.getOriginalValue(colName);
    }

    @Override
    public Row getRow() {
        if (!this.hasNextRow) {
            throw new RuntimeException("cursor is last,not more record");
        }
        return this.row;
    }

    @Override
    public void close() {
        this.row = null;
        if (this.cs.getOlapDataReader() != null) {
            this.cs.getOlapDataReader().close();
        }
        if (this.cs.getConnection() != null) {
            this.cs.getConnection().Close();
        }
    }

    @Override
    public MDResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public boolean isEmpty() {
        return (Boolean)this.notSupportException();
    }

    @Override
    public Map<String, Object> asMap() {
        return (Map)this.notSupportException();
    }

    @Override
    public void merger(IMDResultSet rs) {
        this.notSupportException();
    }

    @Override
    public Map<String, Object> asMap(String joinSign, List<String> selectDims) {
        return (Map)this.notSupportException();
    }

    @Override
    public void mergerReduce(IMDResultSet rs) {
        this.notSupportException();
    }

    private boolean isValidated(Row row, int entityIndex, int processIndex) {
        if (entityIndex == -1 || processIndex == -1) {
            return true;
        }
        String entity = row.getString(PresetConstant.ENTITY_DIM);
        String process = row.getString(PresetConstant.PROCESS_DIM);
        return OrgRelaProcessMembPool.isRelaProcess((String)process) && entity.contains("_") || !OrgRelaProcessMembPool.isRelaProcess((String)process) && !entity.contains("_");
    }
}

