/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.sql.Row;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class MemberGroupKey
implements Serializable {
    public abstract Object getValue(int var1);

    public static MemberGroupKey create(int[] colIndexes, Row row) {
        Preconditions.checkNotNull((Object)colIndexes);
        Preconditions.checkNotNull((Object)row);
        if (colIndexes.length == 1) {
            return new SingleMemberGroupKey(colIndexes[0], row);
        }
        return new MultiMemberGroupKey(colIndexes, row);
    }

    public static MemberGroupKey create(List<Object> members) {
        Preconditions.checkNotNull(members);
        if (members.size() == 1) {
            return new SingleValueGroupKey(members.get(0));
        }
        return new MultiValueGroupKey(members);
    }

    private static final class MultiValueGroupKey
    extends AbstractMultiMemberGroupKey {
        private List<Object> _values;

        MultiValueGroupKey(List<Object> values) {
            this._values = values;
        }

        @Override
        protected int size() {
            return this._values.size();
        }

        @Override
        public Object getValue(int index) {
            return this._values.get(index);
        }
    }

    private static final class MultiMemberGroupKey
    extends AbstractMultiMemberGroupKey {
        private int[] _colIndexes;
        private Row _row;

        MultiMemberGroupKey(int[] colIndexes, Row row) {
            this._colIndexes = colIndexes;
            this._row = row;
        }

        @Override
        protected int size() {
            return this._colIndexes.length;
        }

        @Override
        public Object getValue(int index) {
            return this._row.getValue(this._colIndexes[index]);
        }
    }

    private static abstract class AbstractMultiMemberGroupKey
    extends MemberGroupKey {
        private AbstractMultiMemberGroupKey() {
        }

        protected abstract int size();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractMultiMemberGroupKey)) {
                return false;
            }
            AbstractMultiMemberGroupKey that = (AbstractMultiMemberGroupKey)o;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Object thisValue = this.getValue(i);
                Object thatValue = that.getValue(i);
                if (!(thisValue == null ? thatValue != null : !thisValue.equals(thatValue))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Object thisValue = this.getValue(i);
                int singleValueHashCode = thisValue == null ? 0 : thisValue.hashCode();
                result = 31 * result + singleValueHashCode;
            }
            return result;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Object thisValue = this.getValue(i);
                builder.append(thisValue);
            }
            return builder.toString();
        }
    }

    private static final class SingleValueGroupKey
    extends AbstractSingleMemberGroupKey {
        private Object _value;

        SingleValueGroupKey(Object value) {
            this._value = value;
        }

        @Override
        protected Object getValue() {
            return this._value;
        }
    }

    private static final class SingleMemberGroupKey
    extends AbstractSingleMemberGroupKey {
        private int _colIndex;
        private Row _row;

        SingleMemberGroupKey(int colIndex, Row row) {
            this._colIndex = colIndex;
            this._row = row;
        }

        @Override
        protected Object getValue() {
            return this._row.getValue(this._colIndex);
        }
    }

    private static abstract class AbstractSingleMemberGroupKey
    extends MemberGroupKey {
        private AbstractSingleMemberGroupKey() {
        }

        protected abstract Object getValue();

        @Override
        public Object getValue(int index) {
            if (index == 0) {
                return this.getValue();
            }
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u5f02\u5e38", (String)"MemberGroupKey_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractSingleMemberGroupKey)) {
                return false;
            }
            AbstractSingleMemberGroupKey that = (AbstractSingleMemberGroupKey)o;
            Object thisValue = this.getValue();
            Object thatValue = that.getValue();
            if (thisValue == null) {
                return thatValue == null;
            }
            return thisValue.equals(thatValue);
        }

        public int hashCode() {
            Object thisValue = this.getValue();
            return thisValue == null ? 0 : thisValue.hashCode();
        }

        public String toString() {
            Object value = this.getValue();
            return value == null ? null : value.toString();
        }
    }
}

