/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.common.enums.RangeEnum;

public class OrgScopeFilter {
    private String orgsign;
    private String scopeSign;

    public OrgScopeFilter(String orgsign, String scopeSign) {
        this.orgsign = orgsign;
        this.scopeSign = scopeSign;
    }

    public QFilter getFilter(long orgId) {
        StringBuilder sb;
        String[] nums;
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_entitymembertree", (String)"member.id,model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        long modelId = org.getLong("model.id");
        long memberid = org.getLong("member.id");
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id,longnumber,parent.id,isleaf", (QFilter[])new QFilter[]{new QFilter("member", "=", (Object)memberid)});
        ArrayList directParentIds = new ArrayList();
        ArrayList orgIds = new ArrayList();
        ArrayList unLeafLongnumbers = new ArrayList();
        ArrayList leafLongNumbers = new ArrayList();
        ArrayList longnumbers = new ArrayList();
        orgs.values().forEach(o -> longnumbers.add(o.getString("longnumber")));
        orgs.values().forEach(o -> {
            if (o.getBoolean("isleaf")) {
                leafLongNumbers.add(o.getString("longnumber"));
            } else {
                unLeafLongnumbers.add(o.getString("longnumber"));
            }
        });
        orgs.values().forEach(o -> directParentIds.add(o.getLong("parent.id")));
        orgs.values().forEach(o -> orgIds.add(o.getLong("id")));
        HashSet<String> leafParentLongNums = new HashSet<String>();
        HashSet<String> unLeafParentLongNums = new HashSet<String>();
        for (String ln : leafLongNumbers) {
            nums = ln.split("!");
            sb = new StringBuilder();
            for (String num : nums) {
                sb.append(num);
                leafParentLongNums.add(sb.toString());
                sb.append('!');
            }
        }
        for (String ln : unLeafLongnumbers) {
            nums = ln.split("!");
            sb = new StringBuilder();
            for (String num : nums) {
                sb.append(num);
                unLeafParentLongNums.add(sb.toString());
                sb.append('!');
            }
        }
        ArrayList levelOrgIds = new ArrayList();
        ArrayList leafParentIds = new ArrayList();
        ArrayList unLeafParentIds = new ArrayList();
        Map levelOrgs = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "in", directParentIds), new QFilter("id", "not in", orgIds)});
        Map leafParents = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("longnumber", "in", leafParentLongNums).and(new QFilter("longnumber", "not in", longnumbers))});
        Map unLeafParents = BusinessDataServiceHelper.loadFromCache((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("longnumber", "in", unLeafParentLongNums).and(new QFilter("longnumber", "not in", longnumbers))});
        levelOrgs.values().forEach(o -> levelOrgIds.add(o.getLong("id")));
        leafParents.values().forEach(o -> leafParentIds.add(o.getLong("id")));
        unLeafParents.values().forEach(o -> unLeafParentIds.add(o.getLong("id")));
        QFilter orgFilter = new QFilter(this.orgsign, "in", orgIds).and(new QFilter(this.scopeSign, "in", this.getOwnScope()));
        QFilter directFilter = new QFilter(this.orgsign, "in", directParentIds).and(new QFilter(this.scopeSign, "in", this.getDirectParentScope()));
        QFilter leafFilter = new QFilter(this.orgsign, "in", leafParentIds).and(new QFilter(this.scopeSign, "in", this.getLeafAllParentScope()));
        QFilter unleafFilter = new QFilter(this.orgsign, "in", unLeafParentIds).and(new QFilter(this.scopeSign, "in", this.getUnLeafAllParentScope()));
        QFilter levelFilter = new QFilter(this.orgsign, "in", levelOrgIds).and(new QFilter(this.scopeSign, "in", this.getLevelScope()));
        return orgFilter.or(directFilter).or(leafFilter).or(unleafFilter).or(levelFilter);
    }

    private List<Object> getOwnScope() {
        return Arrays.asList(RangeEnum.VALUE_10.getValue(), RangeEnum.VALUE_30.getValue(), RangeEnum.VALUE_50.getValue(), RangeEnum.VALUE_70.getValue());
    }

    private List<Object> getDirectParentScope() {
        return Arrays.asList(RangeEnum.VALUE_20.getValue(), RangeEnum.VALUE_30.getValue());
    }

    private List<Object> getLeafAllParentScope() {
        return Arrays.asList(RangeEnum.VALUE_40.getValue(), RangeEnum.VALUE_50.getValue(), RangeEnum.VALUE_90.getValue());
    }

    private List<Object> getUnLeafAllParentScope() {
        return Arrays.asList(RangeEnum.VALUE_40.getValue(), RangeEnum.VALUE_50.getValue(), RangeEnum.VALUE_110.getValue());
    }

    private List<Object> getLevelScope() {
        return Arrays.asList(RangeEnum.VALUE_60.getValue(), RangeEnum.VALUE_70.getValue());
    }
}

