/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql.util;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.SysMembConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.PeriodTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.QFBuilder;

public class QCfilterUtils {
    private static final int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];

    public static QFBuilder getFyAndPeriodFilter(String modelid, String yearId, String periodId, String type) {
        QFBuilder timeBuilder;
        block24: {
            String numLike;
            block26: {
                block25: {
                    timeBuilder = new QFBuilder();
                    DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)periodId)).toArray());
                    numLike = dy.getString("number");
                    if (numLike.startsWith("YD_D")) {
                        DynamicObject fy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)yearId)).toArray());
                        return QCfilterUtils.getFyAndPeriodFilterByYD(modelid, fy.getString("number"), numLike, type);
                    }
                    if (!PeriodTypeEnum.PRE.getIndex().equals(type)) break block25;
                    int realMaxPre = 0;
                    if (numLike.startsWith("M_M")) {
                        numLike = "M_M";
                        realMaxPre = 11;
                    } else if (numLike.startsWith("Q_Q")) {
                        numLike = "Q_Q";
                        realMaxPre = 3;
                    } else if (numLike.startsWith("HF_HF")) {
                        numLike = "HF_HF";
                        realMaxPre = 1;
                    }
                    DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, number,name", (QFilter[])new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelid)).add("number", "like", (Object)(numLike + "%")).toArray(), (String)"number");
                    String finalNumLike = numLike;
                    Map<String, Long> number2id = periods.stream().filter(e -> e.getString("number").startsWith(finalNumLike)).collect(Collectors.toMap(s -> s.getString("number"), s -> s.getLong("id")));
                    String modelnumber = MemberReader.findModelNumberById((Object)modelid);
                    String fynumber = MemberReader.findFyMemberById((String)modelnumber, (Long)LongUtil.toLong((Object)yearId)).getNumber();
                    String curperiod = MemberReader.findPeriodMemberById((String)modelnumber, (Long)LongUtil.toLong((Object)periodId)).getNumber();
                    for (int i = periods.size() - 1; i >= 0; --i) {
                        DynamicObject period = (DynamicObject)periods.get(i);
                        if (!periodId.equals(period.getString("id"))) continue;
                        if ("M_M".equals(numLike)) {
                            String[] lastMonthPeriod = PeriodUtils.getLastPeriodIncludeYear((String)modelnumber, (String)fynumber, (String)curperiod, (boolean)true);
                            String prePeriod = lastMonthPeriod[1];
                            String prePeriodFy = lastMonthPeriod[0];
                            if (StringUtils.isNotEmpty((CharSequence)prePeriod)) {
                                timeBuilder.add("period", "=", (Object)number2id.get(prePeriod));
                            } else {
                                timeBuilder.add("1", "=", (Object)0);
                            }
                            if (StringUtils.isEmpty((CharSequence)prePeriodFy)) {
                                timeBuilder.add("1", "=", (Object)0);
                            } else {
                                QFBuilder qf = new QFBuilder("number", "=", (Object)prePeriodFy).and("model", "=", (Object)LongUtil.toLong((Object)modelid));
                                DynamicObject prefy = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (String)"number,id", (QFilter[])qf.toArray());
                                timeBuilder.add("fy", "=", (Object)prefy.getLong("id"));
                            }
                        } else {
                            QFBuilder qf = new QFBuilder("model", "=", (Object)LongUtil.toLong((Object)modelid)).and("isleaf", "=", (Object)"1");
                            qf.and(new QFBuilder("number", "not in", (Object)Lists.newArrayList((Object[])new String[]{"LastYear", "CurrentYear"})));
                            DynamicObjectCollection fys = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"number,id", (QFilter[])qf.toArray(), (String)"dseq");
                            List ids = fys.stream().map(s -> s.getString("id")).collect(Collectors.toList());
                            int index = ids.indexOf(yearId);
                            if (i == 0) {
                                timeBuilder.add("fy", "=", (Object)LongUtil.toLong((Object)(index == 0 ? "0" : ids.get(index - 1))));
                                timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(realMaxPre)).getLong("id"));
                            } else {
                                timeBuilder.add("fy", "=", (Object)LongUtil.toLong((Object)yearId));
                                timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(i > realMaxPre ? realMaxPre - 1 : i - 1)).getLong("id"));
                            }
                        }
                        break block24;
                    }
                    break block24;
                }
                if (!PeriodTypeEnum.CURRENT.getIndex().equals(type)) break block26;
                timeBuilder.add("fy", "=", (Object)LongUtil.toLong((Object)yearId));
                timeBuilder.add("period", "=", (Object)LongUtil.toLong((Object)periodId));
                break block24;
            }
            if (!PeriodTypeEnum.NEXT.getIndex().equals(type)) break block24;
            if (numLike.startsWith("M_M")) {
                numLike = "M_M";
            } else if (numLike.startsWith("Q_Q")) {
                numLike = "Q_Q";
            } else if (numLike.startsWith("HF_HF")) {
                numLike = "HF_HF";
            }
            QFilter periodFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)periodId));
            DynamicObject period = QueryServiceHelper.queryOne((String)"bcm_periodmembertree", (String)"level, parent, number", (QFilter[])new QFilter[]{periodFilter});
            int level = period.getInt("level");
            QFilter periodModelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
            QFilter periodLevelFilter = new QFilter("level", "=", (Object)level);
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, number", (QFilter[])new QFilter[]{periodModelFilter, periodLevelFilter}, (String)"longNumber");
            block1: for (int i = 0; i <= periods.size() - 1; ++i) {
                period = (DynamicObject)periods.get(i);
                if (!period.getString("number").startsWith(numLike) || !periodId.equals(period.getString("id"))) continue;
                if (i != periods.size() - 1) {
                    timeBuilder.add("fy", "=", (Object)LongUtil.toLong((Object)yearId));
                    timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(i + 1)).getLong("id"));
                    break;
                }
                timeBuilder.add("period", "=", (Object)((DynamicObject)periods.get(0)).getLong("id"));
                QFilter fyFilter = new QFilter("id", "=", (Object)LongUtil.toLong((Object)yearId));
                DynamicObject fy = QueryServiceHelper.queryOne((String)"bcm_fymembertree", (String)"level", (QFilter[])new QFilter[]{fyFilter});
                level = fy.getInt("level");
                QFilter fyModelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelid));
                QFilter fyLevelFilter = new QFilter("level", "=", (Object)level);
                DynamicObjectCollection fys = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id", (QFilter[])new QFilter[]{fyModelFilter, fyLevelFilter}, (String)"longNumber");
                for (int j = 0; j <= fys.size() - 1; ++j) {
                    fy = (DynamicObject)fys.get(j);
                    if (!yearId.equals(fy.getString("id"))) continue;
                    if (j != fys.size() - 1) {
                        timeBuilder.add("fy", "=", (Object)((DynamicObject)fys.get(j + 1)).getLong("id"));
                        continue block1;
                    }
                    timeBuilder.add("1", "=", (Object)0);
                }
            }
        }
        return timeBuilder;
    }

    public static QFBuilder getFyAndPeriodFilterByYD(String modelid, String yearnum, String periodnum, String type) {
        for (int i = 0; i < SysMembConstant.dayofMonth.size(); ++i) {
            QCfilterUtils.dayofMonth[i] = (Integer)SysMembConstant.dayofMonth.get(i);
        }
        QFBuilder timeBuilder = new QFBuilder();
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"number", (QFilter[])new QFBuilder("id", "=", (Object)LongUtil.toLong((Object)modelid)).toArray());
        String[] yearperiod = new String[2];
        if (PeriodTypeEnum.PRE.getIndex().equals(type)) {
            yearperiod = PeriodUtils.getLastPeriodIncludeYear((String)model.getString("number"), (String)yearnum, (String)periodnum, (boolean)false);
        } else if (PeriodTypeEnum.CURRENT.getIndex().equals(type)) {
            yearperiod[0] = yearnum;
            yearperiod[1] = periodnum;
        } else if (PeriodTypeEnum.NEXT.getIndex().equals(type)) {
            int mouth = Integer.parseInt(periodnum.substring(0, 2));
            int day = Integer.parseInt(periodnum.substring(2));
            int year = Integer.parseInt(yearnum.split("FY")[1]);
            if (++day > dayofMonth[mouth]) {
                day = 1;
                if (++mouth > 12) {
                    mouth = 1;
                    ++year;
                }
            }
            yearperiod[0] = "FY" + year;
            yearperiod[1] = String.format("%02d%02d", mouth, day);
        }
        DynamicObject year = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_fymembertree", (String)"number", (QFilter[])new QFBuilder("number", "=", (Object)yearperiod[0]).add("model", "=", (Object)LongUtil.toLong((Object)modelid)).toArray());
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_periodmembertree", (String)"number", (QFilter[])new QFBuilder("number", "=", (Object)yearperiod[1]).add("model", "=", (Object)LongUtil.toLong((Object)modelid)).toArray());
        if (year == null || period == null) {
            timeBuilder.add("1", "=", (Object)0);
        } else {
            timeBuilder.add("period", "=", period.get("id"));
            timeBuilder.add("fy", "=", year.get("id"));
        }
        return timeBuilder;
    }

    public static String[] getNextPeriod(String modelid, String yearId, String periodId, String type) {
        String[] nextPeriod = new String[2];
        QFBuilder builder = QCfilterUtils.getFyAndPeriodFilter(modelid, yearId, periodId, type);
        QFilter[] result = builder.toArray();
        if (result.length == 0) {
            return null;
        }
        for (QFilter qFilter : result) {
            if ("1".equals(qFilter.getProperty())) {
                return null;
            }
            if ("period".equals(qFilter.getProperty())) {
                nextPeriod[1] = qFilter.getValue().toString();
                continue;
            }
            if (!"fy".equals(qFilter.getProperty())) continue;
            nextPeriod[0] = qFilter.getValue().toString();
        }
        return nextPeriod;
    }

    private static DynamicObjectCollection getDynamicObjectCollectionByLevel(String modelId, int level, String entity) {
        QFilter periodModelFilter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter periodLevelFilter = new QFilter("level", "=", (Object)level);
        return QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{periodModelFilter, periodLevelFilter}, (String)"longNumber");
    }

    public static DynamicObject getYearOrPeriod(String modelId, DynamicObject dy, String entity, String type) {
        if (PeriodTypeEnum.CURRENT.getIndex().equals(type)) {
            return dy;
        }
        Long entityId = dy.getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)entityId);
        DynamicObject onedy = QueryServiceHelper.queryOne((String)entity, (String)"level", (QFilter[])new QFilter[]{filter});
        int level = onedy.getInt("level");
        DynamicObjectCollection colls = QCfilterUtils.getDynamicObjectCollectionByLevel(modelId, level, entity);
        for (int i = colls.size() - 1; i >= 0; --i) {
            if (PeriodTypeEnum.PRE.getIndex().equals(type) && i != 0) {
                if (entityId.longValue() != ((DynamicObject)colls.get(i)).getLong("id")) continue;
                return (DynamicObject)colls.get(i - 1);
            }
            if (!PeriodTypeEnum.NEXT.getIndex().equals(type) || i == colls.size() - 1 || !entityId.equals(((DynamicObject)colls.get(i)).getLong("id"))) continue;
            return (DynamicObject)colls.get(i + 1);
        }
        return null;
    }

    public static Map<String, DynamicObject> getYearAndPeriod(String modelId, DynamicObject year, DynamicObject period, String type) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (period == null) {
            return map;
        }
        DynamicObject newPeriod = QCfilterUtils.getYearOrPeriod(modelId, period, "bcm_periodmembertree", type);
        if (newPeriod != null) {
            map.put("bcm_fymembertree", year);
            map.put("bcm_periodmembertree", newPeriod);
            return map;
        }
        DynamicObject newYear = QCfilterUtils.getYearOrPeriod(modelId, year, "bcm_fymembertree", type);
        if (newYear != null) {
            map.put("bcm_fymembertree", newYear);
            DynamicObjectCollection periods = QCfilterUtils.getDynamicObjectCollectionByLevel(modelId, period.getInt("level"), "bcm_periodmembertree");
            if (PeriodTypeEnum.PRE.getIndex().equals(type)) {
                map.put("bcm_periodmembertree", (DynamicObject)periods.get(periods.size() - 1));
            } else if (PeriodTypeEnum.NEXT.getIndex().equals(type)) {
                map.put("bcm_periodmembertree", (DynamicObject)periods.get(0));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u8d22\u5e74\u3002", (String)"QCfilterUtils_0", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return map;
    }
}

