/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.sql.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.util.StringUtils;
import kd.fi.bcm.spread.common.util.exception.IllegalConversionException;

public class TypeConversionUtils {
    public static String objToString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
            return null;
        }
        try {
            if (obj instanceof Double) {
                return BigDecimal.valueOf((Double)obj);
            }
            return new BigDecimal(obj.toString());
        }
        catch (RuntimeException ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException(String.format("[%s] NumberFormatException\uff1a", obj) + ex.getMessage());
            illegalConversionException.initCause((Throwable)ex);
            throw illegalConversionException;
        }
    }

    public static int objToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? 1 : 0;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).ordinal();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (RuntimeException ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException(String.format("[%s] NumberFormatException\uff1a", obj) + ex.getMessage());
            illegalConversionException.initCause((Throwable)ex);
            throw illegalConversionException;
        }
    }

    public static Date objToDate(Object obj) {
        return kd.fi.bcm.spread.common.util.TypeConversionUtils.objToDate((Object)obj);
    }
}

