/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.task;

import com.google.common.collect.Lists;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.TaskTypeEnum;

public class MyTaskServiceHelper {
    public static String getSelectFields() {
        return "id";
    }

    public static String getDetailTaskSelectFields() {
        ArrayList<String> selectors = new ArrayList<String>(20);
        selectors.add("id");
        selectors.add("entity");
        selectors.add("entity.id");
        selectors.add("entity.name");
        selectors.add("entity.longnumber");
        selectors.add("entity.level");
        selectors.add("entity.dseq");
        selectors.add("entity.currency");
        selectors.add("entity.currency.number");
        selectors.add("currency.id");
        selectors.add("currency.number");
        selectors.add("reporttask");
        selectors.add("reporttask.name");
        selectors.add("reporttask.number as tasknum");
        selectors.add("reporttask.taskcatalog.id");
        selectors.add("template");
        selectors.add("template.number as tempNum");
        selectors.add("template.name as tempName");
        selectors.add("model");
        selectors.add("fy.name as fyname");
        selectors.add("period.name as periodname");
        selectors.add("scenario.name as scenarioname");
        selectors.add("fy.id as fyid");
        selectors.add("period.id as periodid");
        selectors.add("scenario.id as scenarioid");
        selectors.add("tasktype");
        selectors.add("taskstatus");
        selectors.add("modifier.name as modifier");
        selectors.add("modifytime");
        selectors.add("reportstatus");
        return String.join((CharSequence)",", selectors);
    }

    public static String getTaskSelectFields() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("endtime");
        selectors.add("warningbegintime");
        selectors.add("number");
        selectors.add("name");
        selectors.add("parent");
        selectors.add("tasktype");
        selectors.add("kseq");
        selectors.add("taskcatalog.id");
        return String.join((CharSequence)",", selectors);
    }

    public static List<DynamicObject> getOverTaskNum(String userId, String[] type) {
        QFilter filter3 = new QFilter("endtime", "<", (Object)MyTaskServiceHelper.getTodayDate());
        QFilter[] filters = new QFilter[]{filter3};
        List<DynamicObject> list = MyTaskServiceHelper.getDetailTaskByUser(userId, type, filters, "0");
        return list;
    }

    public static int getOverLeafTaskNum(String userId, String[] type) {
        List<DynamicObject> list = MyTaskServiceHelper.getOverTaskNum(userId, new String[]{"3", "5"});
        return MyTaskServiceHelper.getLeafTaskNum(list);
    }

    public static List<DynamicObject> getDueTaskNum(String userId, String[] type) {
        QFilter filter2 = new QFilter("warningbegintype", "!=", (Object)0);
        QFilter filter3 = new QFilter("warningbegintime", "<=", (Object)MyTaskServiceHelper.getTodayDate());
        QFilter filter4 = new QFilter("endtime", ">=", (Object)MyTaskServiceHelper.getTodayDate());
        QFilter[] filters = new QFilter[]{filter2, filter3, filter4};
        List<DynamicObject> list = MyTaskServiceHelper.getDetailTaskByUser(userId, type, filters, "0");
        return list;
    }

    public static int getDueLeafTaskNum(String userId, String[] type) {
        List<DynamicObject> list = MyTaskServiceHelper.getDueTaskNum(userId, new String[]{"3", "5"});
        return MyTaskServiceHelper.getLeafTaskNum(list);
    }

    public static List<DynamicObject> getPendingTaskNum(String userId, String[] type) {
        List<DynamicObject> list = MyTaskServiceHelper.getDetailTaskByUser(userId, type, null, "0");
        return list;
    }

    public static List<DynamicObject> getDoneTaskNum(String userId, String[] type) {
        List<DynamicObject> list = MyTaskServiceHelper.getDetailTaskByUser(userId, type, null, "1");
        return list;
    }

    public static List<DynamicObject> getALLTaskNum(String userId, String[] type) {
        List<DynamicObject> list = MyTaskServiceHelper.getDetailTaskByUser(userId, type, null, null);
        return list;
    }

    public static List<DynamicObject> getDetailTaskByUser(String userId, String[] type, QFilter[] qFilters, String status) {
        QFilter[] filters;
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        List<DynamicObject> tasklist = MyTaskServiceHelper.getTaskByUser(userId, qFilters, type);
        ArrayList tls = Lists.newArrayListWithCapacity((int)tasklist.size());
        tasklist.forEach(p -> tls.add(p.getLong("id")));
        QFilter filter1 = new QFilter("reporttask", "in", (Object)tls);
        QFilter filter2 = new QFilter("tasktype", "=", (Object)String.valueOf(TaskTypeEnum.REPORT_UNIT.getValue()));
        if (status != null) {
            QFilter filter3 = new QFilter("taskstatus", "=", (Object)status);
            filters = new QFilter[]{filter1, filter2, filter3};
        } else {
            filters = new QFilter[]{filter1, filter2};
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_taskstatus", (String)MyTaskServiceHelper.getDetailTaskSelectFields(), (QFilter[])filters, (String)"entity.level,entity.dseq");
        if (doc != null) {
            list.addAll(doc);
        }
        return list;
    }

    public static int getLeafTaskNum(List<DynamicObject> list) {
        HashMap<String, Long> tasknum = new HashMap<String, Long>(list.size());
        for (DynamicObject obj : list) {
            tasknum.put(obj.get("reporttask") + "_" + obj.get("entity"), 0L);
        }
        return tasknum.size();
    }

    public static List<DynamicObject> getTaskByUser(String userId, QFilter[] qFilters, String[] type) {
        DynamicObjectCollection doc = MyTaskServiceHelper.getTaskByUser(userId, qFilters, type, null, null);
        int size = Objects.nonNull(doc) ? doc.size() : 0;
        ArrayList list = Lists.newArrayListWithCapacity((int)size);
        if (doc != null && doc.size() > 0) {
            doc.forEach(obj -> list.add(obj));
        }
        return list;
    }

    public static DynamicObjectCollection getTaskByUser(String userId, QFilter[] qFilters, String[] type, String selectFields, String order) {
        QFilter[] newQf;
        List<Long> tcls = MyTaskServiceHelper.getTaskCataLogByUser(userId);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = MyTaskServiceHelper.getSelectFields();
        }
        QFilter filter = new QFilter("taskcatalog", "in", tcls);
        QFilter filter2 = type.length == 0 ? new QFilter("tasktype", "!=", (Object)"-1") : new QFilter("tasktype", "in", Arrays.asList(type));
        if (qFilters != null && qFilters.length > 0) {
            newQf = new QFilter[qFilters.length + 2];
            System.arraycopy(qFilters, 0, newQf, 0, qFilters.length);
            newQf[newQf.length - 1] = filter;
            newQf[newQf.length - 2] = filter2;
        } else {
            newQf = new QFilter[]{filter, filter2};
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"MyTaskServiceHelper", (String)"bcm_taskconfig", (String)selectFields, (QFilter[])newQf, (String)order);
        return doc;
    }

    public static DynamicObject[] getTaskByUser4Union(String userId, QFilter[] qFilters, String[] type, String selectFields, String order) {
        QFilter[] filters;
        List<Long> tcls = MyTaskServiceHelper.getTaskCataLogByUser(userId);
        if (StringUtils.isEmpty((CharSequence)selectFields)) {
            selectFields = MyTaskServiceHelper.getSelectFields();
        }
        QFilter filter = new QFilter("taskcatalog", "in", tcls);
        QFilter filter2 = type.length == 0 ? new QFilter("tasktype", "!=", (Object)"-1") : new QFilter("tasktype", "in", Arrays.asList(type));
        if (qFilters != null && qFilters.length > 0) {
            filters = new QFilter[qFilters.length + 2];
            for (int i = 0; i < qFilters.length; ++i) {
                System.arraycopy(qFilters, 0, filters, 0, qFilters.length);
            }
            filters[filters.length - 1] = filter;
            filters[filters.length - 2] = filter2;
        } else {
            filters = new QFilter[]{filter, filter2};
        }
        DynamicObject[] taskColl = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)selectFields, (QFilter[])filters, (String)order);
        return taskColl;
    }

    public static List<Long> getTaskCataLogByUser(String userId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        List<Long> userGroups = MyTaskServiceHelper.getUserGroupByUser(userId);
        String selectFields = "taskcatalog";
        userGroups.add(Long.valueOf(userId));
        QFilter filter3 = new QFilter("userdisentry.eusers", "in", userGroups);
        QFilter[] filters = new QFilter[]{filter3};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdistribute", (String)selectFields, (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            doc.forEach(obj -> ids.add(obj.getLong("taskcatalog")));
        }
        return ids;
    }

    public static List<Long> getTaskCataLogByUserAndApplication(String userId, ApplicationTypeEnum app) {
        ArrayList<Long> ids = new ArrayList<Long>();
        List<Long> userGroups = MyTaskServiceHelper.getUserGroupByUser(userId);
        String selectFields = "taskcatalog";
        userGroups.add(Long.valueOf(userId));
        QFilter filter3 = new QFilter("userdisentry.eusers", "in", userGroups);
        if (app == ApplicationTypeEnum.EB) {
            filter3.and("model.reporttype", "=", (Object)app.getOIndex());
        } else {
            filter3.and("model.reporttype", "!=", (Object)ApplicationTypeEnum.EB.getOIndex());
        }
        QFilter[] filters = new QFilter[]{filter3};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_userdistribute", (String)selectFields, (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            doc.forEach(obj -> ids.add(obj.getLong("taskcatalog")));
        }
        return ids;
    }

    public static List<Long> getUserGroupByUser(String userId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        String selectFields = "usergroup";
        QFilter filter = new QFilter("user", "=", (Object)Long.valueOf(userId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)selectFields, (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            doc.forEach(obj -> ids.add(obj.getLong("usergroup")));
        }
        return ids;
    }

    public static List<Long> getEntityPerByUser(String userId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        return ids;
    }

    private static Date getTodayDate() {
        Date today = new Date(System.currentTimeMillis());
        return today;
    }

    public static DynamicObjectCollection getEntityName(String entity, Object[] ids) {
        String selectFields = "id,name";
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters);
        if (doc != null && doc.size() > 0) {
            return doc;
        }
        return null;
    }

    private static void queryAllUser(Set<Long> userIdSet, String className) {
        QFilter filter = new QFilter("type", "=", (Object)1);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)"bcm_userdistribute", (String)"id", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject[] oo;
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DynamicObject dd : dcs) {
                ids.add(dd.getLong("id"));
            }
            for (DynamicObject obj : oo = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_userdistribute"))) {
                DynamicObjectCollection dcss = obj.getDynamicObjectCollection("userentry");
                for (DynamicObject dy : dcss) {
                    userIdSet.add(dy.getLong("user.id"));
                }
            }
        }
    }

    private static void queryAllGroupUser(Set<Long> userIdSet, String className) {
        QFilter filter = new QFilter("type", "=", (Object)2);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)"bcm_userdistribute", (String)"id", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject dy : dcs) {
                userIdSet.add(dy.getLong("id"));
            }
        }
    }

    public static String getTaskParamSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("year");
        selectors.add("period");
        selectors.add("currency");
        selectors.add("scenario");
        return String.join((CharSequence)",", selectors);
    }

    public static String getTaskParamNameSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("period.name,period.dimension.name");
        selectors.add("year.name,year.dimension.name");
        selectors.add("currency.name,currency.dimension.name");
        selectors.add("scenario.name,scenario.dimension.name");
        return String.join((CharSequence)",", selectors);
    }

    public static String getTaskParamAllSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("year.number,year.id,year.name");
        selectors.add("period.number,period.id,period.name");
        selectors.add("currency.number,currency.id,currency.name");
        selectors.add("scenario.number,scenario.id,scenario.name");
        selectors.add("taskcatalog.id");
        return String.join((CharSequence)",", selectors);
    }

    public static String getTaskParamMemAndDimSelector() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("taskcatalog");
        selectors.add("year,year.dimension");
        selectors.add("period,period.dimension");
        selectors.add("currency,currency.number,currency.dimension");
        selectors.add("scenario,scenario.dimension");
        return String.join((CharSequence)",", selectors);
    }
}

