/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.task;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.common.util.LongUtil;

public class TaskUtil {
    private static final String[] str = new String[]{"M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06", "M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12"};
    private static final String[] quarterStr = new String[]{"M_Q1", "M_Q2", "M_Q3", "M_Q4"};
    private static final String[] halfStr = new String[]{"M_HF1", "M_HF2"};

    public static long queryParentId(long id, String entityId, String className) {
        long parentId = 0L;
        String selectFields = "parent";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entityId, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            parentId = ((DynamicObject)dcs.get(0)).getLong("parent.id");
            return parentId;
        }
        return 0L;
    }

    public static int getMaxDSeq(long id, String entiryName, String className) {
        QFilter fdimenId = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entiryName, (String)"kseq", (QFilter[])filters, (String)"kseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 0;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("kseq");
        }
        return 0;
    }

    public static void initNewDimensionDyObject(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)tx.getUserId());
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
    }

    public static void initUpdateDimensionDyObject(DynamicObject dy) {
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date modifytime = Date.from(instant);
        dy.set("modifytime", (Object)modifytime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        user.set("id", (Object)tx.getUserId());
        dy.set("modifier", (Object)user);
    }

    public static String queryLongNum(long id, String entityId, String className) {
        String longNumber = "";
        String selectFields = "longnumber";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)className, (String)entityId, (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            longNumber = ((DynamicObject)dcs.get(0)).getString("longnumber");
            return longNumber;
        }
        return "";
    }

    public static DynamicObject UpdateParentIsLeaf(long id, String entityName, String className) {
        QFilter filter2;
        long parentId = TaskUtil.queryParentId(id, entityName, className);
        QFilter filter = new QFilter("id", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{filter, filter2 = new QFilter("isleaf", "=", (Object)"1")};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            filter = new QFilter("id", "=", (Object)parentId);
            filters = new QFilter[]{filter};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"isleaf", (QFilter[])filters);
            dynamicObject.set("isleaf", (Object)"0");
            return dynamicObject;
        }
        return null;
    }

    public static Date queryStartTime(long id, String classNmae) {
        String selectFields = "starttime";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)classNmae, (String)"bcm_taskconfig", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getDate("starttime");
        }
        return null;
    }

    public static Date queryEndTime(long id, String classNmae) {
        String selectFields = "endtime";
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)classNmae, (String)"bcm_taskconfig", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() == 1) {
            return ((DynamicObject)dcs.get(0)).getDate("endtime");
        }
        return null;
    }

    public static DynamicObjectCollection queryPreTask(long id, String classNmae) {
        String selectFields = "taskforpre";
        QFilter filter = new QFilter("taskconfig.id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)classNmae, (String)"bcm_taskforpre", (String)selectFields, (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() > 0) {
            return dcs;
        }
        return null;
    }

    public static boolean isCirclePre(long id, long preId, String className) {
        Iterator iterator;
        DynamicObjectCollection preToPreIds = TaskUtil.queryPreTask(preId, className);
        if (preToPreIds != null && (iterator = preToPreIds.iterator()).hasNext()) {
            DynamicObject preToPre = (DynamicObject)iterator.next();
            long preToPreId = preToPre.getLong("taskforpre");
            if (id == 0L) {
                return false;
            }
            if (preToPreId == 0L) {
                return false;
            }
            if (preToPreId == id) {
                return true;
            }
            return TaskUtil.isCirclePre(id, preToPreId, className);
        }
        return false;
    }

    public static Date getNeedTime(int hour, int minute, int second, int addDay, int ... args) {
        Calendar calendar = Calendar.getInstance();
        if (addDay != 0) {
            calendar.add(5, addDay);
        }
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        if (args.length == 1) {
            calendar.set(14, args[0]);
        }
        return calendar.getTime();
    }

    public static Object[] getTaskTem(long id) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_tasktem", (String)"template", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("template");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static Object[] getTaskForPre(long id) {
        QFilter filter = new QFilter("taskconfig.id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"taskforpre", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("taskforpre");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static Object[] getTaskTemEntryId(long id) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_tasktem", (String)"id", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("id");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static Object[] getTaskForPreEntryId(long id) {
        QFilter filter = new QFilter("taskconfig.id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"id", (QFilter[])filters);
        if (dcs != null && dcs.size() > 0) {
            Object[] objs = new Object[dcs.size()];
            int i = 0;
            for (DynamicObject dy : dcs) {
                objs[i] = dy.getLong("id");
                ++i;
            }
            return objs;
        }
        return null;
    }

    public static int compareDate(Date date1, Date date2) {
        Calendar cal1 = TaskUtil.getCalendar(date1);
        Calendar cal2 = TaskUtil.getCalendar(date2);
        return cal1.compareTo(cal2);
    }

    public static Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Date getLastDayOfMonth(Integer year, Integer month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, -1);
        calendar.roll(5, 1);
        return calendar.getTime();
    }

    public static String getNextPeriod(String currentPeriod) {
        int i;
        boolean flag = false;
        for (i = 0; i < halfStr.length; ++i) {
            flag = halfStr[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, halfStr);
        }
        for (i = 0; i < quarterStr.length; ++i) {
            flag = quarterStr[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, quarterStr);
        }
        for (i = 0; i < str.length; ++i) {
            flag = str[i].equals(currentPeriod);
            if (!flag) continue;
            return TaskUtil.getNextString(i, str);
        }
        return "";
    }

    public static String getNextString(int index, String[] strs) {
        if (index == strs.length - 1) {
            return "year" + strs[0];
        }
        return strs[++index];
    }

    public static DynamicObject getIdByNumAndModel(String number, long modelid) {
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter1, filter2});
        if (dy != null) {
            return dy;
        }
        return null;
    }

    public static String getParentLongNumber(String longNumber) {
        int index = longNumber.lastIndexOf(46);
        String parentLongNumber = longNumber.substring(0, index);
        return parentLongNumber;
    }

    public static void assembleSysField(DynamicObject dy) {
        dy.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
        dy.set("creator", (Object)RequestContext.get().getUserId());
        dy.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
        dy.set("modifier", (Object)RequestContext.get().getUserId());
    }

    public static String getSeriaNextNumber(String modelid) {
        StringBuilder sb = new StringBuilder();
        QFilter filter = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelid));
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_taskcatalog", (String)"number", (QFilter[])new QFilter[]{filter}, (String)"number desc", (int)1);
        if (dys != null && dys.length > 0) {
            int i;
            sb.append("TL");
            sb.append(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            String number = dys[0].getString("number");
            int intNum = 1;
            String cs = number.substring(10, number.length());
            StringBuilder newSerNum = new StringBuilder();
            for (i = 0; i < 4; ++i) {
                if ("0".equals(cs.substring(i, i + 1))) continue;
                for (int j = i; j < 4; ++j) {
                    newSerNum.append(cs.substring(j, j + 1));
                }
                break;
            }
            intNum += Integer.parseInt(newSerNum.toString());
            for (i = 0; i < 4 - String.valueOf(intNum).length(); ++i) {
                sb.append('0');
            }
            sb.append(intNum);
        } else {
            sb.append("TL");
            sb.append(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            sb.append("0001");
        }
        return sb.toString();
    }
}

