/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.MergeStatusMsg;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum MergeStatusEnum {
    COL_FLOWSTATUS("1", "flowstatus", new MultiLangEnumBridge("\u9ed8\u8ba4\u5e01\u6d41\u7a0b\u72b6\u6001", "MergeStatusEnum_1", "fi-bcm-business"), new HashMap(4){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.UNDONE);
            this.put("C", MergeStatusMsg.SUBMIT);
        }
    }),
    COL_PCFLOWSTATUS("2", "pcflowstatus", new MultiLangEnumBridge("\u6298\u7b97\u5e01\u6d41\u7a0b\u72b6\u6001", "MergeStatusEnum_2", "fi-bcm-business"), new HashMap(4){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.UNDONE);
            this.put("C", MergeStatusMsg.SUBMIT);
        }
    }),
    COL_ADJUSTSTATUS("3", "adjuststatus", new MultiLangEnumBridge("\u8c03\u6574\u5206\u5f55\u72b6\u6001", "MergeStatusEnum_3", "fi-bcm-business"), new HashMap(4){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("0", MergeStatusMsg.AUDIT);
            this.put("1", MergeStatusMsg.PART_AUDIT);
        }
    }),
    COL_CALCULATESTATUS("4", "calculatestatus", new MultiLangEnumBridge("\u8ba1\u7b97\u72b6\u6001", "MergeStatusEnum_4", "fi-bcm-business"), new HashMap(8){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("A", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.CALC);
            this.put("C", MergeStatusMsg.FINISH);
            this.put("Z", MergeStatusMsg.CALCING);
            this.put("F", MergeStatusMsg.CHANGE);
            this.put("E", MergeStatusMsg.FAIL);
        }
    }),
    COL_PCCALCULATESTATUS("5", "pccalculatestatus", new MultiLangEnumBridge("\u6298\u7b97\u72b6\u6001", "MergeStatusEnum_5", "fi-bcm-business"), new HashMap(8){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("A", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.PC_CALC);
            this.put("C", MergeStatusMsg.FINISH);
            this.put("Z", MergeStatusMsg.PC_CALCING);
            this.put("F", MergeStatusMsg.CHANGE);
            this.put("E", MergeStatusMsg.FAIL);
        }
    }),
    COL_CHKSTATUS("6", "chkstatus", new MultiLangEnumBridge("\u6821\u9a8c\u7ed3\u679c", "MergeStatusEnum_6", "fi-bcm-business"), new HashMap(8){
        {
            super(x0);
            this.put("def", MergeStatusMsg.UNDONE);
            this.put("A", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.NOT_CHK);
            this.put("C", MergeStatusMsg.PASS);
            this.put("U", MergeStatusMsg.UNPASS);
        }
    }),
    COL_ARCHIVESTATUS("7", "archivestatus", new MultiLangEnumBridge("\u5f52\u6863\u72b6\u6001", "MergeStatusEnum_7", "fi-bcm-business"), new HashMap(4){
        {
            super(x0);
            this.put("def", MergeStatusMsg.NOT_ARCHIVE);
            this.put("A", MergeStatusMsg.UNDONE);
            this.put("B", MergeStatusMsg.NOT_ARCHIVE);
            this.put("D", MergeStatusMsg.ARCHIVE);
        }
    });

    private String code;
    private String colkey;
    private MultiLangEnumBridge bridge;
    private Map<String, Pair<MultiLangEnumBridge, String>> statusNames;

    private MergeStatusEnum(String code, String colkey, MultiLangEnumBridge bridge, Map<String, Pair<MultiLangEnumBridge, String>> statusNames) {
        this.code = code;
        this.colkey = colkey;
        this.bridge = bridge;
        this.statusNames = statusNames;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public void setBridge(MultiLangEnumBridge bridge) {
        this.bridge = bridge;
    }

    public static MergeStatusEnum getEnumByCode(String code) {
        for (MergeStatusEnum e : MergeStatusEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        throw new KDBizException("not found MergeStatusEnum code : " + code);
    }

    public String getColkey() {
        return this.colkey;
    }

    public Map<String, Pair<MultiLangEnumBridge, String>> getStatusNames() {
        return this.statusNames;
    }

    public String getStatusName(String statusValue) {
        Pair<MultiLangEnumBridge, String> b = this.statusNames.get(statusValue);
        return null != b ? ((MultiLangEnumBridge)b.p1).loadKDString() : ((MultiLangEnumBridge)this.statusNames.get((Object)"def").p1).loadKDString();
    }

    public String getStatusColor(String statusName) {
        String color = "";
        for (Pair<MultiLangEnumBridge, String> e : this.statusNames.values()) {
            if (!Objects.equals(statusName, ((MultiLangEnumBridge)e.p1).loadKDString())) continue;
            color = (String)e.p2;
            break;
        }
        if (StringUtils.isEmpty((String)color)) {
            color = "#6682F5";
        }
        return color;
    }
}

