/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.status.AbstractStatus;
import kd.fi.bcm.business.taskmanage.status.ReportStatus;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum TaskActivityTypeEnum {
    PeriodManage("1", new MultiLangEnumBridge("\u671f\u95f4\u7ba1\u7406", "TaskActivityTypeEnum_0", "fi-bcm-business"), AbstractStatus.class, "bcm_periodsetting"),
    YearCarry("2", new MultiLangEnumBridge("\u5e74\u521d\u7ed3\u8f6c", "TaskActivityTypeEnum_1", "fi-bcm-business"), AbstractStatus.class, "bcm_carrylist"),
    ExchangeRate("3", new MultiLangEnumBridge("\u6c47\u7387\u7ba1\u7406", "TaskActivityTypeEnum_2", "fi-bcm-business"), AbstractStatus.class, "bcm_exchangerate_maintain"),
    Invest("4", new MultiLangEnumBridge("\u80a1\u6743\u53ca\u6743\u76ca\u4fe1\u606f\u7ef4\u62a4", "TaskActivityTypeEnum_3", "fi-bcm-business"), AbstractStatus.class, "bcm_invsharerelalist"),
    InvestRelation("5", new MultiLangEnumBridge("\u5408\u5e76\u6240\u6709\u6743\u8bbe\u7f6e", "TaskActivityTypeEnum_4", "fi-bcm-business"), AbstractStatus.class, "bcm_invrelation_search"),
    Formula("6", new MultiLangEnumBridge("\u516c\u5f0f\u53d6\u6570", "TaskActivityTypeEnum_5", "fi-bcm-business"), AbstractStatus.class, "bcm_datacollection"),
    Integration("7", new MultiLangEnumBridge("\u96c6\u6210\u53d6\u6570", "TaskActivityTypeEnum_6", "fi-bcm-business"), AbstractStatus.class, "bcm_isschemecollectlist2"),
    Report("8", new MultiLangEnumBridge("\u7f16\u5236\u62a5\u8868", "TaskActivityTypeEnum_7", "fi-bcm-business"), ReportStatus.class, "bcm_report_list"),
    Check("13", new MultiLangEnumBridge("\u5bf9\u8d26\u7ba1\u7406", "TaskActivityTypeEnum_12", "fi-bcm-business"), ReportStatus.class, "bcm_checkmainpage"),
    Adjust("9", new MultiLangEnumBridge("\u8c03\u6574\u62b5\u9500\u5206\u5f55", "TaskActivityTypeEnum_8", "fi-bcm-business"), AbstractStatus.class, "bcm_rptadjust_list"),
    Merge("10", new MultiLangEnumBridge("\u667a\u80fd\u5408\u5e76", "TaskActivityTypeEnum_9", "fi-bcm-business"), AbstractStatus.class, "bcm_mergecontrollist"),
    InveReport("11", new MultiLangEnumBridge("\u80a1\u6743\u62a5\u544a", "TaskActivityTypeEnum_10", "fi-bcm-business"), AbstractStatus.class, "bcm_invsharereport"),
    InvlimSheet("12", new MultiLangEnumBridge("\u8c03\u6574\u62b5\u9500\u5e95\u7a3f", "TaskActivityTypeEnum_11", "fi-bcm-business"), AbstractStatus.class, "bcm_invlimsheetlist");

    private String type;
    private MultiLangEnumBridge bridge;
    private Class<AbstractStatus> statusClass;
    private String menuFormId;

    private TaskActivityTypeEnum(String type, MultiLangEnumBridge bridge, Class statusClass, String menuFormId) {
        this.type = type;
        this.bridge = bridge;
        this.statusClass = statusClass;
        this.menuFormId = menuFormId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public void setBridge(MultiLangEnumBridge bridge) {
        this.bridge = bridge;
    }

    public static TaskActivityTypeEnum getEnumByType(String type) {
        for (TaskActivityTypeEnum e : TaskActivityTypeEnum.values()) {
            if (!e.getType().equals(type)) continue;
            return e;
        }
        throw new KDBizException("not found TaskActivityTypeEnum type : " + type);
    }

    public static List<TaskActivityTypeEnum> getRptEnum() {
        return Lists.newArrayList((Object[])new TaskActivityTypeEnum[]{PeriodManage, YearCarry, ExchangeRate, Formula, Report});
    }

    public static List<TaskRelaOperEnum> getRelaOper(TaskActivityTypeEnum type) {
        ArrayList<TaskRelaOperEnum> list = new ArrayList<TaskRelaOperEnum>(4);
        list.add(TaskRelaOperEnum.NULL);
        if (null != type) {
            switch (type) {
                case Merge: {
                    list.add(TaskRelaOperEnum.MergeEcSubmit);
                    list.add(TaskRelaOperEnum.MergeArchive);
                    break;
                }
                case Report: {
                    list.add(TaskRelaOperEnum.ReportSubmit);
                    break;
                }
            }
        }
        return list;
    }

    public Class<AbstractStatus> getStatusClass() {
        return this.statusClass;
    }

    public String getMenuFormId() {
        return this.menuFormId;
    }
}

