/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.enums;

import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;

public enum TaskStatusEnum {
    READY("0", new MultiLangEnumBridge("\u672a\u5f00\u59cb", "TaskStatusEnum_0", "fi-bcm-business"), "#45DAD1"),
    PROCESSING("1", new MultiLangEnumBridge("\u8fdb\u884c\u4e2d", "TaskStatusEnum_1", "fi-bcm-business"), "#40A9FF"),
    FINISH("2", new MultiLangEnumBridge("\u5df2\u5b8c\u6210", "TaskStatusEnum_2", "fi-bcm-business"), "#73D13D");

    private String code;
    private MultiLangEnumBridge bridge;
    private String color;

    private TaskStatusEnum(String code, MultiLangEnumBridge bridge, String color) {
        this.code = code;
        this.bridge = bridge;
        this.color = color;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public void setBridge(MultiLangEnumBridge bridge) {
        this.bridge = bridge;
    }

    public static TaskStatusEnum getEnumByCode(String code) {
        for (TaskStatusEnum e : TaskStatusEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        throw new KDBizException("not found TaskStatusEnum code : " + code);
    }

    public static String getStatusColor(String statusName) {
        String color = "";
        for (TaskStatusEnum e : TaskStatusEnum.values()) {
            if (!Objects.equals(statusName, e.getName())) continue;
            color = e.color;
            break;
        }
        if (StringUtils.isEmpty((String)color)) {
            color = "#6682F5";
        }
        return color;
    }
}

