/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.helper;

import com.google.common.collect.ArrayListMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class TaskPermHelper {
    private static long getUserId() {
        return RequestContext.get().getCurrUserId();
    }

    private static String getBizAppId() {
        String appId = (String)ThreadCache.get((Object)"appId");
        return StringUtils.isNotEmpty((String)appId) ? appId : "cm";
    }

    public static Set<Long> getPerm(Long modelId, String entityNumber, DataTypeEnum ... dataTypeEnum) {
        boolean modelManager = MemberPermHelper.isModelManager(modelId);
        HashSet<Long> set = new HashSet<Long>();
        if (modelManager) {
            return set;
        }
        Set dataTypes = Arrays.stream(dataTypeEnum).map(e -> e.getIndex()).collect(Collectors.toSet());
        ArrayListMultimap<String, Long> map = PermClassEntityHelper.getPermissionMap(entityNumber, String.valueOf(modelId), String.valueOf(TaskPermHelper.getUserId()));
        Collection entries = map.entries();
        for (Map.Entry entrie : entries) {
            if (!dataTypes.contains(entrie.getKey())) continue;
            set.add((Long)entrie.getValue());
        }
        return set;
    }

    public static QFilter getDisMemberPerm(Long taskTemplateId) {
        TaskTemplateModel templateModel = TaskTemplateModel.dynToModel(taskTemplateId);
        return TaskPermHelper.getDisMemberPerm(templateModel.getModelId(), templateModel.getDisdimensionentity());
    }

    public static QFilter getDisMemberPerm(Long modelId, String disDimensionEntity) {
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)SysDimensionEnum.getDimNumberByMemberTreefrom((String)disDimensionEntity));
        return PermissionServiceImpl.getInstance(modelId).getReadOrWritePermFilter(dimId, disDimensionEntity, "member");
    }

    public static void filterActMenuPerm(List<Long> userList, Long modelId, String entityNum) {
        if (userList == null || userList.size() == 0) {
            return;
        }
        String appId = AppMetadataCache.getAppInfo((String)TaskPermHelper.getBizAppId()).getId();
        String permItemId = "47150e89000000ac";
        userList.removeIf(userId -> 0 == PermissionServiceHelper.checkPermission((long)userId, (String)"bcm_model", (long)modelId, (String)appId, (String)entityNum, (String)permItemId));
    }
}

