/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.scheme.Dimension;
import kd.fi.bcm.business.scheme.DimensionScope;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordTplModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateDisdimEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.model.TaskTmplStatus;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.business.template.model.ReportEditStatus;
import kd.fi.bcm.business.template.model.RightVersionTemplateParams;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.BcmThreadCache;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkStatusEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;

public class TaskRecordServiceHelper {
    public static TaskRecordModel beginRecord(Long taskRecordId, boolean begin) {
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"bcm_taskrecord", (String)"id,status,begintime,endtime,scheduleid,modifytime");
        String status = record.getString("status");
        String newStatus = "";
        if (begin && Objects.equals(status, TaskReocrdStatusEnum.SUSPEND.getValue())) {
            newStatus = TaskReocrdStatusEnum.RUNNING.getValue();
        } else if (!begin && !Objects.equals(status, TaskReocrdStatusEnum.SUSPEND.getValue())) {
            newStatus = TaskReocrdStatusEnum.SUSPEND.getValue();
        }
        if (StringUtils.isNotEmpty((String)newStatus)) {
            record.set("status", (Object)newStatus);
            record.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.update((DynamicObject)record);
        }
        return TaskRecordModel.dynObjToTaskRecordModel(record);
    }

    public static Tuple<List<TaskRecordModel>, Integer, Integer> queryTaskRecordByApi(Date beginDate, Date endDate, Integer pageIndex, Integer pageSize) {
        DynamicObject[] dynas;
        String selectProperties = "id,model,tasktemplate.name,filtermemberentry.dimension,filtermemberentry.member,endtime,begintime";
        QFilter filter = new QFilter("begintime", ">=", (Object)beginDate);
        if (null != endDate) {
            filter.and("begintime", "<=", (Object)endDate);
        }
        filter.and("status", "=", (Object)TaskReocrdStatusEnum.RUNNING.getValue());
        Integer totalSize = null;
        Integer totalPage = null;
        if (null == pageIndex || null == pageSize) {
            dynas = BusinessDataServiceHelper.load((String)"bcm_taskrecord", (String)selectProperties, (QFilter[])filter.toArray(), (String)"begintime");
        } else {
            DynamicObject total = QueryServiceHelper.queryOne((String)"bcm_taskrecord", (String)"count(1)", (QFilter[])filter.toArray());
            totalSize = total.getInt(0);
            totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
            dynas = BusinessDataServiceHelper.load((String)"bcm_taskrecord", (String)selectProperties, (QFilter[])filter.toArray(), (String)"begintime", (int)(pageIndex - 1), (int)pageSize);
        }
        return Tuple.create(TaskRecordModel.dynObjToTaskRecordModel(dynas), totalSize, totalPage);
    }

    public static Set<String> deleteTaskRecord(Set<Long> recordIds) {
        QFBuilder qfBuilder = new QFBuilder("id", "in", recordIds);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"bcm_taskrecord", (String)"id,tasktemplate,scheduleid,model", (QFilter[])qfBuilder.toArray());
        Set taskTemplateIds = records.stream().map(e -> e.getLong("tasktemplate")).collect(Collectors.toSet());
        Set usertaskIds = QueryServiceHelper.query((String)"bcm_usertask", (String)"id", (QFilter[])new QFilter("taskrecord", "in", recordIds).toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Set reportActivityIds = QueryServiceHelper.query((String)"bcm_tasktplactivity", (String)"id", (QFilter[])new QFBuilder("tasktemplate", "in", taskTemplateIds).add("type", "=", (Object)TaskActivityTypeEnum.Report.getType()).toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Set<String> scheduleIds = records.stream().filter(e -> StringUtils.isNotEmpty((String)e.getString("scheduleid"))).map(e -> e.getString("scheduleid")).collect(Collectors.toSet());
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bcm_usertaskinfo", (QFilter[])new QFilter("usertask", "in", usertaskIds).toArray());
                DeleteServiceHelper.delete((String)"bcm_usertask", (QFilter[])new QFilter("taskrecord", "in", recordIds).toArray());
                DeleteServiceHelper.delete((String)"bcm_taskrecord", (QFilter[])qfBuilder.toArray());
                DeleteServiceHelper.delete((String)"bcm_tasktplactivity", (QFilter[])new QFilter("tasktemplate", "in", taskTemplateIds).toArray());
                DeleteServiceHelper.delete((String)"bcm_tasktemplate", (QFilter[])new QFilter("id", "in", taskTemplateIds).toArray());
                DeleteServiceHelper.delete((String)"bcm_taskrecord_tplentity", (QFilter[])new QFilter("activity", "in", reportActivityIds).toArray());
                PermClassEntityHelper.deleteEntities(recordIds.stream().collect(Collectors.toList()), ((DynamicObject)records.get(0)).getLong("model"));
            }
            catch (Throwable e2) {
                tx.markRollback();
                throw new KDBizException(e2, new ErrorCode("", e2.getMessage()), new Object[0]);
            }
        }
        return scheduleIds;
    }

    public static DynamicObject[] loadTaskRecords(Set<Long> recordIds) {
        QFBuilder qfBuilder = new QFBuilder("id", "in", recordIds);
        return BusinessDataServiceHelper.load((String)"bcm_taskrecord", (String)"id,status,begintime,endtime,isforceclose,scheduleid,totalnum,finishnum,startmode,modifytime", (QFilter[])qfBuilder.toArray());
    }

    public static void modifyTaskRecordStatus(TaskReocrdStatusEnum statusEnum, DynamicObject[] records) {
        for (DynamicObject record : records) {
            record.set("modifytime", (Object)TimeServiceHelper.now());
            boolean isFinish = record.getInt("totalnum") == record.getInt("finishnum");
            record.set("status", (Object)(statusEnum == TaskReocrdStatusEnum.RUNNING && isFinish ? TaskReocrdStatusEnum.COMPLETE.getValue() : statusEnum.getValue()));
            if (statusEnum != TaskReocrdStatusEnum.RUNNING || null != record.get("begintime")) continue;
            record.set("begintime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject[])records);
    }

    public static void resetTaskRecord(Set<Long> recordIds) {
        DynamicObject[] recordDyns;
        for (DynamicObject e2 : recordDyns = TaskRecordServiceHelper.loadTaskRecords(recordIds)) {
            e2.set("finishnum", (Object)0);
        }
        DynamicObject[] usertaskDyns = BusinessDataServiceHelper.load((String)"bcm_usertask", (String)"id,taskrecord,status,activity,finishnum", (QFilter[])new QFilter("taskrecord", "in", recordIds).toArray());
        Set usertaskIds = Arrays.stream(usertaskDyns).map(e -> (Long)e.getPkValue()).collect(Collectors.toSet());
        DynamicObject[] usertaskinfoDyns = BusinessDataServiceHelper.load((String)"bcm_usertaskinfo", (String)"id,usertask,status,activity,executeseq", (QFilter[])new QFilter("usertask", "in", usertaskIds).toArray());
        HashMap<Long, Long> currentActivityIdMap = new HashMap<Long, Long>(usertaskDyns.length);
        for (DynamicObject e3 : usertaskinfoDyns) {
            String status = TaskStatusEnum.READY.getCode();
            if (e3.getInt("executeseq") == 1) {
                status = TaskStatusEnum.PROCESSING.getCode();
                currentActivityIdMap.put(e3.getLong("usertask.id"), e3.getLong("activity.id"));
            }
            e3.set("status", (Object)status);
        }
        for (DynamicObject e3 : usertaskDyns) {
            e3.set("finishnum", (Object)0);
            Long currentActivityId = (Long)currentActivityIdMap.get((Long)e3.getPkValue());
            if (null == currentActivityId) continue;
            e3.set("status", (Object)TaskStatusEnum.PROCESSING.getCode());
            e3.set("activity", (Object)currentActivityId);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])recordDyns);
                SaveServiceHelper.save((DynamicObject[])usertaskDyns);
                SaveServiceHelper.save((DynamicObject[])usertaskinfoDyns);
            }
            catch (Throwable e4) {
                tx.markRollback();
                throw new KDBizException(e4, new ErrorCode("", e4.getMessage()), new Object[0]);
            }
        }
    }

    public static void deleteDisList(String groupId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":fgroupid", 1, (Object)groupId)};
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"delete from t_bcm_taskcreate_dis where fgroupid = ? ", (Object[])params);
    }

    public static List<Long> getRangeOrgIdsByDisDim(TaskTemplateModel taskTemplateModel) {
        Long modelId = taskTemplateModel.getModelId();
        Dimension dimension = TaskRecordServiceHelper.getDimensionByTaskTemplate(taskTemplateModel);
        if (null == dimension) {
            return Collections.emptyList();
        }
        HashMap<Long, Integer> collect = new HashMap<Long, Integer>(16);
        for (TaskTemplateDisdimEntry disEntry : taskTemplateModel.getTaskTemplateDisdim()) {
            TaskRecordServiceHelper.buildDimemMap(disEntry.getMemberid(), disEntry.getPropertyvalue(), disEntry.getRange(), collect);
        }
        DimensionScope dimensionScope = new DimensionScope(String.valueOf(modelId), dimension, collect);
        Set<Long> orgIds = dimensionScope.getResolveScopeIds();
        if ((orgIds = QueryMemberDetailsHelper.change2BaseMember(orgIds)).size() > 0) {
            return QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,level,dseq", (QFilter[])new QFilter("id", "in", orgIds).toArray(), (String)"level, dseq").stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Set<Long> getRangeOrgIdsByDisDim(Long modelId, Dimension dimension, Long memberId, Long propertyValue, int range) {
        HashMap<Long, Integer> collect = new HashMap<Long, Integer>(4);
        TaskRecordServiceHelper.buildDimemMap(memberId, propertyValue, range, collect);
        DimensionScope dimensionScope = new DimensionScope(String.valueOf(modelId), dimension, collect);
        Set<Long> orgIds = dimensionScope.getResolveScopeIds();
        orgIds = QueryMemberDetailsHelper.change2BaseMember(orgIds);
        return orgIds;
    }

    public static Set<Long> getRangeOrgIdsByDisDim(Long modelId, Dimension dimension, TaskRecordTplModel tplModel) {
        Set<Long> orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim(modelId, dimension, tplModel.getEntity(), tplModel.getPropertyvalue(), Integer.parseInt(tplModel.getRange()));
        return orgIds;
    }

    public static void buildDimemMap(Long memberId, Long propertyValue, int range, Map<Long, Integer> collect) {
        if (null != memberId && memberId > 0L) {
            collect.put(memberId, range);
        }
        if (null != propertyValue && propertyValue > 0L) {
            collect.put(propertyValue, range);
        }
    }

    public static Dimension getDimensionByTaskTemplate(TaskTemplateModel taskTemplateModel) {
        List<TaskTemplateDisdimEntry> taskTemplateDisdim = taskTemplateModel.getTaskTemplateDisdim();
        if (!Objects.equals(SysDimensionEnum.Entity.getMemberTreemodel(), taskTemplateModel.getDisdimensionentity()) || CollectionUtils.isEmpty(taskTemplateDisdim)) {
            return null;
        }
        return TaskRecordServiceHelper.getDimension(taskTemplateDisdim.get(0).getDisdimensionid());
    }

    public static Dimension getDimension(Long dimensionId) {
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"bcm_dimension", (String)"shortnumber,id,dseq,membermodel,issysdimension,name,number,fieldmapped", (QFilter[])new QFilter("id", "=", (Object)dimensionId).toArray());
        if (dimensions.isEmpty()) {
            return null;
        }
        DynamicObject dyDimension = (DynamicObject)dimensions.get(0);
        Dimension dimension = new Dimension(dyDimension);
        dimension.setSeq(dyDimension.getInt("dseq"));
        dimension.setMembermodel(dyDimension.getString("membermodel"));
        return dimension;
    }

    public static void createDisList(TaskTemplateModel taskTemplateModel, String groupId) {
        List<Long> orgIds = TaskRecordServiceHelper.getRangeOrgIdsByDisDim(taskTemplateModel);
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>(orgIds.size());
        Date now = TimeServiceHelper.now();
        Long userId = RequestContext.get().getCurrUserId();
        Long modelId = taskTemplateModel.getModelId();
        for (Long orgId : orgIds) {
            IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskcreate_dis");
            dyn.set("member", (Object)orgId);
            dyn.set("number", (Object)orgNode.getNumber());
            dyn.set("name", (Object)orgNode.getName());
            dyn.set("isnotleaf", (Object)(!orgNode.isLeaf() ? "1" : "0"));
            dyn.set("tasktemplate", (Object)taskTemplateModel.getComeFrom());
            dyn.set("creator", (Object)userId);
            dyn.set("createtime", (Object)now);
            dyn.set("groupid", (Object)groupId);
            insertList.add(dyn);
        }
        DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskcreate_dis");
        BusinessDataWriter.save((IDataEntityType)dyn.getDynamicObjectType(), (Object[])insertList.toArray(new DynamicObject[0]));
    }

    private static DynamicObjectCollection queryExceptiontpl(Long modelId, Set<Long> activityIds, Set<Long> orgIds) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("activity", "in", activityIds);
        filter.and("entity", "in", orgIds);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_taskrecord_tplentity", (String)"id,activity,entity,template", (QFilter[])filter.toArray());
        return list;
    }

    public static Map<Long, Set<Long>> getExceptiontpl(Long modelId, Long activityId, Set<Long> orgIds) {
        DynamicObjectCollection list = TaskRecordServiceHelper.queryExceptiontpl(modelId, Sets.newHashSet((Object[])new Long[]{activityId}), orgIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.groupingBy(e -> e.getLong("entity"))).entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((List)e.getValue()).stream().map(v -> v.getLong("template")).collect(Collectors.toSet())));
    }

    public static Pair<Boolean, List<Long>> getTaskRecordTemplateIds(Long modelId, Long orgId, Long userTaskInfoId, boolean toTemplateByCycle) {
        UserTaskInfoModel userTaskInfoModel = UserTaskInfoModel.dynToModel(userTaskInfoId);
        boolean isCycletable = TaskTemplateActModel.dynToModel(userTaskInfoModel.getActivity()).isCycletable();
        Map<Long, List<Long>> org2Template = TaskRecordServiceHelper.getTaskRecordTemplateIds(modelId, Sets.newHashSet((Object[])new Long[]{orgId}), userTaskInfoModel.getUserTaskModel().getTaskrecord(), userTaskInfoModel.getActivity(), toTemplateByCycle);
        return Pair.onePair((Object)isCycletable, org2Template.getOrDefault(orgId, Collections.emptyList()));
    }

    public static Map<Long, List<Long>> getTaskRecordTemplateIds(Long modelId, Set<Long> orgIds, Long taskrecordId, Long activityId, boolean toTemplateByCycle) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyMap();
        }
        Pair<Boolean, List<Long>> pair = TaskRecordServiceHelper.getActTemplateentryByRecord(taskrecordId, activityId);
        List allTemplateIds = (List)pair.p2;
        if (CollectionUtils.isEmpty((Collection)allTemplateIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> templateIdsByOrgMap = new HashMap<Long, List<Long>>(orgIds.size());
        Map<Long, Set<Long>> exceptiontplMap = TaskRecordServiceHelper.getExceptiontpl(modelId, activityId, orgIds);
        for (Long orgId : orgIds) {
            List<Object> templateIdsByOrg = Lists.newArrayList((Iterable)allTemplateIds);
            if (exceptiontplMap.containsKey(orgId)) {
                templateIdsByOrg.removeAll((Collection)exceptiontplMap.get(orgId));
            }
            if (((Boolean)pair.p1).booleanValue() && toTemplateByCycle && CollectionUtils.isNotEmpty((Collection)templateIdsByOrg)) {
                Map<Long, Set<Long>> cycleMap = CycleTablesServiceHelper.getTmplDisCycleTablesDetail(modelId, templateIdsByOrg.stream().collect(Collectors.toSet()));
                templateIdsByOrg = cycleMap.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).distinct().collect(Collectors.toList());
            }
            templateIdsByOrgMap.put(orgId, templateIdsByOrg);
        }
        return templateIdsByOrgMap;
    }

    public static Map<Long, Set<Long>> getTemplate2OrgMapOfUserTask(Long modelId, Set<Long> templateIds, Set<Long> orgIds, Map<String, Object> params) {
        Long userTaskInfoId = (Long)params.get("usertaskinfoId");
        boolean toTemplateByCycle = (Boolean)params.get("toTemplateByCycle");
        if (CollectionUtils.isEmpty(templateIds) || CollectionUtils.isEmpty(orgIds) || !LongUtil.isvalidLong((Object)userTaskInfoId)) {
            return templateIds.stream().collect(Collectors.toMap(e -> e, e -> Collections.emptySet()));
        }
        UserTaskInfoModel userTaskInfoModel = UserTaskInfoModel.dynToModel(userTaskInfoId);
        Long taskrecordId = userTaskInfoModel.getUserTaskModel().getTaskrecord();
        Long activityId = userTaskInfoModel.getActivity();
        List<UserTaskModel> usertaskList = UserTaskHelper.loadUserTask(modelId, orgIds, Sets.newHashSet((Object[])new Long[]{taskrecordId}));
        if (CollectionUtils.isEmpty(usertaskList)) {
            return templateIds.stream().collect(Collectors.toMap(e -> e, e -> Collections.emptySet()));
        }
        Map<Long, Long> usertaskId2Org = usertaskList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getMember()));
        Map<Long, List<Long>> usertaskActMap = UserTaskHelper.queryUserTaskReportAct(usertaskId2Org.keySet(), Sets.newHashSet((Object[])new Long[]{activityId}), null);
        if (usertaskActMap.isEmpty()) {
            return templateIds.stream().collect(Collectors.toMap(e -> e, e -> Collections.emptySet()));
        }
        orgIds = usertaskActMap.keySet().stream().map(e -> (Long)usertaskId2Org.get(e)).collect(Collectors.toSet());
        Map<Long, List<Long>> org2Template = TaskRecordServiceHelper.getTaskRecordTemplateIds(modelId, orgIds, taskrecordId, activityId, toTemplateByCycle);
        HashMap<Long, Set<Long>> template2Org = new HashMap<Long, Set<Long>>(templateIds.size());
        for (Long templateId : templateIds) {
            template2Org.computeIfAbsent(templateId, v -> Sets.newHashSet());
            for (Map.Entry<Long, List<Long>> e2 : org2Template.entrySet()) {
                if (!e2.getValue().contains(templateId)) continue;
                ((Set)template2Org.get(templateId)).add(e2.getKey());
            }
        }
        return template2Org;
    }

    public static Pair<Boolean, List<Long>> getActTemplateentryByRecord(Long taskrecordId, Long activityId) {
        DynamicObjectCollection list = TaskRecordServiceHelper.queryTaskRecordTemplateIds(Sets.newHashSet((Object[])new Long[]{taskrecordId}), activityId);
        Boolean iscycletable = CollectionUtils.isNotEmpty((Collection)list) && ((DynamicObject)list.get(0)).getBoolean("acttemplateentry.iscycletable");
        ArrayList<Long> templateIds = new ArrayList<Long>(list.size());
        for (DynamicObject e : list) {
            templateIds.add(e.getLong("acttemplateentry.template"));
        }
        return Pair.onePair((Object)iscycletable, templateIds);
    }

    public static DynamicObjectCollection queryTaskRecordTemplateIds(Collection<Long> taskRecordIds, Long activityId) {
        String selectProperties = "id,acttemplateentry.activity,acttemplateentry.iscycletable,acttemplateentry.template";
        QFilter filter = new QFilter("id", "in", taskRecordIds);
        if (LongUtil.isvalidLong((Object)activityId)) {
            filter.and("acttemplateentry.activity", "=", (Object)activityId);
        } else {
            filter.and("acttemplateentry.activity", "is not null", null);
        }
        return QueryServiceHelper.query((String)"bcm_taskrecord", (String)selectProperties, (QFilter[])filter.toArray());
    }

    public static MultiKeyMap getActCyclableByRecord(Set<Long> taskRecordIds) {
        MultiKeyMap multiKeyMap = new MultiKeyMap();
        DynamicObjectCollection dyns = TaskRecordServiceHelper.queryTaskRecordTemplateIds(taskRecordIds, null);
        for (DynamicObject dyn : dyns) {
            multiKeyMap.put((Object)dyn.getLong("id"), (Object)dyn.getLong("acttemplateentry.activity"), (Object)dyn.getBoolean("acttemplateentry.iscycletable"));
        }
        return multiKeyMap;
    }

    public static boolean existDimByMergeTask(Long modelId, Map<String, Long> dimMap) {
        QFilter filter = new QFilter("tasktemplate.type", "=", (Object)TaskTemplateModel.TypeEnum.MERGE.getCode());
        Set<Long> taskrecordIds = UserTaskHelper.getTaskRecordIdByDataSet(modelId, dimMap, filter);
        return CollectionUtils.isNotEmpty(taskrecordIds);
    }

    public static MultiKeyMap getExceptiontpl(Long modelId, Set<Long> activityIds, Set<Long> orgIds) {
        MultiKeyMap multiKeyMap = new MultiKeyMap();
        DynamicObjectCollection list = TaskRecordServiceHelper.queryExceptiontpl(modelId, activityIds, orgIds);
        list.forEach(e -> {
            Long activityId;
            Long entityId = e.getLong("entity");
            if (!multiKeyMap.containsKey((Object)entityId, (Object)(activityId = Long.valueOf(e.getLong("activity"))))) {
                multiKeyMap.put((Object)entityId, (Object)activityId, new HashSet(8));
            }
            ((Set)multiKeyMap.get((Object)entityId, (Object)activityId)).add(e.getLong("template"));
        });
        return multiKeyMap;
    }

    public static Map<Long, TaskTmplStatus> getUserTaskReportProgress(TaskRecordModel taskRecord, Map<Long, Long> usertaskAndOrgIds, Long schemeId, Map<Long, Set<Long>> baseRealIdMap) {
        Long modelId = taskRecord.getModelId();
        Map<String, Tuple<Long, String, String>> filterMember = taskRecord.getFilterMemberInfo(false);
        Long scenarioId = (Long)filterMember.get((Object)SysDimensionEnum.Scenario.getNumber()).p1;
        Long yearId = (Long)filterMember.get((Object)SysDimensionEnum.Year.getNumber()).p1;
        Long periodId = (Long)filterMember.get((Object)SysDimensionEnum.Period.getNumber()).p1;
        Set<Long> usertaskIds = usertaskAndOrgIds.keySet();
        Set<Long> orgIds = usertaskAndOrgIds.values().stream().collect(Collectors.toSet());
        HashMap<Long, TaskTmplStatus> progressMap = new HashMap<Long, TaskTmplStatus>(usertaskIds.size());
        DynamicObjectCollection dyns = TaskRecordServiceHelper.queryTaskRecordTemplateIds(Collections.singletonList(taskRecord.getId()), null);
        if (CollectionUtils.isEmpty((Collection)dyns)) {
            return progressMap;
        }
        Map<Long, Pair> actTplMap = dyns.stream().collect(Collectors.groupingBy(e -> e.getLong("acttemplateentry.activity"))).entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> Pair.onePair((Object)((DynamicObject)((List)e.getValue()).get(0)).getBoolean("acttemplateentry.iscycletable"), ((List)e.getValue()).stream().map(v -> v.getLong("acttemplateentry.template")).collect(Collectors.toList()))));
        Map<Long, List<Long>> usertaskActMap = UserTaskHelper.queryUserTaskReportAct(usertaskIds, null);
        HashSet<Long> allActivityIds = new HashSet<Long>(16);
        usertaskActMap.entrySet().stream().forEach(e -> allActivityIds.addAll((Collection)e.getValue()));
        MultiKeyMap exceptiontplMap = TaskRecordServiceHelper.getExceptiontpl(modelId, allActivityIds, orgIds);
        HashSet<Long> allTemplateIds = new HashSet<Long>(16);
        HashSet<Long> allTmpIdsIncludeCycleTmpIds = new HashSet<Long>(16);
        HashSet<Long> allCycleIds = new HashSet<Long>(16);
        actTplMap.entrySet().stream().filter(e -> (Boolean)((Pair)e.getValue()).p1).forEach(e -> allCycleIds.addAll((Collection)((Pair)e.getValue()).p2));
        Map cycleTplMap = CollectionUtils.isNotEmpty(allCycleIds) ? TaskRecordServiceHelper.getTmplDisCycleTablesDetailMap(modelId, allCycleIds) : Collections.emptyMap();
        allCycleIds.clear();
        HashMap usertaskTplMap = new HashMap(usertaskIds.size());
        HashMap taskCycleTmplMap = new HashMap(usertaskIds.size());
        for (Map.Entry<Long, List<Long>> entry : usertaskActMap.entrySet()) {
            HashSet<Long> allIds = new HashSet<Long>(16);
            Long orgId = usertaskAndOrgIds.get(entry.getKey());
            HashMap<Long, Set<Long>> cycleTmplMap = new HashMap<Long, Set<Long>>(16);
            Set<Long> actTmplIds = new HashSet<Long>(16);
            HashSet<Long> cycleIds = new HashSet<Long>(16);
            for (Long actId : entry.getValue()) {
                Pair actTpl = actTplMap.get(actId);
                if (null == actTpl) continue;
                HashSet effectIds = new HashSet((Collection)actTpl.p2);
                Set exceptiontpl = (Set)exceptiontplMap.get((Object)orgId, (Object)actId);
                if (CollectionUtils.isNotEmpty((Collection)exceptiontpl)) {
                    effectIds.removeAll(exceptiontpl);
                }
                if (!((Boolean)actTpl.p1).booleanValue()) {
                    actTmplIds.addAll(effectIds);
                    continue;
                }
                for (Long cycleId : effectIds) {
                    if (!cycleTplMap.containsKey(cycleId)) continue;
                    Set cycleTmplIds = (Set)cycleTplMap.get(cycleId);
                    Set<Long> tmplIds = TaskRecordServiceHelper.filterRightVersionReportTplIds(modelId, orgId, scenarioId, yearId, periodId, cycleTmplIds);
                    if (!CollectionUtils.isNotEmpty(tmplIds)) continue;
                    allTmpIdsIncludeCycleTmpIds.addAll(tmplIds);
                    cycleIds.add(cycleId);
                    cycleTmplMap.put(cycleId, tmplIds);
                }
            }
            actTmplIds = TaskRecordServiceHelper.filterRightVersionReportTplIds(modelId, orgId, scenarioId, yearId, periodId, actTmplIds);
            allTemplateIds.addAll(actTmplIds);
            allTmpIdsIncludeCycleTmpIds.addAll(actTmplIds);
            allIds.addAll(actTmplIds);
            allIds.addAll(cycleIds);
            allCycleIds.addAll(cycleIds);
            taskCycleTmplMap.put(entry.getKey(), cycleTmplMap);
            usertaskTplMap.put(entry.getKey(), allIds);
        }
        if (CollectionUtils.isEmpty(allTemplateIds) && CollectionUtils.isEmpty(allCycleIds)) {
            return progressMap;
        }
        MultiKeyMap reportStatusMap = TaskRecordServiceHelper.queryReportStatus(modelId, orgIds, filterMember, allTemplateIds);
        MultiKeyMap cycleStatusMap = TaskRecordServiceHelper.queryReportCycleStatus(modelId, orgIds, filterMember, allCycleIds);
        Set<String> passChkupSet = TaskRecordServiceHelper.queryPassChkup(modelId, schemeId, orgIds, filterMember, allTmpIdsIncludeCycleTmpIds);
        Map<Long, Long> tmpIdGroupMap = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,group", (QFilter[])new QFilter[]{new QFilter("id", "in", allTmpIdsIncludeCycleTmpIds)}).stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("group"), (e1, e2) -> e2));
        for (Map.Entry entry : usertaskTplMap.entrySet()) {
            Long orgId = usertaskAndOrgIds.get(entry.getKey());
            Map cycleTmplMap = (Map)taskCycleTmplMap.get(entry.getKey());
            String currency = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId).getCurrency();
            TaskTmplStatus taskTmplStatus = new TaskTmplStatus(((Set)entry.getValue()).size());
            progressMap.put((Long)entry.getKey(), taskTmplStatus);
            Tuple<Integer, Integer, Integer> statusCount = TaskRecordServiceHelper.countStatus(orgId, currency, (Set)entry.getValue(), allTemplateIds, cycleTmplMap, reportStatusMap, cycleStatusMap, passChkupSet, tmpIdGroupMap);
            taskTmplStatus.setEcStatus((Integer)statusCount.p1, (Integer)statusCount.p2, (Integer)statusCount.p3);
            if (baseRealIdMap == null || baseRealIdMap.get(orgId) == null || baseRealIdMap.get(orgId).isEmpty()) continue;
            for (Long realOrgId : baseRealIdMap.get(orgId)) {
                IDNumberTreeNode parent = MemberReader.findEntityMemberById((Long)modelId, (Long)realOrgId).getParent();
                if (IDNumberTreeNode.NotFoundTreeNode == parent || "Entity".equals(parent.getNumber())) continue;
                Tuple<Integer, Integer, Integer> pcStatusCount = TaskRecordServiceHelper.countStatus(orgId, parent.getCurrency(), (Set)entry.getValue(), allTemplateIds, cycleTmplMap, reportStatusMap, cycleStatusMap, passChkupSet, tmpIdGroupMap);
                taskTmplStatus.addPcStatus(realOrgId, (Integer)pcStatusCount.p1, (Integer)pcStatusCount.p2, (Integer)pcStatusCount.p3);
            }
        }
        return progressMap;
    }

    private static Tuple<Integer, Integer, Integer> countStatus(Long orgId, String currency, Set<Long> tmplCycleIds, Set<Long> allTemplateIds, Map<Long, Set<Long>> cycleTplMap, MultiKeyMap reportStatusMap, MultiKeyMap cycleStatusMap, Set<String> passChkupSet, Map<Long, Long> tmpIdNumberMap) {
        int completeNum = 0;
        int commitNum = 0;
        int chkupNum = 0;
        for (Long templateId : tmplCycleIds) {
            boolean isTemplate = allTemplateIds.contains(templateId);
            String status = isTemplate ? (String)reportStatusMap.get((Object)orgId, (Object)templateId, (Object)currency) : (String)cycleStatusMap.get((Object)orgId, (Object)templateId, (Object)currency);
            completeNum += Objects.equals(status, ReportStatusEnum.COMPLETE.status()) || Objects.equals(status, ReportStatusEnum.COMMIT.status()) ? 1 : 0;
            commitNum += Objects.equals(status, ReportStatusEnum.COMMIT.status()) ? 1 : 0;
            Set chkUpTmplIds = isTemplate ? Sets.newHashSet((Object[])new Long[]{templateId}) : (Set)cycleTplMap.getOrDefault(templateId, new HashSet(1));
            Set chkUpTmplGroups = chkUpTmplIds.stream().map(e -> tmpIdNumberMap.getOrDefault(e, 0L)).collect(Collectors.toSet());
            chkupNum += chkUpTmplGroups.stream().allMatch(e -> passChkupSet.contains(TaskRecordServiceHelper.getChkUpKey(orgId, e, currency))) ? 1 : 0;
        }
        return Tuple.create((Object)completeNum, (Object)commitNum, (Object)chkupNum);
    }

    private static Set<String> queryPassChkup(Long modelId, Long schemeId, Set<Long> orgIds, Map<String, Tuple<Long, String, String>> dimMap, Set<Long> tmplIds) {
        HashSet<String> passKeySet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(tmplIds) || schemeId == null) {
            return passKeySet;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "in", tmplIds)});
        QFilter filter = new QFilter("tmp.group", "in", doc.stream().map(e -> e.getLong("group")).collect(Collectors.toSet()));
        filter.and("model", "=", (Object)modelId);
        filter.and("cslscheme", "=", (Object)schemeId);
        filter.and("org", "in", orgIds);
        filter.and("scenario", "=", dimMap.get((Object)SysDimensionEnum.Scenario.getNumber()).p1);
        filter.and("year", "=", dimMap.get((Object)SysDimensionEnum.Year.getNumber()).p1);
        filter.and("period", "=", dimMap.get((Object)SysDimensionEnum.Period.getNumber()).p1);
        filter.and("process.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"Rpt", "ERpt"}));
        filter.and("checkedstatus", "=", (Object)String.valueOf(ChkStatusEnum.PASS.getStatus()));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_status", (String)"org,tmp.group,currency.number", (QFilter[])new QFilter[]{filter});
        collection.forEach(e -> passKeySet.add(TaskRecordServiceHelper.getChkUpKey(e.getLong("org"), e.getLong("tmp.group"), e.getString("currency.number"))));
        return passKeySet;
    }

    private static String getChkUpKey(long orgId, Long tmpNum, String currency) {
        return String.format("%s_%s_%s", orgId, tmpNum, currency);
    }

    public static Map<Long, Set<Long>> getOrgDisReportTplMap(long modelId, long sceneId, long yearId, long periodId, Set<Long> orgIdSet) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode DCNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)"Currency", (String)"DC");
        RightVersionTemplateParams params = new RightVersionTemplateParams(modelId, sceneId, yearId, periodId, DCNode.getId(), true);
        params.setOrgIds(orgIdSet);
        Map<Long, ReportEditStatus> reportCommitStatus = TemplateUtil.getCommitReportCount(params);
        HashMap<Long, Set<Long>> allTplMap = new HashMap<Long, Set<Long>>(reportCommitStatus.size());
        for (Map.Entry<Long, ReportEditStatus> entry : reportCommitStatus.entrySet()) {
            allTplMap.put(entry.getKey(), new HashSet<Long>(entry.getValue().getAllTemplates()));
        }
        return allTplMap;
    }

    public static Map<Long, Boolean> getOrgDisReportCommitStatusMap(long modelId, long sceneId, long yearId, long periodId, Set<Long> orgIdSet) {
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode DCNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)"Currency", (String)"DC");
        RightVersionTemplateParams params = new RightVersionTemplateParams(modelId, sceneId, yearId, periodId, DCNode.getId(), true);
        params.setOrgIds(orgIdSet);
        Map<Long, ReportEditStatus> reportCommitStatus = TemplateUtil.getCommitReportCount(params);
        HashMap<Long, Boolean> commitStatusMap = new HashMap<Long, Boolean>(reportCommitStatus.size());
        for (Map.Entry<Long, ReportEditStatus> entry : reportCommitStatus.entrySet()) {
            commitStatusMap.put(entry.getKey(), entry.getValue().isAllCommit());
        }
        return commitStatusMap;
    }

    private static Set<Long> filterRightVersionReportTplIds(long modelId, long orgId, long sceneId, long yearId, long periodId, Set<Long> tplIdSet) {
        IDNumberTreeNode orgNode;
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        IDNumberTreeNode DCNode = BcmThreadCache.findMemberByNum((String)modelNumber, (String)"Currency", (String)"DC");
        RightVersionTemplateParams params = new RightVersionTemplateParams(modelId, orgId, sceneId, yearId, periodId, DCNode.getId(), RequestContext.get().getCurrUserId(), tplIdSet);
        params.setUnCheckUserPerm(true);
        params.setUnCheckTplDisOrg(true);
        Map<Long, ReportEditStatus> reportCommitStatus = TemplateUtil.getCommitReportCount(params);
        if (reportCommitStatus.size() > 0 && (orgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId)) != IDNumberTreeNode.NotFoundTreeNode) {
            return new HashSet<Long>(reportCommitStatus.get(orgNode.getBaseTreeNode().getId()).getAllTemplates());
        }
        return tplIdSet;
    }

    private static MultiKeyMap queryReportStatus(Long modelId, Set<Long> orgIds, Map<String, Tuple<Long, String, String>> dimMap, Set<Long> templateIds) {
        MultiKeyMap multiKeyMap = new MultiKeyMap();
        if (CollectionUtils.isEmpty(templateIds)) {
            return multiKeyMap;
        }
        QFilter filter = new QFilter("template", "in", templateIds);
        filter.and("entity", "in", orgIds);
        filter.and("scene", "=", dimMap.get((Object)SysDimensionEnum.Scenario.getNumber()).p1);
        filter.and("fyear", "=", dimMap.get((Object)SysDimensionEnum.Year.getNumber()).p1);
        filter.and("period", "=", dimMap.get((Object)SysDimensionEnum.Period.getNumber()).p1);
        filter.and("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("reportstatus", "in", (Object)new String[]{ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_reportentity", (String)"entity,template,reportstatus,currency.number", (QFilter[])new QFilter[]{filter, statusFilter});
        collection.forEach(e -> multiKeyMap.put((Object)e.getLong("entity"), (Object)e.getLong("template"), (Object)e.getString("currency.number"), (Object)e.getString("reportstatus")));
        return multiKeyMap;
    }

    private static MultiKeyMap queryReportCycleStatus(Long modelId, Set<Long> orgIds, Map<String, Tuple<Long, String, String>> dimMap, Set<Long> cycleIds) {
        MultiKeyMap multiKeyMap = new MultiKeyMap();
        if (CollectionUtils.isEmpty(cycleIds)) {
            return multiKeyMap;
        }
        QFilter filter = new QFilter("cycletable", "in", cycleIds);
        filter.and("entity", "in", orgIds);
        filter.and("scene", "=", dimMap.get((Object)SysDimensionEnum.Scenario.getNumber()).p1);
        filter.and("fyear", "=", dimMap.get((Object)SysDimensionEnum.Year.getNumber()).p1);
        filter.and("period", "=", dimMap.get((Object)SysDimensionEnum.Period.getNumber()).p1);
        filter.and("model", "=", (Object)modelId);
        QFilter statusFilter = new QFilter("cycletabstatus", "in", (Object)new String[]{ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_cycletablereport", (String)"entity,cycletable,cycletabstatus,currency.number", (QFilter[])new QFilter[]{filter, statusFilter});
        collection.forEach(e -> multiKeyMap.put((Object)e.getLong("entity"), (Object)e.getLong("cycletable"), (Object)e.getString("currency.number"), (Object)e.getString("cycletabstatus")));
        return multiKeyMap;
    }

    public static void filterTemplateByScenario(QFilter filter, Long modelId, List<Long> pagememberSceneids) {
        if (CollectionUtils.isNotEmpty(pagememberSceneids)) {
            QFilter sceneFilter = new QFilter("pagemembentry.pagemembid", "in", pagememberSceneids);
            Long sceneParentId = MemberReader.findScenaMemberById((Long)modelId, (Long)pagememberSceneids.get(0)).getParent().getId();
            sceneFilter.or(new QFilter("pagemembentry.pagemembid", "=", (Object)sceneParentId));
            filter.and(sceneFilter);
        }
    }

    public static Set<Long> filterTemplateByScenario(Long modelId, List<Long> pagememberSceneids, Collection<Long> templateIds) {
        QFilter filter = new QFilter("id", "in", templateIds);
        TaskRecordServiceHelper.filterTemplateByScenario(filter, modelId, pagememberSceneids);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bcm_templateentity", (QFilter[])filter.toArray(), null, (int)-1);
        return ids.stream().map(e -> (Long)e).collect(Collectors.toSet());
    }

    public static Map<Long, Set<Long>> getTmplDisCycleTablesDetailMap(Long modelId, Collection<Long> cycleIds) {
        Map<Long, Set<Long>> cycleMap = CycleTablesServiceHelper.getTmplDisCycleTablesDetail(modelId, cycleIds.stream().collect(Collectors.toSet()));
        if (null == cycleMap) {
            return Collections.emptyMap();
        }
        return cycleMap;
    }
}

