/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTemplateHelper {
    public static DynamicObjectCollection getDynByIds(List<Object> ids) {
        return QueryServiceHelper.query((String)"bcm_tasktemplate", (String)"id,number,name,enable", (QFilter[])new QFilter("id", "in", ids).toArray());
    }

    public static void delete(List<Object> ids) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bcm_tasktplactivity", (QFilter[])new QFilter("tasktemplate", "in", ids).toArray());
                DeleteServiceHelper.delete((String)"bcm_tasktemplate", (QFilter[])new QFilter("id", "in", ids).toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    public static void updateStatus(List<Object> ids, boolean isEnable, String updateEnable) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(8);
        params.add(updateEnable);
        params.add(RequestContext.get().getCurrUserId());
        params.add(TimeServiceHelper.now());
        StringBuilder sqlBuilder = new StringBuilder("update t_bcm_tasktemplate set fenable = ?, fmodifierid = ?, fmodifytime = ?");
        if (isEnable) {
            sqlBuilder.append(", fenableuserid = ?, fenabletime = ?");
            params.add(RequestContext.get().getCurrUserId());
            params.add(TimeServiceHelper.now());
        }
        sqlBuilder.append(" where fid in (");
        sqlBuilder.append(String.join((CharSequence)",", ids.stream().map(e -> e.toString()).collect(Collectors.toList())));
        sqlBuilder.append(")");
        DB.update((DBRoute)DBRoute.of((String)"bcm"), (String)sqlBuilder.toString(), (Object[])params.toArray());
    }

    public static TaskTemplateModel copyTaskTemplate(Long sourceTaskTemplateId) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject oldTplDy = BusinessDataServiceHelper.loadSingle((Object)sourceTaskTemplateId, (String)"bcm_tasktemplate");
        DynamicObject newTplDy = (DynamicObject)cloneUtils.clone((IDataEntityBase)oldTplDy);
        long newTemplateId = GlobalIdUtil.genGlobalLongId();
        newTplDy.set("id", (Object)newTemplateId);
        newTplDy.set("comefrom", (Object)oldTplDy);
        DynamicObjectCollection activityList = newTplDy.getDynamicObjectCollection("entryentity_act");
        if (!activityList.isEmpty()) {
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)activityList.size());
            DynamicObjectCollection newActivityList = new DynamicObjectCollection();
            int index = 0;
            for (DynamicObject activity : activityList) {
                DynamicObject newActivity = (DynamicObject)cloneUtils.clone((IDataEntityBase)activity);
                newActivity.set("activity.id", (Object)ids[index]);
                newActivity.set("activity.tasktemplate.id", (Object)newTemplateId);
                newActivityList.add(index, newActivity);
                DynamicObjectCollection tplList = newActivity.getDynamicObject("activity").getDynamicObjectCollection("entryentity_template");
                for (DynamicObject tpl : tplList) {
                    tpl.set("id", null);
                }
                DynamicObjectCollection msgList = newActivity.getDynamicObject("activity").getDynamicObjectCollection("entryentity_msg");
                for (DynamicObject msg : msgList) {
                    msg.set("id", null);
                }
                ++index;
            }
            newTplDy.set("entryentity_act", (Object)newActivityList);
        }
        return TaskTemplateModel.dynToModel(newTplDy);
    }
}

