/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;

public class UserTaskHelper {
    private static QFilter getUserTaskCommonFilter(Long modelId, Set<Long> orgIds, Set<Long> taskrecordIds) {
        QFilter filter = new QFilter("taskrecord.model", "=", (Object)modelId);
        filter.and("taskrecord.status", "!=", (Object)TaskReocrdStatusEnum.SUSPEND.getValue());
        filter.and("member", "in", orgIds);
        filter.and("taskrecord", "in", taskrecordIds);
        filter.and("dimensiontype", "=", (Object)SysDimensionEnum.Entity.getMemberTreemodel());
        return filter;
    }

    public static DynamicObjectCollection queryUserTaskList(Long modelId, Set<Long> orgIds, Set<Long> taskrecordIds, TaskStatusEnum statusEnum, String selectProperties) {
        QFilter filter = UserTaskHelper.getUserTaskCommonFilter(modelId, orgIds, taskrecordIds);
        if (null != statusEnum) {
            filter.and("status", "=", (Object)statusEnum.getCode());
        }
        return UserTaskHelper.queryUserTaskList(filter, selectProperties, null);
    }

    public static DynamicObjectCollection queryUserTaskList(QFilter filter, String selectProperties, String orderBys) {
        DynamicObjectCollection usertaskList = QueryServiceHelper.query((String)"bcm_usertask", (String)selectProperties, (QFilter[])filter.toArray(), (String)orderBys);
        return usertaskList;
    }

    public static List<UserTaskModel> loadUserTask(Long modelId, Set<Long> orgIds, Set<Long> taskrecordIds) {
        QFilter filter = UserTaskHelper.getUserTaskCommonFilter(modelId, orgIds, taskrecordIds);
        String selectProperties = "id,taskrecord,member";
        DynamicObject[] usertaskList = BusinessDataServiceHelper.load((String)"bcm_usertask", (String)selectProperties, (QFilter[])filter.toArray());
        return UserTaskModel.dynToModel(usertaskList);
    }

    public static Map<Long, TaskRecordModel> loadTaskRecordMap(Set<Long> taskRecordIds) {
        DynamicObject[] taskrecordList = UserTaskHelper.loadTaskRecordList(taskRecordIds);
        Map<Long, TaskRecordModel> recordMap = TaskRecordModel.dynObjToTaskRecordModel(taskrecordList).stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        return recordMap;
    }

    public static DynamicObject[] loadTaskRecordList(Set<Long> taskRecordIds) {
        String selectProperties = "id,model,tasktemplate.name,tasktemplate.number,filtermemberentry.dimension,filtermemberentry.member,endtime,status";
        DynamicObject[] taskrecordList = BusinessDataServiceHelper.load((String)"bcm_taskrecord", (String)selectProperties, (QFilter[])new QFilter("id", "in", taskRecordIds).toArray());
        return taskrecordList;
    }

    public static List<UserTaskInfoModel> loadUserTaskInfo(Long userTaskId, Integer endExecuteseq) {
        HashSet<Long> userTaskIds = new HashSet<Long>(1);
        userTaskIds.add(userTaskId);
        return UserTaskHelper.loadUserTaskInfo(userTaskIds, endExecuteseq, false);
    }

    public static List<UserTaskInfoModel> loadUserTaskInfo(Set<Long> userTaskIds, Integer endExecuteseq, boolean onlyReport) {
        String selectProperties = "id,status,executeseq,usertask,activity,activity.type,activity.relevantop,activity.isdependlast";
        QFilter qFilter = new QFilter("usertask", "in", userTaskIds);
        if (null != endExecuteseq) {
            qFilter.and("executeseq", "<=", (Object)endExecuteseq);
        }
        if (onlyReport) {
            qFilter.and("activity.type", "=", (Object)TaskActivityTypeEnum.Report.getType());
        }
        DynamicObject[] usertaskinfoList = BusinessDataServiceHelper.load((String)"bcm_usertaskinfo", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"usertask.id,executeseq");
        return UserTaskInfoModel.dynToModel(usertaskinfoList);
    }

    public static List<UserTaskInfoModel> nextUserTaskInfo(Long userTaskId, Integer startExecuteseq) {
        String selectProperties = "id,status,executeseq,usertask,activity,activity.type,activity.relevantop,activity.isdependlast";
        QFilter qFilter = new QFilter("usertask", "=", (Object)userTaskId);
        qFilter.and("executeseq", ">", (Object)startExecuteseq);
        DynamicObject[] usertaskinfoList = BusinessDataServiceHelper.load((String)"bcm_usertaskinfo", (String)selectProperties, (QFilter[])qFilter.toArray(), (String)"usertask.id,executeseq");
        return UserTaskInfoModel.dynToModel(usertaskinfoList);
    }

    public static Map<Long, List<Long>> queryUserTaskReportAct(Collection<Long> usertaskIds, Collection<Long> activityIds) {
        return UserTaskHelper.queryUserTaskReportAct(usertaskIds, activityIds, "activity");
    }

    public static Map<Long, List<Long>> queryUserTaskReportAct(Collection<Long> usertaskIds, Collection<Long> activityIds, String fieldKey) {
        String selectProperties = "id,usertask,activity";
        QFilter qFilter = new QFilter("usertask", "in", usertaskIds);
        qFilter.and("activity.type", "=", (Object)TaskActivityTypeEnum.Report.getType());
        if (CollectionUtils.isNotEmpty(activityIds)) {
            qFilter.and("activity", "in", activityIds);
        }
        String finalFieldKey = StringUtils.isNotEmpty((String)fieldKey) ? fieldKey : "id";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_usertaskinfo", (String)selectProperties, (QFilter[])qFilter.toArray());
        return dyns.stream().collect(Collectors.groupingBy(e -> e.getLong("usertask"))).entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((List)e.getValue()).stream().map(v -> v.getLong(finalFieldKey)).collect(Collectors.toList())));
    }

    public static TaskRecordModel loadTaskRecord(Long taskRecordId) {
        HashSet<Long> ids = new HashSet<Long>(1);
        ids.add(taskRecordId);
        DynamicObject[] list = UserTaskHelper.loadTaskRecordList(ids);
        if (list.length > 0) {
            return TaskRecordModel.dynObjToTaskRecordModel(list[0]);
        }
        return new TaskRecordModel();
    }

    public static Map<Long, TaskTemplateActModel> queryActivityMap(Set<Long> activityIdSet) {
        String actSelectProperties = "id,name,type,relevantop";
        DynamicObjectCollection actList = QueryServiceHelper.query((String)"bcm_tasktplactivity", (String)actSelectProperties, (QFilter[])new QFilter("id", "in", activityIdSet).toArray());
        Map<Long, TaskTemplateActModel> actMap = actList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> TaskTemplateActModel.dynToModel(e)));
        return actMap;
    }

    public static Map<Long, String> queryUserTaskInfoStatus(DynamicObjectCollection rows) {
        HashMap<Long, String> actStatusMap = new HashMap<Long, String>(rows.size());
        Map<Long, Long> usertaskIdMap = rows.stream().filter(e -> LongUtil.isvalidLong((Object)e.getLong("activity"))).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getLong("activity")));
        if (!usertaskIdMap.isEmpty()) {
            QFilter filter = new QFilter("1", "=", (Object)2);
            for (Map.Entry<Long, Long> entry : usertaskIdMap.entrySet()) {
                QFilter f = new QFilter("usertask", "=", (Object)entry.getKey());
                f.and("activity", "=", (Object)entry.getValue());
                filter.or(f);
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)"bcm_usertaskinfo", (String)"id,status,usertask", (QFilter[])filter.toArray());
            for (DynamicObject e2 : list) {
                actStatusMap.put(e2.getLong("usertask"), e2.getString("status"));
            }
        }
        return actStatusMap;
    }

    public static QFilter getUsertaskinfoFilter(Long usertaskId) {
        QFilter filter = new QFilter("usertask", "=", (Object)usertaskId);
        return filter;
    }

    public static boolean userTaskFinish(Long usertaskId, List<UserTaskInfoModel> usertaskinfoList) {
        QFilter qFilter = UserTaskHelper.getUsertaskinfoFilter(usertaskId);
        DynamicObjectCollection all = QueryServiceHelper.query((String)"bcm_usertaskinfo", (String)"id,executeseq", (QFilter[])qFilter.toArray(), (String)"executeseq");
        return ((DynamicObject)all.get(all.size() - 1)).getInt("executeseq") == usertaskinfoList.get(usertaskinfoList.size() - 1).getExecuteseq() && Objects.equals(((DynamicObject)all.get(all.size() - 1)).getLong("id"), usertaskinfoList.get(usertaskinfoList.size() - 1).getId());
    }

    public static boolean taskRecordFinish(Long usertaskId, Long recordId) {
        QFilter filter = new QFilter("taskrecord", "=", (Object)recordId);
        filter.and("id", "!=", (Object)usertaskId);
        filter.and("status", "!=", (Object)TaskStatusEnum.FINISH.getCode());
        return !QueryServiceHelper.exists((String)"bcm_usertask", (QFilter[])filter.toArray());
    }

    public static Pair<Integer, Integer> getUserTaskFinishProgress(Long usertaskId) {
        Pair pair = null;
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select sum(case when fstatus='2' then 1 else 0 end) as finish, count(1) as total");
        sqlBuilder.append(" from t_bcm_usertaskinfo");
        sqlBuilder.append(" where fusertaskid = ?");
        pair = (Pair)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sqlBuilder.toString(), (Object[])new Object[]{usertaskId}, rs -> {
            Pair p = null;
            while (rs.next()) {
                int finish = rs.getInt("finish");
                int total = rs.getInt("total");
                p = Pair.onePair((Object)finish, (Object)total);
            }
            return p;
        });
        return null != pair ? pair : Pair.onePair((Object)0, (Object)0);
    }

    public static Pair<Integer, Integer> getTaskRecordFinishProgress(Long taskRecordId) {
        Map<String, Integer> countMap = UserTaskHelper.getTaskRecordStatusCount(taskRecordId);
        return Pair.onePair((Object)countMap.get(TaskStatusEnum.FINISH.getCode()), null);
    }

    public static Map<String, Integer> getTaskRecordStatusCount(Long taskRecordId) {
        LinkedHashMap<String, Integer> countMap = new LinkedHashMap<String, Integer>(3);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select sum(case when fstatus='2' then 1 else 0 end) as finish, sum(case when fstatus='1' then 1 else 0 end) as processing, sum(case when fstatus='0' then 1 else 0 end) as ready");
        sqlBuilder.append(" from t_bcm_usertask");
        sqlBuilder.append(" where ftaskrecordid = ?");
        DB.query((DBRoute)BCMConstant.DBROUTE, (String)sqlBuilder.toString(), (Object[])new Object[]{taskRecordId}, rs -> {
            while (rs.next()) {
                int finish = rs.getInt("finish");
                int processing = rs.getInt("processing");
                int ready = rs.getInt("ready");
                countMap.put(TaskStatusEnum.FINISH.getCode(), finish);
                countMap.put(TaskStatusEnum.PROCESSING.getCode(), processing);
                countMap.put(TaskStatusEnum.READY.getCode(), ready);
            }
            return null;
        });
        if ((Integer)countMap.get(TaskStatusEnum.READY.getCode()) == 0) {
            countMap.remove(TaskStatusEnum.READY.getCode());
        }
        return countMap;
    }

    public static List<TaskRecordModel> loadTaskRecordByDataSet(Long modelId, Map<String, Long> dimMap) {
        if (null == dimMap || dimMap.isEmpty()) {
            return Collections.emptyList();
        }
        return TaskRecordModel.dynObjToTaskRecordModel(UserTaskHelper.loadTaskRecordList(UserTaskHelper.getTaskRecordIdByDataSet(modelId, dimMap)));
    }

    public static List<TaskRecordModel> getTaskRecordByMerge(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        HashMap<String, Long> dimMap = new HashMap<String, Long>(3);
        dimMap.put(SysDimensionEnum.Scenario.getNumber(), scenarioId);
        dimMap.put(SysDimensionEnum.Year.getNumber(), yearId);
        dimMap.put(SysDimensionEnum.Period.getNumber(), periodId);
        QFilter filter = new QFilter("status", "!=", (Object)TaskReocrdStatusEnum.SUSPEND.getValue());
        filter.and("tasktemplate.type", "=", (Object)TaskTemplateModel.TypeEnum.MERGE.getCode());
        return TaskRecordModel.dynObjToTaskRecordModel(UserTaskHelper.loadTaskRecordList(UserTaskHelper.getTaskRecordIdByDataSet(modelId, dimMap, filter)));
    }

    public static Set<Long> getTaskRecordIdByDataSet(Long modelId, Map<String, Long> dimMap) {
        QFilter filter = new QFilter("status", "!=", (Object)TaskReocrdStatusEnum.SUSPEND.getValue());
        return UserTaskHelper.getTaskRecordIdByDataSet(modelId, dimMap, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getTaskRecordIdByDataSet(Long modelId, Map<String, Long> dimMap, QFilter filter) {
        if (null == dimMap || dimMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> taskRecordIds = new HashSet<Long>(16);
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(dimMap.size());
        try {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            if (null != filter) {
                modelFilter.and(filter);
            }
            for (Map.Entry<String, Long> e2 : dimMap.entrySet()) {
                Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)e2.getKey());
                dataSets.add(UserTaskHelper.getTaskRecordDataSet("." + e2.getKey(), modelFilter, e2.getValue(), dimId));
            }
            DataSet dataSet = (DataSet)dataSets.get(0);
            for (int i = 1; i < dataSets.size(); ++i) {
                dataSet = dataSet.join((DataSet)dataSets.get(i)).on("id", "id").select(new String[]{"id"}).finish();
            }
            dataSet.forEach(e -> taskRecordIds.add(e.getLong("id")));
        }
        finally {
            dataSets.forEach(e -> UserTaskHelper.closeDataSet(e));
        }
        return taskRecordIds;
    }

    private static DataSet getTaskRecordDataSet(String algoKey, QFilter filter, Long memberId, Long dimId) {
        QFilter filtermemberFilter = new QFilter("filtermemberentry.member", "=", (Object)memberId).and("filtermemberentry.dimension", "=", (Object)dimId);
        String algoKeyPrefix = "kd.fi.bcm.business.taskmanage.helper.UserTaskHelper.queryTaskRecordByDataset";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(algoKeyPrefix + algoKey), (String)"bcm_taskrecord", (String)"id", (QFilter[])filtermemberFilter.and(filter).toArray(), null);
        return dataSet;
    }

    private static void closeDataSet(DataSet dataSet) {
        if (null != dataSet) {
            dataSet.close();
        }
    }
}

