/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskRecordDeleteStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRecordStartModeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskReocrdStatusEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskSwitchStatusEnum;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.ISupportGZip;
import kd.fi.bcm.common.util.ThrowableHelper;

public class TaskRecordModel
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;

    public TaskRecordModel() {
        this.setDataEntityNumber("bcm_taskrecord");
        this.put("filtermemberentry", (Object)new ArrayList(10));
        this.put("acttemplateentry", (Object)new ArrayList(10));
        this.setTotalnum(0);
        this.setFinishnum(0);
    }

    public List<TaskRecordModelFilterMemEntry> getTaskRecordModelFilterMemEntry() {
        return (List)this.get("filtermemberentry");
    }

    public List<TaskRecordModelActTplEntry> getTaskRecordModelActTplEntry() {
        return (List)this.get("acttemplateentry");
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return this.get("model") == null ? 0L : (Long)this.get("model");
    }

    public void setTaskTemplateId(long taskTplId) {
        this.put("tasktemplate", (Object)taskTplId);
    }

    public long getTaskTemplateId() {
        return (Long)this.get("tasktemplate");
    }

    public TaskReocrdStatusEnum getTaskRecordStatus() {
        return TaskReocrdStatusEnum.getStatusEnum((String)this.get("status"));
    }

    public void setTaskRecordStatus(String status) {
        this.put("status", (Object)status);
    }

    public TaskRecordDeleteStatusEnum getDeleteStatus() {
        return TaskRecordDeleteStatusEnum.getStatusEnum((String)this.get("isdelete"));
    }

    public void setDeleteStatus(String deleteStatus) {
        this.put("isdelete", (Object)deleteStatus);
    }

    public TaskRecordStartModeEnum getStartMode() {
        return TaskRecordStartModeEnum.getModeEnum((String)this.get("startmode"));
    }

    public void setStartMode(String startMode) {
        this.put("startmode", (Object)startMode);
    }

    public TaskSwitchStatusEnum getForceClose() {
        return TaskSwitchStatusEnum.getStatusEnum((String)this.get("isforceclose"));
    }

    public void setForceClose(String forceClose) {
        this.put("isforceclose", (Object)forceClose);
    }

    public TaskSwitchStatusEnum getNotice() {
        return TaskSwitchStatusEnum.getStatusEnum((String)this.get("isnotice"));
    }

    public void setNotice(String enableNotice) {
        this.put("isnotice", (Object)enableNotice);
    }

    public Date getBeginTime() {
        return (Date)this.get("begintime");
    }

    public void setBeginTime(Date beginTime) {
        this.put("begintime", (Object)beginTime);
    }

    public Date getEndTime() {
        return (Date)this.get("endtime");
    }

    public void setEndTime(Date endTime) {
        this.put("endtime", (Object)endTime);
    }

    public String getMessageNoticeMode() {
        return (String)this.get("messagechannel");
    }

    public void setMessageNoticeMode(String noticeMode) {
        this.put("messagechannel", (Object)noticeMode);
    }

    public Object getNoticeContent() {
        return this.get("noticecontent");
    }

    public void setNoticeContent(Object noticecontent) {
        this.put("noticecontent", noticecontent);
    }

    public String getScheduleId() {
        return (String)this.get("scheduleid");
    }

    public void setScheduleId(String scheduleId) {
        this.put("scheduleid", (Object)scheduleId);
    }

    public long getCreatorId() {
        return (Long)this.get("creator");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public Date getCreateTime() {
        return (Date)this.get("createtime");
    }

    public void setCreateTime(Date createTime) {
        this.put("createtime", (Object)createTime);
    }

    public long getModifierId() {
        return (Long)this.get("modifier");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifytime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifytime", (Object)modifyTime);
    }

    public int getTotalnum() {
        return (Integer)this.get("totalnum");
    }

    public final void setTotalnum(int totalnum) {
        this.put("totalnum", (Object)totalnum);
    }

    public int getFinishnum() {
        return (Integer)this.get("finishnum");
    }

    public final void setFinishnum(int finishnum) {
        this.put("finishnum", (Object)finishnum);
    }

    public TaskTemplateModel getTaskTemplateModel() {
        return (TaskTemplateModel)this.get("tasktemplatemodel");
    }

    public void setTaskTemplateModel(TaskTemplateModel taskTemplateModel) {
        this.put("tasktemplatemodel", (Object)taskTemplateModel);
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        try {
            this.transferDynaObj2Model(dyna);
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] task record to simple model error!\n %s", dyna.getString("id"), ThrowableHelper.toString((Throwable)t)));
        }
    }

    private void transferDynaObj2Model(DynamicObject dyna) {
        DynamicObject permClassEntity;
        Predicate<String> pExist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
        this.setId(dyna.getLong("id"));
        this.setModelId(this.defaultIfNotExist(pExist, "model", 0L, () -> dyna.getDynamicObject("model").getLong("id")));
        this.setTaskTemplateId(this.defaultIfNotExist(pExist, "tasktemplate", 0L, () -> dyna.getDynamicObject("tasktemplate").getLong("id")));
        this.setTaskRecordStatus(this.defaultIfNotExist(pExist, "status", "0", () -> dyna.getString("status")));
        this.setDeleteStatus(this.defaultIfNotExist(pExist, "isdelete", "0", () -> dyna.getString("isdelete")));
        this.setStartMode(this.defaultIfNotExist(pExist, "startmode", "1", () -> dyna.getString("startmode")));
        this.setForceClose(this.defaultIfNotExist(pExist, "isforceclose", "0", () -> dyna.getString("isforceclose")));
        this.setNotice(this.defaultIfNotExist(pExist, "isnotice", "0", () -> dyna.getString("isnotice")));
        this.setBeginTime(this.defaultIfNotExist(pExist, "begintime", null, () -> dyna.getDate("begintime")));
        this.setEndTime(this.defaultIfNotExist(pExist, "endtime", null, () -> dyna.getDate("endtime")));
        this.setMessageNoticeMode(this.defaultIfNotExist(pExist, "messagechannel", "", () -> dyna.getString("messagechannel")));
        this.setNoticeContent(this.defaultIfNotExist(pExist, "noticecontent", null, () -> dyna.get("noticecontent")));
        this.setScheduleId(this.defaultIfNotExist(pExist, "scheduleid", "", () -> dyna.getString("scheduleid")));
        this.setCreateTime(this.defaultIfNotExist(pExist, "createtime", null, () -> dyna.getDate("createtime")));
        this.setCreatorId(this.defaultIfNotExist(pExist, "creator", 0L, () -> dyna.getDynamicObject("creator").getLong("id")));
        this.setModifierId(this.defaultIfNotExist(pExist, "modifier", 0L, () -> dyna.getDynamicObject("modifier").getLong("id")));
        this.setModifyTime(this.defaultIfNotExist(pExist, "modifytime", null, () -> dyna.getDate("modifytime")));
        this.setTotalnum(this.defaultIfNotExist(pExist, "totalnum", 0, () -> dyna.getInt("totalnum")));
        this.setFinishnum(this.defaultIfNotExist(pExist, "finishnum", 0, () -> dyna.getInt("finishnum")));
        if (pExist.test("filtermemberentry")) {
            this.getTaskRecordModelFilterMemEntry().addAll(new TaskRecordModelFilterMemEntry(this).loadDynaObject(dyna.getDynamicObjectCollection("filtermemberentry"), () -> this));
        }
        if (pExist.test("acttemplateentry")) {
            this.getTaskRecordModelActTplEntry().addAll(new TaskRecordModelActTplEntry(this).loadDynaObject(dyna.getDynamicObjectCollection("acttemplateentry"), () -> this));
        }
        this.setTaskTemplateModel(this.defaultIfNotExist(pExist, "tasktemplate", new TaskTemplateModel(), () -> TaskTemplateModel.dynToModel(dyna.getDynamicObject("tasktemplate"))));
        if (pExist.test("model") && (permClassEntity = PermClassEntityHelper.getPermissionClassEntity(dyna)) != null) {
            this.setPermClass(permClassEntity.getLong("permclass.id"));
        }
    }

    private <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }

    public static TaskRecordModel dynObjToTaskRecordModel(Long taskRecordId) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)taskRecordId, (String)"bcm_taskrecord");
        return TaskRecordModel.dynObjToTaskRecordModel(dyna);
    }

    public static TaskRecordModel dynObjToTaskRecordModel(DynamicObject dyna) {
        TaskRecordModel taskRecordModel = new TaskRecordModel();
        taskRecordModel.loadDynaObj2Model(dyna);
        return taskRecordModel;
    }

    public static List<TaskRecordModel> dynObjToTaskRecordModel(DynamicObject[] dynas) {
        ArrayList<TaskRecordModel> list = new ArrayList<TaskRecordModel>(dynas.length);
        for (DynamicObject dyna : dynas) {
            list.add(TaskRecordModel.dynObjToTaskRecordModel(dyna));
        }
        return list;
    }

    public Map<String, Tuple<Long, String, String>> getFilterMemberInfo(boolean needMemberInfo) {
        List<TaskRecordModelFilterMemEntry> entryList = this.getTaskRecordModelFilterMemEntry();
        HashMap<String, Tuple<Long, String, String>> map = new HashMap<String, Tuple<Long, String, String>>(entryList.size());
        for (TaskRecordModelFilterMemEntry member : entryList) {
            String dimNumber = member.getDimensionNumber();
            String membermodel = member.getDimensionMembermodel();
            Long memberId = member.getMemberId();
            String memberName = null;
            String memberNumber = null;
            if (needMemberInfo) {
                IDNumberTreeNode memberNode = MemberReader.findMemberById((long)this.getModelId(), (String)membermodel, (Long)memberId);
                memberNumber = memberNode.getNumber();
                memberName = memberNode.getName();
            }
            map.put(dimNumber, (Tuple<Long, String, String>)Tuple.create((Object)memberId, memberNumber, memberName));
        }
        return map;
    }
}

