/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActMsgEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActTplEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTemplateActModel
extends DynaEntityObject {
    private static final long serialVersionUID = 1L;

    public TaskTemplateActModel(TaskTemplateModel taskTemplate) {
        if (null != taskTemplate) {
            this.setTaskTemplateId(taskTemplate.getId());
        }
        this.setDataEntityNumber("bcm_tasktplactivity");
        this.put("entryentity_template", (Object)new ArrayList(8));
        this.put("entryentity_msg", (Object)new ArrayList(8));
        this.setDefaultValue();
    }

    public long getEntryId() {
        if (this.get("entryId") == null) {
            this.setEntryId(DBServiceHelper.genGlobalLongId());
        }
        return (Long)this.get("entryId");
    }

    public void setEntryId(long entryid) {
        this.put("entryId", (Object)entryid);
    }

    public int getSeq() {
        return (Integer)this.get("sequence");
    }

    public void setSeq(int seq) {
        this.put("sequence", (Object)seq);
    }

    public long getTaskTemplateId() {
        return (Long)this.get("tasktemplateid");
    }

    public final void setTaskTemplateId(long tasktemplateid) {
        this.put("tasktemplateid", (Object)tasktemplateid);
    }

    public String getActNumber() {
        return (String)this.get("number");
    }

    public void setActNumber(String actnumber) {
        this.put("number", (Object)actnumber);
    }

    public Object getActName() {
        return this.get("name");
    }

    public void setActName(Object actname) {
        this.put("name", actname);
    }

    public String getActNameString() {
        Object name = this.getActName();
        return null != name ? name.toString() : "";
    }

    public TaskActivityTypeEnum getActType() {
        return TaskActivityTypeEnum.getEnumByType((String)this.get("type"));
    }

    public void setActType(String acttype) {
        this.put("type", (Object)acttype);
    }

    public Object getDescription() {
        return this.get("description");
    }

    public void setDescription(Object description) {
        this.put("description", description);
    }

    public boolean isApplydetail() {
        return (Boolean)this.get("isapplydetail");
    }

    public void setIsApplydetail(boolean isapplydetail) {
        this.put("isapplydetail", (Object)isapplydetail);
    }

    public boolean isApplymerge() {
        return (Boolean)this.get("isapplymerge");
    }

    public void setIsApplymerge(boolean isapplymerge) {
        this.put("isapplymerge", (Object)isapplymerge);
    }

    public String getIsdependlast() {
        return (String)this.get("isdependlast");
    }

    public void setIsdependlast(String isdependlast) {
        this.put("isdependlast", (Object)isdependlast);
    }

    public TaskRelaOperEnum getRelevantop() {
        return TaskRelaOperEnum.getEnumByCode((String)this.get("relevantop"));
    }

    public void setRelevantop(String relevantop) {
        this.put("relevantop", (Object)relevantop);
    }

    public boolean isNotice() {
        return (Boolean)this.get("isnotice");
    }

    public void setIsNotice(boolean isnotice) {
        this.put("isnotice", (Object)isnotice);
    }

    public TaskTemplateModel.DismodeEnum getNoticedismode() {
        return TaskTemplateModel.DismodeEnum.getEnum((String)this.get("noticedismode"));
    }

    public void setNoticedismode(String noticedismode) {
        this.put("noticedismode", (Object)noticedismode);
    }

    public String getMessagechannel() {
        return (String)this.get("messagechannel");
    }

    public void setMessagechannel(String messagechannel) {
        this.put("messagechannel", (Object)messagechannel);
    }

    public Object getNoticecontent() {
        return this.get("noticecontent");
    }

    public void setNoticecontent(Object noticecontent) {
        this.put("noticecontent", noticecontent);
    }

    public String getParamlock() {
        return (String)this.get("paramlock");
    }

    public void setParamlock(String paramlock) {
        this.put("paramlock", (Object)paramlock);
    }

    public List<TaskTemplateActTplEntry> getTaskTemplateActTpl() {
        return (List)this.get("entryentity_template");
    }

    public void setTaskTemplateActTpl(List<TaskTemplateActTplEntry> actTpl) {
        this.put("entryentity_template", (Object)actTpl);
    }

    public List<TaskTemplateActMsgEntry> getTaskTemplateActMsg() {
        return (List)this.get("entryentity_msg");
    }

    public void setTaskTemplateActMsg(List<TaskTemplateActMsgEntry> actMsg) {
        this.put("entryentity_msg", (Object)actMsg);
    }

    public List<Long> getMsguserId(TaskTemplateModel.UserTypeEnum userType) {
        return this.getTaskTemplateActMsg().stream().filter(e -> e.getUsertype() == userType).map(e -> e.getUser()).collect(Collectors.toList());
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        this.loadDynaObj2Model(dyna, "");
    }

    public void loadDynaObj2Model(DynamicObject dyna, String dataKey) {
        try {
            if (StringUtils.isEmpty((String)dataKey)) {
                this.transferDynaObj2Model(dyna);
            } else {
                if (dataKey.contains(".")) {
                    dataKey = dataKey.split("\\.")[0];
                }
                if (dyna.getDataEntityType().getProperties().containsKey((Object)dataKey) && dyna.get(dataKey) != null) {
                    this.transferDynaObj2Model(dyna.getDynamicObject(dataKey));
                }
            }
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] templateAct to model error!\n %s", dataKey, ThrowableHelper.toString((Throwable)t)));
        }
    }

    private void transferDynaObj2Model(DynamicObject dyna) {
        Predicate<String> pexist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
        this.setId(dyna.getLong("id"));
        this.setSeq(this.defaultIfNotExist(pexist, "sequence", 0, () -> dyna.getInt("sequence")));
        this.setTaskTemplateId(this.defaultIfNotExist(pexist, "tasktemplate", 0L, () -> dyna.getLong("tasktemplate.id")));
        this.setActNumber(this.defaultIfNotExist(pexist, "number", "", () -> dyna.getString("number")));
        this.setActName(this.defaultIfNotExist(pexist, "name", null, () -> dyna.get("name")));
        this.setActType(this.defaultIfNotExist(pexist, "type", "", () -> dyna.getString("type")));
        this.setDescription(this.defaultIfNotExist(pexist, "description", null, () -> dyna.get("description")));
        this.setIsApplydetail(this.defaultIfNotExist(pexist, "isapplydetail", false, () -> dyna.getBoolean("isapplydetail")));
        this.setIsApplymerge(this.defaultIfNotExist(pexist, "isapplymerge", false, () -> dyna.getBoolean("isapplymerge")));
        this.setIsdependlast(this.defaultIfNotExist(pexist, "isdependlast", "", () -> dyna.getString("isdependlast")));
        this.setRelevantop(this.defaultIfNotExist(pexist, "relevantop", "", () -> dyna.getString("relevantop")));
        this.setIsNotice(this.defaultIfNotExist(pexist, "isnotice", false, () -> dyna.getBoolean("isnotice")));
        this.setNoticedismode(this.defaultIfNotExist(pexist, "noticedismode", "", () -> dyna.getString("noticedismode")));
        this.setMessagechannel(this.defaultIfNotExist(pexist, "messagechannel", "", () -> dyna.getString("messagechannel")));
        this.setNoticecontent(this.defaultIfNotExist(pexist, "noticecontent", null, () -> dyna.get("noticecontent")));
        this.setParamlock(this.defaultIfNotExist(pexist, "paramlock", "", () -> dyna.getString("paramlock")));
        if (pexist.test("entryentity_template")) {
            this.getTaskTemplateActTpl().addAll(new TaskTemplateActTplEntry(this).loadDynaObject(dyna.getDynamicObjectCollection("entryentity_template"), () -> this));
        }
        if (pexist.test("entryentity_msg")) {
            this.getTaskTemplateActMsg().addAll(new TaskTemplateActMsgEntry(this).loadDynaObject(dyna.getDynamicObjectCollection("entryentity_msg"), () -> this));
        }
    }

    private <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }

    public List<TaskTemplateActModel> loadDynaObject(DynamicObjectCollection t, Supplier<TaskTemplateModel> s) {
        ArrayList<TaskTemplateActModel> entries = new ArrayList<TaskTemplateActModel>(t.size());
        for (DynamicObject o : t) {
            TaskTemplateActModel entry = new TaskTemplateActModel(s.get());
            entry.setEntryId(o.getLong("id"));
            entry.loadDynaObj2Model(o, "activity");
            entries.add(entry);
        }
        return entries;
    }

    @Override
    public DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = ORM.create().newDynamicObject("bcm_tasktemplate.entryentity_act");
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        dyna.set("id", (Object)this.getEntryId());
        dyna.set("seq", (Object)incrementer.getAndIncrement());
        dyna.set("activity_id", (Object)this.getId());
        coll.add((Object)dyna);
        return coll;
    }

    public DynamicObject genDynamicObject(AtomicInteger incrementer) {
        DynamicObject dyna = this.newSimpleDynamicObject();
        dyna.set("id", (Object)this.getId());
        dyna.set("sequence", (Object)incrementer.getAndIncrement());
        dyna.set("tasktemplate", (Object)this.getTaskTemplateId());
        dyna.set("number", (Object)this.getActNumber());
        dyna.set("name", this.getActName());
        dyna.set("type", (Object)this.getActType().getType());
        dyna.set("description", this.getDescription());
        dyna.set("isapplydetail", (Object)(this.isApplydetail() ? "1" : "0"));
        dyna.set("isapplymerge", (Object)(this.isApplymerge() ? "1" : "0"));
        dyna.set("isdependlast", (Object)this.getIsdependlast());
        dyna.set("relevantop", (Object)this.getRelevantop().getCode());
        dyna.set("isnotice", (Object)(this.isNotice() ? "1" : "0"));
        dyna.set("noticedismode", (Object)this.getNoticedismode().getCode());
        dyna.set("messagechannel", (Object)this.getMessagechannel());
        dyna.set("noticecontent", this.getNoticecontent());
        dyna.set("paramlock", (Object)this.getParamlock());
        AtomicInteger incr = new AtomicInteger(1);
        DynamicObjectCollection list = dyna.getDynamicObjectCollection("entryentity_template");
        for (TaskTemplateActTplEntry e : this.getTaskTemplateActTpl()) {
            list.add((Object)e.genDynamicObject(incr));
        }
        incr = new AtomicInteger(1);
        DynamicObjectCollection listmsg = dyna.getDynamicObjectCollection("entryentity_msg");
        for (TaskTemplateActMsgEntry e : this.getTaskTemplateActMsg()) {
            listmsg.add((Object)e.genDynamicObject(incr));
        }
        return dyna;
    }

    private void setDefaultValue() {
        this.setActType(TaskActivityTypeEnum.Report.getType());
        this.setIsApplydetail(true);
        this.setIsApplymerge(true);
        this.setIsdependlast("0");
        this.setRelevantop(TaskRelaOperEnum.NULL.getCode());
        this.setIsNotice(false);
        this.setNoticedismode(TaskTemplateModel.DismodeEnum.DEFAULT.getCode());
    }

    public boolean isReport() {
        return this.getActType() == TaskActivityTypeEnum.Report;
    }

    public boolean isCycletable() {
        List<TaskTemplateActTplEntry> tplList = this.getTaskTemplateActTpl();
        boolean iscycletable = CollectionUtils.isNotEmpty(tplList) ? tplList.get(0).isCycletable() : false;
        return iscycletable;
    }

    public static TaskTemplateActModel dynToModel(Long taskActivityId) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)taskActivityId, (String)"bcm_tasktplactivity");
        return TaskTemplateActModel.dynToModel(dyna);
    }

    public static TaskTemplateActModel dynToModel(DynamicObject dyna) {
        TaskTemplateActModel model = new TaskTemplateActModel(null);
        model.loadDynaObj2Model(dyna);
        return model;
    }

    public static List<TaskTemplateActModel> dynToModel(DynamicObject[] dynas) {
        ArrayList<TaskTemplateActModel> list = new ArrayList<TaskTemplateActModel>(dynas.length);
        for (DynamicObject dyna : dynas) {
            list.add(TaskTemplateActModel.dynToModel(dyna));
        }
        return list;
    }

    public static TaskTemplateActModel getDefaultModel(TaskActivityEnum e) {
        TaskTemplateActModel activity = new TaskTemplateActModel(null);
        activity.setActNumber(e.name());
        activity.setActName(e.getNameLocaleString());
        activity.setActType(e.getType().getType());
        activity.setRelevantop(e.getOper().getCode());
        activity.setIsApplydetail(e.isIsapplydetail());
        activity.setIsApplymerge(e.isIsapplymerge());
        return activity;
    }
}

