/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.notice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class TaskNoticeContentHelper {
    public static final String CACT = "CACT";
    public static final String PACT = "PACT";
    public static final String NACT = "NACT";
    public static final List<String> DimParam = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getShortnumber(), SysDimensionEnum.Scenario.getShortnumber(), SysDimensionEnum.Year.getShortnumber(), SysDimensionEnum.Period.getShortnumber()});
    public static final List<Pair<String, MultiLangEnumBridge>> ActParam = Lists.newArrayList((Object[])new Pair[]{Pair.onePair((Object)"CACT", (Object)new MultiLangEnumBridge("\u5f53\u524d\u6d3b\u52a8", "TaskNoticeContentHelper_0", "fi-bcm-business")), Pair.onePair((Object)"PACT", (Object)new MultiLangEnumBridge("\u4e0a\u4e00\u6d3b\u52a8", "TaskNoticeContentHelper_1", "fi-bcm-business")), Pair.onePair((Object)"NACT", (Object)new MultiLangEnumBridge("\u4e0b\u4e00\u6d3b\u52a8", "TaskNoticeContentHelper_2", "fi-bcm-business"))});

    public static Pair<List<ComboItem>, String> getNoticeDim(Long modelId, boolean act) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_dimension", (String)"name,shortnumber", (QFilter[])qf.toArray());
        Map<String, String> map = dyns.stream().collect(Collectors.toMap(s -> s.getString("shortnumber"), s -> s.getString("name")));
        ArrayList comboItems = Lists.newArrayList();
        ArrayList tipsDim = Lists.newArrayList();
        for (String string : DimParam) {
            if (!map.containsKey(string)) continue;
            comboItems.add(new ComboItem(new LocaleString(TaskNoticeContentHelper.dimFormat(map.get(string)) + "\uff1a" + TaskNoticeContentHelper.dimFormat(string)), TaskNoticeContentHelper.dimFormat(string)));
            tipsDim.add(TaskNoticeContentHelper.dimFormat(map.get(string)));
        }
        if (act) {
            for (Pair pair : ActParam) {
                comboItems.add(new ComboItem(new LocaleString(TaskNoticeContentHelper.dimFormat(((MultiLangEnumBridge)pair.p2).loadKDString()) + "\uff1a" + TaskNoticeContentHelper.dimFormat((String)pair.p1)), TaskNoticeContentHelper.dimFormat((String)pair.p1)));
                tipsDim.add(TaskNoticeContentHelper.dimFormat(((MultiLangEnumBridge)pair.p2).loadKDString()));
            }
        }
        String tipsInfo = String.format(ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u5176\u4e2d\u9700\u6309\u6240\u9009\u5e95\u7a3f\u5185\u5bb9\u89e3\u6790\u6210\u5177\u4f53\u7ef4\u5ea6\u6210\u5458\u7684\u8bf7\u6309\u7279\u5b9a\u683c\u5f0f\u586b\u5199\uff0c\u76ee\u524d\u53ef\u652f\u6301\uff1a%s\u3002", (String)"TaskNoticeContentHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", tipsDim.toArray(new String[0])));
        return Pair.onePair((Object)comboItems, (Object)tipsInfo);
    }

    private static String dimFormat(String value) {
        return String.format("\u3010@%s\u3011", value);
    }

    private static Matcher getContentMatcher(String content) {
        Pattern VARIABLE_REGEX = Pattern.compile("\\\u3010\\@\\w{1,}\\\u3011");
        Matcher m = VARIABLE_REGEX.matcher(content);
        return m;
    }

    public static String getRealMessage(String content, Long modelId, Map<String, String> messageParams) {
        Map short2number = MemberReader.getDimensionShortNumber2NumberMap((String)MemberReader.findModelNumberById((Object)modelId));
        Matcher m = TaskNoticeContentHelper.getContentMatcher(content);
        HashMap<String, String> replaceMap = new HashMap<String, String>(8);
        while (m.find()) {
            String originStr = content.substring(m.start() + 2, m.end() - 1);
            String replacedStr = content.substring(m.start(), m.end());
            String number = (String)short2number.get(originStr);
            if (number != null && messageParams.containsKey(number)) {
                replaceMap.put(replacedStr, messageParams.get(number));
                continue;
            }
            if (!messageParams.containsKey(originStr)) continue;
            replaceMap.put(replacedStr, messageParams.get(originStr));
        }
        for (Map.Entry entry : replaceMap.entrySet()) {
            content = content.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return content;
    }
}

