/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.notice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.bcm.business.permission.UserDistributeServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskSwitchStatusEnum;
import kd.fi.bcm.business.taskmanage.helper.TaskPermHelper;
import kd.fi.bcm.business.taskmanage.helper.UserTaskHelper;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModel;
import kd.fi.bcm.business.taskmanage.model.TaskRecordModelFilterMemEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActMsgEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateDisdimEntry;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskInfoModel;
import kd.fi.bcm.business.taskmanage.model.UserTaskModel;
import kd.fi.bcm.business.taskmanage.notice.TaskNoticeContentHelper;
import kd.fi.bcm.business.util.MessageServiceUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import org.apache.commons.collections4.CollectionUtils;

public class TaskTplNoticeService {
    private static void sendMsgByActivity(List<Long> activityIds, Long taskRecordId, Long usertaskId) {
        if (CollectionUtils.isEmpty(activityIds)) {
            return;
        }
        DynamicObject[] activitys = BusinessDataServiceHelper.load((Object[])activityIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_tasktplactivity"));
        ArrayList<TaskTemplateActModel> models = new ArrayList<TaskTemplateActModel>(activityIds.size());
        Arrays.stream(activitys).forEach(s -> models.add(TaskTemplateActModel.dynToModel(s)));
        TaskRecordModel taskRecord = TaskRecordModel.dynObjToTaskRecordModel(taskRecordId);
        UserTaskModel userTask = UserTaskModel.dynToModel(usertaskId);
        TaskTplNoticeService.sendMsgByTaskTpl(models, taskRecord, userTask);
    }

    public static void sendMsgByUserTaskInfo(List<UserTaskInfoModel> userTaskInfoModels) {
        if (CollectionUtils.isEmpty(userTaskInfoModels)) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(userTaskInfoModels.size());
        Long taskRecordId = userTaskInfoModels.get(0).getUserTaskModel().getTaskrecord();
        Long usertaskId = userTaskInfoModels.get(0).getUsertask();
        userTaskInfoModels.forEach(s -> ids.add(s.getActivity()));
        TaskTplNoticeService.sendMsgByActivity(ids, taskRecordId, usertaskId);
    }

    public static void sendMsgByTaskRecord(TaskRecordModel taskRecord, TaskTemplateModel taskTemplate) {
        if (TaskSwitchStatusEnum.DISABLE == taskRecord.getNotice() || taskRecord.getNoticeContent() == null || "".equals(taskRecord.getNoticeContent())) {
            return;
        }
        Map<Long, Object> user2msg = TaskTplNoticeService.groupMsg(taskRecord, taskTemplate);
        String channel = taskRecord.getMessageNoticeMode();
        TaskTplNoticeService.sendMsgDetail(channel, user2msg);
    }

    private static Map<Long, Object> groupMsg(TaskRecordModel taskRecord, TaskTemplateModel taskTemplate) {
        Long modelId = taskTemplate.getModelId();
        Map<String, Set<Long>> org2user = TaskTplNoticeService.getMsgUsersByOrgs(taskTemplate);
        String content = ((OrmLocaleValue)taskRecord.getNoticeContent()).getLocaleValue();
        HashMap<Long, Set> user2org = new HashMap<Long, Set>();
        org2user.forEach((k, v) -> {
            for (Long userId : v) {
                HashSet<String> orgs = (HashSet<String>)user2org.get(userId);
                if (orgs == null) {
                    orgs = new HashSet<String>(8);
                }
                orgs.add((String)k);
                user2org.put(userId, orgs);
            }
        });
        HashMap<Long, Object> user2msg = new HashMap<Long, Object>(user2org.size());
        Map<String, String> messageParams = TaskTplNoticeService.getMessageParams(taskRecord, null);
        user2org.forEach((k, v) -> {
            TaskTplNoticeService.getMessageParamsTpl(messageParams, taskTemplate, v);
            String msgcontent = TaskNoticeContentHelper.getRealMessage(content, modelId, messageParams);
            user2msg.put((Long)k, msgcontent);
        });
        return user2msg;
    }

    private static void sendMsgByTaskTpl(List<TaskTemplateActModel> actModels, TaskRecordModel taskrecord, UserTaskModel usertask) {
        Map<String, String> messageParams = TaskTplNoticeService.getMessageParams(taskrecord, usertask);
        List<UserTaskInfoModel> usertaskinfoList = UserTaskHelper.loadUserTaskInfo(usertask.getId(), null);
        for (TaskTemplateActModel model : actModels) {
            if (!model.isNotice()) continue;
            TaskTemplateModel.DismodeEnum dismodel = model.getNoticedismode();
            String channel = model.getMessagechannel();
            String content = ((OrmLocaleValue)model.getNoticecontent()).getLocaleValue();
            TaskTplNoticeService.getMessageParamsAct(messageParams, model, usertaskinfoList);
            content = TaskNoticeContentHelper.getRealMessage(content, taskrecord.getModelId(), messageParams);
            List<Long> userList = null;
            if (TaskTemplateModel.DismodeEnum.DEFAULT == dismodel) {
                userList = TaskTplNoticeService.getMsgUsers(model.getTaskTemplateId());
            } else if (TaskTemplateModel.DismodeEnum.ASSIGN == dismodel) {
                userList = TaskTplNoticeService.getMsgUsersByAssign(model.getTaskTemplateActMsg());
            }
            TaskPermHelper.filterActMenuPerm(userList, taskrecord.getModelId(), model.getActType().getMenuFormId());
            TaskTplNoticeService.sendMsgDetail(channel, content, userList);
        }
    }

    private static void sendMsgDetail(String channel, Map<Long, Object> user2msg) {
        if (user2msg == null || user2msg.size() == 0 || StringUtils.isEmpty((String)channel)) {
            return;
        }
        String notifyType = TaskTplNoticeService.getNotifyType(channel);
        ArrayList messageInfos = new ArrayList(4);
        user2msg.forEach((k, v) -> {
            MessageInfo message = TaskTplNoticeService.getMessageInfoByType(notifyType, String.valueOf(v), Lists.newArrayList((Object[])new Long[]{k}));
            messageInfos.add(message);
        });
        for (MessageInfo messageInfo : messageInfos) {
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }

    private static void sendMsgDetail(String channel, Object content, Collection<Long> userList) {
        if (userList == null || userList.size() == 0 || StringUtils.isEmpty((String)channel)) {
            return;
        }
        String notifyType = TaskTplNoticeService.getNotifyType(channel);
        MessageInfo messageInfo = TaskTplNoticeService.getMessageInfoByType(notifyType, content.toString(), userList);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private static String getNotifyType(String channel) {
        String[] channels = channel.split(",");
        ArrayList<String> realchannels = new ArrayList<String>(channels.length);
        block10: for (String s : channels) {
            if (StringUtils.isEmpty((String)s)) continue;
            switch (s) {
                case "1": {
                    realchannels.add("yunzhijia");
                    continue block10;
                }
                case "2": {
                    realchannels.add("sms");
                    continue block10;
                }
                case "3": {
                    realchannels.add("email");
                    continue block10;
                }
            }
        }
        return String.join((CharSequence)",", realchannels);
    }

    private static MessageInfo getMessageInfoByType(String type, String content, Collection<Long> receivers) {
        String title = ResManager.loadKDString((String)"\u4efb\u52a1\u7ba1\u7406\u6d88\u606f\u901a\u77e5", (String)"TaskTplNoticeService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        MessageInfo message = MessageServiceUtil.getBasicMessageInfo("message", type, title, content, Lists.newArrayList(receivers));
        return message;
    }

    private static List<Long> getMsgUsers(Long taskTemplateId) {
        TaskTemplateModel model = (TaskTemplateModel)ThreadCache.get((Object)String.valueOf(taskTemplateId), () -> TaskTemplateModel.dynToModel(taskTemplateId));
        return TaskTplNoticeService.getMsgUsersByOrgs(model).values().stream().flatMap(s -> s.stream()).distinct().collect(Collectors.toList());
    }

    private static Map<String, Set<Long>> getMsgUsersByOrgs(TaskTemplateModel taskTemplate) {
        Map<String, Set<Long>> org2users = new HashMap<String, Set<Long>>(1);
        List<TaskTemplateDisdimEntry> dims = taskTemplate.getTaskTemplateDisdim();
        Long modelId = taskTemplate.getModelId();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (TaskTemplateDisdimEntry entry : dims) {
            Long dimesionId = entry.getDisdimensionid();
            String dimNumber = MemberReader.getDimensionNumById((long)dimesionId);
            if (!SysDimensionEnum.Entity.getNumber().equalsIgnoreCase(dimNumber)) continue;
            int range = entry.getRange();
            Long valueid = entry.getMemberid();
            orgIds.addAll(QueryMemberDetailsHelper.queryMemberIdsMapByRange("bcm_entitymembertree", valueid, range, String.valueOf(modelId), DetailTypeEnum.OTHERS).keySet());
        }
        if (orgIds.size() > 0) {
            List<String> orgNumbers = TaskTplNoticeService.getOrgNumbers(modelId, orgIds);
            org2users = MemberPermHelper.getHasEntityPermByNumber(modelId, orgNumbers);
        }
        return org2users;
    }

    private static List<String> getOrgNumbers(Long modelId, Set<Long> orgIds) {
        ArrayList<String> orgNumbers = new ArrayList<String>(orgIds.size());
        for (Long orgId : orgIds) {
            IDNumberTreeNode node = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            orgNumbers.add(node.getNumber());
        }
        return orgNumbers;
    }

    private static List<Long> getMsgUsersByAssign(List<TaskTemplateActMsgEntry> msgEntryList) {
        if (CollectionUtils.isEmpty(msgEntryList)) {
            return new ArrayList<Long>(2);
        }
        ArrayList<Long> userList = new ArrayList<Long>(msgEntryList.size());
        ArrayList<Long> userGroup = new ArrayList<Long>(msgEntryList.size());
        for (TaskTemplateActMsgEntry msgEntry : msgEntryList) {
            if (msgEntry.getUsertype() == TaskTemplateModel.UserTypeEnum.USER) {
                userList.add(msgEntry.getUser());
                continue;
            }
            if (msgEntry.getUsertype() != TaskTemplateModel.UserTypeEnum.GROUP) continue;
            userGroup.add(msgEntry.getUser());
        }
        if (CollectionUtils.isNotEmpty(userGroup)) {
            Set ids = (Set)ThreadCache.get((Object)((Object)userGroup).toString(), () -> {
                DynamicObjectCollection users = UserDistributeServiceHelper.queryAllUsersByGroupIds(userGroup);
                return users.stream().map(s -> s.getLong("user")).collect(Collectors.toSet());
            });
            userList.addAll(ids);
        }
        return userList.stream().distinct().collect(Collectors.toList());
    }

    private static Map<String, String> getMessageParams(TaskRecordModel taskRecord, UserTaskModel userTask) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        List<TaskRecordModelFilterMemEntry> filterMems = taskRecord.getTaskRecordModelFilterMemEntry();
        for (TaskRecordModelFilterMemEntry e : filterMems) {
            String membermodel = e.getDimensionMembermodel();
            if (StringUtils.isEmpty((String)membermodel)) {
                String dimensionNumber = MemberReader.getDimensionNumById((long)e.getDimensionId());
                membermodel = SysDimensionEnum.getEnumByNumber((String)dimensionNumber).getMemberTreemodel();
                e.setDimensionNumber(dimensionNumber);
            }
            Long memberId = e.getMemberId();
            IDNumberTreeNode member = MemberReader.findMemberById((long)taskRecord.getModelId(), (String)membermodel, (Long)memberId);
            map.put(e.getDimensionNumber(), TaskTplNoticeService.format(member.getNumber() + " " + member.getName()));
        }
        if (null != userTask) {
            SysDimensionEnum disdim = SysDimensionEnum.getEnumByMemberTreemodel((String)userTask.getDimensiontype());
            map.put(disdim.getNumber(), TaskTplNoticeService.format(userTask.getMemberNumber() + " " + userTask.getMemberName()));
        }
        return map;
    }

    private static void getMessageParamsTpl(Map<String, String> messageParams, TaskTemplateModel taskTemplate, Collection<String> relatedOrgs) {
        List<TaskTemplateDisdimEntry> disdims = taskTemplate.getTaskTemplateDisdim();
        if (CollectionUtils.isEmpty(disdims)) {
            return;
        }
        String dimNumber = MemberReader.getDimensionNumById((long)disdims.get(0).getDisdimensionid());
        if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) && !CollectionUtils.isEmpty(relatedOrgs)) {
            messageParams.put(dimNumber, TaskTplNoticeService.format(String.join((CharSequence)",", relatedOrgs)));
            return;
        }
    }

    private static void getMessageParamsAct(Map<String, String> messageParams, TaskTemplateActModel model, List<UserTaskInfoModel> usertaskinfoList) {
        messageParams.put("CACT", TaskTplNoticeService.format(model.getActNameString()));
        String preAct = "";
        String nextAct = "";
        int index = 0;
        for (UserTaskInfoModel e : usertaskinfoList) {
            if (Objects.equals(e.getActivityModel().getId(), model.getId())) {
                if (index > 0) {
                    preAct = usertaskinfoList.get(index - 1).getActivityModel().getActNameString();
                }
                if (index < usertaskinfoList.size() - 1) {
                    nextAct = usertaskinfoList.get(index + 1).getActivityModel().getActNameString();
                }
            }
            ++index;
        }
        if (StringUtils.isNotEmpty((String)preAct)) {
            messageParams.put("PACT", TaskTplNoticeService.format(preAct));
        } else {
            messageParams.remove("PACT");
        }
        if (StringUtils.isNotEmpty((String)nextAct)) {
            messageParams.put("NACT", TaskTplNoticeService.format(nextAct));
        } else {
            messageParams.remove("NACT");
        }
    }

    private static String format(String value) {
        return String.format("[%s]", value);
    }
}

