/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.status;

import java.lang.reflect.Constructor;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskStatusEnum;
import kd.fi.bcm.business.taskmanage.status.OperateStatus;
import kd.fi.bcm.business.taskmanage.status.StatusContext;
import kd.fi.bcm.common.model.ResultBox;

public class AbstractStatus
implements OperateStatus {
    protected StatusContext statusContext;

    public AbstractStatus(StatusContext statusContext) {
        this.statusContext = statusContext;
    }

    @Override
    public String show() {
        StringBuilder s = new StringBuilder(this.showPrefix());
        if (StringUtils.isNotEmpty((String)this.statusContext.getActStatus())) {
            s.append(TaskStatusEnum.getEnumByCode(this.statusContext.getActStatus()).getName());
        }
        return s.toString();
    }

    protected String showPrefix() {
        return this.statusContext.getActName() + "\uff1a";
    }

    public static OperateStatus getInstance(StatusContext statusContext) {
        AbstractStatus statusObj = null;
        try {
            Class<AbstractStatus> clazz = TaskRelaOperEnum.NULL == statusContext.getRelaOperEnum() ? statusContext.getActivityTypeEnum().getStatusClass() : statusContext.getRelaOperEnum().getStatusClass();
            Constructor<?> constructor = clazz.getConstructors()[0];
            statusObj = (AbstractStatus)constructor.newInstance(statusContext);
        }
        catch (Exception e) {
            throw new KDBizException("create ShowStatus instance error");
        }
        return statusObj;
    }

    @Override
    public ResultBox finish() {
        return this.getSuccessResult();
    }

    @Override
    public ResultBox cancel() {
        return this.getSuccessResult();
    }

    protected ResultBox getSuccessResult() {
        ResultBox result = ResultBox.of();
        result.setData((Object)Boolean.TRUE);
        return result;
    }
}

