/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.status;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.allinone.model.MergeData;
import kd.fi.bcm.business.allinone.model.Status;
import kd.fi.bcm.business.mergecontrol.MergeControlService;
import kd.fi.bcm.business.mergecontrol.MergeMessage;
import kd.fi.bcm.business.mergecontrol.MergeStatusService;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.status.AbstractStatus;
import kd.fi.bcm.business.taskmanage.status.StatusContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StageOpTypeEnum;
import kd.fi.bcm.common.model.MessageInfo;
import kd.fi.bcm.common.model.ResultBox;
import org.apache.commons.collections4.CollectionUtils;

public class MergeStatus
extends AbstractStatus {
    private final MergeControlService mergeService = MergeControlService.getInstance();
    private static final String CACHEKEY_PRE = MergeStatus.class.getSimpleName() + ".";

    public MergeStatus(StatusContext statusContext) {
        super(statusContext);
    }

    @Override
    public String show() {
        String result;
        switch (this.statusContext.getRelaOperEnum()) {
            case MergeEcSubmit: {
                result = this.showPrefix() + this.mergeEcSubmit();
                break;
            }
            case MergePcSubmit: {
                result = this.showPrefix() + this.mergePcSubmit();
                break;
            }
            case MergeArchive: {
                result = this.showPrefix() + this.mergeArchive();
                break;
            }
            default: {
                result = super.show();
            }
        }
        return result;
    }

    @Override
    public ResultBox finish() {
        ResultBox result = null;
        switch (this.statusContext.getRelaOperEnum()) {
            case MergeEcSubmit: 
            case MergePcSubmit: {
                result = this.submmit(this.statusContext.getRelaOperEnum());
                break;
            }
            case MergeArchive: {
                result = this.archive();
                break;
            }
            default: {
                result = super.finish();
            }
        }
        return result;
    }

    @Override
    public ResultBox cancel() {
        ResultBox result = null;
        switch (this.statusContext.getRelaOperEnum()) {
            case MergeEcSubmit: 
            case MergePcSubmit: {
                result = this.back(this.statusContext.getRelaOperEnum());
                break;
            }
            case MergeArchive: {
                result = this.cancelArchive();
                break;
            }
            default: {
                result = super.cancel();
            }
        }
        return result;
    }

    private Object mergeEcSubmit() {
        MergeData mergeData = this.getMergeData();
        McStatus mcStatus = mergeData.getMergeStatus();
        return this.mergeService.getFlowName(this.getOrgNode(), mcStatus.getFlow().getStatus(), mergeData.getEcData(), true);
    }

    private Object mergePcSubmit() {
        MergeData mergeData = this.getMergeData();
        McStatus mcStatus = mergeData.getMergeStatus();
        return this.mergeService.getFlowName(this.getOrgNode(), mcStatus.getPcFlow().getStatus(), mergeData.getPcData(), false);
    }

    private Object mergeArchive() {
        return this.getArchiveName(this.getMcStatus().getArchive().getStatus());
    }

    private McStatus getMcStatus() {
        McStatus mcStatus = this.getMergeData().getMergeStatus();
        return mcStatus;
    }

    private Map<Long, MergeData> getMergeData(Set<Long> orgIds) {
        Map<Long, MergeData> mcDataMap = MergeStatusService.getInstance().batchGetMcData(this.statusContext.getModelId(), this.statusContext.getScenarioMemberId(), this.statusContext.getYearMemberId(), this.statusContext.getPeriodMemberId(), orgIds);
        return mcDataMap;
    }

    private MergeData getMergeData() {
        Set<Long> orgIds = this.statusContext.getOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            orgIds.add(this.statusContext.getEntityMemberId());
        }
        Map mcDataMap = this.statusContext.isCache() ? (Map)ThreadCache.get((Object)(CACHEKEY_PRE + orgIds), () -> this.getMergeData(orgIds)) : this.getMergeData(orgIds);
        MergeData mergeData = mcDataMap.get(this.statusContext.getEntityMemberId());
        return mergeData;
    }

    private IDNumberTreeNode getOrgNode() {
        return MemberReader.findEntityMemberById((Long)this.statusContext.getModelId(), (Long)this.statusContext.getEntityMemberId());
    }

    private String getArchiveName(String status) {
        return Objects.equals("D", status) ? ResManager.loadKDString((String)"\u5df2\u5f52\u6863", (String)"MergeStatus_0", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u5f52\u6863", (String)"MergeStatus_1", (String)"fi-bcm-business", (Object[])new Object[0]);
    }

    private ResultBox archive() {
        ResultBox result = this.checkPeriodStatus();
        if (null != result) {
            return result;
        }
        McStatus mcStatus = this.getMergeData().getMergeStatus();
        if (Objects.equals("D", mcStatus.getArchive().getStatus())) {
            return this.getSuccessResult();
        }
        result = this.mergeService.archive(this.statusContext.getFixedItem());
        result.setData((Object)result.isSuccess());
        return result;
    }

    private ResultBox cancelArchive() {
        ResultBox result = this.checkPeriodStatus();
        if (null != result) {
            return result;
        }
        McStatus mcStatus = this.getMergeData().getMergeStatus();
        if (!Objects.equals("D", mcStatus.getArchive().getStatus())) {
            return this.getSuccessResult();
        }
        result = this.mergeService.cancelArchive(this.statusContext.getFixedItem());
        result.setData((Object)result.isSuccess());
        return result;
    }

    private ResultBox submmit(TaskRelaOperEnum operEnum) {
        Status status;
        ResultBox result = this.checkPeriodStatus();
        if (null != result) {
            return result;
        }
        McStatus mcStatus = this.getMergeData().getMergeStatus();
        Status status2 = status = operEnum == TaskRelaOperEnum.MergeEcSubmit ? mcStatus.getFlow() : mcStatus.getPcFlow();
        if (Objects.equals("D", mcStatus.getArchive().getStatus()) || Objects.equals("C", status.getStatus())) {
            return this.getSuccessResult();
        }
        result = this.mergeService.stageOp(this.statusContext.getFixedItem(), this.getMergeStepOpDataMap(StageOpTypeEnum.COMMIT, operEnum));
        if (this.containMsg(result, MergeMessage.NONE_TASK)) {
            result.setData((Object)Boolean.TRUE);
        } else {
            result.setData((Object)result.isSuccess());
        }
        return result;
    }

    private ResultBox back(TaskRelaOperEnum operEnum) {
        ResultBox result = this.checkPeriodStatus();
        if (null != result) {
            return result;
        }
        result = this.mergeService.stageOp(this.statusContext.getFixedItem(), this.getMergeStepOpDataMap(StageOpTypeEnum.BACK, operEnum));
        if (this.containMsg(result, MergeMessage.NONE_TASK)) {
            result.setData((Object)Boolean.TRUE);
        } else {
            result.setData((Object)result.isSuccess());
        }
        return result;
    }

    private Map<String, Object> getMergeStepOpDataMap(StageOpTypeEnum stageOpTypeEnum, TaskRelaOperEnum operEnum) {
        if (null == stageOpTypeEnum) {
            return Collections.emptyMap();
        }
        String isEc = operEnum == TaskRelaOperEnum.MergeEcSubmit ? "EC" : "PC";
        HashMap<String, Object> resultMap = new HashMap<String, Object>(10);
        resultMap.put("stepid", null);
        resultMap.put("opinion", "");
        resultMap.put("includeson", "1");
        resultMap.put("stageoptype", stageOpTypeEnum.getCode());
        resultMap.put("isEc", isEc);
        resultMap.put("forcecommit", Boolean.FALSE);
        return resultMap;
    }

    private boolean containMsg(ResultBox result, MergeMessage mergeMessage) {
        boolean flag = false;
        String msg = mergeMessage.getText().replaceAll("%s", "");
        for (MessageInfo info : result.getMessageList()) {
            if (!info.getMessage().contains(msg)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private ResultBox checkPeriodStatus() {
        ResultBox resultBox = null;
        Long modelId = this.statusContext.getModelId();
        if (ConfigServiceHelper.getBoolParam(modelId, "CM012")) {
            String orgNumber = this.statusContext.getFixedItem().getEntityNum();
            if (!PeriodSettingHelper.checkPeriodStatus(modelId, orgNumber, this.statusContext.getScenarioMemberId(), this.statusContext.getYearMemberId(), this.statusContext.getPeriodMemberId(), "datastatus")) {
                resultBox = ResultBox.of();
                resultBox.setData((Object)Boolean.FALSE);
                resultBox.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u8bf7\u524d\u5f80\u201c\u671f\u95f4\u7ba1\u7406\u201d\u5f00\u542f\u3002", (String)"MergeStatus_2", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
        }
        return resultBox;
    }
}

