/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.status;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.taskmanage.helper.TaskRecordServiceHelper;
import kd.fi.bcm.business.taskmanage.status.AbstractStatus;
import kd.fi.bcm.business.taskmanage.status.StatusContext;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.model.ResultBox;

public class ReportStatus
extends AbstractStatus {
    public ReportStatus(StatusContext statusContext) {
        super(statusContext);
    }

    @Override
    public ResultBox finish() {
        ResultBox result = this.checkFinish();
        if (null != result) {
            return result;
        }
        return super.finish();
    }

    @Override
    public ResultBox cancel() {
        return super.cancel();
    }

    private ResultBox checkFinish() {
        ResultBox resultBox = null;
        Pair<Boolean, List<Long>> tplByUsertaskPair = TaskRecordServiceHelper.getTaskRecordTemplateIds(this.statusContext.getModelId(), this.statusContext.getEntityMemberId(), this.statusContext.getUserTaskInfoId(), false);
        boolean isCycletable = (Boolean)tplByUsertaskPair.p1;
        HashSet<Long> tplByUsertask = new HashSet<Long>((Collection)tplByUsertaskPair.p2);
        HashSet<Long> allTemplates = !isCycletable ? this.queryTemplateGroup(tplByUsertask) : tplByUsertask;
        Set<Long> commitedTemplate = this.getCommitedTemplate(isCycletable, tplByUsertask);
        if (!commitedTemplate.containsAll(allTemplates)) {
            resultBox = ResultBox.of();
            resultBox.setData((Object)Boolean.FALSE);
            resultBox.add(!isCycletable ? ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5b8c\u6210\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u5b58\u5728\u672a\u4e0a\u62a5\u7684\u62a5\u8868\u3002", (String)"ReportStatus_1", (String)"fi-bcm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5b8c\u6210\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a\u5b58\u5728\u672a\u4e0a\u62a5\u7684\u5957\u8868\u3002", (String)"ReportStatus_2", (String)"fi-bcm-business", (Object[])new Object[0]));
        }
        return resultBox;
    }

    private Set<Long> getCommitedTemplate(boolean isCycletable, Set<Long> cycleIds) {
        long modelId = this.statusContext.getModelId();
        long entityId = this.statusContext.getEntityMemberId();
        String currencyNumber = MemberReader.findEntityMemberById((Long)modelId, (Long)entityId).getCurrency();
        if (!isCycletable) {
            return ReportServiceHelper.getCommitTemplateByReport(this.statusContext.getModelId(), this.statusContext.getScenarioMemberId(), this.statusContext.getYearMemberId(), this.statusContext.getPeriodMemberId(), entityId, currencyNumber);
        }
        return ReportServiceHelper.getCommitCycleTableByReport(this.statusContext.getModelId(), this.statusContext.getScenarioMemberId(), this.statusContext.getYearMemberId(), this.statusContext.getPeriodMemberId(), entityId, currencyNumber, cycleIds);
    }

    private Set<Long> queryTemplateGroup(Set<Long> templateIds) {
        String group = "group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)group, (QFilter[])new QFilter("id", "in", templateIds).toArray());
        return queryResult.stream().map(e -> e.getLong(group)).collect(Collectors.toSet());
    }
}

