/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.taskmanage.status;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.taskmanage.enums.TaskActivityTypeEnum;
import kd.fi.bcm.business.taskmanage.enums.TaskRelaOperEnum;
import kd.fi.bcm.business.taskmanage.model.TaskTemplateActModel;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;

public class StatusContext {
    private TaskActivityTypeEnum activityTypeEnum;
    private TaskRelaOperEnum relaOperEnum;
    private String actName;
    private String actStatus;
    private Long entityMemberId;
    private Long modelId;
    private Long scenarioMemberId;
    private Long yearMemberId;
    private Long periodMemberId;
    private FixedItem fixedItem;
    private Map<TaskActivityTypeEnum, Set<Long>> orgIds;
    private boolean isCache;
    private Long userTaskInfoId;

    public void init(TaskTemplateActModel act, String actStatus) {
        this.relaOperEnum = act.getRelevantop();
        this.activityTypeEnum = act.getActType();
        this.actName = act.getActNameString();
        this.actStatus = actStatus;
    }

    public TaskActivityTypeEnum getActivityTypeEnum() {
        return this.activityTypeEnum;
    }

    public TaskRelaOperEnum getRelaOperEnum() {
        return this.relaOperEnum;
    }

    public String getActName() {
        return this.actName;
    }

    public String getActStatus() {
        return this.actStatus;
    }

    public Long getEntityMemberId() {
        return this.entityMemberId;
    }

    public void setEntityMemberId(Long entityMemberId) {
        this.entityMemberId = entityMemberId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public void setFilterMembers(Long modelId, Map<String, Tuple<Long, String, String>> filterMembers, String modelNumber, SimpleItem orgItem) {
        this.modelId = modelId;
        if (null == filterMembers || filterMembers.isEmpty()) {
            return;
        }
        SimpleItem scenarioItem = this.getSimpleItem(filterMembers, SysDimensionEnum.Scenario);
        SimpleItem yearItem = this.getSimpleItem(filterMembers, SysDimensionEnum.Year);
        SimpleItem periodItem = this.getSimpleItem(filterMembers, SysDimensionEnum.Period);
        this.scenarioMemberId = (Long)scenarioItem.getId();
        this.yearMemberId = (Long)yearItem.getId();
        this.periodMemberId = (Long)periodItem.getId();
        if (StringUtils.isNotEmpty((String)modelNumber)) {
            this.fixedItem = FixedItem.newOne(SimpleItem.newOne(modelId, modelNumber), scenarioItem, yearItem, periodItem, orgItem);
            ArrayList<SimpleItem> orgList = new ArrayList<SimpleItem>(8);
            orgList.add(orgItem);
            this.fixedItem.setOrgList(orgList);
        }
    }

    private SimpleItem getSimpleItem(Map<String, Tuple<Long, String, String>> filterMemberMap, SysDimensionEnum dimensionEnum) {
        Tuple<Long, String, String> t = filterMemberMap.get(dimensionEnum.getNumber());
        return null != t ? SimpleItem.newOne(t.p1, (String)t.p2) : SimpleItem.newOne(0L, "");
    }

    public Long getScenarioMemberId() {
        return this.scenarioMemberId;
    }

    public Long getYearMemberId() {
        return this.yearMemberId;
    }

    public Long getPeriodMemberId() {
        return this.periodMemberId;
    }

    public FixedItem getFixedItem() {
        return this.fixedItem;
    }

    public void setOrgIds(Map<TaskActivityTypeEnum, Set<Long>> orgIds) {
        this.orgIds = orgIds;
    }

    public Set<Long> getOrgIds() {
        if (null != this.orgIds) {
            return this.orgIds.computeIfAbsent(this.activityTypeEnum, k -> new HashSet(1));
        }
        return new HashSet<Long>(1);
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setCache(boolean cache) {
        this.isCache = cache;
    }

    public Long getUserTaskInfoId() {
        return this.userTaskInfoId;
    }

    public void setUserTaskInfoId(Long userTaskInfoId) {
        this.userTaskInfoId = userTaskInfoId;
    }
}

