/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.permission.permclass.PermClassCache;
import kd.fi.bcm.business.report.cache.NoPluginCache;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.TemplateRangeService;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.util.BCMTreeUtils;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.spread.common.TemplateConstant;
import org.apache.commons.collections.CollectionUtils;

public class TemplatePermCrossUtil {
    public static String ID = TemplateConstant.ID;
    public static String NUMBER = TemplateConstant.NUMBER;
    public static String NAME = TemplateConstant.NAME;
    private static final String modelf7id = "modelf7id";
    private static final String yearf7id = "yearf7id";
    private static final String periodf7id = "periodf7id";

    public static QFilter getTemplateQFilterForReportList(QFilter guideFilter, Set<Long> rTempIds, HashMap<String, Long> f7IdMap) {
        Set<Object> ids = new HashSet(16);
        HashMap numberToIdMap = new HashMap(16);
        QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number", (QFilter[])guideFilter.toArray()).forEach(e -> numberToIdMap.put(e.getLong("id"), e.getString("number")));
        ids = numberToIdMap.keySet();
        if (ids.isEmpty()) {
            guideFilter.and(TemplatePermCrossUtil.getFalsefilter());
            return guideFilter;
        }
        Map<Long, Long> rightTplIdByVersioned = TemplateUtil.getRightTplIdByVersioned(f7IdMap.get(modelf7id), f7IdMap.get(yearf7id), f7IdMap.get(periodf7id), ids, true);
        HashSet numbers = new HashSet(16);
        rightTplIdByVersioned.forEach((k, v) -> numbers.add(numberToIdMap.get(v)));
        ids.forEach(id -> {
            Long trueId = (Long)rightTplIdByVersioned.get(id);
            if (trueId == null) {
                if (numberToIdMap.get(id) != null && !numbers.contains(numberToIdMap.get(id))) {
                    rTempIds.add((Long)id);
                }
            } else {
                rTempIds.add(trueId);
            }
        });
        return guideFilter;
    }

    public static DynamicObjectCollection getCatalogDyos(long modelId) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("getCatalogDyos_" + modelId), () -> QueryServiceHelper.query((String)"bcm_templatecatalog", (String)"id,name,number,parent,isleaf,level", (QFilter[])TemplatePermCrossUtil.getTemplateCatalogFilter(modelId).toArray(), (String)"sequence"));
    }

    public static void buildTemplateTree(IPageCache pageCache, long modelId, TreeNode treeNode, Collection<Long> tempCatalogIds) {
        DynamicObjectCollection objects = TemplatePermCrossUtil.getCatalogDyos(modelId);
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        pageCache.remove(TemplateConstant.FOCUSNODEID);
        String headid = "";
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            ArrayList<Long> noCatalogPermIds = new ArrayList<Long>(16);
            PermClassCache.removePermissionCache(pageCache, "bcm_templateentity");
            PermClassCache.removePermissionCache(pageCache, "bcm_templatecatalog");
            Map<Long, List<DynamicObject>> map = TemplatePermCrossUtil.getCatalogToTemplateMap(pageCache, modelId, true, false, noCatalogPermIds);
            Set<Long> cataLogIds = TemplatePermCrossUtil.getCataLogSet(objects, noCatalogPermIds, map);
            if (tempCatalogIds != null) {
                cataLogIds.retainAll(tempCatalogIds);
            }
            if (!cataLogIds.isEmpty()) {
                for (DynamicObject task : objects) {
                    long id = task.getLong(ID);
                    if (!cataLogIds.contains(id)) continue;
                    treeList.add(TemplatePermCrossUtil.getSingeleCataLogMap(task));
                    if (!TemplateConstant.ROOT_ID.equals(task.get(TemplateConstant.PARENT).toString())) continue;
                    headid = task.get(ID).toString();
                    treeNode.setId(headid);
                    pageCache.put(TemplateConstant.FOCUSNODEID, headid);
                    pageCache.put(TemplateConstant.HEADNODEID, headid);
                }
            }
        }
        TemplatePermCrossUtil.commonAction(pageCache, treeNode, headid, treeList);
    }

    public static void appendSonCatalog(List<Long> noCatalogPermIds, DynamicObjectCollection objects) {
        if (!noCatalogPermIds.isEmpty() && !objects.isEmpty()) {
            Set<Long> idSet = noCatalogPermIds.stream().collect(Collectors.toSet());
            HashMap<Long, List<Long>> parentCataLogMap = new HashMap<Long, List<Long>>(objects.size());
            objects.stream().forEach(e -> {
                long id = e.getLong(TemplateConstant.PARENT);
                parentCataLogMap.computeIfAbsent(id, k -> new ArrayList(16)).add(e.getLong(ID));
            });
            TemplatePermCrossUtil.appendSonCatalog(idSet, parentCataLogMap);
            idSet.addAll(noCatalogPermIds);
            noCatalogPermIds.clear();
            noCatalogPermIds.addAll(idSet.stream().collect(Collectors.toList()));
        }
    }

    public static void appendSonCatalog(Set<Long> idSet, Map<Long, List<Long>> parentCataLogMap) {
        if (idSet.isEmpty() || parentCataLogMap.isEmpty()) {
            return;
        }
        parentCataLogMap.forEach((k, v) -> {
            if (idSet.contains(k)) {
                idSet.addAll((Collection<Long>)v);
                TemplatePermCrossUtil.appendSonForCatalog(idSet, parentCataLogMap, v);
            }
        });
    }

    private static void appendSonForCatalog(Set<Long> idSet, Map<Long, List<Long>> parentCataLogMap, Collection<Long> sons) {
        sons.forEach(id -> {
            List list;
            if (CollectionUtils.isNotEmpty((Collection)((Collection)parentCataLogMap.get(id))) && !idSet.containsAll(list = (List)parentCataLogMap.get(id))) {
                idSet.addAll(list);
                TemplatePermCrossUtil.appendSonForCatalog(idSet, parentCataLogMap, list);
            }
        });
    }

    private static Set<Long> getCataLogSet(DynamicObjectCollection objects, List<Long> noCatalogPermIds, Map<Long, List<DynamicObject>> map) {
        HashSet<Long> cataLogIds = new HashSet<Long>(16);
        if (!objects.isEmpty()) {
            if (noCatalogPermIds.isEmpty()) {
                objects.forEach(e -> cataLogIds.add(e.getLong(ID)));
            } else {
                Map<Long, DynamicObject> cataLogMap = objects.stream().collect(Collectors.toMap(e -> e.getLong(ID), e -> e));
                for (DynamicObject task : objects) {
                    if (noCatalogPermIds.contains(task.getLong(ID)) && map.get(task.getLong(ID)) == null || !cataLogIds.add(task.getLong(ID))) continue;
                    TemplatePermCrossUtil.addSingleNoPermParentCatalog(cataLogMap, cataLogIds, task);
                }
            }
        }
        return cataLogIds;
    }

    private static void addSingleNoPermParentCatalog(Map<Long, DynamicObject> map, Set<Long> cataLogIds, DynamicObject dyo) {
        long parentId = dyo.getLong(TemplateConstant.PARENT);
        if (parentId != 0L && !cataLogIds.contains(parentId) && map.get(parentId) != null) {
            DynamicObject parent = map.remove(parentId);
            cataLogIds.add(parent.getLong(ID));
            TemplatePermCrossUtil.addSingleNoPermParentCatalog(map, cataLogIds, parent);
        }
    }

    public static Map<String, String> getSingeleCataLogMap(DynamicObject task) {
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        memberMap.put(ID, task.get(ID).toString());
        memberMap.put(NUMBER, (String)task.get(NUMBER));
        memberMap.put(NAME, (String)task.get(NAME));
        memberMap.put(TemplateConstant.PARENTID, task.get(TemplateConstant.PARENT).toString());
        return memberMap;
    }

    private static void filterMap(Map<Long, List<DynamicObject>> map, List<Long> noCatalogPermIds, List<Long> hasPermIds) {
        if (!noCatalogPermIds.isEmpty()) {
            noCatalogPermIds.forEach(id -> {
                if (map.get(id) != null) {
                    List list = ((List)map.get(id)).stream().filter(e -> hasPermIds.contains(e.getLong(ID))).collect(Collectors.toList());
                    if (list.isEmpty()) {
                        map.remove(id);
                    } else {
                        map.put((Long)id, list);
                    }
                }
            });
        }
    }

    private static Map<Long, List<DynamicObject>> getTemplateCataLogMap(DynamicObjectCollection dynamicObjects, long headId) {
        LinkedHashMap<Long, List<DynamicObject>> map = new LinkedHashMap<Long, List<DynamicObject>>(16);
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(e -> {
                long catalogId = headId;
                if (e.getLong("templatecatalog.id") != 0L) {
                    catalogId = e.getLong("templatecatalog.id");
                }
                map.computeIfAbsent(catalogId, k -> new ArrayList(16)).add(e);
            });
        }
        return map;
    }

    public static QFilter getTemplateCatalogFilter(Long modelId) {
        return new QFilter("model", "=", (Object)modelId).and(TemplateCatalogTypeEnum.getTemplateCalcogFilter());
    }

    public static QFilter getCommonTemplateQfilter(boolean isQuery, Long modelId, boolean isFromTemplate) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
        if (!isFromTemplate) {
            qFilter.and("status", "=", (Object)TemplateModel.TplStatus.ENABLE.getStatuValue());
            if (!isQuery) {
                qFilter.and("usage", "=", (Object)TemplateModel.UsageEnum.WEAVE.getStatuValue());
            }
        }
        return qFilter;
    }

    public static void buildOldTemplateTree(IPageCache pageCache, long modelId, TreeNode templatecatalog, String algoKey, String entityName, String selectFields, QFilter ftype, Map<String, Object> extParam) {
        String modelID = Long.toString(modelId);
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid, ftype};
        String orderBys = "sequence";
        String headid = (String)extParam.getOrDefault("rootNodeId", "");
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        pageCache.remove(TemplateConstant.FOCUSNODEID);
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            boolean adminUserBol = MemberPermHelper.isModelManager(modelId);
            List<Object> noPerms = new ArrayList(16);
            if (!adminUserBol) {
                PermClassCache.cacheNewPermission(pageCache, entityName, modelID);
                noPerms = PermClassCache.getPermissionMap(pageCache, entityName, DataTypeEnum.NO);
            }
            for (DynamicObject task : dcs) {
                if (!adminUserBol && noPerms.contains(task.getLong(ID))) continue;
                treeList.add(TemplatePermCrossUtil.getSingeleCataLogMap(task));
                if (StringUtils.isNotEmpty((String)headid)) {
                    if (!headid.equals(task.getString("id"))) continue;
                    headid = task.get(ID).toString();
                    templatecatalog.setId(headid);
                    templatecatalog.setText(task.getString(NAME));
                    pageCache.put(TemplateConstant.FOCUSNODEID, headid);
                    pageCache.put(TemplateConstant.HEADNODEID, headid);
                    continue;
                }
                if (!TemplateConstant.ROOT_ID.equals(task.get(TemplateConstant.PARENT).toString())) continue;
                headid = task.get(ID).toString();
                templatecatalog.setId(headid);
                pageCache.put(TemplateConstant.FOCUSNODEID, headid);
                pageCache.put(TemplateConstant.HEADNODEID, headid);
            }
        }
        TemplatePermCrossUtil.commonAction(pageCache, templatecatalog, headid, treeList);
    }

    public static void buildAdjustCalogTree(IPageCache pageCache, long modelId, TreeNode templatecatalog) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("catalogtype", "=", (Object)(TemplateCatalogTypeEnum.ADJCATALOG.getType() + "")).or("parent.id", "=", (Object)0));
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"buildAdjustCalogTree", (String)"bcm_templatecatalog", (String)"id,name,number,parent,catalogtype", (QFilter[])new QFilter[]{qFilter}, (String)"sequence");
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(16);
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            LinkedHashMap<Long, List<Long>> p2TreeDyMap = new LinkedHashMap<Long, List<Long>>(16);
            LinkedHashMap<Long, DynamicObject> pk2DyMap = new LinkedHashMap<Long, DynamicObject>(dcs.size());
            Set<Long> noPerms = MemberPermHelper.isModelManager(modelId) ? Collections.emptySet() : PermClassCache.getPermClassIds(modelId, "bcm_templatecatalog", DataTypeEnum.NO);
            for (DynamicObject calDy : dcs) {
                p2TreeDyMap.computeIfAbsent(calDy.getLong("parent"), a -> Lists.newArrayList()).add(calDy.getLong("id"));
                pk2DyMap.put(calDy.getLong("id"), calDy);
                if (calDy.getLong("parent") != 0L) continue;
                templatecatalog.setId(calDy.getString("id"));
                templatecatalog.setText(ResManager.loadKDString((String)"\u5206\u5f55\u5206\u7c7b", (String)"RptAdjustdListPlugin_127", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            TemplatePermCrossUtil.dealNoPermTreeNode(0L, p2TreeDyMap, noPerms, pk2DyMap, treeList);
        }
        pageCache.put(TemplateConstant.HEADNODEID, templatecatalog.getId());
        pageCache.put(TemplateConstant.FOCUSNODEID, templatecatalog.getId());
        TemplatePermCrossUtil.commonAction(pageCache, templatecatalog, templatecatalog.getId(), treeList);
    }

    private static boolean dealNoPermTreeNode(long pId, Map<Long, List<Long>> p2TreeDyMap, Set<Long> noPerms, Map<Long, DynamicObject> pk2DyMap, List<Map<String, String>> treeList) {
        List<Long> childList = p2TreeDyMap.get(pId);
        if (!CollectionUtil.isEmpty(childList)) {
            childList.removeIf(childPk -> !TemplatePermCrossUtil.dealNoPermTreeNode(childPk, p2TreeDyMap, noPerms, pk2DyMap, treeList));
        }
        if (CollectionUtil.isEmpty(childList) && noPerms.contains(pId)) {
            return false;
        }
        if (pk2DyMap.containsKey(pId)) {
            treeList.add(TemplatePermCrossUtil.getSingeleCataLogMap(pk2DyMap.get(pId)));
        }
        return true;
    }

    private static void commonAction(IPageCache pageCache, TreeNode templatecatalog, String headid, List<Map<String, String>> treeList) {
        templatecatalog.setParentid("");
        pageCache.put(TemplateConstant.TREELIST, SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNode((TreeNode)templatecatalog, treeList, (String)headid);
        BCMTreeUtils.spreadAllNode((TreeNode)templatecatalog);
    }

    public static void dealTemplatePermClassFilter(long modelId, QFilter qFilter1, boolean isMyTemplate) {
        if (MemberPermHelper.isModelManager(modelId)) {
            return;
        }
        if (ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.IS_USE_PERMISSION_CROSS.getNumber())) {
            qFilter1.and(TemplatePermCrossUtil.getTempPCFilterByUserPermCross(modelId, isMyTemplate));
        } else {
            NoPluginCache pageCache = new NoPluginCache();
            PermClassCache.cacheNewPermission(pageCache, "bcm_templateentity", Long.toString(modelId));
            List<Long> noPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.NO);
            if (CollectionUtils.isNotEmpty(noPermIds)) {
                qFilter1.and(isMyTemplate ? "template.id" : ID, "not in", noPermIds);
            }
            PermClassCache.cacheNewPermission(pageCache, "bcm_templatecatalog", String.valueOf(modelId));
            List<Long> noCatalogPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templatecatalog", DataTypeEnum.NO);
            if (!noCatalogPermIds.isEmpty()) {
                TemplatePermCrossUtil.appendSonCatalog(noCatalogPermIds, TemplatePermCrossUtil.getCatalogDyos(modelId));
                qFilter1.and("templatecatalog", "not in", noCatalogPermIds);
            }
        }
    }

    public static List<QFilter> filterNoPermTemplateCatalog(long modelId, IPageCache pageCache) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(TemplatePermCrossUtil.getTemplateCatalogFilter(modelId));
        if (!MemberPermHelper.isModelManager(modelId)) {
            List<Long> noCatalogPermIds;
            if (!PermClassCache.isExistsPermClassCache(pageCache, "bcm_templatecatalog")) {
                PermClassCache.cacheNewPermission(pageCache, "bcm_templatecatalog", String.valueOf(modelId));
            }
            if (!(noCatalogPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templatecatalog", DataTypeEnum.NO)).isEmpty()) {
                DynamicObjectCollection objects = TemplatePermCrossUtil.getCatalogDyos(modelId);
                TemplatePermCrossUtil.appendSonCatalog(noCatalogPermIds, objects);
                if (ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.IS_USE_PERMISSION_CROSS.getNumber())) {
                    List<Object> hasPermIds = new ArrayList(16);
                    if (!PermClassCache.isExistsPermClassCache(pageCache, "bcm_templateentity")) {
                        PermClassCache.cacheNewPermission(pageCache, "bcm_templateentity", String.valueOf(modelId));
                    }
                    hasPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.READ);
                    hasPermIds.addAll(PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.WRITEIN));
                    if (CollectionUtils.isNotEmpty(hasPermIds)) {
                        QFilter qfilter = TemplatePermCrossUtil.getCommonTemplateQfilter(true, modelId, true);
                        qfilter.and("id", "in", hasPermIds);
                        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,group,versionnumber,name,templatecatalog.id", (QFilter[])new QFilter[]{qfilter}, (String)TemplateUtil.getListEntryOrderBy(true));
                        Map<Long, List<DynamicObject>> map = TemplatePermCrossUtil.getTemplateCataLogMap(dynamicObjects, TemplatePermCrossUtil.findHeadId(objects));
                        Set noCatalogPerms = noCatalogPermIds.stream().collect(Collectors.toSet());
                        noCatalogPermIds.clear();
                        map.forEach((k, v) -> {
                            if (CollectionUtils.isNotEmpty((Collection)v)) {
                                noCatalogPerms.remove(k);
                            }
                        });
                        noCatalogPermIds.addAll(noCatalogPerms);
                    }
                }
                if (CollectionUtils.isNotEmpty(noCatalogPermIds)) {
                    qFilters.add(new QFilter("id", "not in", noCatalogPermIds));
                }
            }
        }
        return qFilters;
    }

    public static QFilter getTempPCFilterByUserPermCross(long modelId, boolean isMyTemplate) {
        NoPluginCache pageCache = new NoPluginCache();
        Map<Long, List<DynamicObject>> catalogToTemplateMap = TemplatePermCrossUtil.getCatalogToTemplateMap(pageCache, modelId, true, false, new ArrayList<Long>(16));
        if (catalogToTemplateMap.isEmpty()) {
            return TemplatePermCrossUtil.getFalsefilter();
        }
        HashSet idSet = new HashSet(16);
        catalogToTemplateMap.values().forEach(list -> {
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.stream().forEach(e -> idSet.add(e.getLong(ID)));
            }
        });
        return new QFilter(isMyTemplate ? "template.id" : ID, "in", idSet);
    }

    public static Map<Long, List<DynamicObject>> getCatalogToTemplateMap(IPageCache pageCache, long modelId, boolean isFromTemplate, boolean isQuery, List<Long> noCatalogPermIds) {
        return TemplatePermCrossUtil.getCatalogToTemplateMap(pageCache, modelId, isFromTemplate, isQuery, noCatalogPermIds, RequestContext.get().getCurrUserId());
    }

    public static Map<Long, List<DynamicObject>> getCatalogToTemplateMap(IPageCache pageCache, long modelId, boolean isFromTemplate, boolean isQuery, List<Long> noCatalogPermIds, long userId) {
        QFilter qfilter = TemplatePermCrossUtil.getCommonTemplateQfilter(isQuery, modelId, isFromTemplate);
        boolean adminUserBol = MemberPermHelper.ifUserHasRootPermByModel(userId, Long.toString(modelId));
        List<Object> noPermIds = new ArrayList(16);
        List<Object> hasPermIds = new ArrayList(16);
        if (!adminUserBol) {
            if (!PermClassCache.isExistsPermClassCache(pageCache, "bcm_templateentity")) {
                PermClassCache.cacheNewPermission(pageCache, "bcm_templateentity", String.valueOf(modelId), String.valueOf(userId));
            }
            noPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.NO);
            qfilter.and(ID, "not in", noPermIds);
            hasPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.READ);
            hasPermIds.addAll(PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.WRITEIN));
            PermClassCache.cacheNewPermission(pageCache, "bcm_templatecatalog", String.valueOf(modelId), String.valueOf(userId));
            noCatalogPermIds.addAll(PermClassCache.getPermissionMap(pageCache, "bcm_templatecatalog", DataTypeEnum.NO));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,number,group,versionnumber,name,templatecatalog.id", (QFilter[])new QFilter[]{qfilter}, (String)TemplateUtil.getListEntryOrderBy(true));
        DynamicObjectCollection objects = TemplatePermCrossUtil.getCatalogDyos(modelId);
        Map<Long, List<DynamicObject>> map = TemplatePermCrossUtil.getTemplateCataLogMap(dynamicObjects, TemplatePermCrossUtil.findHeadId(objects));
        if (!adminUserBol) {
            TemplatePermCrossUtil.appendSonCatalog(noCatalogPermIds, objects);
            TemplatePermCrossUtil.filterMap(map, noCatalogPermIds, hasPermIds);
        }
        return map;
    }

    private static long findHeadId(DynamicObjectCollection objects) {
        Optional<DynamicObject> rootCataLog;
        long headId = 0L;
        if (!objects.isEmpty() && (rootCataLog = objects.stream().filter(TemplatePermCrossUtil.getRootPredicate()).findFirst()).isPresent()) {
            headId = rootCataLog.get().getLong(ID);
        }
        return headId;
    }

    private static Predicate<DynamicObject> getRootPredicate() {
        return new Predicate<DynamicObject>(){

            @Override
            public boolean test(DynamicObject dyo) {
                return TemplateCatalogEnum.ROOT.getNumber().equals(dyo.getString(NUMBER));
            }
        };
    }

    public static List<TemplateModel> hasPermTemplates(final List<Long> templateIds, long modelId, final Object fyId, final Object scId, final Object periodId) {
        if (templateIds.isEmpty()) {
            return new ArrayList<TemplateModel>(16);
        }
        TemplatePermCrossUtil.filterNoPermTemplateByUserPermCross(templateIds, modelId, false);
        List<TemplateModel> templateModels = TemplateUtil.batchGetTemplateModel(templateIds, modelId, true);
        templateIds.clear();
        Predicate<TemplateModel> predicate = new Predicate<TemplateModel>(){

            @Override
            public boolean test(TemplateModel o) {
                if (o.getUsage().equals(TemplateModel.UsageEnum.QUERY.getStatuValue()) || TemplateModel.TplStatus.DISABLE == o.getStatus() || o.isSaveByDim() && (!TemplateRangeService.isInnerRange("bcm_fymembertree", o, fyId, true) || !TemplateRangeService.isInnerRange("bcm_scenemembertree", o, scId, true) || !TemplateRangeService.isInnerRange("bcm_periodmembertree", o, periodId, true))) {
                    return false;
                }
                templateIds.add(o.getId());
                return true;
            }
        };
        templateModels = templateModels.stream().filter(predicate).collect(Collectors.toList());
        return templateModels;
    }

    private static void filterNoPermTemplateByUserPermCross(List<Long> templateIds, long modelId, boolean isQuery) {
        TemplatePermCrossUtil.filterNoPermTemplateByUserPermCross(templateIds, modelId, isQuery, RequestContext.get().getCurrUserId());
    }

    public static void filterNoPermTemplateByUserPermCross(List<Long> templateIds, long modelId, boolean isQuery, long userId) {
        if (MemberPermHelper.ifUserHasRootPermByModel(userId, Long.toString(modelId))) {
            return;
        }
        NoPluginCache pageCache = new NoPluginCache();
        if (ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.IS_USE_PERMISSION_CROSS.getNumber())) {
            Map<Long, List<DynamicObject>> map = TemplatePermCrossUtil.getCatalogToTemplateMap(pageCache, modelId, true, isQuery, new ArrayList<Long>(16), userId);
            if (map.isEmpty()) {
                templateIds.clear();
            } else {
                ArrayList ids = new ArrayList(16);
                map.forEach((k, v) -> v.forEach(e -> ids.add(e.getLong(ID))));
                templateIds.retainAll(ids);
            }
        } else {
            ArrayList<Long> noCatalogPermIds = new ArrayList<Long>(16);
            PermClassCache.cacheNewPermission(pageCache, "bcm_templateentity", String.valueOf(modelId), String.valueOf(userId));
            List<Long> noPermIds = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.NO);
            if (!noPermIds.isEmpty()) {
                templateIds.removeAll(noPermIds);
            }
            if (templateIds.isEmpty()) {
                return;
            }
            PermClassCache.cacheNewPermission(pageCache, "bcm_templatecatalog", String.valueOf(modelId), String.valueOf(userId));
            noCatalogPermIds.addAll(PermClassCache.getPermissionMap(pageCache, "bcm_templatecatalog", DataTypeEnum.NO));
            TemplatePermCrossUtil.filterNoPermCatalogTemps(modelId, noCatalogPermIds, templateIds);
        }
        PermClassCache.removePermissionCache(pageCache, "bcm_templatecatalog");
        PermClassCache.removePermissionCache(pageCache, "bcm_templateentity");
    }

    private static void filterNoPermCatalogTemps(long modelId, List<Long> noCatalogPermIds, List<Long> templateIds) {
        DynamicObjectCollection objects = TemplatePermCrossUtil.getCatalogDyos(modelId);
        TemplatePermCrossUtil.appendSonCatalog(noCatalogPermIds, objects);
        if (!templateIds.isEmpty() && !noCatalogPermIds.isEmpty()) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,templatecatalog.id", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
            Map<Long, List<DynamicObject>> map = TemplatePermCrossUtil.getTemplateCataLogMap(dynamicObjects, TemplatePermCrossUtil.findHeadId(objects));
            noCatalogPermIds.forEach(cid -> {
                List objectList = (List)map.get(cid);
                if (CollectionUtils.isNotEmpty((Collection)objectList)) {
                    objectList.forEach(d -> templateIds.remove(d.getLong("id")));
                }
            });
        }
    }

    public static DynamicObjectCollection hasPermCatalogs(long modelId, String entityName, QFilter qFilter) {
        return (DynamicObjectCollection)ThreadCache.get((Object)("hasPermCatalogs_" + entityName + "_" + modelId + "_" + RequestContext.get().getUserId()), () -> TemplatePermCrossUtil.hasPermCatalogsByDB(modelId, entityName, qFilter));
    }

    public static DynamicObjectCollection hasPermCatalogsByDB(long modelId, String entityName, QFilter qFilter) {
        NoPluginCache pageCache = new NoPluginCache();
        QFilter filter = TemplatePermCrossUtil.getTemplateCatalogFilter(modelId);
        if (qFilter != null) {
            filter.clearNests();
            filter = qFilter;
        }
        if (!MemberPermHelper.isModelManager(modelId)) {
            PermClassCache.cacheNewPermission(pageCache, entityName, String.valueOf(modelId));
            List<Long> noPerms = PermClassCache.getPermissionMap(pageCache, entityName, DataTypeEnum.NO);
            if (!noPerms.isEmpty()) {
                filter.and(ID, "not in", noPerms);
            }
            PermClassCache.removePermissionCache(pageCache, entityName);
        }
        return QueryServiceHelper.query((String)entityName, (String)"id,name,number,parent,isleaf", (QFilter[])filter.toArray(), (String)"sequence");
    }

    public static Set<Long> getAllTemplateIds(long modelId, boolean isQuery, boolean isFromTemplate) {
        return Sets.newHashSet((Iterable)((Iterable)ThreadCache.get((Object)("getAllTemplateIds_" + modelId + "_" + isQuery + "_" + isFromTemplate), () -> {
            HashSet templateIds = new HashSet(16);
            QFilter qFilter = TemplatePermCrossUtil.getCommonTemplateQfilter(isQuery, modelId, isFromTemplate);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)TemplateUtil.getListEntryOrderBy(true));
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
                dynamicObjects.stream().forEach(e -> templateIds.add(e.getLong(ID)));
            }
            return templateIds;
        })));
    }

    public static void filterNoPermTemplates(QFilter qFilter, Set<Long> rTempIds, long modelId, boolean isCycleTable, boolean isQuery, boolean flag) {
        if (MemberPermHelper.isModelManager(modelId)) {
            if (flag) {
                qFilter.and(ID, "in", rTempIds);
            }
            return;
        }
        boolean isEmpty = rTempIds.isEmpty();
        if (flag && isEmpty) {
            qFilter.and(TemplatePermCrossUtil.getFalsefilter());
            return;
        }
        if (isCycleTable || !ConfigServiceHelper.getBoolParam(modelId, ConfigEnum.IS_USE_PERMISSION_CROSS.getNumber()) || isEmpty) {
            NoPluginCache pageCache = new NoPluginCache();
            PermClassCache.cacheNewPermission(pageCache, "bcm_templateentity", Long.toString(modelId));
            List<Long> noPerms = PermClassCache.getPermissionMap(pageCache, "bcm_templateentity", DataTypeEnum.NO);
            if (!noPerms.isEmpty()) {
                if (!flag) {
                    qFilter.and(ID, "not in", noPerms);
                }
                rTempIds.removeAll(noPerms);
            }
            if (flag) {
                if (rTempIds.isEmpty()) {
                    qFilter.and(TemplatePermCrossUtil.getFalsefilter());
                } else {
                    qFilter.and(ID, "in", rTempIds);
                }
            }
        } else if (!isEmpty) {
            List<Long> list = rTempIds.stream().collect(Collectors.toList());
            TemplatePermCrossUtil.filterNoPermTemplateByUserPermCross(list, modelId, isQuery);
            rTempIds.clear();
            rTempIds.addAll(list);
            if (list.isEmpty()) {
                qFilter.and(TemplatePermCrossUtil.getFalsefilter());
            } else {
                qFilter.and(ID, "in", list);
            }
        }
    }

    public static List<Long> getTemplatesWithOutNoPerm(IPageCache pageCache, long modelId) {
        ArrayList<Long> templates = new ArrayList<Long>(16);
        Map<Long, List<DynamicObject>> catalogToTemplateMap = TemplatePermCrossUtil.getCatalogToTemplateMap(pageCache, modelId, true, true, new ArrayList<Long>(16));
        if (!catalogToTemplateMap.isEmpty()) {
            catalogToTemplateMap.forEach((k, v) -> v.stream().forEach(e -> templates.add(e.getLong(ID))));
        }
        return templates;
    }

    public static QFilter getFalsefilter() {
        return new QFilter("1", "=", (Object)0);
    }

    public static Set<Long> getTemplatesByCataLog(long modelId, long cataLog) {
        ArrayList<Long> catalogIds = new ArrayList<Long>(16);
        catalogIds.add(cataLog);
        TemplatePermCrossUtil.appendSonCatalog(catalogIds, TemplatePermCrossUtil.getCatalogDyos(modelId));
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("templatecatalog", "in", catalogIds);
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)objects)) {
            objects.forEach(o -> ids.add(o.getLong("id")));
        }
        return ids;
    }
}

