/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.util.TemplateUtils;

public class TemplateSortUtil {
    public static List<String> sort(long modelId, long yearId, long perId, List<Long> tmpIds) {
        Set<Long> groupIds = TemplateSortUtil.getGroupIds(modelId, tmpIds);
        int maxNum = TemplateSortUtil.getMaxNum(modelId, groupIds);
        DynamicObjectCollection allSortGroups = TemplateSortUtil.getAllSortGroups(modelId, maxNum);
        Map<String, Long> map = TemplateSortUtil.getMap(modelId, yearId, perId);
        ArrayList<String> isSortTempIds = new ArrayList<String>(10);
        for (DynamicObject sortGroup : allSortGroups) {
            String group = sortGroup.getString("group");
            Long templateid = map.get(group);
            if (templateid == null) continue;
            isSortTempIds.add(String.valueOf(templateid));
        }
        return isSortTempIds;
    }

    private static Set<Long> getGroupIds(long modelId, List<Long> tmpIds) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        QFilter idQFilters = new QFilter("id", "in", tmpIds);
        String selectFields = "id,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bcm_templateentity", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, idQFilters}, null);
        HashSet groupIds = Sets.newHashSet();
        queryResult.forEach(c -> {
            Long groupId = c.getLong("group");
            groupIds.add(groupId);
        });
        return groupIds;
    }

    private static int getMaxNum(long modelId, Set<Long> groupIds) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        QFilter groupQFilter = new QFilter("group", "in", groupIds);
        String selectFields = "id,setorder";
        DynamicObjectCollection allGroupTemp = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, groupQFilter}, (String)"setorder asc");
        int maxNum = 1;
        for (DynamicObject temp : allGroupTemp) {
            int setorder = Integer.parseInt(temp.getString("setorder"));
            maxNum = setorder > maxNum ? setorder : maxNum;
        }
        return maxNum;
    }

    private static DynamicObjectCollection getAllSortGroups(long modelId, int maxNum) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        String selectFields = "id,group,template";
        QFilter maxQFilter = new QFilter("setorder", "<=", (Object)maxNum);
        DynamicObjectCollection allSortGroups = QueryServiceHelper.query((String)"bcm_datacollectorder", (String)selectFields, (QFilter[])new QFilter[]{modelQFilter, maxQFilter}, (String)"setorder asc");
        return allSortGroups;
    }

    private static Map<String, Long> getMap(long modelId, long yearId, long perId) {
        QFilter modelQFilter = new QFilter("model", "=", (Object)modelId);
        String queryFields = "id,group";
        DynamicObjectCollection tempIds = QueryServiceHelper.query((String)"bcm_templateentity", (String)queryFields, (QFilter[])new QFilter[]{modelQFilter}, null);
        HashSet templateIds = Sets.newHashSet();
        for (DynamicObject template : tempIds) {
            templateIds.add(template.getLong("id"));
        }
        Map<Long, Long> source2Right = TemplateUtils.getRightTplIdByVersioned(modelId, yearId, perId, templateIds);
        HashMap<String, Long> map = new HashMap<String, Long>(10);
        for (DynamicObject template : tempIds) {
            Long sourceTempId = template.getLong("id");
            Long rightTempId = source2Right.get(sourceTempId);
            if (rightTempId == null) continue;
            map.put(template.getString("group"), rightTempId);
        }
        return map;
    }
}

