/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.ILoader;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.Member;

public class ColDimensionEntry
extends MembSettingBaseDetail
implements ILoader<DynamicObjectCollection, List<ColDimensionEntry>, AreaRangeEntry> {
    private static final long serialVersionUID = 1L;

    public ColDimensionEntry(AreaRangeEntry areaRangeEntry) {
        super(areaRangeEntry);
        this.put("members", (Object)new ArrayList());
        this.setDataEntityNumber("bcm_templateentity.areapositionentry.colmembdetail");
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna;
        DynamicObjectCollection coll = parent.getDynamicObjectCollection("colmembdetail");
        for (Member m : this.getMembers()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("coldimension", (Object)this.getDimension().getId());
            dyna.set("colmembid", m == null ? null : Long.valueOf(m.getId()));
            dyna.set("seq", (Object)incrementer.getAndIncrement());
            coll.add((Object)dyna);
        }
        if (this.getMembers().size() <= 0) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("coldimension", (Object)this.getDimension().getId());
            dyna.set("colmembid", null);
            dyna.set("seq", (Object)incrementer.getAndIncrement());
            coll.add((Object)dyna);
        }
        return coll;
    }

    @Override
    public List<ColDimensionEntry> loadDynaObject(DynamicObjectCollection t, Supplier<AreaRangeEntry> s) {
        ArrayList<ColDimensionEntry> entries = new ArrayList<ColDimensionEntry>(t.size());
        ColDimensionEntry e = null;
        HashMap<Long, Dimension> dimKeySet = new HashMap<Long, Dimension>();
        LinkedHashMap<Long, TreeMap<Integer, Member>> dimMap = new LinkedHashMap<Long, TreeMap<Integer, Member>>();
        for (DynamicObject o : t) {
            DynamicObject dyna = o.getDynamicObject("coldimension");
            Long pk = dyna.getLong("id");
            if (!dimKeySet.containsKey(pk)) {
                e = new ColDimensionEntry(s.get());
                e.setSeq(o.getInt("seq"));
                entries.add(e);
                Dimension d = new Dimension();
                d.loadSimpleDynamicObject(dyna);
                d.setDataEntityNumber(dyna.getDataEntityType().getName());
                d.setMemberEntityNumber(dyna.getString("membermodel"));
                d.setFieldmapped(dyna.getString("fieldmapped"));
                e.setDimension(d);
                dimKeySet.put(d.getId(), d);
                dimMap.put(d.getId(), new TreeMap());
            }
            if (o.getLong("colmembid") == 0L) continue;
            Member m = new Member();
            m.setDimension((Dimension)dimKeySet.get(pk));
            m.setId(o.getLong("colmembid"));
            ((TreeMap)dimMap.get(pk)).put(o.getInt("seq"), m);
        }
        this.batchFillBackMembersInfo(dimMap, dimKeySet, s.get().getTemplate().getModelId());
        entries.sort(new Comparator<ColDimensionEntry>(){

            @Override
            public int compare(ColDimensionEntry o1, ColDimensionEntry o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        for (ColDimensionEntry r : entries) {
            r.getMembers().addAll(((TreeMap)dimMap.get(r.getDimension().getId())).values());
        }
        return entries;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "members".equals(key) || "dimension".equals(key);
    }
}

