/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.FilterDimMember;
import kd.fi.bcm.business.template.model.ILoader;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class FilterDimensionEntry
extends BaseEntry
implements ILoader<DynamicObjectCollection, List<FilterDimensionEntry>, TemplateModel> {
    private static final long serialVersionUID = 1L;

    public FilterDimensionEntry(TemplateModel template) {
        super(template);
        this.put("fdmembers", (Object)new ArrayList());
        this.setDataEntityNumber("bcm_templateentity.filtermembentry");
    }

    public List<FilterDimMember> getMembers() {
        return (List)this.get("fdmembers");
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        for (FilterDimMember m : this.getMembers()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("filterdimension", (Object)this.getDimension().getId());
            dyna.set("seq", (Object)incrementer.getAndIncrement());
            MembProperty membProperty = m.getMembProperty();
            if (m.isCustom() && membProperty != null) {
                dyna.set("filtermembid", (Object)membProperty.getId());
                dyna.set("filtermembound", (Object)membProperty.getScope());
                dyna.set("filtermemproperty", (Object)membProperty.getCustomProperty().getId());
            } else {
                dyna.set("filtermembid", (Object)m.getId());
                dyna.set("filtermembound", (Object)m.getScope());
                dyna.set("filtermemproperty", null);
            }
            coll.add((Object)dyna);
        }
        return coll;
    }

    @Override
    public List<FilterDimensionEntry> loadDynaObject(DynamicObjectCollection dynamicObjects, Supplier<TemplateModel> s) {
        ArrayList<FilterDimensionEntry> tfDimEntry = new ArrayList<FilterDimensionEntry>(16);
        LinkedHashMap<Long, List<Long>> dimtoMembMap = new LinkedHashMap<Long, List<Long>>(16);
        HashMap<Long, String> dimIdToEntityMap = new HashMap<Long, String>(16);
        ArrayList<Long> dpList = new ArrayList<Long>(16);
        ArrayList<Long> dpMemberIds = new ArrayList<Long>(16);
        HashMap<Long, FilterDimensionEntry> tfDimEntryMap = new HashMap<Long, FilterDimensionEntry>(16);
        TemplateModel templateModel = s.get();
        dynamicObjects.forEach(dynamicObject -> {
            DynamicObject dimDyo = dynamicObject.getDynamicObject("filterdimension");
            Long dimId = dimDyo.getLong("id");
            if (tfDimEntryMap.get(dimId) == null) {
                tfDimEntryMap.put(dimId, new FilterDimensionEntry(templateModel));
            }
            FilterDimensionEntry tfDim = (FilterDimensionEntry)tfDimEntryMap.get(dimId);
            if (dimtoMembMap.get(dimId) == null) {
                dimtoMembMap.put(dimId, new ArrayList(16));
            }
            List memberIds = (List)dimtoMembMap.get(dimId);
            long filtermembid = dynamicObject.getLong("filtermembid");
            memberIds.add(filtermembid);
            dimIdToEntityMap.put(dimId, dimDyo.getString("membermodel"));
            Dimension dimension = this.initDimension(dimDyo);
            DynamicObject dpDyo = dynamicObject.getDynamicObject("filtermemproperty");
            if (dpDyo != null) {
                dpList.add(dimId);
                dpMemberIds.add(filtermembid);
            }
            FilterDimMember filterDimMember = this.loadFilterDimMember(dpDyo, (DynamicObject)dynamicObject, dimension);
            tfDim.setSeq(dynamicObject.getInt("seq"));
            tfDim.setDimension(dimension);
            tfDim.getMembers().add(filterDimMember);
        });
        if (!dimtoMembMap.isEmpty()) {
            Map<Long, DynamicObject> dpDyo = this.getDpMemDyo(dpMemberIds);
            Long modelId = templateModel.getModelId();
            Map<Long, IDNumberTreeNode> treeMap = this.getMemberDyo(modelId, dpList, dimIdToEntityMap, dimtoMembMap);
            if (!treeMap.isEmpty() || !dpDyo.isEmpty()) {
                this.fillMemberTofilterDimMember(tfDimEntryMap, dimIdToEntityMap, dpDyo, treeMap);
            }
            tfDimEntry.addAll(tfDimEntryMap.values());
            tfDimEntry.sort(new Comparator<FilterDimensionEntry>(){

                @Override
                public int compare(FilterDimensionEntry o1, FilterDimensionEntry o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
        }
        return tfDimEntry;
    }

    private Dimension initDimension(DynamicObject dimDyo) {
        Dimension dimension = new Dimension();
        dimension.loadSimpleDynamicObject(dimDyo);
        dimension.setMemberEntityNumber(dimDyo.getString("membermodel"));
        dimension.setDataEntityNumber(dimDyo.getDataEntityType().getName());
        return dimension;
    }

    private FilterDimMember loadFilterDimMember(DynamicObject dpDyo, DynamicObject dynamicObject, Dimension dimension) {
        FilterDimMember filterDimMember = new FilterDimMember();
        filterDimMember.setScope(dynamicObject.getInt("filtermembound"));
        long filtermembid = dynamicObject.getLong("filtermembid");
        filterDimMember.setDimension(dimension);
        if (dpDyo == null) {
            filterDimMember.setCustom(false);
        } else {
            filterDimMember.setCustom(true);
        }
        filterDimMember.setId(filtermembid);
        return filterDimMember;
    }

    private void fillMemberTofilterDimMember(Map<Long, FilterDimensionEntry> tfDimEntryMap, Map<Long, String> dimIdToEntityMap, Map<Long, DynamicObject> dpDyo, Map<Long, IDNumberTreeNode> treeMap) {
        tfDimEntryMap.forEach((k, v) -> {
            String entityName = (String)dimIdToEntityMap.get(k);
            if (entityName != null && StringUtils.isNotEmpty((String)entityName)) {
                v.getMembers().forEach((? super T filterDimMember) -> {
                    long memberId = filterDimMember.getId();
                    if (filterDimMember.isCustom()) {
                        MembProperty membProperty = new MembProperty();
                        membProperty.setScope(filterDimMember.getScope());
                        DynamicObject dynamicObject = (DynamicObject)dpDyo.get(memberId);
                        CustomProperty prop = new CustomProperty();
                        if (dynamicObject != null) {
                            membProperty.loadSimpleDynamicObject(dynamicObject);
                            prop.loadSimpleDynamicObject(dynamicObject.getDynamicObject("propertyid"));
                            membProperty.setCustomProperty(prop);
                            filterDimMember.setMembProperty(membProperty);
                        }
                    } else {
                        IDNumberTreeNode idNumberTreeNode = (IDNumberTreeNode)treeMap.get(memberId);
                        if (idNumberTreeNode != null) {
                            filterDimMember.loadSimpleDynamicObject(idNumberTreeNode, entityName);
                        }
                    }
                });
            }
        });
    }

    private Map<Long, IDNumberTreeNode> getMemberDyo(Long modelId, List<Long> dpList, Map<Long, String> dimIdToEntityMap, Map<Long, List<Long>> dimtoMembMap) {
        HashMap<Long, IDNumberTreeNode> treeMap = new HashMap<Long, IDNumberTreeNode>(16);
        dimtoMembMap.forEach((k, v) -> {
            String entityName = (String)dimIdToEntityMap.get(k);
            if (entityName != null && StringUtils.isNotEmpty((String)entityName) && (dpList.isEmpty() || !dpList.contains(k))) {
                v.forEach((? super T memId) -> {
                    IDNumberTreeNode numberTreeNode = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memId);
                    if (numberTreeNode != null) {
                        treeMap.put((Long)memId, numberTreeNode);
                    }
                });
            }
        });
        return treeMap;
    }

    private Map<Long, DynamicObject> getDpMemDyo(List<Long> dpMemberIds) {
        Map<Long, Object> cacheMap = new HashMap<Long, DynamicObject>(16);
        if (dpMemberIds.isEmpty()) {
            return cacheMap;
        }
        cacheMap = (Map)ThreadCache.get((Object)"dim_mem_dp_filtermem");
        if (cacheMap != null) {
            return cacheMap;
        }
        cacheMap = new HashMap(16);
        String selectFields = "id,name,number,propertyid";
        DynamicObject[] dpDynamicCollection = BusinessDataServiceHelper.load((String)"bcm_definedpropertyvalue", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dpMemberIds)});
        if (dpDynamicCollection != null) {
            for (DynamicObject dyo : dpDynamicCollection) {
                cacheMap.put(dyo.getLong("id"), dyo);
            }
        }
        return cacheMap;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "fdmembers".equals(key) || "dimension".equals(key);
    }
}

