/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.bcm.business.template.model.BaseEntry;
import kd.fi.bcm.business.template.model.CustomProperty;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.ILoader;
import kd.fi.bcm.business.template.model.MembProperty;
import kd.fi.bcm.business.template.model.TemplateModel;

public class PageDimPropEntry
extends BaseEntry
implements ILoader<DynamicObjectCollection, List<PageDimPropEntry>, TemplateModel> {
    private static final long serialVersionUID = 1L;

    public PageDimPropEntry(TemplateModel template) {
        super(template);
        this.put("properties", (Object)new ArrayList());
        this.put("customproperties", (Object)new ArrayList());
        this.setDataEntityNumber("bcm_templateentity.pagepropentry");
    }

    public List<MembProperty> getAllMembProperties() {
        return (List)this.get("properties");
    }

    public void addMembProperty(MembProperty m) {
        this.getAllMembProperties().add(m);
    }

    public List<MembProperty> getProperties(CustomProperty p) {
        ArrayList<MembProperty> membs = new ArrayList<MembProperty>();
        this.getAllMembProperties().forEach((? super T e) -> {
            if (e.getCustomProperty().equals(p)) {
                membs.add((MembProperty)e);
            }
        });
        return membs;
    }

    public List<CustomProperty> getCustomProperties() {
        return (List)this.get("customproperties");
    }

    public void addCustomProperty(CustomProperty p) {
        if (!this.getCustomProperties().contains(p)) {
            this.getCustomProperties().add(p);
        }
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        int i = 1;
        for (MembProperty p : this.getAllMembProperties()) {
            dyna = this.newSimpleDynamicObject();
            dyna.set("pagepropdim", (Object)this.getDimension().getId());
            dyna.set("property", (Object)p.getCustomProperty().getId());
            dyna.set("membprop", (Object)p.getId());
            dyna.set("seq", (Object)i++);
            dyna.set("propbound", (Object)p.getScope());
            coll.add((Object)dyna);
        }
        return coll;
    }

    @Override
    public List<PageDimPropEntry> loadDynaObject(DynamicObjectCollection t, Supplier<TemplateModel> s) {
        ArrayList<PageDimPropEntry> entries = new ArrayList<PageDimPropEntry>();
        CustomProperty prop = null;
        LinkedHashMap<Long, PageDimPropEntry> Dim2EntryMap = new LinkedHashMap<Long, PageDimPropEntry>();
        LinkedHashMap<Long, CustomProperty> custMap = new LinkedHashMap<Long, CustomProperty>();
        for (DynamicObject o : t) {
            DynamicObject propDyna = o.getDynamicObject("property");
            long id = propDyna.getLong("id");
            long dimID = o.getDynamicObject("pagepropdim").getLong("id");
            long membID = o.getDynamicObject("membprop").getLong("id");
            prop = new CustomProperty();
            prop.loadSimpleDynamicObject(propDyna);
            if (!Dim2EntryMap.containsKey(dimID)) {
                PageDimPropEntry entry = new PageDimPropEntry(s.get());
                entry.setSeq(o.getInt("seq"));
                entry.setId(id);
                Dimension d = new Dimension();
                d.loadSimpleDynamicObject(o.getDynamicObject("pagepropdim"));
                d.setMemberEntityNumber(o.getDynamicObject("pagepropdim").getString("membermodel"));
                entry.setDimension(d);
                Dim2EntryMap.put(dimID, entry);
            }
            ((PageDimPropEntry)Dim2EntryMap.get(dimID)).addCustomProperty(prop);
            if (!custMap.containsKey(membID)) {
                custMap.put(membID, prop);
            }
            MembProperty membProp = new MembProperty();
            membProp.loadSimpleDynamicObject(o.getDynamicObject("membprop"));
            membProp.setScope(o.getInt("propbound"));
            membProp.setCustomProperty((CustomProperty)custMap.get(membID));
            ((PageDimPropEntry)Dim2EntryMap.get(dimID)).getAllMembProperties().add(membProp);
        }
        entries.addAll(Dim2EntryMap.values());
        return entries;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "properties".equals(key) || "dimension".equals(key) || "customproperties".equals(key);
    }
}

