/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReportEditStatus {
    private long modelId;
    private long orgId;
    private long scenarioId;
    private long yearId;
    private long periodId;
    private long currencyId;
    private List<Long> unweaveTemplates = new ArrayList<Long>(16);
    private List<Long> weavingTemplates = new ArrayList<Long>(16);
    private List<Long> completeTemplates = new ArrayList<Long>(16);
    private List<Long> commitTemplates = new ArrayList<Long>(16);
    private List<Long> backTemplates = new ArrayList<Long>(16);
    private List<Long> backapplyTemplates = new ArrayList<Long>(16);
    public Set<String> hasRecordTemNums = new HashSet<String>(16);

    public ReportEditStatus(long modelId, long orgId, long scenarioId, long yearId, long periodId, long currencyId) {
        this.modelId = modelId;
        this.orgId = orgId;
        this.scenarioId = scenarioId;
        this.yearId = yearId;
        this.periodId = periodId;
        this.currencyId = currencyId;
    }

    public long getModelId() {
        return this.modelId;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getScenarioId() {
        return this.scenarioId;
    }

    public long getYearId() {
        return this.yearId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public List<Long> getUnweaveTemplates() {
        return this.unweaveTemplates;
    }

    public List<Long> getWeavingTemplates() {
        return this.weavingTemplates;
    }

    public List<Long> getCompleteTemplates() {
        return this.completeTemplates;
    }

    public List<Long> getCommitTemplates() {
        return this.commitTemplates;
    }

    public List<Long> getBackTemplates() {
        return this.backTemplates;
    }

    public List<Long> getBackapplyTemplates() {
        return this.backapplyTemplates;
    }

    public int getAllReportCount() {
        return this.getUnweaveTemplates().size() + this.getWeavingTemplates().size() + this.getCompleteTemplates().size() + this.getCommitTemplates().size() + this.getBackTemplates().size() + this.getBackapplyTemplates().size();
    }

    public List<Long> getHasRptRecordTemplates() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.addAll(this.getWeavingTemplates());
        ids.addAll(this.getCompleteTemplates());
        ids.addAll(this.getCommitTemplates());
        ids.addAll(this.getBackTemplates());
        ids.addAll(this.getBackapplyTemplates());
        return ids;
    }

    public List<Long> getAllTemplates() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.addAll(this.getUnweaveTemplates());
        ids.addAll(this.getWeavingTemplates());
        ids.addAll(this.getCompleteTemplates());
        ids.addAll(this.getCommitTemplates());
        ids.addAll(this.getBackTemplates());
        ids.addAll(this.getBackapplyTemplates());
        return ids;
    }

    public List<Long> getExitRecordTemplates() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        ids.addAll(this.getWeavingTemplates());
        ids.addAll(this.getCompleteTemplates());
        ids.addAll(this.getCommitTemplates());
        ids.addAll(this.getBackTemplates());
        ids.addAll(this.getBackapplyTemplates());
        return ids;
    }

    public void filterTemplates(Collection<Long> ids) {
        this.getWeavingTemplates().removeAll(ids);
        this.getCompleteTemplates().removeAll(ids);
        this.getCommitTemplates().removeAll(ids);
        this.getBackTemplates().removeAll(ids);
        this.getBackapplyTemplates().removeAll(ids);
    }

    public void filterTemplate(long id) {
        this.getWeavingTemplates().remove(id);
        this.getCompleteTemplates().remove(id);
        this.getCommitTemplates().remove(id);
        this.getBackTemplates().remove(id);
        this.getBackapplyTemplates().remove(id);
    }

    public boolean isAllCommit() {
        return this.getUnweaveTemplates().isEmpty() && this.getWeavingTemplates().isEmpty() && this.getCompleteTemplates().isEmpty() && this.getBackTemplates().isEmpty() && this.getBackapplyTemplates().isEmpty();
    }

    public void clearAllTemplates() {
        this.getWeavingTemplates().clear();
        this.getCompleteTemplates().clear();
        this.getCommitTemplates().clear();
        this.getBackTemplates().clear();
        this.getBackapplyTemplates().clear();
    }

    public Set<String> getHasRecordTemNums() {
        return this.hasRecordTemNums;
    }

    public void setHasRecordTemNums(Set<String> hasRecordTemNums) {
        this.hasRecordTemNums = hasRecordTemNums;
    }
}

