/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.template.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.papertemplate.PaperTemplateHelper;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.DynaEntityObject;
import kd.fi.bcm.business.template.model.FilterDimensionEntry;
import kd.fi.bcm.business.template.model.PageDimPropEntry;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateCatalog;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.papertemplate.PaperTemplateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ISupportGZip;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.domain.view.SpreadManager;

public class TemplateModel
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;
    private static final String TMPL_SCENE_CACHE = "tmpl_scene_cache";
    private boolean isModify = true;

    public TemplateModel() {
        this.put("filtermembentry", (Object)new ArrayList());
        this.put("pagemembentry", (Object)new ArrayList());
        this.put("rank", (Object)new ArrayList());
        this.put("pagepropentry", (Object)new ArrayList());
        this.put("viewpointmembentry", (Object)new ArrayList());
        this.put("areapositionentry", (Object)new ArrayList());
        this.setDataEntityNumber("bcm_templateentity");
        this.setIsFinTemplate(true);
    }

    public void setVarBase(String varbase) {
        this.put("varbaseforeb", (Object)varbase);
    }

    public String getVarBase() {
        return (String)this.get("varbaseforeb");
    }

    public void setVarJson(String varJson) {
        this.put("varjsonforeb", (Object)varJson);
    }

    public String getVarJson() {
        return (String)this.get("varjsonforeb");
    }

    public boolean isOldTemplate() {
        boolean isTrue = true;
        return this.get("isOldTemplate", isTrue);
    }

    public void setIsOldTemplate(boolean isOldTemplate) {
        this.put("isOldTemplate", (Object)isOldTemplate);
    }

    public boolean isSaveByDim() {
        boolean isTrue = true;
        return this.get("issavebydim", isTrue);
    }

    public void setSaveByDim(boolean issavebydim) {
        this.put("issavebydim", (Object)issavebydim);
    }

    public boolean isAutoCalculate() {
        boolean isFalse = false;
        return this.get("isautocalculate", isFalse);
    }

    public void setAutoCalculate(boolean isautocalculate) {
        this.put("isautocalculate", (Object)isautocalculate);
    }

    public boolean isAllowaddic() {
        if (!this.isSaveByDim()) {
            return false;
        }
        return this.get("isallowaddic", true);
    }

    public void setAllowaddic(boolean isallowaddic) {
        this.put("isallowaddic", (Object)isallowaddic);
    }

    public String getAccountreclass() {
        if (StringUtils.isEmpty((String)this.get("accountreclass", "1"))) {
            return "1";
        }
        return this.get("accountreclass", "1");
    }

    public void setAccountreclass(String accountreclass) {
        this.put("accountreclass", (Object)accountreclass);
    }

    public void setDataUnit(String unit) {
        this.put("dataunit", (Object)unit);
    }

    public String getDataUnit() {
        return (String)this.get("dataunit");
    }

    public void setDocCatalog(Object id) {
        this.put("doccatalog", id);
    }

    public Object getDocCatalog() {
        return this.get("doccatalog");
    }

    public List<PageDimPropEntry> getPagePropEntries() {
        return (List)this.get("pagepropentry");
    }

    public void addPagePropEntries(PageDimPropEntry e) {
        this.getPagePropEntries().add(e);
    }

    public void setGroup(long group) {
        this.put("group", (Object)group);
    }

    public long getGroup() {
        if (this.get("group") == null) {
            this.setGroup(DBServiceHelper.genGlobalLongId());
        }
        return (Long)this.get("group");
    }

    public void setDescription(String description) {
        this.put("description", (Object)description);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setVersionDescription(String versiondescription) {
        this.put("versiondescription", (Object)versiondescription);
    }

    public String getVersionDescription() {
        return (String)this.get("versiondescription");
    }

    public void setIsShowDescription(boolean isshowdescription) {
        this.put("isshowdescription", (Object)isshowdescription);
    }

    public boolean getIsShowDescription() {
        return this.containsKey("isshowdescription") ? (Boolean)this.get("isshowdescription") : false;
    }

    public void addPageDimensionEntris(PageDimensionEntry entry) {
        this.getPageDimensionEntries().add(entry);
    }

    public List<PageDimensionEntry> getPageDimensionEntries() {
        return (List)this.get("pagemembentry");
    }

    public static String getSimpleModelSeleter() {
        StringBuilder select = new StringBuilder();
        select.append("id, name,number,group,templatecatalog,model.id,model.number,createtime,templatetype,isoldtemplate,usage,sequence,issavebydim,isonlyread,status,versionnumber,isautocalculate,effectivedate,expiringdate,isallowaddic,accountreclass,ischeckstatus,uncheckentity,isdefaulthasauth,").append("pagemembentry.seq,pagemembentry.pagemembid,pagemembentry.pagedimension,pagemembentry.membbound,").append("viewpointmembentry.seq,viewpointmembentry.viewmembid,viewpointmembentry.viewdimension,").append("pagepropentry.seq,pagepropentry.pagepropdim,pagepropentry.property,pagepropentry.membprop,pagepropentry.propbound,").append("filtermembentry.seq,filtermembentry.filterdimension,filtermembentry.filtermembid,filtermembentry.filtermemproperty,filtermembentry.filtermembound");
        return select.toString();
    }

    public void addTemplateFilterDimensionEntry(FilterDimensionEntry tfEntry) {
        List tfDimEntryList = (List)this.get("filtermembentry");
        tfDimEntryList.add(tfEntry);
    }

    public List<FilterDimensionEntry> getFilterDimensionEntries() {
        if (!this.containsKey("filtermembentry")) {
            return new ArrayList<FilterDimensionEntry>();
        }
        return new ArrayList<FilterDimensionEntry>((Collection)this.get("filtermembentry"));
    }

    public void setTemplateFilterDimensionEntry(List<FilterDimensionEntry> tfDimEntryList) {
        if (tfDimEntryList == null || tfDimEntryList.isEmpty()) {
            return;
        }
        this.put("filtermembentry", (Object)tfDimEntryList);
    }

    public void addViewPointDimensionEntries(ViewPointDimensionEntry entry) {
        this.getViewPointDimensionEntries().add(entry);
    }

    public List<ViewPointDimensionEntry> getViewPointDimensionEntries() {
        return (List)this.get("viewpointmembentry");
    }

    public void setRank(List<String> rank) {
        this.put("rank", (Object)rank);
    }

    public void clearRank() {
        this.put("rank", (Object)new ArrayList(16));
    }

    public List<String> getRank() {
        List rankList = (List)this.get("rank");
        if (rankList.isEmpty()) {
            for (DynamicObject dynamicObject : this.getRankDim()) {
                String number = dynamicObject.getString("number");
                if (rankList.contains(number)) continue;
                rankList.add(number);
            }
        }
        return rankList;
    }

    public List<DynamicObject> getRankDim() {
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (PageDimensionEntry pageDimensionEntry : this.getPageDimensionEntries()) {
            numbers.add(pageDimensionEntry.getDimension().getNumber());
        }
        for (PageDimPropEntry pageDimPropEntry : this.getPagePropEntries()) {
            numbers.add(pageDimPropEntry.getDimension().getNumber());
        }
        for (ViewPointDimensionEntry viewPointDimensionEntry : this.getViewPointDimensionEntries()) {
            numbers.add(viewPointDimensionEntry.getDimension().getNumber());
        }
        List<DynamicObject> rank = QueryDimensionServiceHelper.getOthersDim(numbers, this.getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) || QueryDimensionServiceHelper.checkIcEnt(this.getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    public void addAreaRangeEntries(AreaRangeEntry entry) {
        this.getAreaRangeEntries().add(entry);
    }

    public List<AreaRangeEntry> getAreaRangeEntries() {
        return (List)this.get("areapositionentry");
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public long getModelId() {
        return this.get("model") == null ? 0L : (Long)this.get("model");
    }

    public void setVersionNumber(BigDecimal versionNumber) {
        this.put("versionNumber", (Object)versionNumber);
    }

    public BigDecimal getVersionNumber() {
        return (BigDecimal)this.get("versionNumber");
    }

    public void setVersionStatus(String status) {
        this.put("versionStatus", (Object)status);
    }

    public String getVersionStatus() {
        return (String)this.get("versionStatus");
    }

    public void setUsage(String usage) {
        this.put("usage", (Object)usage);
    }

    public String getUsage() {
        return (String)this.get("usage");
    }

    public void setIsOnlyRead(boolean isOnlyRead) {
        this.put("isOnlyRead", (Object)isOnlyRead);
    }

    public boolean getIsOnlyRead() {
        return this.containsKey("isOnlyRead") ? (Boolean)this.get("isOnlyRead") : false;
    }

    public void setIsCircularDefine(boolean IsCircularDefine) {
        this.put("isCircularDefine", (Object)IsCircularDefine);
    }

    public boolean getIsCircularDefine() {
        return this.containsKey("isCircularDefine") ? (Boolean)this.get("isCircularDefine") : false;
    }

    public String getSpreadJson() {
        return (String)this.get("spreadJson");
    }

    public void setSpreadJson(String spreadJson) {
        this.put("spreadJson", (Object)spreadJson);
    }

    public String getData() {
        return (String)this.get("data");
    }

    public void setData(String data) {
        this.put("data", (Object)data);
    }

    public String getRptData() {
        return (String)this.get("rptdata");
    }

    public void setRptData(String rptdata) {
        this.put("rptdata", (Object)rptdata);
    }

    public String getRptSpreadJson() {
        return (String)this.get("rptspreadjson");
    }

    public void setRptSpreadJson(String spreadJson) {
        this.put("rptspreadjson", (Object)spreadJson);
    }

    public Integer getTemplateType() {
        return (Integer)this.get("templatetype");
    }

    public void setTemplateType(int templatetype) {
        this.put("templatetype", (Object)templatetype);
    }

    public Integer getSequence() {
        return (Integer)this.get("sequence");
    }

    public void setSequence(int sequence) {
        this.put("sequence", (Object)sequence);
    }

    public Date getCreateTime() {
        return (Date)this.get("createTime");
    }

    public void setCreateTime(Date createTime) {
        this.put("createTime", (Object)createTime);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifytime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifytime", (Object)modifyTime);
    }

    public long getCreatorId() {
        return (Long)this.get("creator");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public long getModifierId() {
        return (Long)this.get("modifier");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public long getCreateOrgId() {
        return (Long)this.get("createorg");
    }

    public void setCreateOrgId(long createOrgId) {
        this.put("createorg", (Object)createOrgId);
    }

    public TemplateCatalog getTemplateCatalog() {
        return (TemplateCatalog)this.get("templatecatalog");
    }

    public void setTemplateCatalog(TemplateCatalog catalog) {
        this.put("templatecatalog", (Object)catalog);
    }

    public boolean isFinTemplate() {
        return (Boolean)this.get("isfintemplate");
    }

    public final void setIsFinTemplate(boolean b) {
        this.put("isfintemplate", (Object)b);
    }

    public void setIsCheckStatus(boolean isCheckStatus) {
        this.put("ischeckstatus", (Object)isCheckStatus);
    }

    public boolean getIsCheckStatus() {
        return this.get("ischeckstatus", false);
    }

    public void setUnCheckEntity(String unCheckEntity) {
        this.put("uncheckentity", (Object)unCheckEntity);
    }

    public String getUnCheckEntity() {
        return (String)this.get("uncheckentity");
    }

    public void setIsDefaultHasAuth(boolean isdefaulthasauth) {
        this.put("isdefaulthasauth", (Object)isdefaulthasauth);
    }

    public boolean getIsDefaultHasAuth() {
        return (Boolean)this.get("isdefaulthasauth");
    }

    public TplStatus getStatus() {
        return TplStatus.getStatus((String)this.get("status"));
    }

    public void setStatus(String statuValue) {
        this.put("status", (Object)statuValue);
    }

    public Date getEffectiveDate() {
        return (Date)this.get("effectivedate");
    }

    public void setEffectiveDate(Date effectivedate) {
        this.put("effectivedate", (Object)effectivedate);
    }

    public Date getExpiringDate() {
        return (Date)this.get("expiringdate");
    }

    public void setExpiringDate(Date expiringDate) {
        this.put("expiringdate", (Object)expiringDate);
    }

    public void loadDynaObj2Model(DynamicObject dyna) {
        try {
            this.transferDynaObj2Model(dyna, false);
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] template to model error!\n %s", dyna.getString("number"), ThrowableHelper.toString((Throwable)t)));
        }
    }

    public void loadDynaObj2SimpleModel(DynamicObject dyna) {
        try {
            this.transferDynaObj2Model(dyna, true);
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] template to simple model error!\n %s", dyna.getString("number"), ThrowableHelper.toString((Throwable)t)));
        }
    }

    public void clearFilterDimensionEntry() {
        List tfDimEntryList = (List)this.get("filtermembentry");
        tfDimEntryList.clear();
    }

    private void transferDynaObj2Model(DynamicObject dyna, boolean excludeAreaRange) {
        DynamicObject classEntity;
        boolean isTrue = true;
        boolean isFalse = false;
        Predicate<String> pexist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
        this.setId(dyna.getLong("id"));
        this.setName(dyna.getString("name"));
        this.setNumber(dyna.getString("number"));
        this.setModelId(this.defaultIfNotExist(pexist, "model", 0L, () -> dyna.getDynamicObject("model").getLong("id")));
        this.setIsOldTemplate(dyna.getBoolean("isoldtemplate"));
        this.setSaveByDim(dyna.getBoolean("issavebydim"));
        this.setAllowaddic(dyna.getBoolean("isallowaddic"));
        this.setAutoCalculate(dyna.getBoolean("isautocalculate"));
        this.setAccountreclass(dyna.getString("accountreclass"));
        this.setIsCircularDefine(pexist.test("iscirculardefine") && dyna.getBoolean("iscirculardefine"));
        this.setVarBase(pexist.test("varbaseforeb") ? dyna.getString("varbaseforeb") : "");
        this.setVarJson(pexist.test("varjsonforeb") ? dyna.getString("varjsonforeb") : "");
        this.setIsCheckStatus(dyna.getBoolean("ischeckstatus"));
        this.setUnCheckEntity(dyna.getString("uncheckentity"));
        this.setIsDefaultHasAuth(dyna.getBoolean("isdefaulthasauth"));
        if (ThreadCache.get((Object)"template_dis_permclass") != null) {
            Map permissionClassMap = (Map)ThreadCache.get((Object)"template_dis_permclass");
            classEntity = (DynamicObject)permissionClassMap.get(dyna.getLong("id"));
        } else {
            classEntity = PermClassEntityHelper.getPermissionClassEntity(dyna);
        }
        if (classEntity != null) {
            this.setPermClass(classEntity.get("permclass"));
        }
        this.setTemplateCatalog(this.defaultIfNotExist(pexist, "templatecatalog", null, () -> {
            TemplateCatalog catalog = new TemplateCatalog();
            DynamicObject v = dyna.getDynamicObject("templatecatalog");
            catalog.setId(v.getLong("id"));
            catalog.setName(v.getString("name"));
            return catalog;
        }));
        if (StringUtils.isEmpty((String)dyna.getString("templatetype"))) {
            this.setTemplateType(0);
        } else {
            this.setTemplateType(dyna.getInt("templatetype"));
        }
        this.setGroup(this.defaultIfNotExist(pexist, "group", 0L, () -> dyna.getLong("group")));
        this.setSequence(dyna.getInt("sequence"));
        if (!excludeAreaRange) {
            this.setCreateOrgId(this.defaultIfNotExist(pexist, "createorg", 0L, () -> dyna.getDynamicObject("createorg").getLong("id")));
            this.setCreateTime(this.defaultIfNotExist(pexist, "createTime", null, () -> dyna.getDate("createTime")));
            this.setCreatorId(this.defaultIfNotExist(pexist, "creator", 0L, () -> dyna.getDynamicObject("creator").getLong("id")));
            this.setData(this.defaultIfNotExist(pexist, "data", null, () -> dyna.getString("data")));
            this.setRptData(this.defaultIfNotExist(pexist, "rptdata", null, () -> dyna.getString("rptdata")));
            this.setSpreadJson(this.defaultIfNotExist(pexist, "spreadjson", null, () -> dyna.getString("spreadjson")));
            this.setRptSpreadJson(this.defaultIfNotExist(pexist, "rptspreadjson", null, () -> dyna.getString("rptspreadjson")));
            this.setDescription(this.defaultIfNotExist(pexist, "description", null, () -> dyna.getString("description")));
            this.setIsShowDescription(this.defaultIfNotExist(pexist, "isshowdescription", isFalse, () -> dyna.getBoolean("isshowdescription")));
            this.setIsFinTemplate(this.defaultIfNotExist(pexist, "isfintemplate", isTrue, () -> dyna.getBoolean("isfintemplate")));
            this.setModifierId(this.defaultIfNotExist(pexist, "modifier", 0L, () -> dyna.getDynamicObject("modifier").getLong("id")));
            this.setModifyTime(this.defaultIfNotExist(pexist, "modifytime", null, () -> dyna.getDate("modifytime")));
            this.setVersionStatus(this.defaultIfNotExist(pexist, "versionstatus", null, () -> dyna.getString("versionstatus")));
            this.put("versiondescription", (Object)this.defaultIfNotExist(pexist, "versiondescription", null, () -> dyna.getString("versiondescription")));
        }
        this.setUsage(this.defaultIfNotExist(pexist, "usage", null, () -> dyna.getString("usage")));
        this.setIsOnlyRead(this.defaultIfNotExist(pexist, "isonlyread", isFalse, () -> dyna.getBoolean("isonlyread")));
        this.setStatus(this.defaultIfNotExist(pexist, "status", null, () -> dyna.getString("status")));
        this.setVersionNumber(this.defaultIfNotExist(pexist, "versionnumber", null, () -> dyna.getBigDecimal("versionnumber")));
        this.setEffectiveDate(this.defaultIfNotExist(pexist, "effectivedate", null, () -> dyna.getDate("effectivedate")));
        this.setExpiringDate(this.defaultIfNotExist(pexist, "expiringdate", null, () -> dyna.getDate("expiringdate")));
        DynamicObjectCollection entries = dyna.getDynamicObjectCollection("pagemembentry");
        this.getPageDimensionEntries().addAll(new PageDimensionEntry(this).loadDynaObject(entries, () -> this));
        entries = dyna.getDynamicObjectCollection("viewpointmembentry");
        this.getViewPointDimensionEntries().addAll(new ViewPointDimensionEntry(this).loadDynaObject(entries, () -> this));
        if (!excludeAreaRange) {
            entries = dyna.getDynamicObjectCollection("areapositionentry");
            this.getAreaRangeEntries().addAll(new AreaRangeEntry(this).loadDynaObject(entries, () -> this));
        }
        entries = dyna.getDynamicObjectCollection("pagepropentry");
        this.getPagePropEntries().addAll(new PageDimPropEntry(this).loadDynaObject(entries, () -> this));
        entries = dyna.getDynamicObjectCollection("filtermembentry");
        this.setTemplateFilterDimensionEntry(new FilterDimensionEntry(this).loadDynaObject(entries, () -> this));
    }

    private <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }

    @Override
    public boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "usage".equals(key) || "versionnumber".equals(key) || "versionstatus".equals(key) || "pagemembentry".equals(key) || "pagepropentry".equals(key) || "viewpointmembentry".equals(key) || "areapositionentry".equals(key);
    }

    public AreaRangeEntry findAreaByArea(String area) {
        AreaRangeEntry result = null;
        for (AreaRangeEntry range : this.getAreaRangeEntries()) {
            if (!SpreadAreaUtil.isInArea((String)area, (String)range.getAreaRange())) continue;
            result = range;
            break;
        }
        return result;
    }

    public Map<String, AreaRangeEntry> getSpreadPos2TempModelPosMap(SpreadManager spreadManager) {
        HashMap<String, AreaRangeEntry> spreadPos2TempModelPos = new HashMap<String, AreaRangeEntry>(16);
        spreadManager.getAreaManager().getPostionInfoSet().forEach((? super T pos) -> {
            String originalAreaRange = pos.getOriginalAreaRange();
            AreaRangeEntry result = this.findAreaByArea(pos.getAreaRange());
            if (result != null) {
                spreadPos2TempModelPos.put(originalAreaRange, result);
            }
        });
        return spreadPos2TempModelPos;
    }

    public List<AreaRangeEntry> findOverlapAreaByAreas(String area) {
        ArrayList<AreaRangeEntry> areaRangeEntries = new ArrayList<AreaRangeEntry>();
        for (AreaRangeEntry range : this.getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)area, (String)range.getAreaRange())) continue;
            areaRangeEntries.add(range);
        }
        return areaRangeEntries;
    }

    public static TemplateModel genImmutableModel(DynamicObject dyna) {
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        template.setData(null);
        template.setSpreadJson(null);
        template.isModify = false;
        return template;
    }

    public static TemplateModel genSimpleImmutableModel(DynamicObject dyna) {
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2SimpleModel(dyna);
        template.isModify = false;
        return template;
    }

    public static TemplateModel genTemplateModelBy(DynamicObject dyna) {
        TemplateModel templateModel = new TemplateModel();
        DataEntityPropertyCollection properties = dyna.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (property instanceof BasedataProp) {
                templateModel.put(name, dyna.get(name + "_id"));
                continue;
            }
            templateModel.put(name, dyna.get(name));
        }
        TemplateModel.initPermission(templateModel, dyna);
        Pair<String, Map<String, Set<Long>>> textData = PaperTemplateHelper.explainEffective(dyna);
        templateModel.put("effectivetext", textData.p1);
        templateModel.put("effectivedata", textData.p2);
        templateModel.setDataEntityNumber(dyna.getDataEntityType().getName());
        templateModel.setIsOldTemplate(true);
        templateModel.put(TMPL_SCENE_CACHE, (Object)PaperTemplateHelper.findTmplScene4Setting(dyna.getLong("model.id"), PaperTemplateTypeEnum.INVELIM, dyna.getLong("group")));
        return templateModel;
    }

    private static void initPermission(TemplateModel templateModel, DynamicObject dyna) {
        DynamicObject permission = PermClassEntityHelper.getPermissionClassEntity(dyna);
        if (permission != null) {
            templateModel.put("permclass", permission.getDynamicObject("permclass").getPkValue());
        } else {
            templateModel.put("permclass", (Object)null);
        }
    }

    @Override
    public final Object put(String key, Object value) {
        if (this.isModify) {
            return super.put(key.toLowerCase(Locale.ENGLISH), value);
        }
        throw new UnsupportedOperationException();
    }

    public Map<String, Set<Long>> getEffectivedata() {
        return (Map)this.get("effectivedata");
    }

    public String getEffectivetext() {
        return (String)this.get("effectivetext");
    }

    public static enum TplStatus {
        ENABLE("1"),
        DISABLE("0");

        private String statuValue;

        private TplStatus(String statuValue) {
            this.statuValue = statuValue;
        }

        public String getStatuValue() {
            return this.statuValue;
        }

        public static TplStatus getStatus(String statuValue) {
            if ("1".equals(statuValue)) {
                return ENABLE;
            }
            return DISABLE;
        }
    }

    public static enum UsageEnum {
        QUERY("2"),
        WEAVE("1");

        private String statuValue;

        private UsageEnum(String statuValue) {
            this.statuValue = statuValue;
        }

        public String getStatuValue() {
            return this.statuValue;
        }
    }
}

