/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.tree.ITreeNode;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class AbstractTreeNode<T>
implements ITreeNode<T> {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected ITreeNode<T> parent;
    protected List<ITreeNode<T>> children = new ArrayList<ITreeNode<T>>();
    private T userData;
    private Map<String, Object> detailData = new HashMap<String, Object>();
    private Long rootid;
    private boolean isOpened = false;

    public AbstractTreeNode(String id, String name) {
        this(id, name, null);
    }

    public AbstractTreeNode(String id, String name, ITreeNode<T> parent) {
        this.id = id;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T getData() {
        return this.userData;
    }

    public void setData(T userData) {
        this.userData = userData;
    }

    public Map<String, Object> getDetailData() {
        return this.detailData;
    }

    public void setDetailData(Map<String, Object> detailData) {
        this.detailData = detailData;
    }

    public Long getRootid() {
        return this.rootid;
    }

    public void setRootid(Long rootid) {
        this.rootid = rootid;
    }

    @Override
    public ITreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public List<ITreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(ITreeNode<T> child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean removeChild(ITreeNode<T> child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public void SetIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.getId()).append((Object)this.getName()).append(this.getData()).append(this.getChildren()).build();
    }

    @Override
    public boolean removeAll() {
        this.children = new ArrayList<ITreeNode<T>>();
        return true;
    }

    @Override
    public boolean addAllChild(List<ITreeNode<T>> children) {
        return this.children.addAll(children);
    }
}

