/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.tree;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.CycleTablesServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.bizrule.BizRuleCatalogTreeNode;
import kd.fi.bcm.business.tree.dimension.DimensionTreeNode;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.tree.report.TemplateTreeNode;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.TemplateUsageEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TreeBuilder {
    private static final String NUMBER = "number";
    private static final String SEQ = "sequence";
    private static final String PARENT = "parent";
    private static final String STORAGE_TYPE = "storagetype";
    private static final String IS_LEAF = "isleaf";
    private static final String FI_BCM_BUSINESS = "fi-bcm-business";
    private static List<String> properties = Arrays.asList("accounttype", "exchange", "drcrdirect", "aggoprt");

    public static OrgTreeNode getOrgTree(DynamicObjectCollection rootNodeList, OrgTreeNode root, String showType) {
        return TreeBuilder.getOrgTreeRoot(rootNodeList, showType, false);
    }

    public static BizRuleCatalogTreeNode getBizRuleCatalogTree(DynamicObjectCollection ruleLCollection, BizRuleCatalogTreeNode root, String showType) {
        HashMap<Long, List<DynamicObject>> nodeMap = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject ruleObj : ruleLCollection) {
            long parentId = ruleObj.getLong(PARENT);
            List list = nodeMap.getOrDefault(parentId, new ArrayList(10));
            list.add(ruleObj);
            nodeMap.put(parentId, list);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get(0L) != null) {
            rootNode = (DynamicObject)((List)nodeMap.get(0L)).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        return TreeBuilder.createBizRuleCatalogNode(rootNode, null, nodeMap, showType);
    }

    private static BizRuleCatalogTreeNode createBizRuleCatalogNode(DynamicObject nodeDynaObj, BizRuleCatalogTreeNode parentNode, Map<Long, List<DynamicObject>> nodeMap, String showType) {
        List<DynamicObject> childrenList;
        long id = nodeDynaObj.getLong("id");
        String name = nodeDynaObj.getString("name");
        String number = nodeDynaObj.getString(NUMBER);
        BizRuleCatalogTreeNode currentNode = new BizRuleCatalogTreeNode(String.valueOf(id), name);
        currentNode.setData(number);
        currentNode.SetIsOpened(true);
        if (parentNode != null) {
            currentNode.setParent(parentNode);
            parentNode.addChild(currentNode);
        }
        if ((childrenList = nodeMap.get(id)) != null && !childrenList.isEmpty()) {
            for (DynamicObject childObj : childrenList) {
                TreeBuilder.createBizRuleCatalogNode(childObj, currentNode, nodeMap, showType);
            }
        }
        return currentNode;
    }

    public static OrgTreeNode getOrgCslTree(DynamicObjectCollection rootNodeList, String showType, boolean isCsl) {
        return TreeBuilder.getOrgTreeRoot(rootNodeList, showType, isCsl);
    }

    private static OrgTreeNode getOrgTreeRoot(DynamicObjectCollection rootNodeList, String showType, boolean isCsl) {
        HashMap<String, List<DynamicObject>> nodeMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject node : rootNodeList) {
            String parentId = node.getString("parent_id");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)nodeMap.get(parentId);
            if (list == null) {
                list = new ArrayList<DynamicObject>(10);
                nodeMap.put(parentId, list);
            }
            list.add(node);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (DynamicObject)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        return TreeBuilder.createNode(rootNode, null, nodeMap, showType, isCsl);
    }

    private static OrgTreeNode createNode(DynamicObject map, OrgTreeNode parentNode, Map<String, List<DynamicObject>> nodeMap, String showType, boolean isCsl) {
        String id = map.getString("id");
        String name = map.getString("name");
        String number = map.getString(NUMBER);
        String storageType = map.getString(STORAGE_TYPE);
        String currencyName = map.getString("currency.name");
        String formatName = TreeBuilder.formatDisplayName(showType, name, number, currencyName);
        OrgTreeNode curNode = new OrgTreeNode(id, formatName, number, storageType, formatName);
        List<DynamicObject> list = nodeMap.get(id);
        curNode.SetIsOpened(true);
        if (parentNode != null) {
            curNode.setParent(parentNode);
            parentNode.addChild(curNode);
        }
        if (list != null) {
            for (DynamicObject dnm : list) {
                if (isCsl && dnm.getBoolean(IS_LEAF) && !TreeBuilder.isShareAndNotLeafEntity(dnm, isCsl)) continue;
                TreeBuilder.createNode(dnm, curNode, nodeMap, showType, isCsl);
            }
            curNode.setName(curNode.getFinalname() + "(" + curNode.getChildSize() + ")");
        }
        return curNode;
    }

    private static boolean isShareAndNotLeafEntity(DynamicObject dyn, boolean isCsl) {
        QFilter leafFilter;
        QFilter numberFilter;
        String share = "3";
        boolean flag = false;
        if (!share.equals(dyn.getString(STORAGE_TYPE))) {
            return false;
        }
        QFilter modelFilter = new QFilter("model", "=", dyn.getDynamicObject("model").getPkValue());
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, isleaf", (QFilter[])new QFilter[]{modelFilter, numberFilter = new QFilter(NUMBER, "=", (Object)dyn.getString(NUMBER)), leafFilter = new QFilter(IS_LEAF, "=", (Object)"0")});
        if (cols != null && cols.size() > 0 && isCsl) {
            flag = true;
        }
        return flag;
    }

    public static String formatDisplayName(String showType, String name, String number, String currencyName) {
        String formatName = name;
        switch (showType = kd.bos.util.StringUtils.isEmpty((String)showType) ? "4" : showType) {
            case "2": {
                formatName = kd.bos.util.StringUtils.isNotEmpty((String)currencyName) ? name + " " + currencyName : name;
                break;
            }
            case "3": {
                formatName = number + " " + name;
                break;
            }
            case "4": {
                formatName = kd.bos.util.StringUtils.isNotEmpty((String)currencyName) ? number + " " + name + " " + currencyName : number + " " + name;
            }
        }
        return formatName;
    }

    public static String formatDisplayName(String showType, String name, String number, String currencyName, String singleName) {
        String formatName = name;
        switch (showType = kd.bos.util.StringUtils.isEmpty((String)showType) ? "4" : showType) {
            case "2": {
                formatName = kd.bos.util.StringUtils.isNotEmpty((String)currencyName) ? name + " " + currencyName : name;
                break;
            }
            case "3": {
                formatName = number + " " + name;
                break;
            }
            case "4": {
                formatName = kd.bos.util.StringUtils.isNotEmpty((String)currencyName) ? number + " " + name + " " + currencyName : number + " " + name;
                break;
            }
            case "5": {
                formatName = number + " " + singleName;
                break;
            }
            case "6": {
                if (kd.bos.util.StringUtils.isNotEmpty((String)currencyName) && kd.bos.util.StringUtils.isNotEmpty((String)singleName)) {
                    formatName = number + " " + singleName + " " + currencyName;
                    break;
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)currencyName)) {
                    formatName = number + " " + currencyName;
                    break;
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)singleName)) {
                    formatName = number + " " + singleName;
                    break;
                }
                formatName = number;
                break;
            }
        }
        return formatName;
    }

    @Deprecated
    public static TemplateTreeNode getTemplateTree(DynamicObjectCollection templatecatalogList, TemplateTreeNode root, DynamicObjectCollection templateColls, String showType) {
        return TreeBuilder.getTemplateCatalogTreeRoot(false, templatecatalogList, root, templateColls, showType);
    }

    public static TemplateTreeNode getCycleTablesTree(DynamicObjectCollection templatecatalogList, TemplateTreeNode root, ITemplateQuery query, String showType, ITemplateCollectionFilter tmplFilter, Long modelId, Set<Long> orgIds, QFilter qFilter, Set<Long> rTempIds, boolean isEcCurrency, Map<Long, Pair<Long, String>> org_curr, QFilter currencyfilter, boolean isFromReportQuery) {
        DynamicObjectCollection templateColls = TreeBuilder.getTempTreeDynamicObjects(query, tmplFilter);
        HashMap<Long, DynamicObject> templateMaps = new HashMap<Long, DynamicObject>(templateColls.size());
        templateColls.forEach(tp -> templateMaps.put(tp.getLong("id"), (DynamicObject)tp));
        Map<Long, Set<Long>> cycleTablesDetail = CycleTablesServiceHelper.getTmplDisCycleTablesDetail(modelId, null);
        HashMap<Long, Set<Long>> orgCtTemplateMap = new HashMap<Long, Set<Long>>(16);
        showType = showType == null ? "2" : showType;
        Map<Long, Pair<Integer, Integer>> commitTemplate = TreeBuilder.getCommitTemplate(orgIds, qFilter, cycleTablesDetail, orgCtTemplateMap, rTempIds, isEcCurrency, org_curr, currencyfilter, isFromReportQuery);
        root = TreeBuilder.getCycleTablesTreeRoot(false, templatecatalogList, root, templateMaps, showType, cycleTablesDetail, commitTemplate, orgCtTemplateMap, orgIds);
        TreeBuilder.checkInvalidNode(root);
        TemplateTreeNode newRoot = TreeBuilder.invalidTempTreeNode(root);
        return newRoot;
    }

    public static Map<Long, Pair<Integer, Integer>> getCommitTemplate(Set<Long> orgIds, QFilter qFilter, Map<Long, Set<Long>> cycleTablesDetail, Map<Long, Set<Long>> orgCtTemplateMap, Set<Long> rTempIds, boolean isEcCurrency, Map<Long, Pair<Long, String>> org_curr, QFilter currencyfilter, boolean isFromReportQuery) {
        HashMap<Long, Pair<Integer, Integer>> map = new HashMap<Long, Pair<Integer, Integer>>(16);
        Set<Object> templateSet = new HashSet(16);
        if (cycleTablesDetail == null || cycleTablesDetail.isEmpty() || org_curr.isEmpty() || currencyfilter == null) {
            return map;
        }
        HashSet<Long> ctSet = new HashSet<Long>(cycleTablesDetail.size());
        for (Map.Entry<Long, Set<Long>> entry2 : cycleTablesDetail.entrySet()) {
            ctSet.add(entry2.getKey());
            templateSet.addAll(entry2.getValue());
        }
        if (!isFromReportQuery) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", rTempIds), new QFilter("usage", "=", (Object)TemplateUsageEnum.FORWEAVE.getValue())});
            rTempIds.clear();
            dynamicObjects.forEach(dyo -> rTempIds.add(dyo.getLong("id")));
        }
        templateSet = templateSet.stream().filter(templateId -> rTempIds.contains(templateId)).collect(Collectors.toSet());
        QFilter orgFilter = new QFilter("entity", "in", orgIds);
        QFilter ctFilter = new QFilter("cycletable", "in", ctSet);
        QFilter statusFilter = new QFilter("cycletabstatus", "in", Arrays.asList(ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bcm_cycletablereport", (String)"id,currency.id,entity,entity.id,cycletable,cycletable.name,cycletabstatus,report_entry,report_entry.template", (QFilter[])new QFilter[]{qFilter, orgFilter, ctFilter, statusFilter, currencyfilter});
        HashMap orgCtMap = new HashMap(cycleTablesDetail.size());
        if (objects != null) {
            for (DynamicObject object : objects) {
                DynamicObjectCollection objectCollection;
                boolean isTrueCurr;
                long orgId = object.getLong("entity.id");
                boolean bl = isTrueCurr = !isEcCurrency || isEcCurrency && org_curr.get(orgId) != null && ((Long)org_curr.get((Object)Long.valueOf((long)orgId)).p1).longValue() == object.getLong("currency.id");
                if (!isTrueCurr || (objectCollection = object.getDynamicObjectCollection("report_entry")) == null || objectCollection.isEmpty()) continue;
                HashSet templateList = new HashSet(objectCollection.size());
                objectCollection.forEach(dynamicObject -> templateList.add(dynamicObject.getLong("template.id")));
                long ctId = object.getLong("cycletable.id");
                if (!orgCtTemplateMap.containsKey(ctId)) {
                    orgCtTemplateMap.put(ctId, new HashSet(16));
                }
                orgCtTemplateMap.get(ctId).addAll(templateList);
                orgCtMap.put(Pair.onePair((Object)orgId, (Object)ctId), templateList);
                map.put(ctId, (Pair<Integer, Integer>)Pair.onePair((Object)0, (Object)templateList.size()));
            }
        }
        cycleTablesDetail.entrySet().forEach(entry -> {
            Set templates = ((Set)entry.getValue()).stream().filter(id -> rTempIds.contains(id)).collect(Collectors.toSet());
            if (!map.containsKey(entry.getKey())) {
                map.put((Long)entry.getKey(), (Pair<Integer, Integer>)Pair.onePair((Object)0, (Object)templates.size()));
            }
        });
        QFilter tempFilter = new QFilter("template", "in", templateSet);
        QFilter tempStatusFilter = new QFilter("reportstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bcm_reportentity", (String)"id,entity,template,reportstatus,currency", (QFilter[])new QFilter[]{qFilter, orgFilter, tempFilter, currencyfilter, tempStatusFilter});
        cycleTablesDetail.entrySet().forEach(entry -> {
            if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                dynamicObjects.forEach(dynamicObject -> {
                    boolean isTrueCu;
                    long orgId = dynamicObject.getLong("entity");
                    boolean bl = isTrueCu = !isEcCurrency || isEcCurrency && org_curr.get(orgId) != null && dynamicObject.getLong("currency") == ((Long)((Pair)org_curr.get((Object)Long.valueOf((long)orgId))).p1).longValue();
                    if (isTrueCu) {
                        Pair pair = Pair.onePair((Object)orgId, entry.getKey());
                        Pair twoPair = (Pair)map.get(entry.getKey());
                        if (orgCtMap != null && !orgCtMap.isEmpty() && orgCtMap.containsKey(pair) && orgCtMap.get(pair) != null) {
                            if (((Set)orgCtMap.get(pair)).contains(dynamicObject.getLong("template")) && ((Set)entry.getValue()).contains(dynamicObject.getLong("template"))) {
                                map.put((Long)entry.getKey(), (Pair<Integer, Integer>)Pair.onePair((Object)((Integer)twoPair.p1 + 1), (Object)twoPair.p2));
                            }
                        } else if (((Set)entry.getValue()).contains(dynamicObject.getLong("template"))) {
                            map.put((Long)entry.getKey(), (Pair<Integer, Integer>)Pair.onePair((Object)((Integer)twoPair.p1 + 1), (Object)twoPair.p2));
                        }
                    }
                });
            }
        });
        return map;
    }

    private static TemplateTreeNode getCycleTablesTreeRoot(boolean ishaveroot, DynamicObjectCollection templatecatalogList, TemplateTreeNode parent, Map<Long, DynamicObject> templateMaps, String showType, Map<Long, Set<Long>> cycleTablesDetail, Map<Long, Pair<Integer, Integer>> ctMap, Map<Long, Set<Long>> orgCtTemplateMap, Set<Long> orgIds) {
        for (DynamicObject map : templatecatalogList) {
            if (!ishaveroot) {
                if (!map.getString(PARENT).equals("0")) continue;
                parent = new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString(NUMBER), false);
                parent.SetIsOpened(true);
                TreeBuilder.getTemplateTreeForCT(parent, templateMaps, showType, cycleTablesDetail, orgCtTemplateMap);
                TreeBuilder.getCycleTablesTreeRoot(true, templatecatalogList, parent, templateMaps, showType, cycleTablesDetail, ctMap, orgCtTemplateMap, orgIds);
                continue;
            }
            if (!map.getString(PARENT).equals(parent.getId())) continue;
            TemplateTreeNode child = new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString(NUMBER), false);
            TreeBuilder.getTemplateTreeForCT(child, templateMaps, showType, cycleTablesDetail, orgCtTemplateMap);
            TreeBuilder.getCycleTablesTreeRoot(true, templatecatalogList, child, templateMaps, showType, cycleTablesDetail, ctMap, orgCtTemplateMap, orgIds);
            child.setParent(parent);
            if (child.getChildren() != null && !child.getChildren().isEmpty() && orgIds.size() == 1) {
                Pair<Integer, Integer> pair;
                String name = child.getFinalname();
                if ("2".equals(showType)) {
                    name = child.getNumber() + " " + name;
                }
                if ((pair = ctMap.get(LongUtil.toLong((Object)child.getId()))) != null) {
                    child.setName(name + "(" + pair.p1 + "/" + pair.p2 + ")");
                }
            }
            parent.addChild(child);
            if (child.isLeaf()) continue;
            parent.SetIsOpened(true);
        }
        return parent;
    }

    public static TemplateTreeNode getTemplateTreeNew(DynamicObjectCollection templatecatalogList, TemplateTreeNode root, ITemplateQuery query, String showType, ITemplateCollectionFilter tmplFilter) {
        DynamicObjectCollection templateColls = TreeBuilder.getTempTreeDynamicObjects(query, tmplFilter);
        root = TreeBuilder.getTemplateCatalogTreeRoot(false, templatecatalogList, root, templateColls, showType);
        TreeBuilder.checkInvalidNode(root);
        TemplateTreeNode newRoot = TreeBuilder.invalidTempTreeNode(root);
        return newRoot;
    }

    public static TemplateTreeNode invalidTempTreeNode(TemplateTreeNode root) {
        TemplateTreeNode newRoot = new TemplateTreeNode(root.getId(), root.getName(), root.getNumber(), false);
        TreeBuilder.invaildTreeNode(true, newRoot, root);
        return newRoot;
    }

    public static void invaildTreeNode(boolean isRoot, TemplateTreeNode parentNode, TemplateTreeNode currNode) {
        TemplateTreeNode pNode = parentNode;
        if (isRoot) {
            TreeBuilder.cloneTemplateNode(parentNode, currNode);
        } else if (currNode.isIsvalid()) {
            TemplateTreeNode child = new TemplateTreeNode(currNode.getId(), currNode.getName(), currNode.getNumber(), currNode.isIstemplate());
            TreeBuilder.cloneTemplateNode(child, currNode);
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode c : currNode.getChildren()) {
            TreeBuilder.invaildTreeNode(false, pNode, (TemplateTreeNode)c);
        }
    }

    private static void cloneTemplateNode(TemplateTreeNode parentNode, TemplateTreeNode currNode) {
        parentNode.setId(currNode.getId());
        parentNode.setName(currNode.getName());
        parentNode.setNumber(currNode.getNumber());
        parentNode.setIstemplate(currNode.isIstemplate());
        parentNode.setIsvalid(currNode.isIsvalid());
        parentNode.setUsage(currNode.getUsage());
        parentNode.setParent(currNode.getParent());
        parentNode.setData(currNode.getData());
        parentNode.setDetailData(currNode.getDetailData());
        parentNode.setRootid(currNode.getRootid());
        parentNode.SetIsOpened(currNode.isOpened());
    }

    public static void checkInvalidNode(TemplateTreeNode root) {
        boolean bl;
        for (TemplateTreeNode templateTreeNode : root.getChildren()) {
            if (!templateTreeNode.isIstemplate() && templateTreeNode.getChildren().isEmpty()) {
                templateTreeNode.setIsvalid(false);
                continue;
            }
            TreeBuilder.checkInvalidNode(templateTreeNode);
        }
        if (!root.isIstemplate() && !(bl = root.getChildren().stream().anyMatch(c -> ((TemplateTreeNode)c).isIsvalid()))) {
            root.setIsvalid(false);
        }
    }

    public static DynamicObjectCollection getTempTreeDynamicObjects(ITemplateQuery query, ITemplateCollectionFilter tmplFilter) {
        DynamicObjectCollection templateColls = QueryServiceHelper.query((String)"bcm_templateentity", (String)query.getSelector(), (QFilter[])query.getFilter(), (String)query.getOrder());
        if (CollectionUtils.isNotEmpty((Collection)templateColls)) {
            TemplateUtil.filterVersionTemplateTree((Collection<DynamicObject>)templateColls);
        }
        if (tmplFilter != null) {
            tmplFilter.filter(templateColls);
        }
        return templateColls;
    }

    public static TemplateTreeNode getStageTreeRoot(DynamicObjectCollection stages, TemplateTreeNode parent, String showType) {
        for (DynamicObject map : stages) {
            TemplateTreeNode node = new TemplateTreeNode(map.getString("id"), map.getString(NUMBER), map.getString(NUMBER) + " " + map.getString("name"), false);
            parent.addChild(node);
            parent.SetIsOpened(true);
        }
        return parent;
    }

    public static TemplateTreeNode getTemplateTreeNew(DynamicObjectCollection templatecatalogList, TemplateTreeNode root, String showType) {
        DynamicObjectCollection templateColls = new DynamicObjectCollection();
        return TreeBuilder.getTemplateCatalogTreeRoot(false, templatecatalogList, root, templateColls, showType);
    }

    private static TemplateTreeNode getTemplateTreeRoot(boolean ishaveroot, DynamicObjectCollection templatecatalogList, TemplateTreeNode parent, DynamicObjectCollection templateColls, String showType) {
        for (DynamicObject map : templatecatalogList) {
            if (!ishaveroot) {
                if (!map.getString(PARENT).equals("0")) continue;
                parent = new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString(NUMBER), false);
                parent.SetIsOpened(true);
                TreeBuilder.getTemplateTree(parent, templateColls, showType);
                TreeBuilder.getTemplateCatalogTreeRoot(true, templatecatalogList, parent, templateColls, showType);
                continue;
            }
            if (!map.getString(PARENT).equals(parent.getId())) continue;
            TemplateTreeNode child = "1".equals(showType) ? new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString(NUMBER), false) : ("2".equals(showType) ? new TemplateTreeNode(map.getString("id"), map.getString(NUMBER) + " " + map.getString("name"), map.getString(NUMBER), false) : new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString(NUMBER), false));
            TreeBuilder.getTemplateTree(child, templateColls, showType);
            TreeBuilder.getTemplateCatalogTreeRoot(true, templatecatalogList, child, templateColls, showType);
            child.setParent(parent);
            parent.addChild(child);
            if (child.isLeaf()) continue;
            parent.SetIsOpened(true);
        }
        return parent;
    }

    private static TemplateTreeNode getTemplateCatalogTreeRoot(boolean ishaveroot, DynamicObjectCollection templatecatalogList, TemplateTreeNode parent, DynamicObjectCollection templateColls, String showType) {
        return TreeBuilder.getTemplateTreeRoot(ishaveroot, templatecatalogList, parent, templateColls, showType);
    }

    private static void getTemplateTreeForCT(TemplateTreeNode cycleTableNode, Map<Long, DynamicObject> templateMaps, String showType, Map<Long, Set<Long>> cycleTablesDetail, Map<Long, Set<Long>> orgCtTemplateMap) {
        if (cycleTablesDetail == null || cycleTablesDetail.isEmpty()) {
            return;
        }
        cycleTablesDetail.entrySet().forEach(entry -> {
            if (cycleTableNode.getId().equals(Long.toString((Long)entry.getKey()))) {
                Set templateIds = (Set)entry.getValue();
                if (templateIds == null || templateIds.isEmpty()) {
                    return;
                }
                if (!orgCtTemplateMap.isEmpty() && orgCtTemplateMap.get(entry.getKey()) != null) {
                    templateIds = (Set)orgCtTemplateMap.get(entry.getKey());
                }
                for (Long templateId : templateIds) {
                    if (!templateMaps.containsKey(templateId) || templateMaps.get(templateId) == null) continue;
                    DynamicObject dot = (DynamicObject)templateMaps.get(templateId);
                    TemplateTreeNode template = null;
                    String id = dot.getString("id");
                    String name = dot.getString("name");
                    String number = dot.getString(NUMBER);
                    template = "1".equals(showType) ? new TemplateTreeNode(id, name, number, true) : ("2".equals(showType) ? new TemplateTreeNode(id, number + " " + name, number, true) : new TemplateTreeNode(id, name, number, true));
                    template.setParent(cycleTableNode);
                    template.setUsage(dot.getString("usage"));
                    cycleTableNode.addChild(template);
                    cycleTableNode.SetIsOpened(true);
                }
            }
        });
    }

    private static void getTemplateTree(TemplateTreeNode templatecatalog, DynamicObjectCollection templateColls, String showType) {
        for (DynamicObject dot : templateColls) {
            boolean isDyna = dot.get("templatecatalog") instanceof DynamicObject;
            if (!templatecatalog.getId().equals(isDyna ? dot.getString("templatecatalog.id") : dot.getString("templatecatalog"))) continue;
            TemplateTreeNode template = null;
            String id = dot.getString("id");
            String name = dot.getString("name");
            String number = dot.getString(NUMBER);
            template = "1".equals(showType) ? new TemplateTreeNode(id, name, number, true) : ("2".equals(showType) ? new TemplateTreeNode(id, number + " " + name, number, true) : new TemplateTreeNode(id, name, number, true));
            template.setParent(templatecatalog);
            template.setUsage(dot.getString("usage"));
            templatecatalog.addChild(template);
            templatecatalog.SetIsOpened(true);
        }
    }

    public static DimensionTreeNode getDimensionTree(DynamicObjectCollection rootNodeList) {
        HashMap<String, DimensionTreeNode> allTreeNodeMap = new HashMap<String, DimensionTreeNode>(16);
        DimensionTreeNode childNode = null;
        AbstractTreeNode firstNode = null;
        for (DynamicObject node : rootNodeList) {
            childNode = new DimensionTreeNode(node.getString("id"), node.getString("name"), node.getString(NUMBER), node.getString(STORAGE_TYPE), node.getString("copyfrom"), node.getString("member.id"), node.getInt("share"), node.getInt("level"), node.getInt("dseq"), node.getBoolean(IS_LEAF), false, false, node.getString("longnumber"));
            childNode.setData(node.getString(PARENT));
            childNode.setName(childNode.getNumber() + " " + childNode.getName() + TreeBuilder.getStorage(childNode.getStoragetype()));
            if (firstNode == null && node.getString(PARENT).equals("0")) {
                firstNode = childNode;
                continue;
            }
            allTreeNodeMap.put(node.getString("id"), childNode);
        }
        AbstractTreeNode pNode = null;
        if (firstNode != null) {
            firstNode.SetIsOpened(true);
            firstNode.setParent(null);
        }
        ArrayList allTreeNode = new ArrayList(allTreeNodeMap.values());
        Collections.sort(allTreeNode, TreeBuilder.getNodeDseqComparator());
        for (DimensionTreeNode node : allTreeNode) {
            String pId = (String)node.getData();
            pNode = !allTreeNodeMap.containsKey(pId) ? firstNode : (DimensionTreeNode)allTreeNodeMap.get(pId);
            if (pNode != null) {
                pNode.addChild(node);
            }
            node.setData(null);
        }
        return firstNode;
    }

    public static Comparator getNodeDseqComparator() {
        Comparator<DimensionTreeNode> comparator = new Comparator<DimensionTreeNode>(){

            @Override
            public int compare(DimensionTreeNode o1, DimensionTreeNode o2) {
                int dseq = o1.getDseq() - o2.getDseq();
                return dseq;
            }
        };
        return comparator;
    }

    public static DimensionTreeNode getDimensionTree(DynamicObjectCollection rootNodeList, DimensionTreeNode root) {
        return TreeBuilder.getDimensionTree(rootNodeList, root, "0");
    }

    public static DimensionTreeNode getDimensionTree(DynamicObjectCollection rootNodeList, DimensionTreeNode root, String rootParentId) {
        return TreeBuilder.getDimensionTreeRoot(rootNodeList, root, rootParentId, false);
    }

    public static DimensionTreeNode getDimensionTree4Sync(DynamicObjectCollection rootNodeList, DimensionTreeNode root, String rootParentId) {
        return TreeBuilder.getDimensionTreeRoot(rootNodeList, root, rootParentId, true);
    }

    private static DimensionTreeNode getDimensionTreeRoot(DynamicObjectCollection rootNodeList, DimensionTreeNode parent, String rootParentId, boolean fromSync) {
        Iterator iter = rootNodeList.iterator();
        HashMap<String, DimensionTreeNode> IdNodeMap = new HashMap<String, DimensionTreeNode>(rootNodeList.size());
        ArrayListMultimap parent2ChildMap = ArrayListMultimap.create();
        String rootId = rootParentId;
        String dimensionNumber = ((DynamicObject)rootNodeList.get(0)).getString(NUMBER);
        while (iter.hasNext()) {
            DynamicObject map = (DynamicObject)iter.next();
            String childId = map.getString("id");
            DimensionTreeNode child = TreeBuilder.buildDimensionTreeNode(map, dimensionNumber, fromSync);
            IdNodeMap.put(childId, child);
            Long parentId = map.get(PARENT) instanceof DynamicObject ? Long.valueOf(map.getLong("parent.id")) : Long.valueOf(map.getLong(PARENT));
            if (parentId != null && parentId != 0L && !String.valueOf(parentId).equals(rootParentId)) {
                parent2ChildMap.put((Object)String.valueOf(parentId), (Object)childId);
                continue;
            }
            rootId = childId;
        }
        if (parent2ChildMap.size() == 0) {
            parent = (DimensionTreeNode)IdNodeMap.get(rootId);
            parent.SetIsOpened(true);
            parent.setParent(null);
            return parent;
        }
        for (Map.Entry entry : parent2ChildMap.asMap().entrySet()) {
            DimensionTreeNode parentNode = (DimensionTreeNode)IdNodeMap.get(entry.getKey());
            if (parentNode == null) continue;
            for (String childId : (Collection)entry.getValue()) {
                parentNode.addChild((ITreeNode)IdNodeMap.get(childId));
            }
            if (!((String)entry.getKey()).equals(rootId)) continue;
            parent = parentNode;
            parent.SetIsOpened(true);
            parent.setParent(null);
        }
        return parent;
    }

    public static DimensionTreeNode buildDimensionTreeNode(DynamicObject memberDy, String rootNumber, boolean fromSync) {
        DimensionTreeNode treeNode = new DimensionTreeNode(memberDy.getString("id"), memberDy.getString("name"), memberDy.getString(NUMBER), memberDy.getString(STORAGE_TYPE), memberDy.getString("copyfrom"), memberDy.getString("member.id"), memberDy.getInt("share"), memberDy.getInt("level"), memberDy.getInt("dseq"), memberDy.getBoolean(IS_LEAF), false, false, memberDy.getString("longnumber"));
        if ("Account".equals(rootNumber) && fromSync) {
            for (String field : properties) {
                if (memberDy.get(field) == null) continue;
                treeNode.setProperty(field, memberDy.get(field));
            }
        } else {
            treeNode.setName(treeNode.getNumber() + " " + treeNode.getName() + TreeBuilder.getStorage(treeNode.getStoragetype()));
        }
        return treeNode;
    }

    public static ITreeNode<Object> setOpen(ITreeNode<Object> root) {
        LinkedList queue = new LinkedList();
        queue.addAll(root.getChildren());
        while (!queue.isEmpty()) {
            AbstractTreeNode node = (AbstractTreeNode)queue.poll();
            node.SetIsOpened(false);
            List children = node.getChildren();
            if (children == null) continue;
            queue.addAll(children);
        }
        return root;
    }

    private static String getStorage(String storagetype) {
        switch (storagetype) {
            case "4": {
                return ResManager.loadKDString((String)"\uff08\u4e0d\u5171\u4eab\uff09", (String)"TreeBuilder_0", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\uff08\u6807\u7b7e\uff09", (String)"TreeBuilder_1", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\uff08\u5b58\u50a8\uff09", (String)"TreeBuilder_2", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\uff08\u5171\u4eab\uff09", (String)"TreeBuilder_3", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\uff08\u52a8\u6001\u8ba1\u7b97\uff09", (String)"TreeBuilder_4", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static OrgTreeNode createOrgTreeNode(long modelId, boolean showNoMergeOrg, Map<String, List<Long>> needRemoveNodes, IDNumberTreeNode root, String showType, Long cslShemeId, boolean isShowRate, boolean isOpened) {
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        Map<Long, String> orgNameMap = EntityVersioningUtil.getRealOrgNameOnThread();
        Map<String, String> number2SimpleName = EntityVersioningUtil.getNum2SimpleOnThread();
        String formatName = TreeBuilder.getFormatName(orgNameMap, showType, root, modelNum, number2SimpleName);
        OrgTreeNode rootTreeNode = new OrgTreeNode(root, formatName);
        List<IDNumberTreeNode> validChildren = isShowRate ? root.getChildren() : root.getChildren().stream().filter(node -> node.getProperty("cslscheme.id").equals(cslShemeId)).collect(Collectors.toList());
        HashSet<Long> needRemoveIds = new HashSet<Long>(16);
        needRemoveIds.addAll(needRemoveNodes.getOrDefault("noPermNodeIds", new ArrayList(16)));
        needRemoveIds.addAll(needRemoveNodes.getOrDefault("filterVersionNodeIds", new ArrayList(16)));
        if (!showNoMergeOrg) {
            needRemoveIds.addAll(needRemoveNodes.getOrDefault("noMergeNodeIds", new ArrayList(16)));
        }
        HashSet noMergeOrgNodes = Sets.newHashSet((Iterable)needRemoveNodes.getOrDefault("noMergeNodeIds", new ArrayList(16)));
        TreeBuilder.createTreeNode(modelNum, orgNameMap, rootTreeNode, validChildren, needRemoveIds, noMergeOrgNodes, showNoMergeOrg, showType, isShowRate, isOpened, number2SimpleName);
        return rootTreeNode;
    }

    private static String getFormatName(Map<Long, String> orgNameMap, String showType, IDNumberTreeNode root, String modelNum, Map<String, String> number2SimpleName) {
        String currencyName = "";
        if (StringUtils.isNotEmpty((String)root.getCurrency())) {
            currencyName = MemberReader.findMemberByNumber((String)modelNum, (String)DimEntityNumEnum.CURRENCY.getNumber(), (String)root.getCurrency()).getName();
        }
        String name = Optional.ofNullable(orgNameMap.get(root.getId())).orElseGet(() -> ((IDNumberTreeNode)root).getName());
        String simplename = number2SimpleName.getOrDefault(root.getNumber(), "");
        return TreeBuilder.formatDisplayName(showType, name, root.getNumber(), currencyName, simplename);
    }

    private static void createTreeNode(String modelNum, Map<Long, String> orgNameMap, OrgTreeNode treeNode, List<IDNumberTreeNode> children, Set<Long> needRemoveIds, Set<Long> noMergeOrgNodes, boolean showNoMergeOrg, String showType, boolean isShowRate, boolean isOpened, Map<String, String> number2SimpleName) {
        long parentId = Long.parseLong(treeNode.getId());
        if (needRemoveIds.contains(parentId)) {
            return;
        }
        treeNode.SetIsOpened(isOpened);
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        int childSize = children.size();
        for (IDNumberTreeNode node : children) {
            if (needRemoveIds.contains(node.getId())) {
                --childSize;
                continue;
            }
            OrgTreeNode childTreeNode = new OrgTreeNode(node, TreeBuilder.getFormatName(orgNameMap, showType, node, modelNum, number2SimpleName));
            childTreeNode.setParent(treeNode);
            treeNode.addChild(childTreeNode);
            if (node.isLeaf()) {
                if (showNoMergeOrg && noMergeOrgNodes.contains(node.getId())) {
                    childTreeNode.setName(String.format("%s(%s)", childTreeNode.getFinalname(), ResManager.loadKDString((String)"\u4e0d\u53c2\u4e0e\u5408\u5e76", (String)"TreeBuilder_5", (String)FI_BCM_BUSINESS, (Object[])new Object[0])));
                    continue;
                }
                childTreeNode.setName(String.format("%s", childTreeNode.getFinalname()));
                continue;
            }
            if (!node.isLeaf() || !isShowRate) {
                TreeBuilder.createTreeNode(modelNum, orgNameMap, childTreeNode, node.getChildren(), needRemoveIds, noMergeOrgNodes, showNoMergeOrg, showType, isShowRate, isOpened, number2SimpleName);
                continue;
            }
            if (!TreeBuilder.isShareAndCopyFromNotLeaf(node)) continue;
            TreeBuilder.createTreeNode(modelNum, orgNameMap, childTreeNode, node.getChildren(), needRemoveIds, noMergeOrgNodes, showNoMergeOrg, showType, isShowRate, isOpened, number2SimpleName);
        }
        if (showNoMergeOrg && noMergeOrgNodes.contains(parentId)) {
            if (childSize <= 0) {
                treeNode.setName(String.format("%s(%s)", treeNode.getFinalname(), ResManager.loadKDString((String)"\u4e0d\u53c2\u4e0e\u5408\u5e76", (String)"TreeBuilder_5", (String)FI_BCM_BUSINESS, (Object[])new Object[0])));
            } else {
                treeNode.setName(String.format("%s(%d)(%s)", treeNode.getFinalname(), childSize, ResManager.loadKDString((String)"\u4e0d\u53c2\u4e0e\u5408\u5e76", (String)"TreeBuilder_5", (String)FI_BCM_BUSINESS, (Object[])new Object[0])));
            }
        } else if (childSize <= 0) {
            treeNode.setName(String.format("%s", treeNode.getFinalname()));
        } else {
            treeNode.setName(String.format("%s(%d)", treeNode.getFinalname(), childSize));
        }
    }

    private static boolean isShareAndCopyFromNotLeaf(IDNumberTreeNode node) {
        if (!node.isShare()) {
            return false;
        }
        IDNumberTreeNode member = node.getBaseTreeNode();
        return member != IDNumberTreeNode.NotFoundTreeNode && !member.isLeaf();
    }

    public static interface ITemplateCollectionFilter {
        public void filter(DynamicObjectCollection var1);
    }

    public static interface ITemplateQuery {
        default public String getSelector() {
            return "id,number,name,templatecatalog,templatecatalog.id,usage,versionnumber,group";
        }

        public QFilter[] getFilter();

        default public String getOrder() {
            return "sequence,number";
        }
    }
}

