/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import org.apache.commons.lang3.tuple.Pair;

public class TreeModel<E extends ITreeNode<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CACHE_KEY = "key_treemodel";
    public static final String CACHE_DICT_KEY = "key_dickeyset";
    private E root;
    private Map<String, ITreeNode<?>> dict = new HashMap();
    private boolean isBuiltDict = false;

    public TreeModel(E root) {
        Objects.requireNonNull(root);
        this.root = root;
    }

    public E getRoot() {
        return this.root;
    }

    public E searchByNodeId(String nodeId) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        return (E)this.dict.get(nodeId);
    }

    public E searchByNodeAttribute(Predicate test) {
        Optional<ITreeNode> op;
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        return (E)((op = this.dict.values().stream().filter(tree -> test.test(tree)).findFirst()).isPresent() ? op.get() : null);
    }

    private void buildNodeDictionary() {
        this.cycleIterateNode((ITreeNode<?>)this.root);
        this.isBuiltDict = true;
    }

    private void cycleIterateNode(ITreeNode<?> node) {
        this.dict.put(node.getId(), node);
        for (ITreeNode<?> n : node.getChildren()) {
            this.cycleIterateNode(n);
        }
    }

    public E seekChildIf(String pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(null);
        this.cycleSeekNode((ITreeNode<?>)node, p, (Recorder<ITreeNode<?>>)r);
        return (E)((ITreeNode)r.getRecord());
    }

    private boolean cycleSeekNode(ITreeNode<?> node, Predicate<E> p, Recorder<ITreeNode<?>> r) {
        return node.getChildren().stream().anyMatch(t -> {
            if (p.test(t)) {
                r.setRecord(t);
                return true;
            }
            return this.cycleSeekNode((ITreeNode<?>)t, p, r);
        });
    }

    public List<E> seekChildrenIf(String pNodeId, boolean isIncludeSelf, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(new ArrayList());
        if (isIncludeSelf) {
            ((List)r.getRecord()).add(node);
        }
        this.cycleSeekNodes((ITreeNode<?>)node, p, (Recorder<List<E>>)r);
        return (List)r.getRecord();
    }

    private void cycleSeekNodes(ITreeNode<?> node, Predicate<E> p, Recorder<List<E>> r) {
        node.getChildren().forEach(t -> {
            if (p.test(t)) {
                ((List)r.getRecord()).add(t);
            }
        });
    }

    public List<E> seekAllChildren(String pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(new ArrayList());
        if (p.test(node)) {
            ((List)r.getRecord()).add(node);
        }
        this.cycleSeekAllNodes((ITreeNode<?>)node, p, (Recorder<List<E>>)r);
        return (List)r.getRecord();
    }

    public List<E> seekAllChildrenIf(String pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(new ArrayList());
        if (p.test(this.root)) {
            ((List)r.getRecord()).add(this.root);
        }
        this.cycleSeekAllNodes((ITreeNode<?>)node, p, (Recorder<List<E>>)r);
        return (List)r.getRecord();
    }

    private void cycleSeekAllNodes(ITreeNode<?> node, Predicate<E> p, Recorder<List<E>> r) {
        node.getChildren().forEach(t -> {
            if (p.test(t)) {
                ((List)r.getRecord()).add(t);
            }
            this.cycleSeekAllNodes((ITreeNode<?>)t, p, r);
        });
    }

    public List<E> seekChildrenByGivenNode(String pNodeId, boolean isIncludeSelf) {
        ArrayList children = new ArrayList();
        E pnode = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)pnode, pNodeId);
        if (isIncludeSelf) {
            children.add(pnode);
        }
        this.cycleNode((ITreeNode<?>)pnode, c -> children.add(c));
        return children;
    }

    private void cycleNode(ITreeNode<?> pNode, Consumer<ITreeNode<?>> cs) {
        pNode.getChildren().forEach(c -> {
            cs.accept((ITreeNode<?>)c);
            this.cycleNode((ITreeNode<?>)c, cs);
        });
    }

    private void checkNode(ITreeNode<?> node, String nodeId) {
        if (node == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8282\u70b9ID\uff1a%s\u5728\u6811\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TreeModel_0", (String)"fi-bcm-business", (Object[])new Object[0]), nodeId));
        }
    }

    public TreeNode buildEntryTreeLimitLevel(TreeView tree, int limitLevel) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        this.cloneTreeNode(true, troot, (ITreeNode<?>)this.root, 1, limitLevel);
        tree.addNode(troot);
        return troot;
    }

    private void cloneTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode, int level, int limitLevel) {
        if (level > limitLevel) {
            return;
        }
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            child.setIsOpened(currNode.isOpened());
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode<?> c : currNode.getChildren()) {
            this.cloneTreeNode(false, pNode, c, level + 1, limitLevel);
        }
    }

    public TreeNode fillAndExpandChildren(TreeView treeView, String expandNodeId) {
        E expandNode = this.searchByNodeId(expandNodeId);
        if (expandNode == null) {
            return null;
        }
        TreeNode fillNode = new TreeNode();
        this.cloneTreeNode(false, fillNode, (ITreeNode<?>)expandNode, 1, 2);
        if (CollectionUtil.isEmpty((Collection)fillNode.getChildren())) {
            return null;
        }
        TreeNode childNode = (TreeNode)fillNode.getChildren().get(0);
        treeView.updateNode(childNode);
        treeView.expand(childNode.getId());
        return childNode;
    }

    public void expandSelectNode(TreeView treeView, String selectId, TreeNode treeNode) {
        Stack<String> nodeIdStack = new Stack<String>();
        for (Object tempNode = this.searchByNodeId(selectId); tempNode != null && tempNode.getParent() != null; tempNode = tempNode.getParent()) {
            nodeIdStack.push(tempNode.getId());
        }
        for (int i = 0; i < 2; ++i) {
            if (nodeIdStack.isEmpty()) {
                return;
            }
            nodeIdStack.pop();
        }
        while (!nodeIdStack.isEmpty()) {
            TreeNode expandNode = this.fillAndExpandChildren(treeView, (String)nodeIdStack.pop());
            treeNode.getTreeNode(expandNode.getId()).setChildren(expandNode.getChildren());
        }
    }

    public TreeNode buildEntryTree(TreeView tree) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        this.cloneTreeNode(true, troot, (ITreeNode<?>)this.root);
        tree.addNode(troot);
        return troot;
    }

    private void cloneTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            child.setIsOpened(currNode.isOpened());
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode<?> c : currNode.getChildren()) {
            this.cloneTreeNode(false, pNode, c);
        }
    }

    public void cache2page(IPageCache cache) {
        cache.put(CACHE_KEY, ObjectSerialUtil.toByteSerialized((Object)this));
        if (this.isBuiltDict) {
            cache.put(CACHE_DICT_KEY, ObjectSerialUtil.toByteSerialized(new HashSet<String>(this.dict.keySet())));
        }
    }

    public void ache2page(IPageCache cache, String pagecachekey) {
        cache.put(pagecachekey, ObjectSerialUtil.toByteSerialized((Object)this));
        if (this.isBuiltDict) {
            cache.put(CACHE_DICT_KEY, ObjectSerialUtil.toByteSerialized(new HashSet<String>(this.dict.keySet())));
        }
        ThreadCache.remove((Object)pagecachekey);
    }

    public static TreeModel<?> toTreeModel(IPageCache cache, String pagecachekey) {
        return (TreeModel)ThreadCache.get((Object)pagecachekey, () -> {
            String serial = cache.get(pagecachekey);
            if (StringUtils.isNotEmpty((String)serial)) {
                return (TreeModel)ObjectSerialUtil.deSerializedBytes((String)serial);
            }
            return null;
        });
    }

    public static Set<String> getDictNodeSet(IPageCache cache) {
        return (Set)ThreadCache.get((Object)CACHE_DICT_KEY, () -> {
            String serial = cache.get(CACHE_DICT_KEY);
            if (StringUtils.isNotEmpty((String)serial)) {
                return (Set)ObjectSerialUtil.deSerializedBytes((String)serial);
            }
            return null;
        });
    }

    public static TreeModel<?> toTreeModel(IPageCache cache) {
        return (TreeModel)ThreadCache.get((Object)CACHE_KEY, () -> {
            String serial = cache.get(CACHE_KEY);
            if (StringUtils.isNotEmpty((String)serial)) {
                return (TreeModel)ObjectSerialUtil.deSerializedBytes((String)serial);
            }
            return null;
        });
    }

    public static AbstractTreeNode<Object> QueryTreeNodeById(AbstractTreeNode<Object> root, String selectedNodeId) {
        AbstractTreeNode<Object> theNode = null;
        if (root.getId().equals(selectedNodeId)) {
            theNode = root;
        } else {
            List<ITreeNode<Object>> children = root.getChildren();
            for (ITreeNode<Object> node : children) {
                if (node.getId().equals(selectedNodeId)) {
                    theNode = (AbstractTreeNode<Object>)node;
                    break;
                }
                theNode = TreeModel.QueryTreeNodeById((AbstractTreeNode)node, selectedNodeId);
            }
        }
        return theNode;
    }

    public Map<String, ITreeNode<?>> getDict() {
        return this.dict;
    }

    public Pair<TreeNode, Set<String>> loadtoNode(TreeView tree, String nodeId) {
        ITreeNode<?> parent;
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        List selectedNodeId = tree.getTreeState().getCheckedNodeIds();
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        ITreeNode<?> find = this.dict.get(nodeId);
        HashSet<String> openedNodeIdSets = new HashSet<String>();
        for (parent = find.getParent(); parent != null; parent = parent.getParent()) {
            openedNodeIdSets.add(parent.getId());
        }
        if (!find.isLeaf()) {
            openedNodeIdSets.add(find.getId());
        }
        if (!selectedNodeId.isEmpty()) {
            for (String s : selectedNodeId) {
                if (openedNodeIdSets.contains(s)) continue;
                find = this.dict.get(s);
                for (parent = find.getParent(); parent != null && !openedNodeIdSets.contains(parent.getId()); parent = parent.getParent()) {
                    openedNodeIdSets.add(parent.getId());
                }
            }
        }
        this.loadOpenedTreeNode(true, troot, (ITreeNode<?>)this.root, (Set<String>)openedNodeIdSets);
        TreeNode focusNode = new TreeNode();
        focusNode.setId(nodeId);
        tree.addNode(troot);
        openedNodeIdSets.forEach(e -> tree.expand(e));
        tree.focusNode(focusNode);
        for (String s : selectedNodeId) {
            TreeNode selectNode = new TreeNode();
            selectNode.setId(s);
            tree.checkNode(selectNode);
        }
        return Pair.of((Object)troot, openedNodeIdSets);
    }

    private void loadOpenedTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode, Set<String> openedNodeIdSets) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            parentNode.addChild(child);
            pNode = child;
        }
        if (openedNodeIdSets.contains(currNode.getId())) {
            for (ITreeNode<?> c : currNode.getChildren()) {
                this.loadOpenedTreeNode(false, pNode, c, openedNodeIdSets);
            }
        }
    }
}

