/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.tree.dimension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.bcm.business.tree.AbstractTreeNode;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class DimensionTreeNode
extends AbstractTreeNode<Object>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private String number;
    private String storagetype;
    private String copyfrom;
    private String memberid;
    private boolean ischanged;
    private boolean neadsave;
    private int share;
    private int level;
    private int dseq;
    private boolean isleaf;
    private String longnumber;
    private Map<String, Object> properties;
    private static final String FI_BCM_BUSINESS = "fi-bcm-business";
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DimensionTreeNode.class);

    public DimensionTreeNode(String id, String name) {
        super(id, name);
    }

    public DimensionTreeNode(String id, String name, String number, String storagetype, String copyfrom, String memberid, int share, int level, int dseq, boolean isleaf, boolean ischanged, boolean neadsave, String longnumber) {
        super(id, name);
        this.number = number;
        this.storagetype = storagetype;
        this.copyfrom = copyfrom;
        this.memberid = memberid;
        this.share = share;
        this.level = level;
        this.dseq = dseq;
        this.isleaf = isleaf;
        this.ischanged = ischanged;
        this.neadsave = neadsave;
        this.longnumber = longnumber;
    }

    public static Queue<DimensionTreeNode> getQueue(DimensionTreeNode root) {
        LinkedList<DimensionTreeNode> queue = new LinkedList<DimensionTreeNode>();
        LinkedList<DimensionTreeNode> result = new LinkedList<DimensionTreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)queue.poll();
            result.add(node);
            node.getChildren().forEach(e -> queue.add((DimensionTreeNode)e));
        }
        return result;
    }

    public static List<DimensionTreeNode> searchNode(DimensionTreeNode root, String number) {
        ArrayList<DimensionTreeNode> nodes = new ArrayList<DimensionTreeNode>();
        Stack<DimensionTreeNode> stack = new Stack<DimensionTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)stack.pop();
            if (node.getNumber().equals(number)) {
                nodes.add(node);
            }
            node.getChildren().forEach(e -> stack.push((DimensionTreeNode)e));
        }
        return nodes;
    }

    public static DimensionTreeNode searchNoShareNode(DimensionTreeNode root, String number) {
        Stack<DimensionTreeNode> stack = new Stack<DimensionTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)stack.pop();
            if (node.getNumber().equalsIgnoreCase(number) && !node.getStoragetype().equals(StorageTypeEnum.SHARE.index)) {
                return node;
            }
            node.getChildren().forEach(e -> stack.push((DimensionTreeNode)e));
        }
        return null;
    }

    public static List<DimensionTreeNode> searchShareNode(DimensionTreeNode root, String number) {
        ArrayList<DimensionTreeNode> nodeList = new ArrayList<DimensionTreeNode>();
        Stack<DimensionTreeNode> stack = new Stack<DimensionTreeNode>();
        stack.push(root);
        while (!stack.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)stack.pop();
            if (node.getNumber().equals(number) && node.getStoragetype().equals(StorageTypeEnum.SHARE.index)) {
                nodeList.add(node);
            }
            node.getChildren().forEach(e -> stack.push((DimensionTreeNode)e));
        }
        return nodeList;
    }

    public static List<Map<String, String>> getAllNode(DimensionTreeNode root) {
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(10);
        Queue<DimensionTreeNode> queue = DimensionTreeNode.getQueue(root);
        while (!queue.isEmpty()) {
            DimensionTreeNode node = queue.poll();
            treeList.add(DimensionTreeNode.getMap(node));
        }
        return treeList;
    }

    private static Map<String, String> getMap(DimensionTreeNode node) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", node.getId());
        map.put("parentid", node.getParent() == null ? "0" : node.getParent().getId());
        map.put("member.id", node.getMemberid());
        return map;
    }

    public static DimensionTreeNode changeId(DimensionTreeNode root, DimensionTreeNode rootParent) {
        Queue<DimensionTreeNode> queue = DimensionTreeNode.getQueue(root);
        ArrayList<Pair> id_parent = new ArrayList<Pair>();
        while (!queue.isEmpty()) {
            DimensionTreeNode node = queue.poll();
            if (node.getParent() != null) {
                id_parent.add(Pair.onePair((Object)node.getId(), (Object)node.getParent().getId()));
                continue;
            }
            id_parent.add(Pair.onePair((Object)node.getId(), (Object)rootParent.getId()));
        }
        root.setLongnumber(rootParent.getLongnumber() + "!" + root.getNumber());
        queue = DimensionTreeNode.getQueue(root);
        ArrayList<DimensionTreeNode> parenttemp = new ArrayList<DimensionTreeNode>();
        while (!queue.isEmpty()) {
            DimensionTreeNode node = queue.poll();
            String oldid = node.getId();
            String newid = String.valueOf(DBServiceHelper.genGlobalLongId());
            for (int i = 0; i < id_parent.size(); ++i) {
                Pair id = (Pair)id_parent.get(i);
                if (((String)id.p1).equals(oldid)) {
                    int length = node.getStoragetype().equals("4") ? 5 : 4;
                    DimensionTreeNode nodenew = new DimensionTreeNode(newid, node.getName(), node.getNumber(), "3", node.getCopyfrom().equals("0") ? node.getId() : node.getCopyfrom(), node.getMemberid(), 1, node.getLevel(), node.getDseq(), node.getIsleaf(), false, true, node.getLongnumber());
                    nodenew.setName(nodenew.getName().substring(0, node.getName().length() - length) + DimensionTreeNode.getStorage(nodenew.getStoragetype()));
                    parenttemp.add(nodenew);
                    for (DimensionTreeNode parent : parenttemp) {
                        if (!parent.getId().equals(id.p2)) continue;
                        parent.addChild(nodenew);
                        nodenew.setParent(parent);
                        nodenew.setLongnumber(parent.getLongnumber() + "!" + nodenew.getNumber());
                    }
                }
                if (!((String)id.p2).equals(oldid)) continue;
                id_parent.set(i, Pair.onePair((Object)id.p1, (Object)newid));
            }
        }
        return (DimensionTreeNode)parenttemp.get(0);
    }

    public static List<DimensionTreeNode> getAllShareNode(DimensionTreeNode root, DimensionTreeNode selectednode) {
        Queue<DimensionTreeNode> queue = DimensionTreeNode.getQueue(root);
        ArrayList<DimensionTreeNode> result = new ArrayList<DimensionTreeNode>();
        while (!queue.isEmpty()) {
            DimensionTreeNode node = queue.poll();
            if (!node.getMemberid().equals(selectednode.getMemberid())) continue;
            result.add(node);
        }
        return result;
    }

    public static DimensionTreeNode deleteChild(DimensionTreeNode deletenode, DimensionTreeNode root, Set<DimensionTreeNode> nodes) {
        HashSet<DimensionTreeNode> temp = new HashSet<DimensionTreeNode>(16);
        nodes.add(deletenode);
        do {
            temp.addAll(nodes);
        } while ((nodes = DimensionTreeNode.getCopyNode(nodes, deletenode, root)).size() != temp.size());
        for (DimensionTreeNode node : nodes) {
            node.updateInfo(node);
            node.getParent().removeChild(node);
        }
        return root;
    }

    private static Set<DimensionTreeNode> getCopyNode(Set<DimensionTreeNode> nodeset, DimensionTreeNode deletenode, DimensionTreeNode root) {
        Queue<DimensionTreeNode> queue = DimensionTreeNode.getQueue(root);
        while (!queue.isEmpty()) {
            DimensionTreeNode node = queue.poll();
            if (!node.getCopyfrom().equals(deletenode.getId())) continue;
            nodeset.add(node);
        }
        return nodeset;
    }

    private void updateInfo(DimensionTreeNode node) {
        DimensionTreeNode parent = node.getParent();
        if (parent.getChildren().size() == 1) {
            parent.setIsleaf(true);
            parent.setIschanged(false);
            return;
        }
        boolean before = true;
        for (ITreeNode e : parent.getChildren()) {
            DimensionTreeNode child = (DimensionTreeNode)e;
            if (child.equals(node)) {
                before = false;
                continue;
            }
            if (before) continue;
            child.setDseq(child.getDseq() - 1);
        }
    }

    public static String getStorage(String storagetype) {
        switch (storagetype) {
            case "1": {
                return ResManager.loadKDString((String)"\uff08\u6807\u7b7e\uff09", (String)"DimensionTreeNode_0", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\uff08\u5b58\u50a8\uff09", (String)"DimensionTreeNode_1", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\uff08\u5171\u4eab\uff09", (String)"DimensionTreeNode_2", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\uff08\u4e0d\u5171\u4eab\uff09", (String)"DimensionTreeNode_3", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\uff08\u52a8\u6001\u8ba1\u7b97\uff09", (String)"DimensionTreeNode_4", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
            }
        }
        return null;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getStoragetype() {
        return this.storagetype;
    }

    public void setStoragetype(String storagetype) {
        this.storagetype = storagetype;
    }

    public String getCopyfrom() {
        return this.copyfrom;
    }

    public void setCopyfrom(String copyfrom) {
        this.copyfrom = copyfrom;
    }

    public String getMemberid() {
        return this.memberid;
    }

    public void setMemberid(String memberid) {
        this.memberid = memberid;
    }

    public boolean getIschanged() {
        return this.ischanged;
    }

    public void setIschanged(boolean ischanged) {
        this.ischanged = ischanged;
    }

    public boolean isNeadsave() {
        return this.neadsave;
    }

    public void setNeadsave(boolean neadsave) {
        this.neadsave = neadsave;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int seq) {
        this.dseq = seq;
    }

    public boolean getIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(boolean isleaf) {
        this.isleaf = isleaf;
    }

    public int getShare() {
        return this.share;
    }

    public void setShare(int shareall) {
        this.share = shareall;
    }

    public String getLongnumber() {
        return this.longnumber;
    }

    public void setLongnumber(String longnumber) {
        this.longnumber = longnumber;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setProperty(String key, Object t) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, t);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public DimensionTreeNode getParent() {
        return (DimensionTreeNode)super.getParent();
    }

    public DimensionTreeNode clone() {
        DimensionTreeNode node = null;
        try {
            node = (DimensionTreeNode)super.clone();
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.putAll(node.getProperties());
            node.setProperties(temp);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Throwable)e);
        }
        return node;
    }
}

