/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.IUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.ThrowableHelper;

public abstract class AbstractUpgradeService
implements IUpgradeService {
    private String number;
    private List<String> parentNumbers;
    private LocaleString name;
    private ExcuteEnum excuteStatus = ExcuteEnum.FAILURE;
    protected UpgradeContext context;

    public AbstractUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        this.number = number;
        this.name = name;
        this.context = context;
        this.parentNumbers = parentNumbers;
    }

    public ExcuteEnum getExcuteStatus() {
        return this.excuteStatus;
    }

    @Override
    public boolean doExcuteUpgrade() {
        try {
            if (!this.checkPreDataUpgradedStatus()) {
                return false;
            }
            this.saveExcuteStatus(ExcuteEnum.EXCUTING, "", null);
            this.readyUpgradeData();
        }
        catch (Exception e) {
            this.saveExcuteStatus(ExcuteEnum.FAILURE, "readyData", e);
            return false;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.saveData();
                this.afterSaveData();
                this.saveExcuteStatus(ExcuteEnum.SUCESS, "", null);
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        catch (Exception e) {
            this.saveExcuteStatus(ExcuteEnum.FAILURE, "saveData", e);
            return false;
        }
        this.excuteStatus = ExcuteEnum.SUCESS;
        return true;
    }

    abstract void saveData();

    protected abstract void readyUpgradeData();

    public boolean checkPreDataUpgradedStatus() {
        QFilter filter1 = new QFilter("model.id", "=", (Object)this.context.getModelId());
        filter1.and(new QFilter("number", "=", (Object)this.number));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_upgradestatus", (String)"status", (QFilter[])new QFilter[]{filter1});
        if (dy == null || dy.getInt("status") == ExcuteEnum.SUCESS.index) {
            // empty if block
        }
        QFilter filter2 = new QFilter("model.id", "=", (Object)this.context.getModelId());
        filter2.and(new QFilter("number", "in", this.parentNumbers));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_upgradestatus", (String)"status", (QFilter[])new QFilter[]{filter2});
        if (doc.size() < 1) {
            return true;
        }
        return doc.stream().allMatch(d -> d.getInt("status") == ExcuteEnum.SUCESS.index);
    }

    public void updateServiceStatus(ExcuteEnum excuteStatus) {
        this.context.getServiceNum2status().put(this.number, excuteStatus);
    }

    public void saveExcuteStatus(ExcuteEnum excuteStatus, String detail, Throwable e) {
        this.excuteStatus = excuteStatus;
        QFilter filter = new QFilter("model.id", "=", (Object)this.context.getModelId());
        filter.and(new QFilter("number", "=", (Object)this.number));
        DynamicObject statusDy = BusinessDataServiceHelper.loadSingle((String)"bcm_upgradestatus", (String)"status,log,lasttime,creater", (QFilter[])new QFilter[]{filter});
        if (statusDy == null) {
            statusDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_upgradestatus");
            statusDy.set("model", (Object)this.context.getModelId());
            statusDy.set("number", (Object)this.number);
            statusDy.set("name", (Object)this.name);
        }
        statusDy.set("status", (Object)excuteStatus.index);
        statusDy.set("log", (Object)(e == null ? "" : detail + ThrowableHelper.toString((Throwable)e)));
        statusDy.set("creater", (Object)RequestContext.getOrCreate().getUserId());
        statusDy.set("lasttime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statusDy});
    }

    public void saveExcuteStatus(ExcuteEnum excuteStatus, String detail) {
        this.excuteStatus = excuteStatus;
        QFilter filter = new QFilter("model.id", "=", (Object)this.context.getModelId());
        filter.and(new QFilter("number", "=", (Object)this.number));
        DynamicObject statusDy = BusinessDataServiceHelper.loadSingle((String)"bcm_upgradestatus", (String)"status,log,lasttime,creater", (QFilter[])new QFilter[]{filter});
        if (statusDy == null) {
            statusDy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_upgradestatus");
            statusDy.set("model", (Object)this.context.getModelId());
            statusDy.set("number", (Object)this.number);
            statusDy.set("name", (Object)this.name);
        }
        statusDy.set("status", (Object)excuteStatus.index);
        statusDy.set("log", (Object)(detail == null ? "" : detail));
        statusDy.set("creater", (Object)RequestContext.getOrCreate().getUserId());
        statusDy.set("lasttime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statusDy});
    }

    public String getNumber() {
        return this.number;
    }

    public List<String> getParentNumbers() {
        return this.parentNumbers;
    }

    public LocaleString getName() {
        return this.name;
    }

    public static enum ExcuteEnum {
        EXCUTING(new MultiLangEnumBridge("\u6267\u884c\u4e2d", "AbstractUpgradeService_0", "fi-bcm-business"), 2),
        SUCESS(new MultiLangEnumBridge("\u6210\u529f", "AbstractUpgradeService_1", "fi-bcm-business"), 1),
        FAILURE(new MultiLangEnumBridge("\u5931\u8d25", "AbstractUpgradeService_2", "fi-bcm-business"), 0);

        private int index;
        private MultiLangEnumBridge bridge;

        public int getIndex() {
            return this.index;
        }

        private ExcuteEnum(MultiLangEnumBridge bridge, int index) {
            this.bridge = bridge;
            this.index = index;
        }
    }
}

